/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.shade.connection.management.ConnectionManagementConnectionKey;
import org.mule.devkit.utils.NameUtils;

public class ConnectionKeyGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Collections.emptyList();
    private static final List<Product> PRODUCES = Arrays.asList(Product.CONNECTION_KEY);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule || module.manager().connectionManagementComponents().size() > 0;
    }

    public void generate(Module module) throws GenerationException {
        if (!module.manager().connectionManagementComponents().isEmpty()) {
            this.generateConnectionManagementKey(module);
        } else {
            this.generateSimpleConnectionKey(module);
        }
    }

    private void generateSimpleConnectionKey(Module module) {
        ManagedConnectionModule managedConnectionType = (ManagedConnectionModule)module;
        GeneratedClass connectionKeyClass = this.getConnectionKeyClass(managedConnectionType);
        Map<String, AbstractMuleGenerator.FieldVariableElement> keyFields = this.generateStandardFieldForEachParameter(connectionKeyClass, (Method)managedConnectionType.getConnectMethod());
        this.generateKeyConstructor(managedConnectionType.getConnectMethod(), connectionKeyClass, keyFields);
        this.generateConnectionKeyHashCodeMethod(managedConnectionType.getConnectMethod(), connectionKeyClass);
        this.generateConnectionKeyEqualsMethod(managedConnectionType.getConnectMethod(), connectionKeyClass);
    }

    private void generateConnectionManagementKey(Module module) {
        for (ConnectionManagementComponent connectionManagementComponent : module.manager().connectionManagementComponents()) {
            GeneratedClass connectionKeyClass = this.getConnectionKeyClass(connectionManagementComponent, module);
            Map<String, AbstractMuleGenerator.FieldVariableElement> keyFields = this.generateStandardFieldForEachParameter(connectionKeyClass, (Method)connectionManagementComponent.getConnectMethod());
            this.generateKeyConstructor(connectionManagementComponent.getConnectMethod(), connectionKeyClass, keyFields);
            this.generateConnectionKeyHashCodeMethod(connectionManagementComponent.getConnectMethod(), connectionKeyClass);
            this.generateConnectionKeyEqualsMethod(connectionManagementComponent.getConnectMethod(), connectionKeyClass);
        }
    }

    private GeneratedClass getConnectionKeyClass(ConnectionManagementComponent connectionManagementComponent, Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass connectionKey = pkg._class(1, "ConnectionManagement" + NameUtils.camel((String)connectionManagementComponent.configElementName()) + module.getClassName() + "ConnectionKey");
        connectionKey._implements(ConnectionManagementConnectionKey.class);
        this.ctx().registerProduct(Product.CONNECTION_KEY, (Identifiable)connectionManagementComponent, module.getName(), (Object)connectionKey);
        return connectionKey;
    }

    private GeneratedClass getConnectionKeyClass(ManagedConnectionModule module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass connectionKey = pkg._class(1, module.getClassName() + "ConnectionKey");
        connectionKey._implements(ConnectionManagementConnectionKey.class);
        connectionKey.javadoc().add((Object)"A tuple of connection parameters");
        this.ctx().registerProduct(Product.CONNECTION_KEY, (Identifiable)module, (Object)connectionKey);
        return connectionKey;
    }

    private void generateKeyConstructor(ConnectMethod connectMethod, GeneratedClass connectionKeyClass, Map<String, AbstractMuleGenerator.FieldVariableElement> keyFields) {
        GeneratedMethod keyConstructor = connectionKeyClass.constructor(1);
        for (Parameter variable : connectMethod.getParameters()) {
            String fieldName = variable.getName();
            GeneratedVariable parameter = keyConstructor.param(this.ref(variable.asTypeMirror()), fieldName);
            keyConstructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)keyFields.get(fieldName).getField()), (GeneratedExpression)parameter);
        }
    }

    private void generateConnectionKeyHashCodeMethod(ConnectMethod connectMethod, GeneratedClass connectionKeyClass) {
        GeneratedMethod hashCode = connectionKeyClass.method(1, (Type)this.ctx().getCodeModel().INT, "hashCode");
        hashCode.annotate(Override.class);
        GeneratedVariable result = null;
        for (Parameter variable : connectMethod.getParameters()) {
            if (variable.getAnnotation(ConnectionKey.class) == null) continue;
            String fieldName = variable.getName();
            GeneratedExpression ternaryCondition = Op.cond((GeneratedExpression)ExpressionFactory._this().ref(fieldName).isNotNull(), (GeneratedExpression)ExpressionFactory._this().ref(fieldName).invoke(hashCode), (GeneratedExpression)ExpressionFactory.lit((int)0));
            if (result == null) {
                result = hashCode.body().decl((Type)this.ctx().getCodeModel().INT, "result", ternaryCondition);
                continue;
            }
            hashCode.body().assign((AssignmentTarget)result, Op.plus((GeneratedExpression)Op.mul((GeneratedExpression)ExpressionFactory.lit((int)31), result), (GeneratedExpression)ternaryCondition));
        }
        hashCode.body()._return(result);
    }

    private void generateConnectionKeyEqualsMethod(ConnectMethod connectMethod, GeneratedClass connectionKey) {
        GeneratedMethod equals = connectionKey.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "equals");
        equals.annotate(Override.class);
        GeneratedVariable o = equals.param((Type)this.ref(Object.class), "o");
        equals.body()._if(Op.eq((GeneratedExpression)ExpressionFactory._this(), (GeneratedExpression)o))._then()._return(ExpressionFactory.lit((boolean)true));
        equals.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)o, (Type)connectionKey)))._then()._return(ExpressionFactory.lit((boolean)false));
        GeneratedVariable that = equals.body().decl((Type)connectionKey, "that", (GeneratedExpression)ExpressionFactory.cast((Type)connectionKey, (GeneratedExpression)o));
        for (Parameter variable : connectMethod.getParameters()) {
            if (variable.getAnnotation(ConnectionKey.class) == null) continue;
            String fieldName = variable.getName();
            GeneratedExpression ternaryIfOperator = Op.cond((GeneratedExpression)ExpressionFactory._this().ref(fieldName).isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)ExpressionFactory._this().ref(fieldName).invoke("equals").arg((GeneratedExpression)that.ref(fieldName))), (GeneratedExpression)that.ref(fieldName).isNotNull());
            equals.body()._if(ternaryIfOperator)._then()._return(ExpressionFactory.lit((boolean)false));
        }
        equals.body()._return(ExpressionFactory.lit((boolean)true));
    }
}

