/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.common.MuleVersion;
import org.mule.config.MuleManifest;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleAdapterGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.METADATA_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.LIFECYCLE_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.EXPRESSION_LANGUAGE;
    }

    public void generate(Module module) {
        GeneratedClass lifecycleAdapter = this.getLifecycleAdapterClass(module);
        lifecycleAdapter.javadoc().add((Object)("A <code>" + lifecycleAdapter.name() + "</code> is a wrapper around "));
        lifecycleAdapter.javadoc().add((Object)this.ref(module.asTypeMirror()));
        lifecycleAdapter.javadoc().add((Object)" that adds lifecycle methods to the pojo.");
        this.generateStartMethod(module, lifecycleAdapter);
        this.generateStopMethod(module, lifecycleAdapter);
        this.generateInitMethod(module, lifecycleAdapter);
        this.generateDisposeMethod(module, lifecycleAdapter);
    }

    protected void muleContextField(GeneratedClass adapter) {
        new FieldBuilder(adapter).name("muleContext").type(MuleContext.class).setter().getter().build();
    }

    private void generateDisposeMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method disposeMethod = module.getLifecycleMethod("dispose");
        lifecycleAdapter._implements(Disposable.class);
        this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends Type>)disposeMethod, "dispose", null, false);
    }

    private void generateInitMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method initMethod = module.getLifecycleMethod("initialise");
        lifecycleAdapter._implements(Initialisable.class);
        this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends Type>)initMethod, "initialise", InitialisationException.class, true);
    }

    private void generateStopMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method stopMethod = module.getLifecycleMethod("stop");
        lifecycleAdapter._implements(Stoppable.class);
        GeneratedMethod stop = this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends Type>)stopMethod, "stop", MuleException.class, false);
    }

    private void generateStartMethod(Module module, GeneratedClass lifecycleAdapter) {
        Method startMethod = module.getLifecycleMethod("start");
        lifecycleAdapter._implements(Startable.class);
        GeneratedMethod start = this.generateLifecycleInvocation(lifecycleAdapter, module, (Method<? extends Type>)startMethod, "start", MuleException.class, false);
    }

    private GeneratedClass getLifecycleAdapterClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        GeneratedClass previous = ((GeneratedClass)this.ctx().getProduct(Product.METADATA_ADAPTER, (Identifiable)module)).topLevelClass();
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + "LifecycleAdapter", (TypeReference)previous);
        this.ctx().registerProduct(Product.LIFECYCLE_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }

    private GeneratedMethod generateLifecycleInvocation(GeneratedClass lifecycleWrapper, Module module, Method<? extends Type> superExecutableElement, String name, Class<?> catchException, boolean addThis) {
        GeneratedMethod lifecycleMethod = lifecycleWrapper.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, name);
        lifecycleMethod.annotate(this.ref(Override.class));
        if (name.equals("initialise")) {
            GeneratedVariable log = lifecycleMethod.body().decl((org.mule.devkit.model.code.Type)this.ref(Logger.class), "log", (GeneratedExpression)this.ref(LoggerFactory.class).staticInvoke("getLogger").arg(lifecycleWrapper.dotclass()));
            GeneratedVariable connectorVersion = lifecycleMethod.body().decl((org.mule.devkit.model.code.Type)this.ref(MuleVersion.class), "connectorVersion", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MuleVersion.class)).arg(ExpressionFactory.lit((String)module.getMinMuleVersion().toString())));
            GeneratedVariable muleVersion = lifecycleMethod.body().decl((org.mule.devkit.model.code.Type)this.ref(MuleVersion.class), "muleVersion", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MuleVersion.class)).arg((GeneratedExpression)this.ref(MuleManifest.class).staticInvoke("getProductVersion")));
            GeneratedConditional ifversionatleast = lifecycleMethod.body()._if(Op.not((GeneratedExpression)muleVersion.invoke("atLeastBase").arg((GeneratedExpression)connectorVersion)));
            ifversionatleast._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(InitialisationException.class)).arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("minMuleVersionNotMet").arg((GeneratedExpression)ExpressionFactory._this().invoke("getMinMuleVersion"))).arg(ExpressionFactory._this()));
        }
        if (catchException != null) {
            lifecycleMethod._throws(this.ref(catchException));
        }
        if (superExecutableElement != null) {
            GeneratedInvocation startInvocation = ExpressionFactory._super().invoke(superExecutableElement.getName());
            boolean foundNonCatchException = false;
            for (TypeMirror exception : superExecutableElement.getThrownTypes()) {
                if (catchException.getName().toString().equals(exception.toString())) continue;
                foundNonCatchException = true;
            }
            if (foundNonCatchException) {
                GeneratedTry tryBlock = lifecycleMethod.body()._try();
                tryBlock.body().add((Statement)startInvocation);
                int i = 0;
                for (TypeMirror exception : superExecutableElement.getThrownTypes()) {
                    GeneratedCatchBlock catchBlock = tryBlock._catch(this.ref(exception).boxify());
                    GeneratedVariable catchedException = catchBlock.param("e" + i);
                    GeneratedInvocation newMuleException = null;
                    newMuleException = catchException.getName().toString().equals(MuleException.class.getName()) ? ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)) : ExpressionFactory._new((TypeReference)this.ref(catchException));
                    newMuleException.arg((GeneratedExpression)catchedException);
                    if (addThis) {
                        newMuleException.arg(ExpressionFactory._this());
                    }
                    catchBlock.body()._throw((GeneratedExpression)newMuleException);
                    ++i;
                }
            } else {
                lifecycleMethod.body().add((Statement)startInvocation);
            }
        }
        return lifecycleMethod;
    }
}

