/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Arrays;
import java.util.List;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.client.MuleClient;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreManager;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.utils.NameUtils;
import org.mule.util.queue.QueueManager;

public class InjectAdapterGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.PROCESS_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.INJECTION_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getInjectFields().size() > 0;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass adapter = this.getMuleContextAwareAdapter(module);
        adapter.javadoc().add((Object)("A <code>" + adapter.name() + "</code> is a wrapper around "));
        adapter.javadoc().add((Object)this.ref(module.asTypeMirror()));
        adapter.javadoc().add((Object)" that allows the injection of several Mule facilities when a MuleContext is set.");
        GeneratedMethod setMuleContext = adapter.method(1, (Type)this.ctx().getCodeModel().VOID, "setMuleContext");
        setMuleContext.annotate(Override.class);
        GeneratedVariable context = setMuleContext.param((Type)this.ref(MuleContext.class), "context");
        for (Field variable : module.getInjectFields()) {
            if (variable.asTypeMirror().toString().startsWith(MuleContext.class.getName())) {
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)context));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(ObjectStoreManager.class.getName())) {
                GeneratedCast getObjectStoreManager = ExpressionFactory.cast((Type)this.ref(ObjectStoreManager.class), (GeneratedExpression)context.invoke("getRegistry").invoke("get").arg((GeneratedExpression)this.ref(MuleProperties.class).staticRef("OBJECT_STORE_MANAGER")));
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getObjectStoreManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(TransactionManager.class.getName())) {
                GeneratedInvocation getTransactionManager = context.invoke("getTransactionManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getTransactionManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(QueueManager.class.getName())) {
                GeneratedInvocation getQueueManager = context.invoke("getQueueManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getQueueManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(ObjectStore.class.getName())) {
                GeneratedConditional notNull = setMuleContext.body()._if(Op.eq((GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)variable.getName()))), (GeneratedExpression)ExpressionFactory._null()));
                GeneratedInvocation getObjectStore = context.invoke("getRegistry").invoke("lookupObject").arg((GeneratedExpression)this.ref(MuleProperties.class).staticRef("OBJECT_STORE_DEFAULT_IN_MEMORY_NAME"));
                notNull._then().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ObjectStore.class), (GeneratedExpression)getObjectStore)));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(MuleConfiguration.class.getName())) {
                GeneratedInvocation getConfiguration = context.invoke("getConfiguration");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getConfiguration));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(LifecycleManager.class.getName())) {
                GeneratedInvocation getLifecycleManager = context.invoke("getLifecycleManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getLifecycleManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(ClassLoader.class.getName())) {
                GeneratedInvocation getExecutionClassLoader = context.invoke("getExecutionClassLoader");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getExecutionClassLoader));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(ExpressionManager.class.getName())) {
                GeneratedInvocation getExpressionManager = context.invoke("getExpressionManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getExpressionManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(EndpointFactory.class.getName())) {
                GeneratedInvocation getEndpointFactory = context.invoke("getEndpointFactory");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getEndpointFactory));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(MuleClient.class.getName())) {
                GeneratedInvocation getClient = context.invoke("getClient");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getClient));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(SystemExceptionHandler.class.getName())) {
                GeneratedInvocation getExceptionListener = context.invoke("getExceptionListener");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getExceptionListener));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(SecurityManager.class.getName())) {
                GeneratedInvocation getSecurityManager = context.invoke("getSecurityManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getSecurityManager));
                continue;
            }
            if (variable.asTypeMirror().toString().startsWith(WorkManager.class.getName())) {
                GeneratedInvocation getWorkManager = context.invoke("getWorkManager");
                setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getWorkManager));
                continue;
            }
            if (!variable.asTypeMirror().toString().startsWith(Registry.class.getName()) && !variable.asTypeMirror().toString().startsWith(MuleRegistry.class.getName())) continue;
            GeneratedInvocation getRegistry = context.invoke("getRegistry");
            setMuleContext.body().add((Statement)ExpressionFactory._super().invoke(NameUtils.buildSetter((String)variable.getName())).arg((GeneratedExpression)getRegistry));
        }
    }

    private GeneratedClass getMuleContextAwareAdapter(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        TypeReference previous = (TypeReference)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)module);
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + "InjectionAdapter", previous);
        clazz._implements(this.ref(MuleContextAware.class));
        this.ctx().registerProduct(Product.INJECTION_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }
}

