/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.NestedProcessor;
import org.mule.api.annotations.Mime;
import org.mule.api.annotations.expressions.Expr;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.Literal;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.callback.HttpCallback;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.NestedProcessorChain;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.Flow;
import org.mule.devkit.generation.AbstractCapabilityGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.MuleGeneratorUtils;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.components.connection.ConfigurationComponent;
import org.mule.devkit.model.module.components.connection.ConnectionManagementComponent;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthCapability;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.util.StringUtils;

public abstract class AbstractMuleGenerator
extends AbstractCapabilityGenerator {
    protected Set<String> privateFieldnames = this.toNames(Arrays.asList(DevkitBasedMessageProcessor.class.getDeclaredFields()));

    private Set<String> toNames(List<Field> fields) {
        if (fields == null) {
            return new HashSet<String>();
        }
        HashSet<String> result = new HashSet<String>();
        for (Field f : fields) {
            result.add(f.getName());
        }
        return result;
    }

    public Set<String> getPrivateFieldnames() {
        return this.privateFieldnames;
    }

    protected GeneratedField generateFieldForModuleObject(GeneratedClass messageProcessorClass, TypeVariable typeVariable) {
        GeneratedField field = messageProcessorClass.field(2, (Type)typeVariable, "moduleObject");
        field.javadoc().add((Object)"Module object");
        return field;
    }

    protected Map<String, FieldVariableElement> generateFieldForEachParameter(GeneratedClass messageProcessorClass, Method processorMethod, Set<String> privateFieldnames) {
        return this.generateProcessorFieldForEachParameter(messageProcessorClass, (Method<? extends org.mule.devkit.model.Type>)processorMethod, null, privateFieldnames);
    }

    protected Map<String, FieldVariableElement> generateProcessorFieldForEachParameter(GeneratedClass messageProcessorClass, Method<? extends org.mule.devkit.model.Type> processorMethod, Class annotatedWith, Set<String> privateFieldnames) {
        HashMap<String, FieldVariableElement> fields = new HashMap<String, FieldVariableElement>();
        for (Parameter variable : processorMethod.getParameters()) {
            GeneratedField fieldType;
            GeneratedField field;
            if (MuleGeneratorUtils.shouldSkipFieldGenerationForParameter(annotatedWith, privateFieldnames, variable).booleanValue()) continue;
            String fieldName = variable.getName();
            if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                field = new FieldBuilder(messageProcessorClass).protectedVisibility().type(Object.class).name(fieldName).build();
                fieldType = new FieldBuilder(messageProcessorClass).protectedVisibility().type(this.ref(variable.asTypeMirror())).name("_" + fieldName + "Type").build();
            } else if (variable.isQuery() && variable.asType().isDsqlQueryObject()) {
                field = new FieldBuilder(messageProcessorClass).protectedVisibility().type(Object.class).name(fieldName).build();
                fieldType = new FieldBuilder(messageProcessorClass).type((Type)this.ref(String.class)).name("_" + fieldName + "Type").build();
            } else if (variable.asTypeMirror().toString().startsWith(HttpCallback.class.getName())) {
                field = new FieldBuilder(messageProcessorClass).type(Flow.class).name(fieldName + "CallbackFlow").javadoc("The flow to be invoked when the http callback is received").build();
                fieldType = new FieldBuilder(messageProcessorClass).type((Type)this.ref(HttpCallback.class)).name(fieldName).javadoc("An HttpCallback instance responsible for linking the APIs http callback with the flow {@link " + messageProcessorClass.fullName() + "#" + fieldName + "CallbackFlow").build();
            } else {
                field = new FieldBuilder(messageProcessorClass).protectedVisibility().type(Object.class).name(fieldName).build();
                fieldType = new FieldBuilder(messageProcessorClass).protectedVisibility().type(this.ref(variable.asTypeMirror())).name("_" + fieldName + "Type").build();
            }
            fields.put(variable.getName(), new FieldVariableElement(field, fieldType, (Variable)variable));
        }
        return fields;
    }

    protected Map<String, FieldVariableElement> generateStandardFieldForEachParameter(GeneratedClass connectionKeyClass, Method processorMethod) {
        Map<String, FieldVariableElement> fieldMap = this.generateStandardFieldForEachParameter(connectionKeyClass, (Method<? extends org.mule.devkit.model.Type>)processorMethod, null);
        for (String fieldName : fieldMap.keySet()) {
            connectionKeyClass.setter(fieldMap.get(fieldName).getField());
            connectionKeyClass.getter(fieldMap.get(fieldName).getField());
        }
        return fieldMap;
    }

    protected Map<String, FieldVariableElement> generateStandardFieldForEachParameter(GeneratedClass messageProcessorClass, Method<? extends org.mule.devkit.model.Type> processorMethod, Class annotatedWith) {
        HashMap<String, FieldVariableElement> fields = new HashMap<String, FieldVariableElement>();
        for (Parameter variable : processorMethod.getParameters()) {
            if (annotatedWith != null && variable.getAnnotation(annotatedWith) == null) continue;
            String fieldName = variable.getName();
            GeneratedField fieldType = null;
            GeneratedField field = new FieldBuilder(messageProcessorClass).privateVisibility().type(this.ref(variable.asTypeMirror())).name(fieldName).build();
            field.javadoc().add((Object)variable.getJavaDocParameterSummary(variable.getName()));
            fields.put(variable.getName(), new FieldVariableElement(field, fieldType, (Variable)variable));
        }
        return fields;
    }

    protected GeneratedClass getModuleObject(org.mule.devkit.model.Type type, ConnectionManagementComponent connectionManagementComponent) {
        GeneratedClass generatedClass = null;
        generatedClass = connectionManagementComponent != null ? (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGER, (Identifiable)connectionManagementComponent, type.getName()) : this.getModuleObject(type);
        return generatedClass;
    }

    protected GeneratedClass getModuleObject(org.mule.devkit.model.Type type, OAuthCapability oAuthCapability) {
        GeneratedClass generatedClass = null;
        generatedClass = oAuthCapability != null && oAuthCapability.getOAuthVersion().equals((Object)OAuthVersion.V2) ? (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)type) : this.getModuleObject(type);
        return generatedClass;
    }

    protected GeneratedClass getModuleObject(org.mule.devkit.model.Type type, ConfigurationComponent configurationComponent) {
        return (GeneratedClass)this.ctx().getProduct(Product.BASIC_CONNECTOR_ADAPTER, (Identifiable)configurationComponent, type.getName());
    }

    protected GeneratedClass getModuleObject(org.mule.devkit.model.Type type) {
        if (type instanceof ManagedConnectionModule) {
            return (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGER, (Identifiable)type);
        }
        if (type instanceof Module && ((Module)type).usesPooling()) {
            return (GeneratedClass)this.ctx().getProduct(Product.POOL_MANAGER, (Identifiable)type);
        }
        if (type instanceof OAuthModule && ((OAuthModule)type).getOAuthVersion().equals((Object)OAuthVersion.V2)) {
            return (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)type);
        }
        if (type instanceof OAuthModule && ((OAuthModule)type).getOAuthVersion().equals((Object)OAuthVersion.V10A)) {
            return (GeneratedClass)this.ctx().getProduct(Product.OAUTH_ADAPTER, (Identifiable)type);
        }
        if (this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)type) != null) {
            return ((GeneratedClass)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)type)).topLevelClass();
        }
        return null;
    }

    protected GeneratedMethod generateInitialiseMethod(GeneratedClass messageProcessorClass, Map<String, FieldVariableElement> fields, Module module) {
        GeneratedMethod initialise = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        initialise.javadoc().add((Object)"Obtains the expression manager from the Mule context and initialises the connector. If a target object ");
        initialise.javadoc().add((Object)" has not been set already it will search the Mule registry for a default one.");
        initialise.javadoc().addThrows(this.ref(InitialisationException.class));
        initialise._throws(InitialisationException.class);
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                FieldVariableElement variableElement = fields.get(fieldName);
                if (!variableElement.getVariable().asType().isNestedProcessor() && (!variableElement.getVariable().asType().isArrayOrList() || variableElement.getVariable().getTypeArguments().size() <= 0 || !((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor())) continue;
                boolean isList = variableElement.getVariable().asType().isArrayOrList();
                if (!isList) {
                    this.propagateMuleConstraintToInnerProcess(initialise.body(), (GeneratedVariable)variableElement.getField());
                    continue;
                }
                GeneratedConditional ifIsList = initialise.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                this.propagateMuleConstraintToInnerProcess(forEachProcessor.body(), forEachProcessor.var());
            }
        }
        return initialise;
    }

    private void propagateMuleConstraintToInnerProcess(GeneratedBlock body, GeneratedVariable field) {
        GeneratedConditional ifFlowConstructAware = body._if(Op._instanceof((GeneratedExpression)field, (Type)this.ref(FlowConstructAware.class)));
        ifFlowConstructAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(FlowConstructAware.class), (GeneratedExpression)field).invoke("setFlowConstruct").arg((GeneratedExpression)ExpressionFactory.invoke((String)"getFlowConstruct")));
        GeneratedConditional ifMuleContextAware = body._if(Op._instanceof((GeneratedExpression)field, (Type)this.ref(MuleContextAware.class)));
        ifMuleContextAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (GeneratedExpression)field).invoke("setMuleContext").arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext")));
        GeneratedConditional ifInitialisable = body._if(Op._instanceof((GeneratedExpression)field, (Type)this.ref(Initialisable.class)));
        ifInitialisable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Initialisable.class), (GeneratedExpression)field).invoke("initialise"));
    }

    protected GeneratedMethod generateSetMuleContextMethod(GeneratedClass clazz, Map<String, FieldVariableElement> fields) {
        GeneratedMethod setMuleContext = clazz.method(1, (Type)this.ctx().getCodeModel().VOID, "setMuleContext");
        setMuleContext.javadoc().add((Object)"Set the Mule context");
        setMuleContext.javadoc().addParam("context Mule context to set");
        GeneratedVariable newMuleContext = setMuleContext.param((Type)this.ref(MuleContext.class), "context");
        setMuleContext.body().add((Statement)ExpressionFactory._super().invoke("setMuleContext").arg((GeneratedExpression)newMuleContext));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                FieldVariableElement variableElement = fields.get(fieldName);
                if (!variableElement.getVariable().asType().isNestedProcessor() && (!variableElement.getVariable().asType().isArrayOrList() || variableElement.getVariable().getTypeArguments().size() <= 0 || !((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor())) continue;
                boolean isList = variableElement.getVariable().asType().isArrayOrList();
                if (!isList) {
                    GeneratedConditional ifMuleContextAware = setMuleContext.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(MuleContextAware.class)));
                    ifMuleContextAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (GeneratedExpression)variableElement.getField()).invoke("setMuleContext").arg((GeneratedExpression)newMuleContext));
                    continue;
                }
                GeneratedConditional ifIsList = setMuleContext.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                GeneratedConditional ifMuleContextAware = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(MuleContextAware.class)));
                ifMuleContextAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (GeneratedExpression)forEachProcessor.var()).invoke("setMuleContext").arg((GeneratedExpression)newMuleContext));
            }
        }
        return setMuleContext;
    }

    protected GeneratedMethod generateSetFlowConstructMethod(GeneratedClass messageSourceClass, Map<String, FieldVariableElement> fields) {
        GeneratedMethod setFlowConstruct = messageSourceClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setFlowConstruct");
        setFlowConstruct.javadoc().add((Object)"Sets flow construct");
        setFlowConstruct.javadoc().addParam("flowConstruct Flow construct to set");
        GeneratedVariable newFlowConstruct = setFlowConstruct.param((Type)this.ref(FlowConstruct.class), "flowConstruct");
        setFlowConstruct.body().add((Statement)ExpressionFactory._super().invoke("setFlowConstruct").arg((GeneratedExpression)newFlowConstruct));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                FieldVariableElement variableElement = fields.get(fieldName);
                if (!variableElement.getVariable().asType().isNestedProcessor() && (!variableElement.getVariable().asType().isArrayOrList() || variableElement.getVariable().getTypeArguments().size() <= 0 || !((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor())) continue;
                boolean isList = variableElement.getVariable().asType().isArrayOrList();
                if (!isList) {
                    GeneratedConditional ifMuleContextAware = setFlowConstruct.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(FlowConstructAware.class)));
                    ifMuleContextAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(FlowConstructAware.class), (GeneratedExpression)variableElement.getField()).invoke("setFlowConstruct").arg((GeneratedExpression)newFlowConstruct));
                    continue;
                }
                GeneratedConditional ifIsList = setFlowConstruct.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                GeneratedConditional ifMuleContextAware = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(FlowConstructAware.class)));
                ifMuleContextAware._then().add((Statement)ExpressionFactory.cast((Type)this.ref(FlowConstructAware.class), (GeneratedExpression)forEachProcessor.var()).invoke("setFlowConstruct").arg((GeneratedExpression)newFlowConstruct));
            }
        }
        return setFlowConstruct;
    }

    protected void generateThrow(String bundle, Class<?> clazz, GeneratedCatchBlock callProcessorCatch, GeneratedExpression event, String methodName) {
        GeneratedVariable exception = callProcessorCatch.param("e");
        TypeReference coreMessages = this.ref(CoreMessages.class);
        GeneratedInvocation failedToInvoke = coreMessages.staticInvoke(bundle);
        if (methodName != null) {
            failedToInvoke.arg(ExpressionFactory.lit((String)methodName));
        }
        GeneratedInvocation messageException = ExpressionFactory._new((TypeReference)this.ref(clazz));
        messageException.arg((GeneratedExpression)failedToInvoke);
        if (event != null) {
            messageException.arg(event);
        }
        messageException.arg((GeneratedExpression)exception);
        callProcessorCatch.body()._throw((GeneratedExpression)messageException);
    }

    public void generateThrow(String bundle, Class<?> clazz, GeneratedBlock block, GeneratedExpression event, String methodName) {
        TypeReference coreMessages = this.ref(CoreMessages.class);
        GeneratedInvocation failedToInvoke = coreMessages.staticInvoke(bundle);
        if (methodName != null) {
            failedToInvoke.arg(ExpressionFactory.lit((String)methodName));
        }
        GeneratedInvocation messageException = ExpressionFactory._new((TypeReference)this.ref(clazz));
        messageException.arg((GeneratedExpression)failedToInvoke);
        if (event != null) {
            messageException.arg(event);
        }
        block._throw((GeneratedExpression)messageException);
    }

    public GeneratedVariable declareTransformedVariable(Variable variable, GeneratedExpression expression, Type fieldClass, GeneratedVariable muleEvent, GeneratedBlock block, GeneratedExpression muleContext) {
        if (variable.hasAnnotation(Literal.class)) {
            TypeReference varType = variable.getJavaType().equals(new TypeToken<List<String>>(){}.getType().toString()) ? this.ref(List.class) : this.ref(String.class);
            GeneratedCast cast = ExpressionFactory.cast((Type)varType, (GeneratedExpression)ExpressionFactory._this().ref(variable.getName()));
            return block.decl(8, (Type)varType, "_not_evaluated" + StringUtils.capitalize((String)variable.getName()), (GeneratedExpression)cast);
        }
        GeneratedInvocation getGenericType = fieldClass.boxify().dotclass().invoke("getDeclaredField").arg(ExpressionFactory.lit((String)("_" + variable.getName() + "Type"))).invoke("getGenericType");
        return this.declareTransformedVariable(variable, expression, (GeneratedExpression)getGenericType, muleEvent, block, muleContext);
    }

    protected GeneratedVariable declareTransformedVariable(Variable variable, GeneratedExpression expression, GeneratedExpression getGenericType, GeneratedVariable muleEvent, GeneratedBlock block, GeneratedExpression muleContext) {
        InboundHeaders inboundHeaders = (InboundHeaders)variable.getAnnotation(InboundHeaders.class);
        InvocationHeaders invocationHeaders = (InvocationHeaders)variable.getAnnotation(InvocationHeaders.class);
        SessionHeaders sessionHeaders = (SessionHeaders)variable.getAnnotation(SessionHeaders.class);
        Payload payload = (Payload)variable.getAnnotation(Payload.class);
        ExceptionPayload exceptionPayload = (ExceptionPayload)variable.getAnnotation(ExceptionPayload.class);
        CorrelationId correlationId = (CorrelationId)variable.getAnnotation(CorrelationId.class);
        CorrelationSequence correlationSequence = (CorrelationSequence)variable.getAnnotation(CorrelationSequence.class);
        CorrelationGroupSize correlationGroupSize = (CorrelationGroupSize)variable.getAnnotation(CorrelationGroupSize.class);
        MessageRootId messageRootId = (MessageRootId)variable.getAnnotation(MessageRootId.class);
        MessageUniqueId messageUniqueId = (MessageUniqueId)variable.getAnnotation(MessageUniqueId.class);
        Expr expr = (Expr)variable.getAnnotation(Expr.class);
        TypeReference type = this.ref(variable.asTypeMirror()).boxify();
        String name = "_transformed" + StringUtils.capitalize((String)variable.getName());
        GeneratedInvocation evaluateAndTransform = ExpressionFactory.invoke((String)"evaluateAndTransform").arg(muleContext).arg((GeneratedExpression)muleEvent).arg(getGenericType);
        Mime mime = (Mime)variable.getAnnotation(Mime.class);
        if (mime != null) {
            evaluateAndTransform.arg(ExpressionFactory.lit((String)mime.value()));
        } else {
            evaluateAndTransform.arg(ExpressionFactory._null());
        }
        if (inboundHeaders != null) {
            if (variable.asType().isArrayOrList()) {
                evaluateAndTransform.arg("#[headers-list:INBOUND:" + inboundHeaders.value() + "]");
            } else if (variable.asType().isMap()) {
                evaluateAndTransform.arg("#[headers:INBOUND:" + inboundHeaders.value() + "]");
            } else {
                evaluateAndTransform.arg("#[header:INBOUND:" + inboundHeaders.value() + "]");
            }
        } else if (invocationHeaders != null) {
            if (variable.asType().isArrayOrList()) {
                evaluateAndTransform.arg("#[headers-list:INVOCATION:" + invocationHeaders.value() + "]");
            } else if (variable.asType().isMap()) {
                evaluateAndTransform.arg("#[headers:INVOCATION:" + invocationHeaders.value() + "]");
            } else {
                evaluateAndTransform.arg("#[header:INVOCATION:" + invocationHeaders.value() + "]");
            }
        } else if (sessionHeaders != null) {
            if (variable.asType().isArrayOrList()) {
                evaluateAndTransform.arg("#[headers-list:SESSION:" + sessionHeaders.value() + "]");
            } else if (variable.asType().isMap()) {
                evaluateAndTransform.arg("#[headers:SESSION:" + sessionHeaders.value() + "]");
            } else {
                evaluateAndTransform.arg("#[header:SESSION:" + sessionHeaders.value() + "]");
            }
        } else if (payload != null) {
            evaluateAndTransform.arg("#[payload]");
        } else if (exceptionPayload != null) {
            evaluateAndTransform.arg((GeneratedExpression)muleEvent.invoke("getMessage").invoke("getExceptionPayload"));
        } else if (correlationId != null) {
            evaluateAndTransform.arg((GeneratedExpression)muleEvent.invoke("getMessage").invoke("getCorrelationId"));
        } else if (correlationSequence != null) {
            evaluateAndTransform.arg((GeneratedExpression)muleEvent.invoke("getMessage").invoke("getCorrelationSequence"));
        } else if (correlationGroupSize != null) {
            evaluateAndTransform.arg((GeneratedExpression)muleEvent.invoke("getMessage").invoke("getCorrelationGroupSize"));
        } else if (messageRootId != null) {
            evaluateAndTransform.arg((GeneratedExpression)muleEvent.invoke("getMessage").invoke("getMessageRootId"));
        } else if (messageUniqueId != null) {
            evaluateAndTransform.arg((GeneratedExpression)muleEvent.invoke("getMessage").invoke("getUniqueId"));
        } else if (expr != null) {
            evaluateAndTransform.arg(expr.value());
        } else {
            evaluateAndTransform.arg(expression);
        }
        GeneratedCast cast = ExpressionFactory.cast((Type)type, (GeneratedExpression)evaluateAndTransform);
        return block.decl(8, (Type)type, name, (GeneratedExpression)cast);
    }

    public GeneratedVariable declareNestedProcessorParameter(GeneratedExpression expr, GeneratedExpression muleContext, GeneratedVariable event, GeneratedBlock body, boolean isList, String fieldName) {
        if (!isList) {
            GeneratedVariable transformed = body.decl(8, (Type)this.ref(NestedProcessor.class), "_transformed" + StringUtils.capitalize((String)fieldName), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(NestedProcessorChain.class)).arg((GeneratedExpression)event).arg(muleContext).arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MessageProcessor.class), (GeneratedExpression)expr)));
            return transformed;
        }
        GeneratedVariable transformed = body.decl(8, (Type)this.ref(List.class).narrow(this.ref(NestedProcessor.class)), "_transformed" + StringUtils.capitalize((String)fieldName), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(this.ref(NestedProcessor.class))));
        GeneratedConditional ifMessageProcessor = body._if(expr.isNotNull());
        GeneratedForEach forEachProcessor = ifMessageProcessor._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)expr));
        forEachProcessor.body().add((Statement)transformed.invoke("add").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(NestedProcessorChain.class)).arg((GeneratedExpression)event).arg(muleContext).arg((GeneratedExpression)forEachProcessor.var())));
        return transformed;
    }

    protected void generateCustomConstructor(GeneratedClass messageProcessorClass) {
        GeneratedMethod customConstructor = messageProcessorClass.constructor(1);
        customConstructor.param((Type)this.ref(String.class), "operationName");
        customConstructor.body().directStatement("super(operationName);");
    }

    public class FieldVariableElement {
        private final GeneratedField field;
        private final GeneratedField fieldType;
        private final Variable variable;

        public FieldVariableElement(GeneratedField field, GeneratedField fieldType, Variable variable) {
            this.field = field;
            this.fieldType = fieldType;
            this.variable = variable;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + (this.fieldType == null ? 0 : this.fieldType.hashCode());
            result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldVariableElement other = (FieldVariableElement)obj;
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            if (this.fieldType == null ? other.fieldType != null : !this.fieldType.equals(other.fieldType)) {
                return false;
            }
            return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
        }

        public GeneratedField getField() {
            return this.field;
        }

        public GeneratedField getFieldType() {
            return this.fieldType;
        }

        public Variable getVariable() {
            return this.variable;
        }
    }
}

