/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import org.mule.api.annotations.MetaDataKeyRetriever;
import org.mule.api.annotations.MetaDataRetriever;
import org.mule.api.annotations.MetaDataScope;
import org.mule.api.annotations.Query;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.MultiModuleAnnotationVerifier;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.metadata.MetaDataModule;
import org.mule.devkit.verifiers.metadata.MetaDataAnnotationVerifierUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class MultiModuleMetaDataVerifier
implements MultiModuleAnnotationVerifier {
    public boolean shouldVerify(List<Module> modules) {
        for (Module module : modules) {
            if (!module.getKind().equals((Object)ModuleKind.METADATA_CATEGORY) && !module.getKind().equals((Object)ModuleKind.CONNECTOR)) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (!module.getKind().equals((Object)ModuleKind.METADATA_CATEGORY) && !module.getKind().equals((Object)ModuleKind.CONNECTOR) && !module.getKind().equals((Object)ModuleKind.GENERIC)) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    public void verify(List<Module> modules, NotificationGatherer gatherer) throws AnnotationVerificationException {
        List<Module> managedConnectionModules = this.getManagedConnectionModules(modules);
        List<Module> genericModules = this.getModuleByKind(modules, ModuleKind.GENERIC);
        List<Module> metaDataCategoryModules = this.getModuleByKind(modules, ModuleKind.METADATA_CATEGORY);
        if (managedConnectionModules.isEmpty() && !metaDataCategoryModules.isEmpty()) {
            gatherer.error((Identifiable)metaDataCategoryModules.get(0), (DevkitNotification)Message.DEVKIT_067, new Object[0]);
        }
        this.verifyManagedConnectionModules(managedConnectionModules, metaDataCategoryModules, gatherer);
        this.verifyGenericModules(genericModules, metaDataCategoryModules, gatherer);
        this.verifyConsistencyMetaDataCategoryModules(metaDataCategoryModules, managedConnectionModules, gatherer);
    }

    private void verifyGenericModules(List<Module> genericModules, List<Module> metaDataCategoryModules, NotificationGatherer gatherer) {
        for (Module genericModule : genericModules) {
            List<Module> specificUsedMetaDataCategoryModules = this.getSpecificUsedMetaDataCategoryModules(metaDataCategoryModules, genericModule);
            if (specificUsedMetaDataCategoryModules.isEmpty()) continue;
            ArrayList<String> metaDataCategoriesNames = new ArrayList<String>();
            for (Module metaDataCategory : specificUsedMetaDataCategoryModules) {
                metaDataCategoriesNames.add(metaDataCategory.getName());
            }
            gatherer.error((Identifiable)genericModule, (DevkitNotification)Message.DEVKIT_068, new Object[]{genericModule.getName(), StringUtils.join(metaDataCategoriesNames, (String)", ")});
        }
    }

    private void verifyConsistencyMetaDataCategoryModules(List<Module> metaDataCategoryModules, List<Module> managedConnectionModules, NotificationGatherer gatherer) {
        List<Type> managedConnectionModuleTypes = this.gatherAllManagedConnectionModulesTypes(managedConnectionModules);
        HashMap metaDataCategoryNameMap = new HashMap();
        for (Module module : metaDataCategoryModules) {
            if (metaDataCategoryNameMap.get(module.getName()) == null) {
                metaDataCategoryNameMap.put(module.getName(), new ArrayList());
            }
            ((List)metaDataCategoryNameMap.get(module.getName())).add(module);
            if (module.getInjectFields().size() != 1) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_069, new Object[0]);
            } else {
                Field connectorField = (Field)module.getInjectFields().get(0);
                if (!connectorField.hasSetter()) {
                    gatherer.error((Identifiable)connectorField, (DevkitNotification)Message.DEVKIT_070, new Object[]{connectorField.getName()});
                }
                if (connectorField.asType().isInterface() || connectorField.asType().isFinal()) {
                    gatherer.error((Identifiable)connectorField, (DevkitNotification)Message.DEVKIT_071, new Object[]{connectorField.getName()});
                }
            }
            if (!module.hasNoArgConstructor()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_072, new Object[0]);
            }
            if (module.isPrivate() || module.isAbstract() || module.isProtected()) {
                gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_073, new Object[0]);
            }
            this.verifyProperMetaDataImplementation(module, gatherer);
        }
        for (Map.Entry entry : metaDataCategoryNameMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            ArrayList<String> fullQualifiedNames = new ArrayList<String>();
            for (Module m : (List)entry.getValue()) {
                fullQualifiedNames.add(m.getQualifiedName().toString());
            }
            gatherer.error((Identifiable)((List)entry.getValue()).get(0), (DevkitNotification)Message.DEVKIT_074, new Object[]{entry.getKey(), String.valueOf(((List)entry.getValue()).size()), StringUtils.join(fullQualifiedNames, (String)", ")});
        }
        for (Module module : this.getUnusedMetaDataCategoryModules(metaDataCategoryModules, managedConnectionModules)) {
            gatherer.warn((Identifiable)module, (DevkitNotification)Message.DEVKIT_075, new Object[]{module.getQualifiedName()});
        }
    }

    private List<Type> gatherAllManagedConnectionModulesTypes(List<Module> managedConnectionModules) {
        ArrayList<Type> managedConnectionModuleTypes = new ArrayList<Type>();
        for (Module managedConnectionModule : managedConnectionModules) {
            managedConnectionModuleTypes.add(managedConnectionModule.asType());
        }
        return managedConnectionModuleTypes;
    }

    private void verifyManagedConnectionModules(List<Module> managedConnectionModules, List<Module> metaDataCategoryModules, NotificationGatherer gatherer) {
        for (Module connectorModule : managedConnectionModules) {
            boolean moduleImplementsMetaData;
            List<Module> specificUsedMetaDataCategoryModules = this.getSpecificUsedMetaDataCategoryModules(metaDataCategoryModules, connectorModule);
            boolean bl = moduleImplementsMetaData = !specificUsedMetaDataCategoryModules.isEmpty() || connectorModule.getMetaDataKeyRetrieverMethod() != null || connectorModule.getMetaDataRetrieverMethod() != null;
            if (moduleImplementsMetaData) {
                if (!connectorModule.getMinMuleVersion().atLeast("3.4")) {
                    gatherer.error((Identifiable)connectorModule, (DevkitNotification)Message.DEVKIT_076, new Object[0]);
                }
                if (!specificUsedMetaDataCategoryModules.isEmpty()) {
                    this.verifyManagedConnectionModulesWithMetaDataCategories(connectorModule, specificUsedMetaDataCategoryModules, gatherer);
                    continue;
                }
                this.verifyProperMetaDataImplementationWithoutGrouping(connectorModule, gatherer);
                continue;
            }
            this.verifyProcessorsHasNoMetaData(connectorModule, gatherer);
        }
    }

    private void verifyManagedConnectionModulesWithMetaDataCategories(Module connectorModule, List<Module> usedMetaDataCategoryModules, NotificationGatherer gatherer) {
        if (connectorModule.getMetaDataRetrieverMethod() != null || connectorModule.getMetaDataKeyRetrieverMethod() != null) {
            gatherer.error((Identifiable)usedMetaDataCategoryModules.get(0), (DevkitNotification)Message.DEVKIT_077, new Object[0]);
        }
        ArrayList<String> metaDataCategoryNames = new ArrayList<String>();
        for (Module metaDataCategoryModule : usedMetaDataCategoryModules) {
            metaDataCategoryNames.add(metaDataCategoryModule.getQualifiedName().toString());
            if (metaDataCategoryModule.getInjectFields().isEmpty()) continue;
            Field connectorField = ((MetaDataModule)metaDataCategoryModule).getInjectedConnector();
            if (connectorModule.asType().equals(connectorField.asType()) || connectorModule.inheritsFrom(connectorField.asType())) continue;
            gatherer.error((Identifiable)connectorField, (DevkitNotification)Message.DEVKIT_078, new Object[]{connectorModule.getName(), metaDataCategoryModule.getName(), connectorField.getName(), connectorModule.getQualifiedName(), connectorField.asType().getQualifiedName()});
        }
        ArrayList<String> unscopedProcessors = new ArrayList<String>();
        for (ProcessorMethod processorMethod : connectorModule.getProcessorMethods()) {
            if (!processorMethod.hasDynamicMetaData()) continue;
            if (processorMethod.hasMetaDataScope()) {
                List<DeclaredType> usedCategories = Arrays.asList(processorMethod.metaDataScope());
                this.validateMetaDataScope(usedCategories, metaDataCategoryNames, (Identifiable)processorMethod, gatherer);
                continue;
            }
            unscopedProcessors.add(processorMethod.getName());
        }
        if (!unscopedProcessors.isEmpty()) {
            MetaDataScope metaDataScope = (MetaDataScope)connectorModule.getAnnotation(MetaDataScope.class);
            if (metaDataScope == null) {
                gatherer.error((Identifiable)connectorModule, (DevkitNotification)Message.DEVKIT_079, new Object[]{StringUtils.join(unscopedProcessors, (String)",")});
            } else {
                List<DeclaredType> usedCategories = Arrays.asList(connectorModule.metaDataScope());
                this.validateMetaDataScope(usedCategories, metaDataCategoryNames, (Identifiable)connectorModule, gatherer);
            }
        }
    }

    private void verifyProperMetaDataImplementation(Module module, NotificationGatherer gatherer) {
        Method metaDataOutputRetrieverMethod;
        List metaDataKeysRetrievers = module.getRecursivelyAnnotationProcessorMethodsAnnotatedWith(MetaDataKeyRetriever.class);
        List metaDataRetriever = module.getRecursivelyAnnotationProcessorMethodsAnnotatedWith(MetaDataRetriever.class);
        if (metaDataKeysRetrievers.isEmpty()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_080, new Object[]{module.getClassName()});
        }
        if (metaDataRetriever.isEmpty()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_081, new Object[]{module.getClassName()});
        }
        if (metaDataKeysRetrievers.size() > 1 || metaDataRetriever.size() > 1) {
            this.logErrorIfRequired(metaDataKeysRetrievers, Message.DEVKIT_082, gatherer);
            this.logErrorIfRequired(metaDataRetriever, Message.DEVKIT_082, gatherer);
        }
        if (metaDataKeysRetrievers.size() == 1 && metaDataRetriever.size() == 1) {
            Method metaDataKeyRetrieverMethod = (Method)metaDataKeysRetrievers.get(0);
            MetaDataAnnotationVerifierUtils.verifyMetaDataKeyRetrieverMethod((Method<Type>)metaDataKeyRetrieverMethod, gatherer);
            Method metaDataRetrieveMethod = (Method)metaDataRetriever.get(0);
            MetaDataAnnotationVerifierUtils.verifyMetaDataRetrieveMethod((Method<Type>)metaDataRetrieveMethod, gatherer);
            MetaDataAnnotationVerifierUtils.checkMetaDataKeyParam(module, gatherer);
        }
        if ((metaDataOutputRetrieverMethod = module.getMetaDataOutputRetrieverMethod()) != null) {
            MetaDataAnnotationVerifierUtils.verifyMetaDataRetrieveMethod((Method<Type>)metaDataOutputRetrieverMethod, gatherer);
        }
    }

    private void logErrorIfRequired(List<Method<Type>> methodsList, Message errorMessage, NotificationGatherer gatherer) {
        if (methodsList != null && methodsList.size() > 1) {
            for (Method<Type> method : methodsList) {
                gatherer.error(method, (DevkitNotification)errorMessage, new Object[0]);
            }
        }
    }

    private void verifyProperMetaDataImplementationWithoutGrouping(Module module, NotificationGatherer gatherer) {
        Method metaDataOutputRetrieverMethod = module.getMetaDataOutputRetrieverMethod();
        if (metaDataOutputRetrieverMethod != null) {
            gatherer.error((Identifiable)metaDataOutputRetrieverMethod, (DevkitNotification)Message.DEVKIT_083, new Object[0]);
        }
        this.verifyProperMetaDataImplementation(module, gatherer);
    }

    private void verifyProcessorsHasNoMetaData(Module connectorModule, NotificationGatherer gatherer) {
        for (ProcessorMethod m : connectorModule.getProcessorMethods()) {
            for (Parameter key : m.getParameters()) {
                if (key.getAnnotation(MetaDataKeyParam.class) != null) {
                    gatherer.error((Identifiable)m, (DevkitNotification)Message.DEVKIT_084, new Object[]{m.getName()});
                }
                if (key.getAnnotation(MetaDataStaticKey.class) != null) {
                    gatherer.error((Identifiable)m, (DevkitNotification)Message.DEVKIT_085, new Object[]{m.getName()});
                }
                if (key.getAnnotation(Query.class) == null) continue;
                gatherer.error((Identifiable)m, (DevkitNotification)Message.DEVKIT_086, new Object[]{key.getName(), m.getName()});
            }
            if (m.getAnnotation(MetaDataStaticKey.class) == null) continue;
            gatherer.error((Identifiable)m, (DevkitNotification)Message.DEVKIT_087, new Object[]{m.getName()});
        }
    }

    private void validateMetaDataScope(List<DeclaredType> usedMetaDataScopes, List<String> metaDataCategoryNames, Identifiable identifiable, NotificationGatherer gatherer) {
        for (DeclaredType declaredType : usedMetaDataScopes) {
            if (metaDataCategoryNames.contains(declaredType.toString())) continue;
            String fullQUalifiedClassName = declaredType.toString();
            gatherer.error(identifiable, (DevkitNotification)Message.DEVKIT_088, new Object[]{fullQUalifiedClassName, fullQUalifiedClassName});
        }
    }

    private List<Module> getUnusedMetaDataCategoryModules(List<Module> metaDataCategoryModules, List<Module> modules) {
        ArrayList<Module> usedMetaDataCategoryModules = new ArrayList<Module>();
        for (Module module : modules) {
            usedMetaDataCategoryModules.addAll(this.getSpecificUsedMetaDataCategoryModules(metaDataCategoryModules, module));
        }
        ArrayList<Module> unusedMetaDataCategories = new ArrayList<Module>(metaDataCategoryModules);
        unusedMetaDataCategories.removeAll(usedMetaDataCategoryModules);
        return unusedMetaDataCategories;
    }

    private List<Module> getSpecificUsedMetaDataCategoryModules(List<Module> metaDataCategoryModules, Module module) {
        ArrayList<Module> usedMetaDataCategoryModules = new ArrayList<Module>();
        ArrayList<DeclaredType> usedCategories = new ArrayList<DeclaredType>();
        if (module.getAnnotation(MetaDataScope.class) != null) {
            usedCategories.add(module.metaDataScope());
        }
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.hasMetaDataScope()) continue;
            usedCategories.add(processorMethod.metaDataScope());
        }
        block1: for (Module metaDataCategoryModule : metaDataCategoryModules) {
            String fullQualifiedName = metaDataCategoryModule.getQualifiedName().toString();
            for (DeclaredType declaredType : usedCategories) {
                if (!fullQualifiedName.equals(declaredType.toString())) continue;
                usedMetaDataCategoryModules.add(metaDataCategoryModule);
                continue block1;
            }
        }
        return usedMetaDataCategoryModules;
    }

    private List<Module> getManagedConnectionModules(List<Module> modules) {
        ArrayList<Module> connectionManagedModules = new ArrayList<Module>();
        for (Module module : this.getModuleByKind(modules, ModuleKind.CONNECTOR)) {
            if (!(module instanceof ManagedConnectionModule)) continue;
            connectionManagedModules.add(module);
        }
        return connectionManagedModules;
    }

    private List<Module> getModuleByKind(List<Module> modules, ModuleKind aKind) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (!module.getKind().equals((Object)aKind)) continue;
            specificModules.add(module);
        }
        return specificModules;
    }
}

