/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.lang.model.type.TypeKind;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.lifecycle.Start;
import org.mule.api.annotations.lifecycle.Stop;
import org.mule.devkit.generation.NamingConstants;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    private static final boolean ALWAYS_VERIFY = true;

    public boolean shouldVerify(Module module) {
        return true;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        this.checkForbiddedMethodNames(module);
        this.check(module, PostConstruct.class);
        this.check(module, Start.class);
        this.check(module, Stop.class);
        this.check(module, PreDestroy.class);
    }

    private void checkForbiddedMethodNames(Module module) throws AnnotationVerificationException {
        List methods = module.getMethods();
        for (Method method : methods) {
            if (method.isPrivate() || !method.getParameters().isEmpty()) continue;
            for (String forbiddenNoArgMethodName : NamingConstants.RESERVED_NO_ARGS_METHOD_NAMES) {
                String methodName;
                if (!forbiddenNoArgMethodName.equals(methodName = method.getName())) continue;
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_044, new Object[]{methodName, StringUtils.join(NamingConstants.RESERVED_NO_ARGS_METHOD_NAMES, (String)",")});
            }
        }
    }

    private void check(Module module, Class<? extends Annotation> annotation) throws AnnotationVerificationException {
        Method method;
        List methods = module.getMethodsAnnotatedWith(annotation);
        if (methods.isEmpty()) {
            return;
        }
        if (methods.size() > 1) {
            this.addListOfErrors(methods, (DevkitNotification)Message.DEVKIT_045, annotation.getSimpleName());
        }
        if (!(method = (Method)methods.get(0)).getParameters().isEmpty()) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_046, new Object[]{annotation.getSimpleName()});
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_047, new Object[0]);
        }
        if (method.isStatic()) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_048, new Object[]{annotation.getSimpleName()});
        }
        if (!method.isPublic()) {
            this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_049, new Object[]{annotation.getSimpleName()});
        }
    }

    private void addListOfErrors(List<Method<Type>> methodsWithError, DevkitNotification notification, String annotationSimpleName) {
        for (Method<Type> method : methodsWithError) {
            this.getGatherer().error(method, notification, new Object[]{annotationSimpleName});
        }
    }
}

