/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.HashSet;
import java.util.List;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

public class ConnectParametersVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        ManagedConnectionModule cmodule = (ManagedConnectionModule)module;
        List cparameters = cmodule.getConnectMethod().getParameters();
        HashSet<String> connectionParametersNames = new HashSet<String>(cparameters.size());
        for (Parameter cparameter : cparameters) {
            connectionParametersNames.add(cparameter.getName());
        }
        for (ProcessorMethod pm : cmodule.getProcessorMethods()) {
            for (Parameter param : pm.getParameters()) {
                if (!connectionParametersNames.contains(param.getName())) continue;
                gatherer.error((Identifiable)param, (DevkitNotification)Message.DEVKIT_040, new Object[]{param.getName()});
            }
        }
    }
}

