/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.spring.SchemaBuilder;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.schema.Schema;
import org.mule.devkit.model.schema.SchemaLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator
extends AbstractCodeGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.NAMESPACE_HANDLER, Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.INJECTION_ADAPTER, Product.OAUTH_ADAPTER, Product.POOL_CONFIG, Product.POOL_IMPL);
    private static final List<Product> PRODUCES = Arrays.asList(Product.SCHEMA);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    public void generate(List<Module> modules) throws GenerationException {
        Set<String> targetNamespaces = this.getTargetNamespaces(modules);
        for (String targetNamespace : targetNamespaces) {
            SchemaBuilder schemaBuilder = SchemaBuilder.newSchema(targetNamespace);
            schemaBuilder.importXmlNamespace().importSpringFrameworkNamespace().importMuleNamespace();
            Module oneModuleFromThatNamespace = null;
            for (Module module : modules) {
                if (!module.getXmlNamespace().equals(targetNamespace)) continue;
                oneModuleFromThatNamespace = module;
                GeneratedClass moduleClass = this.getModuleClass(module);
                schemaBuilder.registerConfigElement(module, moduleClass, this.ctx()).registerProcessorsAndSourcesAndFilters(module).registerTransformers(module);
            }
            schemaBuilder.registerEnums();
            schemaBuilder.registerSimpleTypes();
            if (oneModuleFromThatNamespace == null) {
                throw new IllegalStateException(String.format("A namespace (%s) was found but no module is registered in it.", targetNamespace));
            }
            Module module = oneModuleFromThatNamespace;
            String fileName = "META-INF/mule-" + module.getModuleName() + ".xsd";
            String versionedLocation = module.getVersionedSchemaLocation();
            String currentLocation = module.getCurrentSchemaLocation();
            String namespaceHandlerName = ((GeneratedClass)this.ctx().getProduct(Product.NAMESPACE_HANDLER, null, targetNamespace)).boxify().fullName();
            String className = this.getModuleClass(module).fullName();
            Schema schema = schemaBuilder.getSchema();
            SchemaLocation versionedSchemaLocation = new SchemaLocation(schema, schema.getTargetNamespace(), fileName, versionedLocation, namespaceHandlerName, className);
            this.ctx().getSchemaModel().addSchemaLocation(versionedSchemaLocation);
            if (currentLocation == null) continue;
            SchemaLocation currentSchemaLocation = new SchemaLocation(null, schema.getTargetNamespace(), fileName, currentLocation, namespaceHandlerName, className);
            this.ctx().getSchemaModel().addSchemaLocation(currentSchemaLocation);
        }
    }

    private Set<String> getTargetNamespaces(List<Module> modules) {
        HashSet<String> targetNamespaces = new HashSet<String>();
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC || targetNamespaces.contains(module.getXmlNamespace())) continue;
            targetNamespaces.add(module.getXmlNamespace());
        }
        return targetNamespaces;
    }

    private GeneratedClass getModuleClass(Module module) {
        GeneratedClass moduleClass = module instanceof ManagedConnectionModule ? (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGER, (Identifiable)module) : (module.usesPooling() ? (GeneratedClass)this.ctx().getProduct(Product.POOL_MANAGER, (Identifiable)module) : ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass());
        return moduleClass;
    }
}

