/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transformer;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectivityProcessorInterfaceGenerator
extends AbstractMuleGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(new Product[0]);
    private static final List<Product> PRODUCES = Arrays.asList(Product.CONNECTIVITY_PROCESSOR_INTERFACE);
    private static final String CONNECTIVITY_PROCESSOR_NAME_INTERFACE = "ConnectivityProcessor";
    public static final String METHOD_TYPE_FOR = "typeFor";

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        if (this.ctx().getProduct(Product.CONNECTIVITY_PROCESSOR_INTERFACE) != null) {
            return false;
        }
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule) && !(module instanceof OAuthModule)) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule) && !(module instanceof OAuthModule)) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    public void generate(List<Module> modules) throws GenerationException {
        GeneratedClass connectivityProcessorInterfaceClass = this.getConnectivityProcessorInterfaceClass(modules.get(0));
        for (Module module : modules) {
            ConnectMethod connectMethod;
            if (!(module instanceof ManagedConnectionModule) || (connectMethod = ((ManagedConnectionModule)module).getConnectMethod()) == null) continue;
            for (Parameter parameter : connectMethod.getParameters()) {
                connectivityProcessorInterfaceClass.method(1, (org.mule.devkit.model.code.Type)this.ref(Object.class), "get" + StringUtils.capitalize((String)parameter.getName()));
            }
        }
        GeneratedMethod getTypeForMethod = connectivityProcessorInterfaceClass.method(1, (org.mule.devkit.model.code.Type)this.ref(Type.class), METHOD_TYPE_FOR);
        getTypeForMethod._throws(NoSuchFieldException.class);
        GeneratedVariable fieldName = getTypeForMethod.param(String.class, "fieldName");
        getTypeForMethod.javadoc().add((Object)"Retrieves the concrete java.lang.reflect.Type of a connectivity argument, needed for the @Connect");
        getTypeForMethod.javadoc().addParam(fieldName).add((Object)"Name of the field to look for");
        getTypeForMethod.javadoc().addReturn("").add((Object)("The {@link java.lang.reflect.Type} associated with the field {@code " + fieldName.name() + "}"));
        getTypeForMethod.javadoc().addThrows(NoSuchFieldException.class).add((Object)("Thrown when the {@code " + fieldName.name() + "} is not a field from the current class"));
    }

    protected GeneratedClass getConnectivityProcessorInterfaceClass(Module type) throws GenerationException {
        try {
            GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".processors");
            GeneratedClass generatedInterface = pkg._interface(CONNECTIVITY_PROCESSOR_NAME_INTERFACE);
            this.ctx().registerProduct(Product.CONNECTIVITY_PROCESSOR_INTERFACE, (Object)generatedInterface);
            generatedInterface.javadoc().add((Object)"Interface used to unify all message processors (those which use (or not) pagination) from the ManagedConnectionProcessInterceptor");
            return generatedInterface;
        }
        catch (ClassAlreadyExistsException e) {
            throw new GenerationException("There was a problem while trying to generate the [" + type.getPackage().getName() + "." + CONNECTIVITY_PROCESSOR_NAME_INTERFACE + "] interface ", (Throwable)e);
        }
    }
}

