/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationValue;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.MetaDataScope;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.api.annotations.Mime;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.NoMetaData;
import org.mule.api.annotations.QueryCustomMetadata;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.SourceCallback;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transport.PropertyScope;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultParameterizedMapMetaDataModel;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.QueryMetadataConnector;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.util.MetaDataQueryFilter;
import org.mule.common.query.DsqlQuery;
import org.mule.common.query.dsql.parser.MuleDsqlParser;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.MessageConstants;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedArray;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.security.oauth.DefaultHttpCallback;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.security.oauth.processor.AbstractListeningMessageProcessor;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.PagingDelegate;
import org.mule.streaming.ProviderAwarePagingDelegate;
import org.mule.streaming.processor.AbstractDevkitBasedPageableMessageProcessor;
import org.mule.streaming.processor.ManagedPagingDelegateAdapter;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.INJECTION_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.OAUTH_ADAPTER, Product.CONNECTION_KEY, Product.POOL_MANAGER, Product.CONNECTION_MANAGER, Product.ABSTRACT_CONNECTED_PROCESSOR, Product.PROCESS_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MESSAGE_PROCESSOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(org.mule.devkit.model.module.Module module) {
        return module.hasProcessors() && (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC);
    }

    public void generate(org.mule.devkit.model.module.Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            this.generateMessageProcessor(module, processorMethod);
        }
    }

    private void generateMessageProcessor(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod) {
        if (this.ctx().getProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName()) != null) {
            return;
        }
        GeneratedClass messageProcessorClass = processorMethod.isIntercepting() ? this.getInterceptingMessageProcessorClass(module, processorMethod) : this.getMessageProcessorClass(module, processorMethod);
        this.generateCustomConstructor(messageProcessorClass);
        this.ctx().note("Generating message processor as " + messageProcessorClass.fullName() + " for method " + processorMethod.getName() + " in " + module.getName());
        this.generateMessageProcessorClassDoc(processorMethod, messageProcessorClass);
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateFieldForEachParameter(messageProcessorClass, (Method)processorMethod, this.privateFieldnames);
        this.generateInitialiseMethod(messageProcessorClass, fields, module);
        this.generateStartMethod(messageProcessorClass, fields);
        this.generateStopMethod(messageProcessorClass, fields);
        this.generateDiposeMethod(messageProcessorClass, fields);
        for (String fieldName : fields.keySet()) {
            if (this.privateFieldnames.contains(fieldName)) continue;
            messageProcessorClass.setter(fields.get(fieldName).getField());
        }
        if (module.usesPooling()) {
            GeneratedClass poolObjectClass = ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass();
            this.generateProcessMethod(processorMethod, messageProcessorClass, fields, poolObjectClass, module);
        } else {
            this.generateProcessMethod(processorMethod, messageProcessorClass, fields, module);
        }
        if (module.getMinMuleVersion().atLeastBase("3.4") && this.isMetaDataEnabled(processorMethod, module)) {
            this.generateInputMetadata(module, processorMethod, messageProcessorClass);
            this.generateOutputMetadata(module, processorMethod, messageProcessorClass);
            this.generateGetPojoOrSimpleModel(module, processorMethod, messageProcessorClass);
            this.generateGetGenericMetaDataMethod(module, processorMethod, messageProcessorClass);
        }
    }

    private boolean isMetaDataEnabled(ProcessorMethod processorMethod, org.mule.devkit.model.module.Module module) {
        return processorMethod.getAnnotation(NoMetaData.class) == null && (module.isConnector() && !MetaDataSwitch.OFF.equals((Object)((Connector)module.getAnnotation(Connector.class)).metaData()) || module.isModule() && !MetaDataSwitch.OFF.equals((Object)((Module)module.getAnnotation(Module.class)).metaData()));
    }

    private void generateOutputMetadata(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getOutputMetadata = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "getOutputMetaData");
        getOutputMetadata.param((Type)this.ref(MetaData.class), "inputMetadata");
        getOutputMetadata.annotate(Override.class);
        GenericType outputGeneric = processorMethod.getReturnGenericType();
        Parameter key = processorMethod.getOutputMetaDataKeyParameter();
        if (processorMethod.hasQuery()) {
            GeneratedMethod auxOutputMetadata = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "auxOutputMetaData");
            auxOutputMetadata.param((Type)this.ref(MetaData.class), "inputMetadata");
            GeneratedVariable auxKey = auxOutputMetadata.param((Type)this.ref(String.class), "key");
            this.generateMetaDataByKeyMethod(auxKey.name(), outputGeneric, module, auxOutputMetadata, processorMethod, TypeDescribingProperty.TypeScope.OUTPUT);
            this.generateQueryMetaDataMethod(module, getOutputMetadata, auxOutputMetadata, processorMethod);
        } else if (processorMethod.hasStaticKeyOutputMetaData()) {
            String literalValue = processorMethod.getStaticKeyOutputMetaData().type();
            this.generateMetaDataByLiteralMethod(literalValue, outputGeneric, module, getOutputMetadata, processorMethod, TypeDescribingProperty.TypeScope.OUTPUT);
        } else if (processorMethod.hasDynamicOutputMetaData()) {
            this.generateMetaDataByKeyMethod(key.getName(), outputGeneric, module, getOutputMetadata, processorMethod, TypeDescribingProperty.TypeScope.OUTPUT);
        } else if (outputGeneric != null) {
            this.generateMetaDataImplicitMethod(outputGeneric, module, getOutputMetadata, processorMethod);
        } else {
            this.generateNullMetaDataMethod(getOutputMetadata);
        }
    }

    private void generateQueryMetaDataMethod(org.mule.devkit.model.module.Module module, GeneratedMethod getOutputMetadata, GeneratedMethod auxOutputMetadata, ProcessorMethod processorMethod) {
        GeneratedTry tryParseQueryAndFilter = getOutputMetadata.body()._try();
        GeneratedVariable parser = tryParseQueryAndFilter.body().decl((Type)this.ref(MuleDsqlParser.class), "parser", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MuleDsqlParser.class)));
        GeneratedVariable queryStr = tryParseQueryAndFilter.body().decl((Type)this.ref(String.class), "queryStr", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)ExpressionFactory.direct((String)processorMethod.getQueryParameter().getName())));
        GeneratedConditional ifDsql = tryParseQueryAndFilter.body()._if(Op.cand((GeneratedExpression)Op.ne((GeneratedExpression)queryStr, (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)queryStr.invoke("startsWith").arg(ExpressionFactory.lit((String)"dsql:"))));
        GeneratedBlock thenBlock = ifDsql._then();
        thenBlock.assign((AssignmentTarget)queryStr, (GeneratedExpression)queryStr.invoke("substring").arg(ExpressionFactory.lit((int)5)));
        GeneratedVariable q = thenBlock.decl((Type)this.ref(DsqlQuery.class), "q", (GeneratedExpression)parser.invoke("parse").arg((GeneratedExpression)queryStr));
        if (processorMethod.getAnnotation(QueryCustomMetadata.class) != null) {
            GeneratedClass connectionManager = this.getConnectionManager(processorMethod);
            GeneratedVariable connectorManager = thenBlock.decl((Type)connectionManager, "connectorManager", (GeneratedExpression)ExpressionFactory.cast((Type)connectionManager, (GeneratedExpression)ExpressionFactory.invoke((String)"findOrCreate").arg(this.ref((org.mule.devkit.model.Type)module).dotclass()).arg(ExpressionFactory.TRUE).arg(ExpressionFactory._null())));
            GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)processorMethod.getManagedConnectionModule())).topLevelClass();
            GeneratedVariable adapter = thenBlock.decl((Type)connectorClass, "adapter", (GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)connectorManager.invoke("acquireConnection").arg((GeneratedExpression)connectorManager.invoke("getDefaultConnectionKey"))));
            thenBlock._if((GeneratedExpression)this.ref(QueryMetadataConnector.class).dotclass().invoke("isAssignableFrom").arg((GeneratedExpression)adapter.invoke("getClass")))._then()._return((GeneratedExpression)adapter.invoke("getQueryMetadata").arg((GeneratedExpression)q));
        }
        GeneratedVariable result = thenBlock.decl((Type)this.ref(Result.class).narrow(this.ref(MetaData.class)), "result", (GeneratedExpression)ExpressionFactory.invoke((String)"auxOutputMetaData").arg(ExpressionFactory._null()).arg((GeneratedExpression)q.invoke("getTypes").invoke("get").arg(ExpressionFactory.lit((int)0)).invoke("getName")));
        GeneratedVariable filter = thenBlock.decl((Type)this.ref(MetaDataQueryFilter.class), "filter", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MetaDataQueryFilter.class)).arg((GeneratedExpression)result.invoke("get")).arg((GeneratedExpression)q.invoke("getFields")));
        thenBlock._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg((GeneratedExpression)filter.invoke("doFilter")));
        GeneratedBlock elseBlock = ifDsql._else();
        elseBlock._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")));
        GeneratedCatchBlock catchBlock = tryParseQueryAndFilter._catch(this.ref(Exception.class));
        catchBlock.param("e");
        catchBlock.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(ExpressionFactory.lit((String)"Failed on parsing and getting query metadata")));
    }

    private void generateInputMetadata(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getInputMetadata = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "getInputMetaData");
        getInputMetadata.annotate(Override.class);
        if (processorMethod.hasStaticKeyInputMetaData()) {
            Parameter input = processorMethod.getStaticKeyInputMetaData();
            String literalValue = ((MetaDataStaticKey)input.getAnnotation(MetaDataStaticKey.class)).type();
            this.generateMetaDataByLiteralMethod(literalValue, input.getGenericType(), module, getInputMetadata, processorMethod, TypeDescribingProperty.TypeScope.INPUT);
        } else if (processorMethod.hasDynamicInputMetadata()) {
            Parameter key = processorMethod.getInputMetaDataKeyParameter();
            Parameter input = processorMethod.getPayloadParameter();
            this.generateMetaDataByKeyMethod(key.getName(), input.getGenericType(), module, getInputMetadata, processorMethod, TypeDescribingProperty.TypeScope.INPUT);
        } else if (processorMethod.getPayloadParameter() != null) {
            this.generateMetaDataImplicitMethod(processorMethod.getPayloadParameter().getGenericType(), module, getInputMetadata, processorMethod);
        } else {
            this.generateNullMetaDataMethod(getInputMetadata);
        }
    }

    private void generateGetPojoOrSimpleModel(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getPojoOrSimpleModel = messageProcessorClass.method(4, (Type)this.ref(MetaDataModel.class), "getPojoOrSimpleModel");
        GeneratedVariable clazz = getPojoOrSimpleModel.param((Type)this.ref(Class.class), "clazz");
        GeneratedVariable dataType = getPojoOrSimpleModel.body().decl((Type)this.ref(DataType.class), "dataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("getInstance").invoke("getDataType").arg((GeneratedExpression)clazz));
        GeneratedConditional conditional = getPojoOrSimpleModel.body()._if((GeneratedExpression)this.ref(DataType.class).staticRef("POJO").invoke("equals").arg((GeneratedExpression)dataType));
        conditional._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultPojoMetaDataModel.class)).arg((GeneratedExpression)clazz));
        conditional._else()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultSimpleMetaDataModel.class)).arg((GeneratedExpression)dataType));
    }

    private void generateNullMetaDataMethod(GeneratedMethod method) {
        method.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(MetaData.class))).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.SUCCESS")));
    }

    private void generateMetaDataImplicitMethod(GenericType type, org.mule.devkit.model.module.Module module, GeneratedMethod method, ProcessorMethod processorMethod) {
        GeneratedInvocation defaultResultMetaData = ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaData.class)).arg(this.foldMetaData(type, processorMethod)));
        method.body()._return((GeneratedExpression)defaultResultMetaData);
    }

    private GeneratedExpression foldMetaData(GenericType type, ProcessorMethod processorMethod) {
        return this.foldMetaData(type, null, processorMethod);
    }

    private void generateMetaDataByLiteralMethod(String literalValue, GenericType type, org.mule.devkit.model.module.Module module, GeneratedMethod method, ProcessorMethod processorMethod, TypeDescribingProperty.TypeScope scope) {
        this.generateMetaDataByExpressionMethod(type, module, method, processorMethod, ExpressionFactory.lit((String)literalValue), scope);
    }

    private void generateMetaDataByKeyMethod(String typeName, GenericType type, org.mule.devkit.model.module.Module module, GeneratedMethod method, ProcessorMethod processorMethod, TypeDescribingProperty.TypeScope scope) {
        method.body()._if(Op.cor((GeneratedExpression)Op.eq((GeneratedExpression)ExpressionFactory.direct((String)typeName), (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)Op.eq((GeneratedExpression)ExpressionFactory.direct((String)typeName).invoke("toString"), (GeneratedExpression)ExpressionFactory._null())))._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.typeIsNull(module.getName(), processorMethod.getName(), typeName)));
        this.generateMetaDataByExpressionMethod(type, module, method, processorMethod, (GeneratedExpression)ExpressionFactory.direct((String)typeName).invoke("toString"), scope);
    }

    private void generateMetaDataByExpressionMethod(GenericType type, org.mule.devkit.model.module.Module module, GeneratedMethod method, ProcessorMethod processorMethod, GeneratedExpression metaDataKeyID, TypeDescribingProperty.TypeScope scope) {
        String[] split;
        GeneratedVariable metaDataKey = method.body().decl((Type)this.ref(DefaultMetaDataKey.class), "metaDataKey", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaDataKey.class)).arg(metaDataKeyID).arg(ExpressionFactory._null()));
        String fullQualifiedName = null;
        if (processorMethod.hasMetaDataScope()) {
            fullQualifiedName = processorMethod.metaDataScope().toString();
        } else if (module.getAnnotation(MetaDataScope.class) != null) {
            fullQualifiedName = module.metaDataScope().toString();
        }
        if (fullQualifiedName != null && (split = fullQualifiedName.split("\\.")).length > 1) {
            method.body().add((Statement)metaDataKey.invoke("setCategory").arg(split[split.length - 1]));
        }
        method.body().add((Statement)metaDataKey.invoke("addProperty").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(TypeDescribingProperty.class)).arg((GeneratedExpression)this.ref(TypeDescribingProperty.TypeScope.class).staticRef(scope.toString())).arg(processorMethod.getName())));
        GeneratedVariable genericMetaData = method.body().decl((Type)this.ref(Result.class).narrow(MetaData.class), "genericMetaData", (GeneratedExpression)ExpressionFactory.invoke((String)"getGenericMetaData").arg((GeneratedExpression)metaDataKey));
        method.body()._if((GeneratedExpression)ExpressionFactory.direct((String)"Result.Status.FAILURE").invoke("equals").arg((GeneratedExpression)genericMetaData.invoke("getStatus")))._then()._return((GeneratedExpression)genericMetaData);
        GeneratedInvocation defaultResultMetaData = ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaData.class)).arg(this.foldMetaData(type, genericMetaData, processorMethod)));
        method.body()._return((GeneratedExpression)defaultResultMetaData);
    }

    private void generateGetGenericMetaDataMethod(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getGenericMetaDataMethod = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "getGenericMetaData");
        GeneratedVariable metaDataKeyParam = getGenericMetaDataMethod.param((Type)this.ref(MetaDataKey.class), "metaDataKey");
        GeneratedVariable connector = getGenericMetaDataMethod.body().decl((Type)this.ref(ConnectorMetaDataEnabled.class), "connector");
        GeneratedTry generatedTry = getGenericMetaDataMethod.body()._try();
        if (module instanceof ManagedConnectionModule) {
            generatedTry.body().assign((AssignmentTarget)connector, (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectorMetaDataEnabled.class), (GeneratedExpression)ExpressionFactory.invoke((String)"findOrCreate").arg(this.getConnectionManager(processorMethod).dotclass()).arg(ExpressionFactory.TRUE).arg(ExpressionFactory._null())));
        } else {
            generatedTry.body().assign((AssignmentTarget)connector, (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectorMetaDataEnabled.class), (GeneratedExpression)ExpressionFactory.invoke((String)"findOrCreate").arg(this.ref((org.mule.devkit.model.Type)module).dotclass()).arg(ExpressionFactory.TRUE).arg(ExpressionFactory._null())));
        }
        GeneratedTry metadataTry = generatedTry.body()._try();
        GeneratedVariable metadata = metadataTry.body().decl((Type)this.ref(Result.class).narrow(MetaData.class), "metadata", (GeneratedExpression)connector.invoke("getMetaData").arg((GeneratedExpression)metaDataKeyParam));
        metadataTry.body()._if((GeneratedExpression)ExpressionFactory.direct((String)"Result.Status.FAILURE").invoke("equals").arg((GeneratedExpression)metadata.invoke("getStatus")))._then()._return((GeneratedExpression)metadata);
        metadataTry.body()._if(Op.eq((GeneratedExpression)metadata.invoke("get"), (GeneratedExpression)ExpressionFactory._null()))._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.metaDataGetNull(module.getName(), processorMethod.getName())));
        GeneratedCatchBlock metadataCatch = metadataTry._catch(this.ref(Exception.class));
        GeneratedVariable e1 = metadataCatch.param("e");
        metadataCatch.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e1.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e1));
        metadataTry.body()._return((GeneratedExpression)metadata);
        GeneratedCatchBlock classCastExeption = generatedTry._catch(this.ref(ClassCastException.class));
        classCastExeption.param("cast");
        classCastExeption.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.noConnectionManagerAvaiableMaybeOauth()));
        GeneratedCatchBlock configException = generatedTry._catch(this.ref(ConfigurationException.class));
        GeneratedVariable e = configException.param("e");
        configException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock registrationException = generatedTry._catch(this.ref(RegistrationException.class));
        registrationException.param("e");
        registrationException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock illegalAccessException = generatedTry._catch(this.ref(IllegalAccessException.class));
        illegalAccessException.param("e");
        illegalAccessException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock instantiationException = generatedTry._catch(this.ref(InstantiationException.class));
        instantiationException.param("e");
        instantiationException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock exception = generatedTry._catch(this.ref(Exception.class));
        exception.param("e");
        exception.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
    }

    private GeneratedClass getConnectionManager(ProcessorMethod processorMethod) {
        if (processorMethod.canBeUsedInConnectionManagement()) {
            return (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGER, (Identifiable)processorMethod.getManagedConnectionModule());
        }
        throw new RuntimeException();
    }

    private GeneratedExpression foldMetaData(GenericType type, GeneratedVariable metadata, ProcessorMethod processorMethod) {
        if (type.isCollection() || type.getElement() != null && type.is(ProviderAwarePagingDelegate.class.getSimpleName())) {
            return this.foldCollectionMetaData(type, metadata, processorMethod);
        }
        if (metadata != null) {
            return metadata.invoke("get").invoke("getPayload");
        }
        if (type.isMap()) {
            return this.foldMapMetaData(type, metadata, processorMethod);
        }
        return this.foldLeafMetaData(type, processorMethod);
    }

    private GeneratedExpression foldCollectionMetaData(GenericType type, GeneratedVariable metadata, ProcessorMethod processorMethod) {
        GeneratedExpression arg0 = type.getGenericTypeArguments().isEmpty() ? this.foldLeafPojoOrSimpleModelMetaData(this.ref(Object.class).dotclass()) : this.foldMetaData((GenericType)type.getGenericTypeArguments().get(0), metadata, processorMethod);
        return ExpressionFactory._new((TypeReference)this.ref(DefaultListMetaDataModel.class)).arg(arg0);
    }

    private GeneratedExpression foldMapMetaData(GenericType type, GeneratedVariable metadata, ProcessorMethod processorMethod) {
        GeneratedExpression arg1;
        GeneratedExpression arg0;
        if (type.getGenericTypeArguments().isEmpty()) {
            arg0 = this.foldLeafPojoOrSimpleModelMetaData(this.ref(Object.class).dotclass());
            arg1 = this.foldLeafPojoOrSimpleModelMetaData(this.ref(Object.class).dotclass());
        } else {
            arg0 = this.foldMetaData((GenericType)type.getGenericTypeArguments().get(0), metadata, processorMethod);
            arg1 = this.foldMetaData((GenericType)type.getGenericTypeArguments().get(1), metadata, processorMethod);
        }
        return ExpressionFactory._new((TypeReference)this.ref(DefaultParameterizedMapMetaDataModel.class)).arg(arg0).arg(arg1);
    }

    private GeneratedExpression foldLeafMetaData(GenericType type, ProcessorMethod processorMethod) {
        if (type.getType() != null) {
            if (!type.getGenericTypeArguments().isEmpty()) {
                this.ctx().warn(MessageConstants.typeDoesntSupportMetaData(type, processorMethod));
            }
            DataTypeFactory.getInstance().getDataType(type.getType().getKind().getDeclaringClass());
            return this.foldLeafPojoOrSimpleModelMetaData(this.ref(type.getType()).dotclass());
        }
        this.ctx().error(MessageConstants.errorGeneratingMetaData(processorMethod));
        return ExpressionFactory._null();
    }

    private GeneratedExpression foldLeafPojoOrSimpleModelMetaData(GeneratedExpression classDotClass) {
        return ExpressionFactory.invoke((String)"getPojoOrSimpleModel").arg(classDotClass);
    }

    private void generateMessageProcessorClassDoc(ProcessorMethod executableElement, GeneratedClass messageProcessorClass) {
        messageProcessorClass.javadoc().add((Object)(messageProcessorClass.name() + " invokes the "));
        messageProcessorClass.javadoc().add((Object)("{@link " + ((org.mule.devkit.model.Type)executableElement.parent()).getQualifiedName().toString() + "#"));
        messageProcessorClass.javadoc().add((Object)(executableElement.getName() + "("));
        boolean first = true;
        for (Parameter variable : executableElement.getParameters()) {
            if (!first) {
                messageProcessorClass.javadoc().add((Object)", ");
            }
            messageProcessorClass.javadoc().add((Object)((Object)variable.asTypeMirror()).toString().replaceAll("<[a-zA-Z\\-\\.\\<\\>\\s\\,]*>", ""));
            first = false;
        }
        messageProcessorClass.javadoc().add((Object)")} method in ");
        messageProcessorClass.javadoc().add((Object)this.ref(((org.mule.devkit.model.Type)executableElement.parent()).asTypeMirror()));
        messageProcessorClass.javadoc().add((Object)". For each argument there is a field in this processor to match it. ");
        messageProcessorClass.javadoc().add((Object)" Before invoking the actual method the processor will evaluate and transform");
        messageProcessorClass.javadoc().add((Object)" where possible to the expected argument type.");
    }

    private void generateProcessMethod(ProcessorMethod processorMethod, GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, org.mule.devkit.model.module.Module module) {
        this.generateProcessMethod(processorMethod, messageProcessorClass, fields, null, module);
    }

    private void generateProcessMethod(ProcessorMethod processorMethod, GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedClass poolObjectClass, org.mule.devkit.model.module.Module module) {
        GeneratedInvocation findOrCreate;
        String methodName = processorMethod.getName();
        boolean isPaged = processorMethod.isPaged();
        TypeReference muleEvent = this.ref(MuleEvent.class);
        boolean injectParameters = processorMethod.getAnnotation(Inject.class) != null;
        GeneratedMethod process = null;
        process = isPaged ? messageProcessorClass.method(1, (Type)this.ref(PagingDelegate.class), "getPagingDelegate") : messageProcessorClass.method(1, (Type)muleEvent, "doProcess");
        process.javadoc().add((Object)"Invokes the MessageProcessor.");
        process.javadoc().addParam("event MuleEvent to be processed");
        process.javadoc().addThrows(this.ref(Exception.class));
        process._throws(Exception.class);
        GeneratedVariable event = null;
        event = process.param(8, (Type)muleEvent, "event");
        GeneratedVariable pagingConfiguration = null;
        if (isPaged) {
            pagingConfiguration = process.param(8, (Type)this.ref(PagingConfiguration.class), "pagingConfiguration");
        }
        GeneratedVariable sourceCallback = null;
        if (processorMethod.isIntercepting()) {
            sourceCallback = process.body().decl(8, (Type)this.ref(SourceCallback.class), "sourceCallback", ExpressionFactory._this());
        }
        GeneratedVariable poolObject = this.declarePoolObjectIfClassNotNull(poolObjectClass, process);
        GeneratedVariable moduleObject = process.body().decl((Type)this.ref(Object.class), "moduleObject", ExpressionFactory._null());
        GeneratedTry callProcessor = process.body()._try();
        if (this.getModuleObject((org.mule.devkit.model.Type)processorMethod.parent()) != null) {
            findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(this.getModuleObject((org.mule.devkit.model.Type)processorMethod.parent()).dotclass());
            if (processorMethod.parent() instanceof org.mule.devkit.model.module.Module && ((org.mule.devkit.model.module.Module)processorMethod.parent()).needsConfig()) {
                findOrCreate.arg(ExpressionFactory.FALSE);
            } else {
                findOrCreate.arg(ExpressionFactory.TRUE);
            }
            findOrCreate.arg((GeneratedExpression)event);
            callProcessor.body().assign((AssignmentTarget)moduleObject, (GeneratedExpression)findOrCreate);
        } else {
            findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(this.ref(ProcessAdapter.class).dotclass());
            findOrCreate.arg(ExpressionFactory.FALSE);
            findOrCreate.arg((GeneratedExpression)event);
            callProcessor.body().assign((AssignmentTarget)moduleObject, (GeneratedExpression)findOrCreate);
        }
        for (String fieldName : fields.keySet()) {
            AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
            if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
            GeneratedField callbackFlowName = fields.get(fieldName).getField();
            GeneratedBlock ifCallbackFlowNameIsNull = callProcessor.body()._if(Op.cand((GeneratedExpression)callbackFlowName.isNotNull(), (GeneratedExpression)variableElement.getFieldType().isNull()))._then();
            GeneratedVariable castedModuleObject = ifCallbackFlowNameIsNull.decl((Type)this.ref(HttpCallbackAdapter.class), "castedModuleObject", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(HttpCallbackAdapter.class), (GeneratedExpression)moduleObject));
            GeneratedInvocation domain = castedModuleObject.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)"domain"));
            GeneratedInvocation localPort = castedModuleObject.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)"localPort"));
            GeneratedInvocation remotePort = castedModuleObject.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)"remotePort"));
            GeneratedInvocation async = castedModuleObject.invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)"async"));
            ifCallbackFlowNameIsNull.assign((AssignmentTarget)variableElement.getFieldType(), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultHttpCallback.class)).arg((GeneratedExpression)callbackFlowName).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext")).arg((GeneratedExpression)domain).arg((GeneratedExpression)localPort).arg((GeneratedExpression)remotePort).arg((GeneratedExpression)async));
            ifCallbackFlowNameIsNull.add((Statement)variableElement.getFieldType().invoke("start"));
        }
        ArrayList<GeneratedExpression> parameters = new ArrayList<GeneratedExpression>();
        GeneratedVariable interceptCallback = null;
        GeneratedVariable outboundHeadersMap = null;
        GeneratedVariable messageProcessorReference = null;
        if (isPaged) {
            messageProcessorReference = callProcessor.body().decl(8, (Type)this.ref(MessageProcessor.class), "messageProcessor", ExpressionFactory._this());
        }
        for (Parameter variable : processorMethod.getParameters()) {
            String fieldName = variable.getName();
            if (((Object)variable.asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) {
                parameters.add((GeneratedExpression)fields.get(fieldName).getFieldType());
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(SourceCallback.class.getName())) {
                parameters.add((GeneratedExpression)sourceCallback);
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(PagingConfiguration.class.getName())) {
                parameters.add((GeneratedExpression)pagingConfiguration);
                continue;
            }
            if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                parameters.add((GeneratedExpression)this.declareNestedProcessorParameter((GeneratedExpression)fields.get(fieldName).getField(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"), event, callProcessor.body(), variable.asType().isArrayOrList(), fieldName));
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(MuleMessage.class.getName()) && injectParameters) {
                parameters.add((GeneratedExpression)event.invoke("getMessage"));
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(MuleEvent.class.getName()) && injectParameters) {
                parameters.add((GeneratedExpression)event);
                continue;
            }
            outboundHeadersMap = this.declareStandardParameter((Variable)variable, messageProcessorClass, event, callProcessor, parameters, outboundHeadersMap);
            GeneratedExpression lastTrasformedVariable = (GeneratedExpression)parameters.get(parameters.size() - 1);
            if (variable.asType().isString() && variable.hasSizeLimit()) {
                this.restrictSize(callProcessor, methodName, lastTrasformedVariable, event, "length", (Variable)variable);
            } else if (variable.hasSizeLimit()) {
                this.restrictSize(callProcessor, methodName, lastTrasformedVariable, event, "size", (Variable)variable);
            }
            if (!variable.asType().isString() || !variable.hasPattern() && !variable.hasEmailPattern()) continue;
            this.restrictPattern(callProcessor, methodName, lastTrasformedVariable, event, "matches", variable);
        }
        Type returnType = this.ref(processorMethod.getReturnType());
        GeneratedVariable resultPayload = this.generateMethodCall(processorMethod, callProcessor.body(), methodName, parameters, event, returnType, interceptCallback, (org.mule.devkit.model.Type)processorMethod.parent(), moduleObject, module, messageProcessorReference);
        for (Parameter variable : processorMethod.getParameters()) {
            OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
            if (outboundHeaders == null) continue;
            GeneratedConditional ifNotEmpty = callProcessor.body()._if(Op.cand((GeneratedExpression)outboundHeadersMap.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)outboundHeadersMap.invoke("isEmpty"))));
            if (this.isMuleEvent(returnType)) {
                ifNotEmpty._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)resultPayload).invoke("getMessage").invoke("addProperties").arg((GeneratedExpression)outboundHeadersMap).arg((GeneratedExpression)this.ref(PropertyScope.class).staticRef("OUTBOUND")));
                continue;
            }
            ifNotEmpty._then().add((Statement)event.invoke("getMessage").invoke("addProperties").arg((GeneratedExpression)outboundHeadersMap).arg((GeneratedExpression)this.ref(PropertyScope.class).staticRef("OUTBOUND")));
        }
        if (processorMethod.getAnnotation(Mime.class) != null) {
            GeneratedInvocation invocation = this.isMuleEvent(returnType) ? ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)resultPayload).invoke("getMessage") : event.invoke("getMessage");
            GeneratedCast defaultMuleMessage = ExpressionFactory.cast((Type)this.ref(DefaultMuleMessage.class), (GeneratedExpression)invocation);
            GeneratedInvocation setMimeType = defaultMuleMessage.invoke("setMimeType").arg(ExpressionFactory.lit((String)((Mime)processorMethod.getAnnotation(Mime.class)).value()));
            callProcessor.body().add((Statement)setMimeType);
        }
        if (isPaged) {
            callProcessor.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(PagingDelegate.class), (GeneratedExpression)resultPayload));
        } else if (this.isMuleEvent(returnType)) {
            callProcessor.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)resultPayload));
        } else {
            callProcessor.body()._return((GeneratedExpression)event);
        }
        GeneratedCatchBlock catchMessagingException = callProcessor._catch(this.ref(Exception.class));
        GeneratedVariable e = catchMessagingException.param("e");
        catchMessagingException.body()._throw((GeneratedExpression)e);
        if (poolObjectClass != null) {
            GeneratedBlock fin = callProcessor._finally();
            GeneratedBlock poolObjectNotNull = fin._if(poolObject.isNotNull())._then();
            poolObjectNotNull.add((Statement)ExpressionFactory.cast((Type)((TypeReference)this.ctx().getProduct(Product.POOL_MANAGER_INTERFACE)), (GeneratedExpression)moduleObject).invoke("getLifecyleEnabledObjectPool").invoke("returnObject").arg((GeneratedExpression)poolObject));
        }
    }

    private void restrictPattern(GeneratedTry callProcessor, String methodName, GeneratedExpression trasformedVariable, GeneratedVariable event, String matches, Parameter variable) {
        GeneratedExpression optional = variable.isOptional() ? Op.ne((GeneratedExpression)trasformedVariable, (GeneratedExpression)ExpressionFactory._null()) : ExpressionFactory.TRUE;
        GeneratedConditional conditional = callProcessor.body()._if(Op.cand((GeneratedExpression)optional, (GeneratedExpression)Op.not((GeneratedExpression)trasformedVariable.invoke(matches).arg(variable.getPattern()))));
        this.generateThrow("createStaticMessage", MessagingException.class, conditional._then(), (GeneratedExpression)event, "Pattern doesn't match on attribute:" + variable.getName() + MessageConstants.AT_PROCESSOR + NameUtils.uncamel((String)methodName));
    }

    private void restrictSize(GeneratedTry callProcessor, String methodName, GeneratedExpression transformedParameter, GeneratedVariable event, String sizeMethod, Variable variable) {
        GeneratedExpression optional = variable.isOptional() ? Op.ne((GeneratedExpression)transformedParameter, (GeneratedExpression)ExpressionFactory._null()) : ExpressionFactory.TRUE;
        GeneratedConditional conditional = callProcessor.body()._if(Op.cand((GeneratedExpression)optional, (GeneratedExpression)Op.cor((GeneratedExpression)Op.lt((GeneratedExpression)transformedParameter.invoke(sizeMethod), (GeneratedExpression)ExpressionFactory.lit((int)variable.getMinSizeLimit())), (GeneratedExpression)Op.lt((GeneratedExpression)ExpressionFactory.lit((int)variable.getMaxSizeLimit()), (GeneratedExpression)transformedParameter.invoke(sizeMethod)))));
        this.generateThrow("createStaticMessage", MessagingException.class, conditional._then(), (GeneratedExpression)event, MessageConstants.LIMITED_SIZE_EXCEEDED + variable.getName() + MessageConstants.AT_PROCESSOR + NameUtils.uncamel((String)methodName));
    }

    private GeneratedVariable declareStandardParameter(Variable variable, GeneratedClass messageProcessorClass, GeneratedVariable muleEvent, GeneratedTry callProcessor, List<GeneratedExpression> parameters, GeneratedVariable outboundHeadersMap) {
        OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
        if (variable.isQuery() && variable.asType().isDsqlQueryObject()) {
            GeneratedVariable transformed = this.declareTransformedVariableClass(variable, String.class, (Type)messageProcessorClass, muleEvent, callProcessor.body());
            parameters.add((GeneratedExpression)transformed);
        } else if (this.privateFieldnames.contains(variable.getName())) {
            GeneratedVariable transformed = this.declareTransformedSuperField(variable, DevkitBasedMessageProcessor.class, messageProcessorClass, muleEvent, callProcessor.body());
            parameters.add((GeneratedExpression)transformed);
        } else if (outboundHeaders == null) {
            GeneratedVariable transformed = this.declareTransformedVariable(variable, (GeneratedExpression)ExpressionFactory.ref((String)variable.getName()), (Type)messageProcessorClass, muleEvent, callProcessor.body(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
            parameters.add((GeneratedExpression)transformed);
        } else {
            TypeReference type = this.ref(HashMap.class).narrow(new TypeReference[]{this.ref(String.class), this.ref(Object.class)});
            String name = "_transformed" + org.apache.commons.lang.StringUtils.capitalize((String)variable.getName());
            outboundHeadersMap = callProcessor.body().decl(8, (Type)type, name, (GeneratedExpression)ExpressionFactory._new((Type)type));
            parameters.add((GeneratedExpression)outboundHeadersMap);
        }
        return outboundHeadersMap;
    }

    private GeneratedVariable declareTransformedSuperField(Variable variable, Class devkitSuperMessageProcessor, GeneratedClass fieldClass, GeneratedVariable muleEvent, GeneratedBlock block) {
        GeneratedInvocation muleContext = ExpressionFactory.invoke((String)"getMuleContext");
        TypeReference type = this.ref(variable.asTypeMirror()).boxify();
        String name = "_transformed" + StringUtils.capitalize((String)variable.getName());
        GeneratedInvocation getGenericType = this.ref(devkitSuperMessageProcessor).dotclass().invoke("getDeclaredField").arg(ExpressionFactory.lit((String)variable.getName())).invoke("getGenericType");
        GeneratedInvocation evaluateAndTransform = ExpressionFactory.invoke((String)"evaluateAndTransform").arg((GeneratedExpression)muleContext).arg((GeneratedExpression)muleEvent).arg((GeneratedExpression)getGenericType);
        Mime mime = (Mime)variable.getAnnotation(Mime.class);
        if (mime != null) {
            evaluateAndTransform.arg(ExpressionFactory.lit((String)mime.value()));
        } else {
            evaluateAndTransform.arg(ExpressionFactory._null());
        }
        Payload payload = (Payload)variable.getAnnotation(Payload.class);
        if (payload != null) {
            evaluateAndTransform.arg("#[payload]");
        } else {
            evaluateAndTransform.arg((GeneratedExpression)ExpressionFactory._super().invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)variable.getName())));
        }
        GeneratedCast cast = ExpressionFactory.cast((Type)type, (GeneratedExpression)evaluateAndTransform);
        return block.decl(8, (Type)type, name, (GeneratedExpression)cast);
    }

    private GeneratedVariable declareTransformedVariableClass(Variable variable, Class clazz, Type fieldClass, GeneratedVariable muleEvent, GeneratedBlock block) {
        GeneratedInvocation muleContext = ExpressionFactory.invoke((String)"getMuleContext");
        TypeReference type = this.ref(clazz).boxify();
        String name = "_transformed" + StringUtils.capitalize((String)variable.getName());
        GeneratedInvocation getGenericType = fieldClass.boxify().dotclass().invoke("getDeclaredField").arg(ExpressionFactory.lit((String)("_" + variable.getName() + "Type"))).invoke("getGenericType");
        GeneratedInvocation evaluateAndTransform = ExpressionFactory.invoke((String)"evaluateAndTransform").arg((GeneratedExpression)muleContext).arg((GeneratedExpression)muleEvent).arg((GeneratedExpression)getGenericType);
        Mime mime = (Mime)variable.getAnnotation(Mime.class);
        if (mime != null) {
            evaluateAndTransform.arg(ExpressionFactory.lit((String)mime.value()));
        } else {
            evaluateAndTransform.arg(ExpressionFactory._null());
        }
        Payload payload = (Payload)variable.getAnnotation(Payload.class);
        if (payload != null) {
            evaluateAndTransform.arg("#[payload]");
        } else {
            evaluateAndTransform.arg((GeneratedExpression)ExpressionFactory.ref((String)variable.getName()));
        }
        GeneratedCast cast = ExpressionFactory.cast((Type)type, (GeneratedExpression)evaluateAndTransform);
        return block.decl(8, (Type)type, name, (GeneratedExpression)cast);
    }

    private GeneratedVariable declarePoolObjectIfClassNotNull(GeneratedClass poolObjectClass, GeneratedMethod process) {
        if (poolObjectClass != null) {
            return process.body().decl((Type)poolObjectClass, "_poolObject", ExpressionFactory._null());
        }
        return null;
    }

    private GeneratedVariable generateMethodCall(ProcessorMethod executableElement, GeneratedBlock body, String methodName, List<GeneratedExpression> parameters, GeneratedVariable event, Type returnType, GeneratedVariable interceptCallback, org.mule.devkit.model.Type moduleType, GeneratedVariable moduleObject, org.mule.devkit.model.module.Module module, GeneratedVariable messageProcessorReference) {
        boolean isPaged = executableElement.isPaged();
        GeneratedVariable resultPayload = null;
        if (returnType != this.ctx().getCodeModel().VOID) {
            resultPayload = body.decl((Type)this.ref(Object.class), "resultPayload");
        }
        GeneratedVariable processTemplate = body.decl(8, (Type)this.ref(ProcessTemplate.class).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)), "processTemplate", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ProcessAdapter.class).narrow(this.ref(Object.class)), (GeneratedExpression)moduleObject).invoke("getProcessTemplate"));
        GeneratedClass executionCallback = this.ctx().getCodeModel().anonymousClass(this.ref(ProcessCallback.class).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)));
        GeneratedMethod getManagedExceptions = executionCallback.method(1, (Type)this.ref(List.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard())), "getManagedExceptions");
        ArrayList<GeneratedExpression> exceptionClasses = new ArrayList<GeneratedExpression>();
        List reconnectionModuleExceptions = module.reconnectOn();
        List reconnectionProcessorExceptions = executableElement.reconnectOn();
        if (!reconnectionProcessorExceptions.isEmpty()) {
            for (AnnotationValue reconnectionException : reconnectionProcessorExceptions) {
                exceptionClasses.add(this.ref(reconnectionException.getValue().toString()).boxify().dotclass());
            }
        } else if (!reconnectionModuleExceptions.isEmpty()) {
            for (AnnotationValue reconnectionException : reconnectionModuleExceptions) {
                exceptionClasses.add(this.ref(reconnectionException.getValue().toString()).boxify().dotclass());
            }
        } else if (executableElement.invalidateConnectionOn() != null || executableElement.invalidateAccessTokenOn() != null) {
            if (executableElement.invalidateConnectionOn() != null) {
                exceptionClasses.add(this.ref(executableElement.invalidateConnectionOn()).boxify().dotclass());
            }
            if (executableElement.invalidateAccessTokenOn() != null) {
                exceptionClasses.add(this.ref(executableElement.invalidateAccessTokenOn()).boxify().dotclass());
            }
        }
        if (exceptionClasses.isEmpty()) {
            getManagedExceptions.body()._return(ExpressionFactory._null());
        } else {
            GeneratedArray newExceptionArray = ExpressionFactory.newArray((Type)this.ref(Class.class));
            for (GeneratedExpression generatedExpression : exceptionClasses) {
                newExceptionArray.add(generatedExpression);
            }
            getManagedExceptions.body()._return((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(Class.class).narrow(this.ref(Exception.class).wildcard()).array(), (GeneratedExpression)newExceptionArray)));
        }
        GeneratedMethod isProtected = executionCallback.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isProtected");
        if (executableElement.isOAuthProtected()) {
            isProtected.body()._return(ExpressionFactory.TRUE);
        } else {
            isProtected.body()._return(ExpressionFactory.FALSE);
        }
        GeneratedMethod process = executionCallback.method(1, (Type)this.ref(Object.class), "process");
        GeneratedVariable object2 = process.param((Type)this.ref(Object.class), "object");
        process._throws(this.ref(Exception.class));
        GeneratedInvocation transformedCall = ExpressionFactory.cast((Type)this.ref(moduleType), (GeneratedExpression)object2).invoke(methodName);
        for (GeneratedExpression parameter : parameters) {
            transformedCall.arg(parameter);
        }
        if (isPaged) {
            transformedCall = ExpressionFactory._new((TypeReference)this.ref(ManagedPagingDelegateAdapter.class)).arg((GeneratedExpression)transformedCall).arg((GeneratedExpression)processTemplate).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)getManagedExceptions)).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)isProtected)).arg((GeneratedExpression)messageProcessorReference).arg((GeneratedExpression)event);
        }
        if (executableElement.hasQuery()) {
            GeneratedVariable connector = process.body().decl(this.ref(moduleType), "connector", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(moduleType), (GeneratedExpression)object2));
            GeneratedExpression transformedQuery = ExpressionFactory.direct((String)("_transformed" + StringUtils.capitalize((String)executableElement.getQueryParameter().getName())));
            GeneratedVariable trimmedQuery = process.body().decl((Type)this.ref(String.class), "trimmedQuery", transformedQuery);
            GeneratedConditional ifDsql = process.body()._if(Op.cand((GeneratedExpression)Op.ne((GeneratedExpression)trimmedQuery, (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)transformedQuery.invoke("startsWith").arg(ExpressionFactory.lit((String)"dsql:"))));
            ifDsql._then().assign((AssignmentTarget)trimmedQuery, (GeneratedExpression)transformedQuery.invoke("substring").arg(ExpressionFactory.lit((int)5)));
            GeneratedVariable parser = ifDsql._then().decl((Type)this.ref(MuleDsqlParser.class), "parser", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MuleDsqlParser.class)));
            GeneratedVariable query = ifDsql._then().decl((Type)this.ref(DsqlQuery.class), "q", (GeneratedExpression)parser.invoke("parse").arg((GeneratedExpression)trimmedQuery));
            GeneratedInvocation methodCall = ExpressionFactory.cast((Type)this.ref(moduleType), (GeneratedExpression)object2).invoke(methodName);
            List originalParameters = executableElement.getParameters();
            for (int i = 0; i < originalParameters.size(); ++i) {
                if (((Parameter)originalParameters.get(i)).isQuery() && module.getQueryTranslatorMethod() != null) {
                    methodCall.arg((GeneratedExpression)connector.invoke(module.getQueryTranslatorMethod().getName()).arg((GeneratedExpression)query).invoke("toString"));
                    continue;
                }
                if (((Parameter)originalParameters.get(i)).isQuery() && ((Parameter)originalParameters.get(i)).asType().isDsqlQueryObject()) {
                    methodCall.arg((GeneratedExpression)query);
                    continue;
                }
                if (((Parameter)originalParameters.get(i)).isQuery() && !executableElement.hasQueryParts()) {
                    methodCall.arg(parameters.get(i));
                    continue;
                }
                if (((Parameter)originalParameters.get(i)).isQueryPart()) {
                    methodCall.arg((GeneratedExpression)connector.invoke(module.getQueryTranslatorMethod().getName()).invoke("get" + org.apache.commons.lang.StringUtils.capitalize((String)((Parameter)originalParameters.get(i)).getName())));
                    continue;
                }
                methodCall.arg(parameters.get(i));
            }
            if (isPaged) {
                methodCall = ExpressionFactory._new((TypeReference)this.ref(ManagedPagingDelegateAdapter.class)).arg((GeneratedExpression)methodCall).arg((GeneratedExpression)processTemplate).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)getManagedExceptions)).arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)isProtected)).arg((GeneratedExpression)messageProcessorReference).arg((GeneratedExpression)event);
            }
            ifDsql._then()._return((GeneratedExpression)methodCall);
            if (!executableElement.getQueryParameter().asType().isDsqlQueryObject()) {
                ifDsql._else()._return((GeneratedExpression)transformedCall);
            } else {
                ifDsql._else()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg(ExpressionFactory.lit((String)"the dsql is not valid")));
            }
            body.assign((AssignmentTarget)resultPayload, (GeneratedExpression)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        } else if (returnType != this.ctx().getCodeModel().VOID) {
            process.body()._return((GeneratedExpression)transformedCall);
            body.assign((AssignmentTarget)resultPayload, (GeneratedExpression)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        } else {
            process.body().add((Statement)transformedCall);
            process.body()._return(ExpressionFactory._null());
            body.add((Statement)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        }
        GeneratedBlock scope = body;
        if (interceptCallback != null) {
            GeneratedConditional shallContinue = body._if(Op.cand((GeneratedExpression)interceptCallback.invoke("getShallContinue"), (GeneratedExpression)ExpressionFactory.invoke((String)"getListener").isNotNull()));
            shallContinue._then().assign((AssignmentTarget)event, (GeneratedExpression)ExpressionFactory.invoke((String)"getListener").invoke("process").arg((GeneratedExpression)event));
            scope = shallContinue._else();
        }
        if (returnType != this.ctx().getCodeModel().VOID && !this.isMuleEvent(returnType) && !isPaged) {
            scope.add((Statement)event.invoke("getMessage").invoke("setPayload").arg((GeneratedExpression)resultPayload));
        }
        return resultPayload;
    }

    private GeneratedClass getMessageProcessorClass(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod) {
        GeneratedClass clazz;
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)processorMethod.parent()).getPackage().getName() + ".processors");
        if (this.hasToBeConnected(module)) {
            TypeReference typeReference = (TypeReference)this.ctx().getProduct(processorMethod.isPaged() ? Product.ABSTRACT_PAGED_CONNECTED_PROCESOR : Product.ABSTRACT_CONNECTED_PROCESSOR);
            clazz = pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", typeReference, new Class[]{MessageProcessor.class});
        } else {
            clazz = processorMethod.isPaged() ? pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", AbstractDevkitBasedPageableMessageProcessor.class, new Class[]{MessageProcessor.class}) : pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", DevkitBasedMessageProcessor.class, new Class[]{MessageProcessor.class});
        }
        if (module.getMinMuleVersion().atLeastBase("3.4") && this.isMetaDataEnabled(processorMethod, module)) {
            clazz._implements(OperationMetaDataEnabled.class);
        }
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName(), (Object)clazz);
        return clazz;
    }

    private boolean hasToBeConnected(org.mule.devkit.model.module.Module module) {
        return module instanceof ManagedConnectionModule || module instanceof OAuthModule;
    }

    private GeneratedClass getInterceptingMessageProcessorClass(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)processorMethod.parent()).getPackage().getName() + ".processors");
        GeneratedClass clazz = pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", AbstractListeningMessageProcessor.class, new Class[]{InterceptingMessageProcessor.class});
        if (module.getMinMuleVersion().atLeastBase("3.4") && this.isMetaDataEnabled(processorMethod, module)) {
            clazz._implements(OperationMetaDataEnabled.class);
        }
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName(), (Object)clazz);
        return clazz;
    }

    private void generateStartMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod startMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        startMethod._throws(this.ref(MuleException.class));
        startMethod.body().add((Statement)ExpressionFactory._super().invoke("start"));
        startMethod.annotate(Override.class);
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStartable = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Startable.class)));
                        ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)variableElement.getField()).invoke("start"));
                        continue;
                    }
                    GeneratedConditional ifIsList = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStartable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Startable.class)));
                    ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)forEachProcessor.var()).invoke("start"));
                    continue;
                }
                if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
                startMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "start");
            }
        }
    }

    private void generateStopMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod stopMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stopMethod._throws(this.ref(MuleException.class));
        stopMethod.annotate(Override.class);
        stopMethod.body().add((Statement)ExpressionFactory._super().invoke("stop"));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStoppable = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Stoppable.class)));
                        ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)variableElement.getField()).invoke("stop"));
                        continue;
                    }
                    GeneratedConditional ifIsList = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStoppable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Stoppable.class)));
                    ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)forEachProcessor.var()).invoke("stop"));
                    continue;
                }
                if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
                stopMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "stop");
            }
        }
    }

    private void generateDiposeMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod diposeMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
        diposeMethod.annotate(Override.class);
        diposeMethod.body().add((Statement)ExpressionFactory._super().invoke("dispose"));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (!variableElement.getVariable().asType().isNestedProcessor() && (!variableElement.getVariable().asType().isArrayOrList() || variableElement.getVariable().getTypeArguments().size() <= 0 || !((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor())) continue;
                boolean isList = variableElement.getVariable().asType().isArrayOrList();
                if (!isList) {
                    GeneratedConditional ifDisposable = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Disposable.class)));
                    ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)variableElement.getField()).invoke("dispose"));
                    continue;
                }
                GeneratedConditional ifIsList = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                GeneratedConditional ifDisposable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Disposable.class)));
                ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)forEachProcessor.var()).invoke("dispose"));
            }
        }
    }

    private boolean isMuleEvent(Type type) {
        return type.fullName().startsWith(MuleEvent.class.getName());
    }
}

