/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.Mime;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.callback.HttpCallback;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.FilterMethod;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.security.oauth.DefaultHttpCallback;
import org.mule.security.oauth.callback.HttpCallbackAdapter;
import org.mule.security.oauth.callback.ProcessCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.INJECTION_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.OAUTH_ADAPTER, Product.CONNECTION_KEY, Product.POOL_MANAGER, Product.CONNECTION_MANAGER, Product.ABSTRACT_FILTER, Product.PROCESS_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(Product.FILTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.hasFilters() && module.getKind() == ModuleKind.GENERIC;
    }

    public void generate(Module module) {
        for (FilterMethod filterMethod : module.getFilterMethods()) {
            this.generateFilter(module, filterMethod);
        }
    }

    private void generateFilter(Module module, FilterMethod filterMethod) {
        if (this.ctx().getProduct(Product.MESSAGE_PROCESSOR, filterMethod.parent(), filterMethod.getName()) != null) {
            return;
        }
        GeneratedClass filterClass = this.getFilterClass(filterMethod);
        this.ctx().note("Generating filter as " + filterClass.fullName() + " for method " + filterMethod.getName() + " in " + module.getName());
        this.generateFilterClassDoc(filterMethod, filterClass);
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateFieldForEachParameter(filterClass, (Method)filterMethod, this.privateFieldnames);
        this.generateInitialiseMethod(filterClass, fields, module);
        this.generateStartMethod(filterClass, fields);
        this.generateStopMethod(filterClass, fields);
        this.generateDiposeMethod(filterClass, fields);
        this.generateSetMuleContextMethod(filterClass, fields);
        this.generateSetFlowConstructMethod(filterClass, fields);
        for (String fieldName : fields.keySet()) {
            filterClass.setter(fields.get(fieldName).getField());
        }
        if (module.usesPooling()) {
            GeneratedClass poolObjectClass = ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass();
            this.generateAcceptMethod(filterMethod, filterClass, fields, poolObjectClass);
        } else {
            this.generateAcceptMethod(filterMethod, filterClass, fields);
        }
    }

    private void generateFilterClassDoc(FilterMethod filterMethod, GeneratedClass filterClass) {
        filterClass.javadoc().add((Object)(filterClass.name() + " invokes the "));
        filterClass.javadoc().add((Object)("{@link " + ((org.mule.devkit.model.Type)filterMethod.parent()).getQualifiedName().toString() + "#"));
        filterClass.javadoc().add((Object)(filterMethod.getName() + "("));
        boolean first = true;
        for (Parameter variable : filterMethod.getParameters()) {
            if (!first) {
                filterClass.javadoc().add((Object)", ");
            }
            filterClass.javadoc().add((Object)((Object)variable.asTypeMirror()).toString().replaceAll("<[a-zA-Z\\-\\.\\<\\>\\s\\,]*>", ""));
            first = false;
        }
        filterClass.javadoc().add((Object)")} method in ");
        filterClass.javadoc().add((Object)this.ref(((org.mule.devkit.model.Type)filterMethod.parent()).asTypeMirror()));
        filterClass.javadoc().add((Object)". For each argument there is a field in this processor to match it. ");
        filterClass.javadoc().add((Object)" Before invoking the actual method the processor will evaluate and transform");
        filterClass.javadoc().add((Object)" where possible to the expected argument type.");
    }

    private void generateAcceptMethod(FilterMethod filterMethod, GeneratedClass filterClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        this.generateAcceptMethod(filterMethod, filterClass, fields, null);
    }

    private void generateAcceptMethod(FilterMethod filterMethod, GeneratedClass filterClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedClass poolObjectClass) {
        GeneratedInvocation findOrCreate;
        String methodName = filterMethod.getName();
        TypeReference muleEvent = this.ref(MuleEvent.class);
        boolean injectParameters = filterMethod.getAnnotation(Inject.class) != null;
        GeneratedMethod accept = filterClass.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "accept");
        accept.javadoc().add((Object)"Check a given message against this filter.");
        accept.javadoc().addParam("message a non null message to filter");
        GeneratedVariable message = null;
        message = accept.param(8, (Type)this.ref(MuleMessage.class), "message");
        GeneratedVariable poolObject = this.declarePoolObjectIfClassNotNull(poolObjectClass, accept);
        GeneratedVariable moduleObject = accept.body().decl((Type)this.ref(Object.class), "moduleObject", ExpressionFactory._null());
        GeneratedTry callProcessor = accept.body()._try();
        if (this.getModuleObject((org.mule.devkit.model.Type)filterMethod.parent()) != null) {
            findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(this.getModuleObject((org.mule.devkit.model.Type)filterMethod.parent()).dotclass());
            if (filterMethod.parent() instanceof Module && ((Module)filterMethod.parent()).needsConfig()) {
                findOrCreate.arg(ExpressionFactory.FALSE);
            } else {
                findOrCreate.arg(ExpressionFactory.TRUE);
            }
            findOrCreate.arg((GeneratedExpression)message);
            callProcessor.body().assign((AssignmentTarget)moduleObject, (GeneratedExpression)findOrCreate);
        } else {
            findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(this.ref(ProcessAdapter.class).dotclass());
            findOrCreate.arg(ExpressionFactory.FALSE);
            findOrCreate.arg((GeneratedExpression)message);
            callProcessor.body().assign((AssignmentTarget)moduleObject, (GeneratedExpression)findOrCreate);
        }
        for (String fieldName : fields.keySet()) {
            AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
            if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
            GeneratedField callbackFlowName = fields.get(fieldName).getField();
            GeneratedBlock ifCallbackFlowNameIsNull = callProcessor.body()._if(Op.cand((GeneratedExpression)callbackFlowName.isNotNull(), (GeneratedExpression)variableElement.getFieldType().isNull()))._then();
            GeneratedVariable castedModuleObject = ifCallbackFlowNameIsNull.decl((Type)this.ref(HttpCallbackAdapter.class), "castedModuleObject", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(HttpCallbackAdapter.class), (GeneratedExpression)moduleObject));
            GeneratedInvocation domain = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"domain"));
            GeneratedInvocation localPort = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"localPort"));
            GeneratedInvocation remotePort = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"remotePort"));
            GeneratedInvocation async = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"async"));
            ifCallbackFlowNameIsNull.assign((AssignmentTarget)variableElement.getFieldType(), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultHttpCallback.class)).arg((GeneratedExpression)callbackFlowName).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext")).arg((GeneratedExpression)domain).arg((GeneratedExpression)localPort).arg((GeneratedExpression)remotePort).arg((GeneratedExpression)async));
            ifCallbackFlowNameIsNull.add((Statement)variableElement.getFieldType().invoke("start"));
        }
        ArrayList<GeneratedExpression> parameters = new ArrayList<GeneratedExpression>();
        GeneratedVariable interceptCallback = null;
        GeneratedVariable outboundHeadersMap = null;
        for (Parameter variable : filterMethod.getParameters()) {
            String fieldName = variable.getName();
            if (((Object)variable.asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) {
                parameters.add((GeneratedExpression)fields.get(fieldName).getFieldType());
                continue;
            }
            if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                parameters.add((GeneratedExpression)this.declareNestedProcessorParameter((GeneratedExpression)fields.get(fieldName).getField(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"), message, callProcessor.body(), variable.asType().isArrayOrList(), fieldName));
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(MuleMessage.class.getName()) && injectParameters) {
                parameters.add((GeneratedExpression)message);
                continue;
            }
            outboundHeadersMap = this.declareStandardParameter((Variable)variable, filterClass, message, callProcessor, parameters, outboundHeadersMap);
        }
        Type returnType = this.ref(filterMethod.getReturnType());
        GeneratedVariable resultPayload = this.generateMethodCall(filterMethod, callProcessor.body(), methodName, parameters, message, returnType, interceptCallback, (org.mule.devkit.model.Type)filterMethod.parent(), moduleObject);
        for (Parameter variable : filterMethod.getParameters()) {
            OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
            if (outboundHeaders == null) continue;
            GeneratedConditional ifNotEmpty = callProcessor.body()._if(Op.cand((GeneratedExpression)outboundHeadersMap.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)outboundHeadersMap.invoke("isEmpty"))));
            if (this.isMuleEvent(returnType)) {
                ifNotEmpty._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)resultPayload).invoke("getMessage").invoke("addProperties").arg((GeneratedExpression)outboundHeadersMap).arg((GeneratedExpression)this.ref(PropertyScope.class).staticRef("OUTBOUND")));
                continue;
            }
            ifNotEmpty._then().add((Statement)message.invoke("getMessage").invoke("addProperties").arg((GeneratedExpression)outboundHeadersMap).arg((GeneratedExpression)this.ref(PropertyScope.class).staticRef("OUTBOUND")));
        }
        if (filterMethod.getAnnotation(Mime.class) != null) {
            GeneratedInvocation invocation = this.isMuleEvent(returnType) ? ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)resultPayload).invoke("getMessage") : message.invoke("getMessage");
            GeneratedCast defaultMuleMessage = ExpressionFactory.cast((Type)this.ref(DefaultMuleMessage.class), (GeneratedExpression)invocation);
            GeneratedInvocation setMimeType = defaultMuleMessage.invoke("setMimeType").arg(ExpressionFactory.lit((String)((Mime)filterMethod.getAnnotation(Mime.class)).value()));
            callProcessor.body().add((Statement)setMimeType);
        }
        callProcessor.body()._return(Op.not((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(Boolean.class), (GeneratedExpression)resultPayload)));
        GeneratedCatchBlock catchMessagingException = callProcessor._catch(this.ref(MessagingException.class));
        GeneratedVariable messagingException = catchMessagingException.param("messagingException");
        catchMessagingException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)messagingException));
        this.generateRuntimeThrow("failedToInvoke", MessagingException.class, callProcessor._catch(this.ref(Exception.class)), (GeneratedExpression)message, methodName);
        if (poolObjectClass != null) {
            GeneratedBlock fin = callProcessor._finally();
            GeneratedBlock poolObjectNotNull = fin._if(poolObject.isNotNull())._then();
            poolObjectNotNull.add((Statement)ExpressionFactory.cast((Type)((TypeReference)this.ctx().getProduct(Product.POOL_MANAGER_INTERFACE)), (GeneratedExpression)moduleObject).invoke("getLifecyleEnabledObjectPool").invoke("returnObject").arg((GeneratedExpression)poolObject));
        }
    }

    protected void generateRuntimeThrow(String bundle, Class<?> clazz, GeneratedCatchBlock callProcessorCatch, GeneratedExpression event, String methodName) {
        GeneratedVariable exception = callProcessorCatch.param("e");
        TypeReference coreMessages = this.ref(CoreMessages.class);
        GeneratedInvocation failedToInvoke = coreMessages.staticInvoke(bundle);
        if (methodName != null) {
            failedToInvoke.arg(ExpressionFactory.lit((String)methodName));
        }
        GeneratedInvocation messageException = ExpressionFactory._new((TypeReference)this.ref(clazz));
        messageException.arg((GeneratedExpression)failedToInvoke);
        if (event != null) {
            messageException.arg(event);
        }
        messageException.arg((GeneratedExpression)exception);
        callProcessorCatch.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)messageException));
    }

    private GeneratedVariable declareStandardParameter(Variable variable, GeneratedClass messageProcessorClass, GeneratedVariable muleEvent, GeneratedTry callProcessor, List<GeneratedExpression> parameters, GeneratedVariable outboundHeadersMap) {
        OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
        if (outboundHeaders == null) {
            GeneratedVariable transformed = this.declareTransformedVariable(variable, (GeneratedExpression)ExpressionFactory.ref((String)variable.getName()), (Type)messageProcessorClass, muleEvent, callProcessor.body(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
            parameters.add((GeneratedExpression)transformed);
        } else {
            TypeReference type = this.ref(HashMap.class).narrow(new TypeReference[]{this.ref(String.class), this.ref(Object.class)});
            String name = "_transformed" + StringUtils.capitalize((String)variable.getName());
            outboundHeadersMap = callProcessor.body().decl(8, (Type)type, name, (GeneratedExpression)ExpressionFactory._new((Type)type));
            parameters.add((GeneratedExpression)outboundHeadersMap);
        }
        return outboundHeadersMap;
    }

    private GeneratedVariable declarePoolObjectIfClassNotNull(GeneratedClass poolObjectClass, GeneratedMethod process) {
        if (poolObjectClass != null) {
            return process.body().decl((Type)poolObjectClass, "_poolObject", ExpressionFactory._null());
        }
        return null;
    }

    private GeneratedVariable generateMethodCall(FilterMethod filterMethod, GeneratedBlock body, String methodName, List<GeneratedExpression> parameters, GeneratedVariable event, Type returnType, GeneratedVariable interceptCallback, org.mule.devkit.model.Type module, GeneratedVariable moduleObject) {
        GeneratedVariable resultPayload = null;
        if (returnType != this.ctx().getCodeModel().VOID) {
            resultPayload = body.decl((Type)this.ref(Object.class), "resultPayload");
        }
        GeneratedVariable processTemplate = body.decl((Type)this.ref(ProcessTemplate.class).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)), "processTemplate", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ProcessAdapter.class).narrow(this.ref(Object.class)), (GeneratedExpression)moduleObject).invoke("getProcessTemplate"));
        GeneratedClass executionCallback = this.ctx().getCodeModel().anonymousClass(this.ref(ProcessCallback.class).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)));
        GeneratedMethod getManagedExceptions = executionCallback.method(1, (Type)this.ref(List.class).narrow(this.ref(Class.class).narrow(this.ref(Exception.class).wildcard())), "getManagedExceptions");
        getManagedExceptions.body()._return(ExpressionFactory._null());
        GeneratedMethod isProtected = executionCallback.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isProtected");
        isProtected.body()._return(ExpressionFactory.FALSE);
        GeneratedMethod process = executionCallback.method(1, (Type)this.ref(Object.class), "process");
        GeneratedVariable object2 = process.param((Type)this.ref(Object.class), "object");
        process._throws(this.ref(Exception.class));
        GeneratedInvocation methodCall = ExpressionFactory.cast((Type)this.ref(module), (GeneratedExpression)object2).invoke(methodName);
        for (GeneratedExpression parameter : parameters) {
            methodCall.arg(parameter);
        }
        process.body()._return((GeneratedExpression)methodCall);
        body.assign((AssignmentTarget)resultPayload, (GeneratedExpression)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        return resultPayload;
    }

    private GeneratedClass getFilterClass(FilterMethod filterMethod) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)filterMethod.parent()).getPackage().getName() + ".filters");
        GeneratedClass abstractFilter = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_FILTER);
        GeneratedClass clazz = pkg._class(filterMethod.getCapitalizedName() + "Filter", abstractFilter.narrow(this.ref(Object.class)), new Class[]{Filter.class, Initialisable.class, Startable.class, Disposable.class, Stoppable.class});
        this.ctx().registerProduct(Product.FILTER, filterMethod.parent(), filterMethod.getName(), (Object)clazz);
        return clazz;
    }

    private void generateStartMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod startMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        startMethod._throws(this.ref(MuleException.class));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStartable = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Startable.class)));
                        ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)variableElement.getField()).invoke("start"));
                        continue;
                    }
                    GeneratedConditional ifIsList = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStartable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Startable.class)));
                    ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)forEachProcessor.var()).invoke("start"));
                    continue;
                }
                if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
                startMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "start");
            }
        }
    }

    private void generateStopMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod stopMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stopMethod._throws(this.ref(MuleException.class));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStoppable = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Stoppable.class)));
                        ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)variableElement.getField()).invoke("stop"));
                        continue;
                    }
                    GeneratedConditional ifIsList = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStoppable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Stoppable.class)));
                    ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)forEachProcessor.var()).invoke("stop"));
                    continue;
                }
                if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
                stopMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "stop");
            }
        }
    }

    private void generateDiposeMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod diposeMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (!variableElement.getVariable().asType().isNestedProcessor() && (!variableElement.getVariable().asType().isArrayOrList() || variableElement.getVariable().getTypeArguments().size() <= 0 || !((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor())) continue;
                boolean isList = variableElement.getVariable().asType().isArrayOrList();
                if (!isList) {
                    GeneratedConditional ifDisposable = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Disposable.class)));
                    ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)variableElement.getField()).invoke("dispose"));
                    continue;
                }
                GeneratedConditional ifIsList = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                GeneratedConditional ifDisposable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Disposable.class)));
                ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)forEachProcessor.var()).invoke("dispose"));
            }
        }
    }

    private boolean isMuleEvent(Type type) {
        return type.fullName().startsWith(MuleEvent.class.getName());
    }
}

