/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.config.PoolingProfile;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void generate(Module module) throws GenerationException {
        ConnectStrategy strategy = ((ManagedConnectionModule)module).getConnectMethod().getStrategy();
        switch (strategy) {
            case SINGLE_INSTANCE: {
                this.generateCacheImplementation(module);
                this.generateCacheConfig(module);
                break;
            }
            case MULTIPLE_INSTANCES: {
                this.generateMultipleImplementation(module);
                this.ctx().registerProduct(Product.POOL_CONFIG, (Object)this.ref(PoolingProfile.class));
            }
        }
    }

    private void generateMultipleImplementation(Module module) {
        GeneratedClass devkitGenericKeyedObjectPool = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".pooling")._class(1, "DevkitGenericKeyedObjectPool");
        devkitGenericKeyedObjectPool._extends(this.ref(GenericKeyedObjectPool.class));
        devkitGenericKeyedObjectPool.direct("    public DevkitGenericKeyedObjectPool(org.apache.commons.pool.KeyedPoolableObjectFactory factory, org.mule.config.PoolingProfile connectionPoolingProfile) {\n        super(factory,toConfig(connectionPoolingProfile));\n    }\n\n    private static org.apache.commons.pool.impl.GenericKeyedObjectPool.Config toConfig(org.mule.config.PoolingProfile connectionPoolingProfile) {\n        org.apache.commons.pool.impl.GenericKeyedObjectPool.Config config = new org.apache.commons.pool.impl.GenericKeyedObjectPool.Config();\n        if (connectionPoolingProfile!= null) {\n            config.maxIdle = connectionPoolingProfile.getMaxIdle();\n            config.maxActive = connectionPoolingProfile.getMaxActive();\n            config.maxWait = connectionPoolingProfile.getMaxWait();\n            config.whenExhaustedAction = ((byte) connectionPoolingProfile.getExhaustedAction());\n            config.timeBetweenEvictionRunsMillis = connectionPoolingProfile.getEvictionCheckIntervalMillis();\n            config.minEvictableIdleTimeMillis = connectionPoolingProfile.getMinEvictionMillis();\n        }\n        return config;\n    }");
        this.ctx().registerProduct(Product.POOL_IMPL, (Object)devkitGenericKeyedObjectPool);
    }

    private void generateCacheConfig(Module module) {
        GeneratedClass cacheConfig = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".pooling")._class(1, "CacheConfig");
        cacheConfig.direct("private int initialCapacity = -1;\n    private long expireAfterAccessMinutes = -1;\n    private long expireAfterWriteMinutes = -1;\n\n    public int getInitialCapacity() {\n        return initialCapacity;\n    }\n\n    public void setInitialCapacity(int initialCapacity) {\n        this.initialCapacity = initialCapacity;\n    }\n\n    public long getExpireAfterAccessMinutes() {\n        return expireAfterAccessMinutes;\n    }\n\n    public void setExpireAfterAccessMinutes(long expireAfterAccessMinutes) {\n        this.expireAfterAccessMinutes = expireAfterAccessMinutes;\n    }\n\n    public long getExpireAfterWriteMinutes() {\n        return expireAfterWriteMinutes;\n    }\n\n    public void setExpireAfterWriteMinutes(long expireAfterWriteMinutes) {\n        this.expireAfterWriteMinutes = expireAfterWriteMinutes;\n    }\n\n    protected <K,V> com.google.common.cache.CacheBuilder<K,V> configure(com.google.common.cache.CacheBuilder<K,V> builder) {\n        if (expireAfterWriteMinutes > 0) builder.expireAfterWrite(expireAfterWriteMinutes, java.util.concurrent.TimeUnit.MINUTES);\n        if (expireAfterAccessMinutes > 0) builder.expireAfterAccess(expireAfterAccessMinutes, java.util.concurrent.TimeUnit.MINUTES);\n        if (initialCapacity > 0) builder.initialCapacity(initialCapacity);\n        return builder;\n    }");
        this.ctx().registerProduct(Product.POOL_CONFIG, (Object)cacheConfig);
    }

    private void generateCacheImplementation(Module module) {
        GeneratedClass cachedObjectPoolAdapterClass = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".pooling")._class(1, "CachedObjectPoolAdapter");
        cachedObjectPoolAdapterClass.generify("K,V");
        cachedObjectPoolAdapterClass._implements(this.ref(KeyedObjectPool.class).narrow("K,V"));
        cachedObjectPoolAdapterClass.direct("com.google.common.cache.LoadingCache<K,V> cache;\n    org.apache.commons.pool.KeyedPoolableObjectFactory<K,V> factory;\n\n    private static org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(CachedObjectPoolAdapter.class);\n\n    com.google.common.cache.RemovalListener<K, V> removalListener = new com.google.common.cache.RemovalListener<K,V>() {\n        public void onRemoval(com.google.common.cache.RemovalNotification<K, V> removal) {\n            try {\n                factory.destroyObject(removal.getKey(),removal.getValue());\n            } catch (Exception e) {\n                logger.error(e.getMessage());\n            }\n        }\n    };\n\n    public CachedObjectPoolAdapter(final org.apache.commons.pool.KeyedPoolableObjectFactory<K,V> factory, CacheConfig loadedConfig) {\n        this.factory = factory;\n        CacheConfig config = loadedConfig != null ? loadedConfig : new CacheConfig();\n        this.cache = config.configure(com.google.common.cache.CacheBuilder.newBuilder())\n                .removalListener(removalListener)\n                .recordStats()\n                .build(new com.google.common.cache.CacheLoader<K, V>() {\n                    @Override\n                    public V load(K K) throws Exception {\n                        return factory.makeObject(K);\n                    }\n                });\n    }\n\n    @Override\n    public V borrowObject(K key) throws Exception {\n        return cache.get(key);\n    }\n\n    @Override\n    public void returnObject(K key, V obj) throws Exception {\n        //This is a cache so there's nothing to be done here\n    }\n\n    @Override\n    public void invalidateObject(K key, V obj) throws Exception {\n        cache.invalidate(key);\n    }\n\n    @Override\n    public void addObject(K key) throws Exception {\n        cache.get(key);\n    }\n\n    @Override\n    public int getNumIdle(K key) throws UnsupportedOperationException {\n        throw new UnsupportedOperationException();\n    }\n\n    @Override\n    public int getNumActive(K key) throws UnsupportedOperationException {\n        throw new UnsupportedOperationException();\n    }\n\n    @Override\n    public int getNumIdle() throws UnsupportedOperationException {\n        throw new UnsupportedOperationException();\n    }\n\n    @Override\n    public int getNumActive() throws UnsupportedOperationException {\n        throw new UnsupportedOperationException();\n    }\n\n    @Override\n    public void clear() throws Exception {\n        cache.invalidateAll();\n    }\n\n    @Override\n    public void clear(Object key) throws Exception {\n        cache.invalidate(key);\n    }\n\n    @Override\n    public void close() throws Exception {\n        cache = null;\n        factory = null;\n    }\n\n    @Override\n    public void setFactory(org.apache.commons.pool.KeyedPoolableObjectFactory<K,V> factory) throws IllegalStateException, UnsupportedOperationException {\n        throw new UnsupportedOperationException();\n    }");
        this.ctx().registerProduct(Product.POOL_IMPL, (Object)cachedObjectPoolAdapterClass);
    }

    public List<Product> consumes() {
        return Arrays.asList(new Object[0]);
    }

    public List<Product> produces() {
        return Arrays.asList(Product.POOL_IMPL, Product.POOL_CONFIG);
    }
}

