/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.MetadataAware;
import org.mule.api.MuleEvent;
import org.mule.api.annotations.ConnectStrategy;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.MetaDataKeyRetriever;
import org.mule.api.annotations.MetaDataRetriever;
import org.mule.api.annotations.MetaDataScope;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.NativeQueryMetadataTranslator;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.query.DsqlQuery;
import org.mule.devkit.generation.AbstractMetadataCodeGenerator;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.MessageConstants;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.metadata.MetaDataModule;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManagerGenerator
extends AbstractMetadataCodeGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.POOL_IMPL, Product.POOL_CONFIG, Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.INJECTION_ADAPTER, Product.OAUTH_ADAPTER, Product.MANAGED_CONNECTION_PROCESS_TEMPLATE, Product.METADATA_ADAPTER, Product.PROCESS_INTERFACES, Product.CONNECTION_INTERFACES, Product.ABSTRACT_CONNECTED_PROCESSOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.CONNECTION_MANAGER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule)) continue;
            return true;
        }
        return false;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> processableModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule) && module.getKind() != ModuleKind.METADATA_CATEGORY) continue;
            processableModules.add(module);
        }
        return processableModules;
    }

    public void generate(List<Module> modules) throws GenerationException {
        List<Module> managedConnectionModules = this.getManagedConnectionModules(modules);
        List<Module> metaDataCategoryModules = this.getModuleByKind(modules, ModuleKind.METADATA_CATEGORY);
        for (Module managedConnectionModule : managedConnectionModules) {
            List<Module> usedMetaDataCategoryModules = this.getSpecificUsedMetaDataCategoryModules(metaDataCategoryModules, managedConnectionModule);
            this.generateModule(managedConnectionModule, usedMetaDataCategoryModules);
        }
    }

    public void generateModule(Module module, List<Module> usedMetaDataCategoryModules) throws GenerationException {
        ManagedConnectionModule managedConnectionType = (ManagedConnectionModule)module;
        ConnectMethod connectMethod = managedConnectionType.getConnectMethod();
        Method disconnectMethod = managedConnectionType.getDisconnectMethod();
        Method validateConnectionMethod = managedConnectionType.getValidateConnectionMethod();
        GeneratedClass connectionManagerClass = this.getConnectionManagerAdapterClass(managedConnectionType);
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateStandardFieldForEachParameter(connectionManagerClass, (Method)connectMethod);
        for (Field field : module.getConfigurableFields()) {
            GeneratedField configField = connectionManagerClass.field(4, this.ref(field.asTypeMirror()), field.getName());
            connectionManagerClass.setter(configField);
            connectionManagerClass.getter(configField);
        }
        GeneratedField muleContext = connectionManagerClass.muleContextField();
        GeneratedField flowConstruct = connectionManagerClass.flowConstructField();
        GeneratedField connectionPool = this.generateFieldForConnectionPool(connectionManagerClass);
        GeneratedField poolingConfig = connectionManagerClass.field(2, (Type)((TypeReference)this.ctx().getProduct(Product.POOL_CONFIG)), StringUtils.uncapitalize((String)((TypeReference)this.ctx().getProduct(Product.POOL_CONFIG)).name()));
        GeneratedField retryPolicyTemplate = connectionManagerClass.field(2, (Type)this.ref(RetryPolicyTemplate.class), "retryPolicyTemplate");
        connectionManagerClass.setter(poolingConfig);
        connectionManagerClass.getter(poolingConfig);
        connectionManagerClass.setter(retryPolicyTemplate);
        connectionManagerClass.getter(retryPolicyTemplate);
        for (String fieldName : fields.keySet()) {
            connectionManagerClass.setter(fields.get(fieldName).getField());
            connectionManagerClass.getter(fields.get(fieldName).getField());
        }
        GeneratedClass connectionKeyClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module);
        GeneratedClass connectionFactoryClass = this.getConnectorFactoryClass(module);
        GeneratedField loggerFactory = this.generateLoggerField(connectionFactoryClass);
        GeneratedField connectionManagerInFactory = connectionFactoryClass.field(4, (Type)connectionManagerClass, "connectionManager");
        GeneratedMethod connectionFactoryConstructor = connectionFactoryClass.constructor(1);
        GeneratedVariable constructorConnectionManager = connectionFactoryConstructor.param((Type)connectionManagerClass, "connectionManager");
        connectionFactoryConstructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)connectionManagerInFactory), (GeneratedExpression)constructorConnectionManager);
        this.generateMakeObjectMethod(module, connectMethod, validateConnectionMethod, connectionFactoryClass, connectionKeyClass, connectionManagerInFactory, loggerFactory);
        this.generateDestroyObjectMethod((Method)connectMethod, disconnectMethod, connectionKeyClass, connectionFactoryClass, loggerFactory);
        this.generateValidateObjectMethod(connectionFactoryClass, loggerFactory, validateConnectionMethod);
        this.generateActivateObjectMethod(connectionFactoryClass, validateConnectionMethod, connectMethod, connectionKeyClass, loggerFactory);
        this.generatePassivateObjectMethod(connectionFactoryClass);
        this.generateInitialiseMethod(connectMethod.getStrategy(), connectionManagerClass, connectionPool, poolingConfig, retryPolicyTemplate, connectionFactoryClass);
        this.generateDisposeMethod(module, connectionManagerClass, connectionPool, poolingConfig, retryPolicyTemplate, connectionFactoryClass);
        this.generateBorrowConnectionMethod((Method)connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateReturnConnectionMethod((Method)connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateDestroyConnectionMethod((Method)connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateIsCapableOfMethod(module, connectionManagerClass);
        this.generateGetProcessTemplateMethod(managedConnectionType, connectionManagerClass);
        this.generateGetDefaultConnectionKey(managedConnectionType, connectionManagerClass, connectionKeyClass);
        this.generateGetEvaluatedConnectionKey(managedConnectionType, connectionManagerClass, connectionKeyClass, muleContext);
        this.generateMetadataConstantsAndGetters(module, connectionManagerClass);
        if (module.getMinMuleVersion().atLeastBase("3.4")) {
            this.generateTestMethod((Method)connectMethod, connectionManagerClass, connectionKeyClass);
            this.generateBuildFailureTestResultMethod((Method)connectMethod, connectionManagerClass);
        }
        if (this.isMetaDataCapable(module, usedMetaDataCategoryModules)) {
            connectionManagerClass._implements(this.ref(ConnectorMetaDataEnabled.class));
            this.generateMetadataMethods(module, connectionManagerClass, connectionKeyClass, (Method)connectMethod, usedMetaDataCategoryModules);
        }
        this.generateNativeQueryMethod(module, connectMethod, connectionManagerClass, connectionKeyClass);
    }

    private void generateNativeQueryMethod(Module module, ConnectMethod connectMethod, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        if (module.hasQueryTranslator()) {
            GeneratedMethod nativeQueryMethod = connectionManagerClass.method(1, (Type)this.ref(Result.class).narrow(String.class), "toNativeQuery");
            GeneratedVariable query = nativeQueryMethod.param((Type)this.ref(DsqlQuery.class), "query");
            nativeQueryMethod.annotate(Override.class);
            GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connectMethod.parent())).topLevelClass();
            GeneratedVariable connection = nativeQueryMethod.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
            GeneratedVariable result = nativeQueryMethod.body().decl((Type)this.ref(Result.class).narrow(this.ref(String.class)), "result");
            GeneratedVariable defaultConnectionKey = nativeQueryMethod.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
            GeneratedTry tryTestConnection = nativeQueryMethod.body()._try();
            tryTestConnection.body().assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
            Method translator = module.getQueryTranslatorMethod();
            tryTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(String.class)).arg((GeneratedExpression)connection.invoke(translator.getName()).arg((GeneratedExpression)query).invoke("toString")));
            GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
            GeneratedVariable e = catchTestConnection.param("e");
            GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
            tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
            tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
            catchTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(String.class)).arg(ExpressionFactory._null()).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")));
            GeneratedBlock finallyTestConnection = tryTestConnection._finally();
            GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
            GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
            tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
            tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
            nativeQueryMethod.body()._return((GeneratedExpression)result);
        }
    }

    private boolean isMetaDataCapable(Module module, List<Module> usedMetaDataCategoryModules) {
        if (MetaDataSwitch.OFF.equals((Object)((Connector)module.getAnnotation(Connector.class)).metaData())) {
            return false;
        }
        if (!usedMetaDataCategoryModules.isEmpty()) {
            return true;
        }
        List metaDataKeysRetrievers = module.getMethodsAnnotatedWith(MetaDataKeyRetriever.class);
        List metaDataRetriever = module.getMethodsAnnotatedWith(MetaDataRetriever.class);
        return module.getMinMuleVersion().atLeastBase("3.4") && metaDataKeysRetrievers.size() == 1 && metaDataRetriever.size() == 1;
    }

    protected void generateMetadataMethods(Module module, GeneratedClass generatedClass, GeneratedClass connectionKeyClass, Method connect, List<Module> usedMetaDataCategoryModules) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        this.generateMetaDataKeysMethod(module, generatedClass, connectionKeyClass, connectorClass, usedMetaDataCategoryModules);
        this.generateMetaDataMethod(module, generatedClass, connectionKeyClass, usedMetaDataCategoryModules, connectorClass);
    }

    private void generateMetaDataMethod(Module module, GeneratedClass generatedClass, GeneratedClass connectionKeyClass, List<Module> usedMetaDataCategoryModules, GeneratedClass connectorClass) {
        GeneratedMethod getMetadata = generatedClass.method(1, (Type)this.ref(Result.class).narrow(this.ref(MetaData.class)), "getMetaData");
        getMetadata.annotate(Override.class);
        GeneratedVariable key = getMetadata.param((Type)this.ref(MetaDataKey.class), "metaDataKey");
        GeneratedVariable connection = getMetadata.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
        GeneratedVariable defaultConnectionKey = getMetadata.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
        GeneratedTry tryTestConnection = getMetadata.body()._try();
        tryTestConnection.body().assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
        GeneratedTry tryGetMetaData = tryTestConnection.body()._try();
        GeneratedInvocation concreteMetaDataInvocation = null;
        if (usedMetaDataCategoryModules.isEmpty()) {
            concreteMetaDataInvocation = connection.invoke(module.getMetaDataRetrieverMethod().getName()).arg((GeneratedExpression)key);
        } else {
            GeneratedVariable metaData = tryGetMetaData.body().decl((Type)this.ref(MetaData.class), "metaData", ExpressionFactory._null());
            GeneratedVariable property = tryGetMetaData.body().decl((Type)this.ref(TypeDescribingProperty.class), "property", (GeneratedExpression)key.invoke("getProperty").arg(ExpressionFactory.dotclass((Type)this.ref(TypeDescribingProperty.class))));
            GeneratedConditional tailConditional = null;
            ArrayList<String> metaDataCategoryNames = new ArrayList<String>();
            GeneratedVariable categoryVariable = tryGetMetaData.body().decl((Type)this.ref(String.class), "category", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultMetaDataKey.class), (GeneratedExpression)key).invoke("getCategory"));
            GeneratedConditional hasPropertyIF = tryGetMetaData.body()._if(Op.ne((GeneratedExpression)categoryVariable, (GeneratedExpression)ExpressionFactory._null()));
            for (Module metaDataCategoryModule : usedMetaDataCategoryModules) {
                GeneratedBlock block;
                metaDataCategoryNames.add(metaDataCategoryModule.getName());
                GeneratedInvocation conditionStartsWith = categoryVariable.invoke("equals").arg(metaDataCategoryModule.getName());
                if (tailConditional == null) {
                    tailConditional = hasPropertyIF._then()._if((GeneratedExpression)conditionStartsWith);
                    block = tailConditional._then();
                } else {
                    tailConditional = tailConditional._elseif((GeneratedExpression)conditionStartsWith);
                    block = tailConditional._then();
                }
                GeneratedVariable categoryObject = block.decl((Type)this.ref(((TypeElement)metaDataCategoryModule.unwrap()).asType()).boxify(), StringUtils.uncapitalize((String)metaDataCategoryModule.getName()), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(((TypeElement)metaDataCategoryModule.unwrap()).asType()).boxify()));
                Field injectedConnector = ((MetaDataModule)metaDataCategoryModule).getInjectedConnector();
                block.add((Statement)categoryObject.invoke(injectedConnector.getSetter().getName()).arg((GeneratedExpression)connection));
                Method metaDataRetrieverOutputMethod = metaDataCategoryModule.getMetaDataOutputRetrieverMethod();
                if (metaDataRetrieverOutputMethod != null) {
                    GeneratedConditional ifPropertyIsOutput = block._if(Op.cand((GeneratedExpression)Op.ne((GeneratedExpression)property, (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)property.invoke("getTypeScope").invoke("equals").arg((GeneratedExpression)this.ref(TypeDescribingProperty.TypeScope.class).staticRef("OUTPUT"))));
                    ifPropertyIsOutput._then().assign((AssignmentTarget)metaData, (GeneratedExpression)categoryObject.invoke(metaDataRetrieverOutputMethod.getName()).arg((GeneratedExpression)key));
                    ifPropertyIsOutput._else().assign((AssignmentTarget)metaData, (GeneratedExpression)categoryObject.invoke(metaDataCategoryModule.getMetaDataRetrieverMethod().getName()).arg((GeneratedExpression)key));
                    continue;
                }
                block.assign((AssignmentTarget)metaData, (GeneratedExpression)categoryObject.invoke(metaDataCategoryModule.getMetaDataRetrieverMethod().getName()).arg((GeneratedExpression)key));
            }
            GeneratedExpression messageException = ExpressionFactory.lit((String)"Invalid key type. There is no matching category for [").plus((GeneratedExpression)key.invoke("getId")).plus(ExpressionFactory.lit((String)("]. All keys must contain a category with any of the following options:[" + StringUtils.join(metaDataCategoryNames, (String)", ") + "]")));
            tailConditional._else()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Exception.class)).arg(messageException.plus(ExpressionFactory.lit((String)", but found [").plus((GeneratedExpression)categoryVariable).plus(ExpressionFactory.lit((String)"] instead")))));
            hasPropertyIF._else()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Exception.class)).arg(messageException));
            concreteMetaDataInvocation = metaData;
        }
        tryGetMetaData.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(MetaData.class))).arg((GeneratedExpression)concreteMetaDataInvocation));
        GeneratedCatchBlock catchGetMetaData = tryGetMetaData._catch(this.ref(Exception.class));
        GeneratedVariable e1 = catchGetMetaData.param("e");
        catchGetMetaData.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMetaDataException").arg((GeneratedExpression)key)).arg((GeneratedExpression)this.ref(MetaDataFailureType.class).staticRef("ERROR_METADATA_RETRIEVER")).arg((GeneratedExpression)e1));
        GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
        GeneratedVariable e = catchTestConnection.param("e");
        GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
        tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
        catchTestConnection.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultResult.class).narrow(this.ref(MetaData.class)), (GeneratedExpression)ExpressionFactory.invoke((String)"buildFailureTestResult").arg((GeneratedExpression)e)));
        GeneratedBlock finallyTestConnection = tryTestConnection._finally();
        GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
        GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
        tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
        GeneratedMethod getMetaDataException = generatedClass.method(4, (Type)this.ref(String.class), "getMetaDataException");
        GeneratedVariable metaDataKey = getMetaDataException.param((Type)this.ref(MetaDataKey.class), "key");
        GeneratedConditional metadataif = getMetaDataException.body()._if(Op.cand((GeneratedExpression)Op.ne((GeneratedExpression)metaDataKey, (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)Op.ne((GeneratedExpression)metaDataKey.invoke("getId"), (GeneratedExpression)ExpressionFactory._null())));
        metadataif._then()._return(Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"There was an error retrieving metadata from key: "), (GeneratedExpression)Op.plus((GeneratedExpression)metaDataKey.invoke("getId"), (GeneratedExpression)ExpressionFactory.lit((String)" after acquiring the connection, for more detailed information please read the provided stacktrace"))));
        metadataif._else()._return(ExpressionFactory.lit((String)"There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace"));
    }

    private void generateMetaDataKeysMethod(Module module, GeneratedClass generatedClass, GeneratedClass connectionKeyClass, GeneratedClass connectorClass, List<Module> usedMetaDataCategoryModules) {
        GeneratedMethod getMetadataKeys = generatedClass.method(1, (Type)this.ref(String.class), "getMetaDataKeys");
        getMetadataKeys.annotate(Override.class);
        getMetadataKeys.type((Type)this.ref(Result.class).narrow(this.ref(List.class).narrow(this.ref(MetaDataKey.class))));
        GeneratedVariable connection = getMetadataKeys.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
        GeneratedVariable defaultConnectionKey = getMetadataKeys.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
        GeneratedTry tryTestConnection = getMetadataKeys.body()._try();
        tryTestConnection.body().assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
        GeneratedTry tryGetMetaDataKeys = tryTestConnection.body()._try();
        GeneratedInvocation concreteMetaDataInvocation = null;
        if (usedMetaDataCategoryModules.isEmpty()) {
            concreteMetaDataInvocation = connection.invoke(module.getMetaDataKeyRetrieverMethod().getName());
        } else {
            GeneratedMethod fillCategoryMethod = generatedClass.method(4, (Type)this.ref(List.class).narrow(this.ref(MetaDataKey.class)), "fillCategory");
            GeneratedVariable metadataKeys = fillCategoryMethod.param((Type)this.ref(List.class).narrow(this.ref(MetaDataKey.class)), "metadataKeys");
            GeneratedVariable categoryClassName = fillCategoryMethod.param((Type)this.ref(String.class), "categoryClassName");
            GeneratedForEach forMetaDataKeys = fillCategoryMethod.body().forEach((Type)this.ref(MetaDataKey.class), "metaDataKey", (GeneratedExpression)metadataKeys);
            forMetaDataKeys.body().add((Statement)ExpressionFactory.cast((Type)this.ref(DefaultMetaDataKey.class), (GeneratedExpression)forMetaDataKeys.var()).invoke("setCategory").arg((GeneratedExpression)categoryClassName));
            fillCategoryMethod.body()._return((GeneratedExpression)metadataKeys);
            GeneratedVariable gatheredMetaDataKeys = tryGetMetaDataKeys.body().decl((Type)this.ref(List.class).narrow(MetaDataKey.class), "gatheredMetaDataKeys", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(MetaDataKey.class)));
            for (Module metaDataCategoryModule : usedMetaDataCategoryModules) {
                GeneratedVariable categoryObject = tryGetMetaDataKeys.body().decl((Type)this.ref(((TypeElement)metaDataCategoryModule.unwrap()).asType()).boxify(), StringUtils.uncapitalize((String)metaDataCategoryModule.getName()), (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(((TypeElement)metaDataCategoryModule.unwrap()).asType()).boxify()));
                Field injectedConnector = ((MetaDataModule)metaDataCategoryModule).getInjectedConnector();
                tryGetMetaDataKeys.body().add((Statement)categoryObject.invoke(injectedConnector.getSetter().getName()).arg((GeneratedExpression)connection));
                tryGetMetaDataKeys.body().add((Statement)gatheredMetaDataKeys.invoke("addAll").arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)fillCategoryMethod).arg((GeneratedExpression)categoryObject.invoke(metaDataCategoryModule.getMetaDataKeyRetrieverMethod().getName())).arg(metaDataCategoryModule.getName())));
            }
            concreteMetaDataInvocation = gatheredMetaDataKeys;
        }
        tryGetMetaDataKeys.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(List.class).narrow(MetaDataKey.class))).arg((GeneratedExpression)concreteMetaDataInvocation).arg(ExpressionFactory.direct((String)"Result.Status.SUCCESS")));
        GeneratedCatchBlock catchGetMetaDataKeys = tryGetMetaDataKeys._catch(this.ref(Exception.class));
        GeneratedVariable e1 = catchGetMetaDataKeys.param("e");
        catchGetMetaDataKeys.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(List.class).narrow(MetaDataKey.class))).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.getMetaDataKeysException()).arg((GeneratedExpression)this.ref(MetaDataFailureType.class).staticRef("ERROR_METADATA_KEYS_RETRIEVER")).arg((GeneratedExpression)e1));
        GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
        GeneratedVariable e = catchTestConnection.param("e");
        GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
        tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
        catchTestConnection.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultResult.class).narrow(this.ref(List.class).narrow(MetaDataKey.class)), (GeneratedExpression)ExpressionFactory.invoke((String)"buildFailureTestResult").arg((GeneratedExpression)e)));
        GeneratedBlock finallyTestConnection = tryTestConnection._finally();
        GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
        GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
        tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
    }

    private void generateTestMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod testMethod = connectionManagerClass.method(1, (Type)this.ref(TestResult.class), "test");
        GeneratedVariable connection = testMethod.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
        GeneratedVariable result = testMethod.body().decl((Type)this.ref(DefaultTestResult.class), "result");
        GeneratedVariable defaultConnectionKey = testMethod.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
        GeneratedTry tryTestConnection = testMethod.body()._try();
        tryTestConnection.body().assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
        tryTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("SUCCESS")));
        GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
        GeneratedVariable e = catchTestConnection.param("e");
        GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
        tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
        catchTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultTestResult.class), (GeneratedExpression)ExpressionFactory.invoke((String)"buildFailureTestResult").arg((GeneratedExpression)e)));
        GeneratedBlock finallyTestConnection = tryTestConnection._finally();
        GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
        GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
        tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
        testMethod.body()._return((GeneratedExpression)result);
    }

    private void generateBuildFailureTestResultMethod(Method connect, GeneratedClass connectionManagerClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod buildFailureTestResult = connectionManagerClass.method(1, (Type)this.ref(DefaultResult.class), "buildFailureTestResult");
        GeneratedVariable exception = buildFailureTestResult.param((Type)this.ref(Exception.class), "exception");
        GeneratedVariable result = buildFailureTestResult.body().decl((Type)this.ref(DefaultTestResult.class), "result");
        GeneratedConditional ifConnectionException = buildFailureTestResult.body()._if(exception._instanceof((Type)this.ref(ConnectionException.class)));
        GeneratedVariable code = ifConnectionException._then().decl((Type)this.ref(ConnectionExceptionCode.class), "code", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectionException.class), (GeneratedExpression)exception).invoke("getCode"));
        GeneratedConditional ifCode = ifConnectionException._then()._if(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("UNKNOWN_HOST")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNKNOWN_HOST")).arg((GeneratedExpression)exception));
        ifCode = ifCode._elseif(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("CANNOT_REACH")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("RESOURCE_UNAVAILABLE")).arg((GeneratedExpression)exception));
        ifCode = ifCode._elseif(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("INCORRECT_CREDENTIALS")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("INVALID_CREDENTIALS")).arg((GeneratedExpression)exception));
        ifCode = ifCode._elseif(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("CREDENTIALS_EXPIRED")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("INVALID_CREDENTIALS")).arg((GeneratedExpression)exception));
        ifCode = ifCode._elseif(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("UNKNOWN")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)exception));
        ifCode._else().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)exception));
        ifConnectionException._else().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)exception));
        buildFailureTestResult.body()._return((GeneratedExpression)result);
    }

    private void generateGetDefaultConnectionKey(ManagedConnectionModule module, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        GeneratedMethod getDefaultConnectionKey = connectionManagerClass.method(1, (Type)connectionKeyClass, "getDefaultConnectionKey");
        getDefaultConnectionKey.annotate(Override.class);
        GeneratedInvocation newConnectionKey = ExpressionFactory._new((TypeReference)connectionKeyClass);
        for (Parameter parameter : module.getConnectMethod().getParameters()) {
            newConnectionKey.arg((GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)parameter.getName()))));
        }
        getDefaultConnectionKey.body()._return((GeneratedExpression)newConnectionKey);
    }

    private void generateGetEvaluatedConnectionKey(ManagedConnectionModule managedConnectionType, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass, GeneratedField muleContext) {
        GeneratedMethod getEvaluatedConnectionKey = connectionManagerClass.method(1, (Type)connectionKeyClass, "getEvaluatedConnectionKey");
        getEvaluatedConnectionKey.annotate(Override.class);
        getEvaluatedConnectionKey._throws(Exception.class);
        GeneratedVariable event = getEvaluatedConnectionKey.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedBlock ifNotNull = getEvaluatedConnectionKey.body()._if(event.isNotNull())._then();
        GeneratedClass abstractConnectedProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_CONNECTED_PROCESSOR);
        GeneratedInvocation newKey = ExpressionFactory._new((TypeReference)connectionKeyClass);
        for (Parameter parameter : managedConnectionType.getConnectMethod().getParameters()) {
            GeneratedVariable transformedVariable = this.declareTransformedVariable((Variable)parameter, (GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)parameter.getName()))), (GeneratedExpression)ExpressionFactory._this().invoke("getClass").invoke("getDeclaredField").arg(parameter.getName()).invoke("getGenericType"), event, ifNotNull, (GeneratedExpression)muleContext);
            newKey.arg((GeneratedExpression)transformedVariable);
            if (parameter.isOptional()) continue;
            ifNotNull._if(transformedVariable.isNull())._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)((TypeReference)this.ctx().getProduct(Product.UNABLE_TO_ACQUIRE_CONNECTION_EXCEPTION))).arg(MessageConstants.nullNotOptionalParameter(parameter.getName(), managedConnectionType.getConnectMethod().getName())));
        }
        ifNotNull._return((GeneratedExpression)newKey);
        getEvaluatedConnectionKey.body()._return((GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
    }

    private void generateGetProcessTemplateMethod(ManagedConnectionModule module, GeneratedClass connectionManagerClass) {
        GeneratedClass connectionIdentifierAdapterClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass managedConnectionProcessTemplateClass = (GeneratedClass)this.ctx().getProduct(Product.MANAGED_CONNECTION_PROCESS_TEMPLATE);
        GeneratedMethod getProcessTemplate = connectionManagerClass.method(1, (Type)this.ref(ProcessTemplate.class), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)this.ref(ProcessTemplate.class).narrow((TypeReference)p).narrow((TypeReference)connectionIdentifierAdapterClass));
        getProcessTemplate.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)managedConnectionProcessTemplateClass).arg(ExpressionFactory._this()).arg((GeneratedExpression)ExpressionFactory.ref((String)"muleContext")));
    }

    private void generateBorrowConnectionMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod borrowConnector = connectionManagerClass.method(1, (Type)connectorClass, "acquireConnection");
        GeneratedVariable key = borrowConnector.param((Type)connectionKeyClass, "key");
        borrowConnector._throws(this.ref(Exception.class));
        borrowConnector.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)connectionPool.invoke("borrowObject").arg((GeneratedExpression)key)));
    }

    private void generateReturnConnectionMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod returnConnector = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "releaseConnection");
        GeneratedVariable key = returnConnector.param((Type)connectionKeyClass, "key");
        returnConnector._throws(this.ref(Exception.class));
        GeneratedVariable connection = returnConnector.param((Type)connectorClass, "connection");
        returnConnector.body().add((Statement)connectionPool.invoke("returnObject").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
    }

    private void generateDestroyConnectionMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod destroyConnector = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "destroyConnection");
        GeneratedVariable key = destroyConnector.param((Type)connectionKeyClass, "key");
        destroyConnector._throws(this.ref(Exception.class));
        GeneratedVariable connection = destroyConnector.param((Type)connectorClass, "connection");
        destroyConnector.body().add((Statement)connectionPool.invoke("invalidateObject").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
    }

    private void generateDisposeMethod(Module module, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedField connectionPoolingProfile, GeneratedField retryPolicyTemplate, GeneratedClass connectionFactoryClass) {
        GeneratedMethod disposeMethod = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
        disposeMethod.annotate(Override.class);
        GeneratedTry tryClose = disposeMethod.body()._try();
        tryClose.body().add((Statement)connectionPool.invoke("close"));
        GeneratedCatchBlock catchBlock = tryClose._catch(this.ref(Exception.class));
        catchBlock.param("e");
    }

    private void generateInitialiseMethod(ConnectStrategy connectStrategy, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedField poolingConfig, GeneratedField retryPolicyTemplate, GeneratedClass connectionFactoryClass) {
        GeneratedMethod initialisableMethod = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        GeneratedInvocation newObjectFactory = ExpressionFactory._new((TypeReference)connectionFactoryClass);
        newObjectFactory.arg(ExpressionFactory._this());
        initialisableMethod.body().assign((AssignmentTarget)connectionPool, (GeneratedExpression)ExpressionFactory._new((TypeReference)((TypeReference)this.ctx().getProduct(Product.POOL_IMPL))).arg((GeneratedExpression)newObjectFactory).arg((GeneratedExpression)poolingConfig));
        GeneratedConditional ifRetryPolicyTemplateIsNull = initialisableMethod.body()._if(retryPolicyTemplate.isNull());
        ifRetryPolicyTemplateIsNull._then().assign((AssignmentTarget)retryPolicyTemplate, (GeneratedExpression)ExpressionFactory.ref((String)"muleContext").invoke("getRegistry").invoke("lookupObject").arg((GeneratedExpression)this.ref(MuleProperties.class).staticRef("OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE")));
    }

    private void generateActivateObjectMethod(GeneratedClass connectionFactoryClass, Method validateConnectionMethod, ConnectMethod connect, GeneratedClass connectionKeyClass, GeneratedField logger) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, validateConnectionMethod.parent())).topLevelClass();
        GeneratedMethod activateObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "activateObject");
        activateObject._throws(this.ref(Exception.class));
        GeneratedVariable key = activateObject.param(Object.class, "key");
        GeneratedVariable obj = activateObject.param(Object.class, "obj");
        GeneratedConditional ifNotKey = activateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)connectionKeyClass)));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        GeneratedConditional ifNotObj = activateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = activateObject.body()._try();
        GeneratedConditional ifNotConnected = tryDisconnect.body()._if(Op.not((GeneratedExpression)casterConnector.invoke(validateConnectionMethod.getName())));
        GeneratedCast castedConnectionKey = ExpressionFactory.cast((Type)connectionKeyClass, (GeneratedExpression)key);
        GeneratedInvocation connectInvoke = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke(connect.getName());
        for (Parameter variable : connect.getParameters()) {
            String fieldName = variable.getName();
            connectInvoke.arg((GeneratedExpression)castedConnectionKey.invoke("get" + StringUtils.capitalize((String)fieldName)));
        }
        ifNotConnected._then().add((Statement)connectInvoke);
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body()._throw((GeneratedExpression)e);
    }

    private void generatePassivateObjectMethod(GeneratedClass connectionFactoryClass) {
        GeneratedMethod passivateObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "passivateObject");
        passivateObject._throws(this.ref(Exception.class));
        passivateObject.param(Object.class, "key");
        passivateObject.param(Object.class, "obj");
    }

    private void generateValidateObjectMethod(GeneratedClass connectionFactoryClass, GeneratedField logger, Method validateConnectionMethod) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, validateConnectionMethod.parent())).topLevelClass();
        GeneratedMethod validateObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "validateObject");
        validateObject.param(Object.class, "key");
        GeneratedVariable obj = validateObject.param(Object.class, "obj");
        GeneratedConditional ifNotObj = validateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        GeneratedConditional ifNullObj = ifNotObj._then()._if(obj.isNull());
        ifNullObj._then().add((Statement)logger.invoke("warn").arg("Connector is null"));
        ifNullObj._else().add((Statement)logger.invoke("warn").arg((GeneratedExpression)ExpressionFactory.lit((String)"Cannot cast connector of type ").invoke("concat").arg((GeneratedExpression)obj.invoke("getClass").invoke("getName").invoke("concat").arg(" to ").invoke("concat").arg(connectorClass.fullName()))));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)ExpressionFactory.lit((String)"Invalid connector type ").invoke("concat").arg((GeneratedExpression)obj.invoke("getClass").invoke("getName"))));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = validateObject.body()._try();
        tryDisconnect.body()._return((GeneratedExpression)casterConnector.invoke(validateConnectionMethod.getName()));
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body().add((Statement)logger.invoke("error").arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)e));
        catchAndRethrow.body()._return(ExpressionFactory.FALSE);
    }

    private void generateDestroyObjectMethod(Method connect, Method disconnect, GeneratedClass connectionKeyClass, GeneratedClass connectionFactoryClass, GeneratedField logger) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod destroyObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "destroyObject");
        destroyObject._throws(this.ref(Exception.class));
        GeneratedVariable key = destroyObject.param(Object.class, "key");
        GeneratedVariable obj = destroyObject.param(Object.class, "obj");
        GeneratedConditional ifNotKey = destroyObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)connectionKeyClass)));
        GeneratedConditional ifNullKey = ifNotKey._then()._if(key.isNull());
        ifNullKey._then().add((Statement)logger.invoke("warn").arg("Connection key is null"));
        ifNullKey._else().add((Statement)logger.invoke("warn").arg((GeneratedExpression)ExpressionFactory.lit((String)"Cannot cast key of type ").invoke("concat").arg((GeneratedExpression)key.invoke("getClass").invoke("getName").invoke("concat").arg(" to ").invoke("concat").arg(connectionKeyClass.fullName()))));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)ExpressionFactory.lit((String)"Invalid key type ").invoke("concat").arg((GeneratedExpression)key.invoke("getClass").invoke("getName"))));
        GeneratedConditional ifNotObj = destroyObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        GeneratedConditional ifNullObj = ifNotObj._then()._if(obj.isNull());
        ifNullObj._then().add((Statement)logger.invoke("warn").arg("Connector is null"));
        ifNullObj._else().add((Statement)logger.invoke("warn").arg((GeneratedExpression)ExpressionFactory.lit((String)"Cannot cast connector of type ").invoke("concat").arg((GeneratedExpression)obj.invoke("getClass").invoke("getName").invoke("concat").arg(" to ").invoke("concat").arg(connectorClass.fullName()))));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)ExpressionFactory.lit((String)"Invalid connector type ").invoke("concat").arg((GeneratedExpression)obj.invoke("getClass").invoke("getName"))));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = destroyObject.body()._try();
        tryDisconnect.body().add((Statement)casterConnector.invoke(disconnect.getName()));
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body()._throw((GeneratedExpression)e);
        tryDisconnect._finally()._if(Op._instanceof((GeneratedExpression)casterConnector, (Type)this.ref(Stoppable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)obj).invoke("stop"));
        tryDisconnect._finally()._if(Op._instanceof((GeneratedExpression)casterConnector, (Type)this.ref(Disposable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)obj).invoke("dispose"));
    }

    private void generateMakeObjectMethod(Module module, ConnectMethod connect, Method validateConnectionMethod, GeneratedClass connectionFactoryClass, GeneratedClass connectionKey, GeneratedField connectionManagerInFactory, GeneratedField logger) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod makeObject = connectionFactoryClass.method(1, Object.class, "makeObject");
        makeObject._throws(this.ref(Exception.class));
        GeneratedVariable key = makeObject.param(Object.class, "key");
        GeneratedConditional ifNotKey = makeObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)connectionKey)));
        GeneratedConditional ifNullKey = ifNotKey._then()._if(key.isNull());
        ifNullKey._then().add((Statement)logger.invoke("warn").arg("Connection key is null"));
        ifNullKey._else().add((Statement)logger.invoke("warn").arg((GeneratedExpression)ExpressionFactory.lit((String)"Cannot cast key of type ").invoke("concat").arg((GeneratedExpression)key.invoke("getClass").invoke("getName").invoke("concat").arg(" to ").invoke("concat").arg(connectionKey.fullName()))));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)ExpressionFactory.lit((String)"Invalid key type ").invoke("concat").arg((GeneratedExpression)key.invoke("getClass").invoke("getName"))));
        GeneratedVariable connector = makeObject.body().decl((Type)connectorClass, "connector", (GeneratedExpression)ExpressionFactory._new((TypeReference)connectorClass));
        for (Field field : module.getConfigurableFields()) {
            makeObject.body().add((Statement)connector.invoke("set" + StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)connectionManagerInFactory.invoke("get" + StringUtils.capitalize((String)field.getName()))));
        }
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (GeneratedExpression)connector).invoke("setMuleContext").arg((GeneratedExpression)connectionManagerInFactory.invoke("getMuleContext")));
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Initialisable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Initialisable.class), (GeneratedExpression)connector).invoke("initialise"));
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Startable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)connector).invoke("start"));
        this.setMuleContextToConnectorIfNecessary(connectionManagerInFactory, connectorClass, makeObject, connector);
        GeneratedConditional ifNotConnected = makeObject.body()._if(Op.not((GeneratedExpression)connector.invoke(validateConnectionMethod.getName())));
        GeneratedCast castedConnectionKey = ExpressionFactory.cast((Type)connectionKey, (GeneratedExpression)key);
        GeneratedInvocation connectInvoke = connector.invoke(connect.getName());
        for (Parameter variable : connect.getParameters()) {
            String fieldName = variable.getName();
            connectInvoke.arg((GeneratedExpression)castedConnectionKey.invoke("get" + StringUtils.capitalize((String)fieldName)));
        }
        ifNotConnected._then().add((Statement)connectInvoke);
        makeObject.body()._return((GeneratedExpression)connector);
    }

    private void setMuleContextToConnectorIfNecessary(GeneratedField connectionManagerInFactory, GeneratedClass connectorClass, GeneratedMethod makeObject, GeneratedVariable connector) {
        Iterator implementsIterator = connectorClass._implements();
        while (implementsIterator.hasNext()) {
            TypeReference implementedInterface = (TypeReference)implementsIterator.next();
            if (!implementedInterface.equals((Object)this.ref(MuleContextAware.class))) continue;
            makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)connector.invoke("setMuleContext").arg(ExpressionFactory.direct((String)(connectionManagerInFactory.name() + "." + "muleContext"))));
        }
    }

    private GeneratedField generateFieldForConnectionPool(GeneratedClass connectionManagerClass) {
        GeneratedField connectionPool = connectionManagerClass.field(4, (Type)this.ref(KeyedObjectPool.class), "connectionPool");
        connectionPool.javadoc().add((Object)"Connector Pool");
        return connectionPool;
    }

    private GeneratedClass getConnectionManagerAdapterClass(ManagedConnectionModule module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass connectionKeyClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module)).topLevelClass();
        GeneratedClass classToExtend = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass connectionManagerClass = pkg._class(module.getClassName() + "ConnectionManager");
        connectionManagerClass._implements(this.ref(Initialisable.class));
        connectionManagerClass._implements(this.ref(Capabilities.class));
        connectionManagerClass._implements(this.ref(MuleContextAware.class));
        connectionManagerClass._implements(((TypeReference)this.ctx().getProduct(Product.CONNECTION_MANAGER_INTERFACE)).narrow((TypeReference)connectionKeyClass).narrow((TypeReference)classToExtend));
        connectionManagerClass._implements(this.ref(ProcessAdapter.class).narrow((TypeReference)classToExtend));
        connectionManagerClass._implements(this.ref(MetadataAware.class));
        connectionManagerClass._implements(this.ref(Disposable.class));
        connectionManagerClass._extends(ExpressionEvaluatorSupport.class);
        if (module.getMinMuleVersion().atLeastBase("3.4")) {
            connectionManagerClass._implements(this.ref(Testable.class));
        }
        if (module.hasQueryTranslator()) {
            connectionManagerClass._implements(this.ref(NativeQueryMetadataTranslator.class));
        }
        this.ctx().registerProduct(Product.CONNECTION_MANAGER, (Identifiable)module, (Object)connectionManagerClass);
        connectionManagerClass.javadoc().add((Object)("A {@code " + connectionManagerClass.name() + "} is a wrapper around "));
        connectionManagerClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        connectionManagerClass.javadoc().add((Object)" that adds connection management capabilities to the pojo.");
        return connectionManagerClass;
    }

    private GeneratedClass getConnectorFactoryClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass objectFactory = pkg._class(1, module.getClassName() + "ConnectionFactory");
        objectFactory._implements(KeyedPoolableObjectFactory.class);
        return objectFactory;
    }

    private List<Module> getSpecificUsedMetaDataCategoryModules(List<Module> metaDataCategoryModules, Module module) {
        ArrayList<Module> usedMetaDataCategoryModules = new ArrayList<Module>();
        ArrayList<DeclaredType> usedCategories = new ArrayList<DeclaredType>();
        if (module.getAnnotation(MetaDataScope.class) != null) {
            usedCategories.add(module.metaDataScope());
        }
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            if (!processorMethod.hasMetaDataScope()) continue;
            usedCategories.add(processorMethod.metaDataScope());
        }
        block1: for (Module metaDataCategoryModule : metaDataCategoryModules) {
            String fullQualifiedName = metaDataCategoryModule.getQualifiedName().toString();
            for (DeclaredType declaredType : usedCategories) {
                if (!fullQualifiedName.equals(declaredType.toString())) continue;
                usedMetaDataCategoryModules.add(metaDataCategoryModule);
                continue block1;
            }
        }
        return usedMetaDataCategoryModules;
    }

    private List<Module> getManagedConnectionModules(List<Module> modules) {
        ArrayList<Module> connectionManagedModules = new ArrayList<Module>();
        for (Module module : this.getModuleByKind(modules, ModuleKind.CONNECTOR)) {
            if (!(module instanceof ManagedConnectionModule)) continue;
            connectionManagedModules.add(module);
        }
        return connectionManagedModules;
    }

    private List<Module> getModuleByKind(List<Module> modules, ModuleKind aKind) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (!module.getKind().equals((Object)aKind)) continue;
            specificModules.add(module);
        }
        return specificModules;
    }
}

