/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class AdapterInterfacesGenerator
implements ModuleGenerator {
    private static final String ADAPTER_NAMESPACE = ".adapter";
    private static final String HTTP_CALLBACK_ADAPTER_INTERFACE_NAME = "HttpCallbackAdapter";
    private static final String POOL_MANAGER_INTERFACE = "PoolManager";
    protected Context context;

    public boolean shouldGenerate(Module module) {
        return module.getKind() != ModuleKind.METADATA_CATEGORY;
    }

    public void generate(Module module) throws GenerationException {
        try {
            this.generatePoolManagerInterface(module);
        }
        catch (ClassAlreadyExistsException classAlreadyExistsException) {
            // empty catch block
        }
    }

    private void generatePoolManagerInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ADAPTER_NAMESPACE);
        GeneratedClass clazz = pkg._interface(POOL_MANAGER_INTERFACE);
        this.ctx().registerProduct(Product.POOL_MANAGER_INTERFACE, (Object)clazz);
        clazz.direct("/**\n     * Retrieves the pool of objects\n     */\n    public org.mule.util.pool.LifecyleEnabledObjectPool getLifecyleEnabledObjectPool();");
    }

    private void generateHttpCallbackAdapter(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ADAPTER_NAMESPACE);
        GeneratedClass clazz = pkg._interface(HTTP_CALLBACK_ADAPTER_INTERFACE_NAME);
        this.ctx().registerProduct(Product.HTTP_CALLBACK_ADAPTER_INTERFACE, (Object)clazz);
        clazz.direct("  Integer getLocalPort();\n\n    Integer getRemotePort();\n\n    String getDomain();\n\n    org.mule.api.transport.Connector getConnector();\n\n    Boolean getAsync();\n\n    String getPath();");
    }

    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    public List<Product> produces() {
        return Arrays.asList(Product.ADAPTER_INTERFACES);
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    protected TypeReference ref(Class<?> clazz) {
        return this.ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return this.ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return this.ctx().getCodeModel().ref(module.asTypeMirror());
    }
}

