/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class ConnectionInterfacesGenerator
implements ModuleGenerator {
    private static final String CONNECTION_NAMESPACE = ".connection";
    private static final String CONNECTION_INTERFACE = "Connection";
    private static final String CONNECTION_EXEPTION = "ConnectionException";
    private static final String CONNECTION_EXEPTION_CODE = "ConnectionExceptionCode";
    private static final String CONNECTION_MANAGER_INTERFACE = "ConnectionManager";
    private static final String UNABLE_TO_RELEASE_CONNECTION_EXCEPTION = "UnableToReleaseConnectionException";
    private static final String UNABLE_TO_ACQUIRE_CONNECTION_EXCEPTION = "UnableToAcquireConnectionException";
    protected Context context;

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        try {
            this.generateConnectionInterface(module);
            this.generateConnectionManagerInterface(module);
            this.generateUnableToAcquireConnectionException(module);
            this.generateUnableToReleaseConnectionException(module);
        }
        catch (ClassAlreadyExistsException classAlreadyExistsException) {
            // empty catch block
        }
    }

    private void generateUnableToReleaseConnectionException(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + CONNECTION_NAMESPACE);
        GeneratedClass clazz = pkg._class(1, UNABLE_TO_RELEASE_CONNECTION_EXCEPTION);
        this.ctx().registerProduct(Product.UNABLE_TO_RELEASE_CONNECTION_EXCEPTION, (Object)clazz);
        clazz._extends(this.ref(Exception.class));
        clazz.javadoc().append((Object)"Exception thrown when the release connection operation of the\n connection manager fails.");
        clazz.direct(" /**\n     * Create a new exception\n     *\n     * @param throwable Inner exception\n     */\n    public UnableToReleaseConnectionException(Throwable throwable) {\n        super(throwable);\n    }");
    }

    private void generateUnableToAcquireConnectionException(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + CONNECTION_NAMESPACE);
        GeneratedClass clazz = pkg._class(1, UNABLE_TO_ACQUIRE_CONNECTION_EXCEPTION);
        this.ctx().registerProduct(Product.UNABLE_TO_ACQUIRE_CONNECTION_EXCEPTION, (Object)clazz);
        clazz._extends(this.ref(Exception.class));
        clazz.javadoc().append((Object)"Exception thrown when the connection needed for executing an\n operation is null.");
        clazz.direct("/**\n     * Create a new exception\n     */\n    public UnableToAcquireConnectionException() {\n    }\n\n    /**\n     * Create a new exception\n     */\n    public UnableToAcquireConnectionException(String message) {\n        super(message);\n    }\n\n    /**\n     * Create a new exception\n     *\n     * @param throwable Inner exception\n     */\n    public UnableToAcquireConnectionException(Throwable throwable) {\n        super(throwable);\n    }");
    }

    private void generateConnectionManagerInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + CONNECTION_NAMESPACE);
        GeneratedClass clazz = pkg._interface(CONNECTION_MANAGER_INTERFACE);
        this.ctx().registerProduct(Product.CONNECTION_MANAGER_INTERFACE, (Object)clazz);
        clazz.generify("K, C extends Connection");
        clazz.javadoc().append((Object)"Wrapper around {@link org.mule.api.annotations.Connector} annotated class that will infuse it with connection management capabilities. <p/> It can receive a {@link org.mule.config.PoolingProfile} which is a configuration object used to define the connection pooling parameters.\n@param <K> Connection key\n@param <C> Actual connector object that represents a connection");
        clazz.direct("/**\n     * Borrow a connection from the pool\n     *\n     * @param connectorKey Key used to borrow the connector\n     * @return An existing connector, or a newly created one\n     * @throws Exception If the connection cannot be created\n     */\n    C acquireConnection(K connectorKey) throws Exception;\n\n    /**\n     * Return a connection to the pool\n     *\n     * @param connectorKey Key used to borrow the connector\n     * @param connector    connector to be returned to the pool\n     * @throws Exception If the connection cannot be returned\n     */\n    void releaseConnection(K connectorKey, C connector) throws Exception;\n\n    /**\n     * Destroy a connection\n     *\n     * @param connectorKey Key used to borrow the connector\n     * @param connector    Connector to be destroyed\n     * @throws Exception If the connection could not be destroyed.\n     */\n    void destroyConnection(K connectorKey, C connector) throws Exception;\n\n    /**\n     * Retrieve the default connection key\n     *\n     * @return The default connection key\n     */\n    K getDefaultConnectionKey();\n\n\n    /**\n     * Retrieve the connection key evaluated with the received mule event\n     *\n     * @return The default connection key\n     */\n\n    K getEvaluatedConnectionKey(org.mule.api.MuleEvent event) throws Exception;\n\n    /**\n     * Retrieve the reconnection strategy used by this connection\n     * manager.\n     *\n     * @return The reconnection strategy {@see RetryPolicyTemplate}\n     */\n    org.mule.api.retry.RetryPolicyTemplate getRetryPolicyTemplate();\n");
    }

    private void generateConnectionExceptionCode(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + CONNECTION_NAMESPACE);
        GeneratedClass clazz = pkg._enum(CONNECTION_EXEPTION_CODE);
        this.ctx().registerProduct(Product.CONNECTION_EXCEPTION_CODE, (Object)clazz);
        clazz.javadoc().append((Object)"List of possible outcomes to a connection failure");
        clazz.direct(" /**\n     * The host cannot be resolved to an IP address\n     */\n    UNKNOWN_HOST,\n    /**\n     * The destination cannot be reached. Either the host is wrong\n     * or the port might be.\n     */\n    CANNOT_REACH,\n    /**\n     * The supplied credentials are not correct.\n     */\n    INCORRECT_CREDENTIALS,\n    /**\n     * The credentials used to authenticate has expired.\n     */\n    CREDENTIALS_EXPIRED,\n    /**\n     * Something else went wrong.\n     */\n    UNKNOWN;");
    }

    private void generateConnectionException(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + CONNECTION_NAMESPACE);
        GeneratedClass clazz = pkg._class(1, CONNECTION_EXEPTION);
        this.ctx().registerProduct(Product.CONNECTION_EXCEPTION, (Object)clazz);
        clazz._extends(this.ref(Exception.class));
        clazz.javadoc().append((Object)"Exception thrown when the method annotated with {@link org.mule.api.annotations.Connect} fails to connect properly.");
        clazz.direct("/**\n     * Exception code\n     */\n    private ConnectionExceptionCode code;\n\n    /**\n     * Third-party code\n     */\n    private String thirdPartyCode;\n\n    /**\n     * Create a new connection exception\n     *\n     * @param code           Code describing what went wrong. Use {@link ConnectionExceptionCode.UNKNOWN} for unexpected problems.\n     * @param thirdPartyCode Code as provided by the third party API\n     * @param message        Message describing what went wrong\n     */\n    public ConnectionException(ConnectionExceptionCode code, String thirdPartyCode, String message) {\n        super(message);\n\n        this.code = code;\n        this.thirdPartyCode = thirdPartyCode;\n    }\n\n    /**\n     * Create a new connection exception\n     *\n     * @param code           Code describing what went wrong. Use {@link ConnectionExceptionCode.UNKNOWN} for unexpected problems.\n     * @param thirdPartyCode Code as provided by the third party API\n     * @param throwable      Inner exception\n     * @param message        Message describing what went wrong\n     */\n    public ConnectionException(ConnectionExceptionCode code, String thirdPartyCode, String message, Throwable throwable) {\n        super(message, throwable);\n\n        this.code = code;\n        this.thirdPartyCode = thirdPartyCode;\n    }\n\n    /**\n     * Get a code for what went wrong\n     *\n     * @return A {@link ConnectionExceptionCode}\n     */\n    public ConnectionExceptionCode getCode() {\n        return code;\n    }\n\n    /**\n     * Get a code for what went wrong as provided\n     * by the third party API\n     *\n     * @return A string with the code\n     */\n    public String getThirdPartyCode() {\n        return thirdPartyCode;\n    }");
    }

    private void generateConnectionInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + CONNECTION_NAMESPACE);
        GeneratedClass clazz = pkg._interface(CONNECTION_INTERFACE);
        this.ctx().registerProduct(Product.CONNECTION_INTERFACE, (Object)clazz);
        clazz.direct(" /**\n     * Retrieve the identification of this connection\n     */\n    public String getConnectionIdentifier();");
    }

    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    public List<Product> produces() {
        return Arrays.asList(Product.CONNECTION_INTERFACES);
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    protected TypeReference ref(Class<?> clazz) {
        return this.ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return this.ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return this.ctx().getCodeModel().ref(module.asTypeMirror());
    }
}

