/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers.metadata;

import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataAnnotationVerifierUtils {
    static void verifyMetaDataRetrieveMethod(Method<Type> metaDataRetrieveMethod, NotificationGatherer gatherer) {
        if (!metaDataRetrieveMethod.isPublic()) {
            gatherer.error(metaDataRetrieveMethod, (DevkitNotification)Message.DEVKIT_050, new Object[0]);
        } else if (metaDataRetrieveMethod.getParameters().isEmpty() || metaDataRetrieveMethod.getParameters().size() > 1 || !((Parameter)metaDataRetrieveMethod.getParameters().get(0)).getGenericType().is("MetaDataKey")) {
            gatherer.error(metaDataRetrieveMethod, (DevkitNotification)Message.DEVKIT_051, new Object[0]);
        } else if (!metaDataRetrieveMethod.getReturnGenericType().is("MetaData")) {
            gatherer.error(metaDataRetrieveMethod, (DevkitNotification)Message.DEVKIT_052, new Object[0]);
        }
    }

    static void verifyMetaDataKeyRetrieverMethod(Method<Type> metaDataKeyRetrieverMethod, NotificationGatherer gatherer) {
        if (!metaDataKeyRetrieverMethod.isPublic()) {
            gatherer.error(metaDataKeyRetrieverMethod, (DevkitNotification)Message.DEVKIT_053, new Object[0]);
        } else if (!metaDataKeyRetrieverMethod.getParameters().isEmpty()) {
            gatherer.error(metaDataKeyRetrieverMethod, (DevkitNotification)Message.DEVKIT_054, new Object[0]);
        } else if (!MetaDataAnnotationVerifierUtils.isListOfMetaDataKeys(metaDataKeyRetrieverMethod.getReturnGenericType())) {
            gatherer.error(metaDataKeyRetrieverMethod, (DevkitNotification)Message.DEVKIT_055, new Object[0]);
        }
    }

    static void checkMetaDataKeyParam(Module module, NotificationGatherer gatherer) {
        for (ProcessorMethod method : module.getProcessorMethods()) {
            Integer cantMetaDataKeyParam = 0;
            Integer cantInputMetaDataStaticKey = 0;
            Parameter metaDataKeyParam = null;
            Parameter metaDataStaticParam = null;
            for (Parameter parameter : method.getParameters()) {
                Integer n;
                Integer n2;
                if (parameter.getAnnotation(MetaDataKeyParam.class) != null) {
                    n2 = cantMetaDataKeyParam;
                    n = cantMetaDataKeyParam = Integer.valueOf(cantMetaDataKeyParam + 1);
                    metaDataKeyParam = parameter;
                }
                if (parameter.getAnnotation(MetaDataStaticKey.class) == null) continue;
                n2 = cantInputMetaDataStaticKey;
                n = cantInputMetaDataStaticKey = Integer.valueOf(cantInputMetaDataStaticKey + 1);
                metaDataStaticParam = parameter;
            }
            if (cantInputMetaDataStaticKey > 0) {
                if (cantInputMetaDataStaticKey > 1) {
                    gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_056, new Object[]{cantMetaDataKeyParam});
                }
                MetaDataAnnotationVerifierUtils.checkStaticType(method, metaDataStaticParam.getGenericType(), ((MetaDataStaticKey)metaDataStaticParam.getAnnotation(MetaDataStaticKey.class)).type(), gatherer);
                if (method.getPayloadParameter() == null) {
                    gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_057, new Object[0]);
                }
            }
            if (method.hasStaticKeyOutputMetaData()) {
                MetaDataAnnotationVerifierUtils.checkStaticType(method, method.getReturnGenericType(), method.getStaticKeyOutputMetaData().type(), gatherer);
            }
            if (cantMetaDataKeyParam <= 0) continue;
            if (cantMetaDataKeyParam > 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_058, new Object[]{cantMetaDataKeyParam});
            }
            switch (((MetaDataKeyParam)metaDataKeyParam.getAnnotation(MetaDataKeyParam.class)).affects()) {
                case AUTO: {
                    MetaDataAnnotationVerifierUtils.checkDynamicAuto(method, gatherer);
                    break;
                }
                case INPUT: {
                    MetaDataAnnotationVerifierUtils.checkDynamicInput(method, gatherer);
                    break;
                }
                case OUTPUT: {
                    MetaDataAnnotationVerifierUtils.checkDynamicOutput(method, gatherer);
                    break;
                }
                case BOTH: {
                    MetaDataAnnotationVerifierUtils.checkDynamicInput(method, gatherer);
                    MetaDataAnnotationVerifierUtils.checkDynamicOutput(method, gatherer);
                }
            }
        }
    }

    private static void checkDynamicAuto(ProcessorMethod method, NotificationGatherer gatherer) {
        if (method.hasStaticKeyInputMetaData()) {
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_059, new Object[0]);
        }
        if (method.hasStaticKeyOutputMetaData()) {
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_060, new Object[0]);
        }
    }

    private static void checkStaticType(ProcessorMethod method, GenericType genericType, String typeValue, NotificationGatherer gatherer) {
        if (genericType == null || !genericType.hasMetaData()) {
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_061, new Object[0]);
        }
        if (StringUtils.isEmpty((String)typeValue) || StringUtils.isEmpty((String)typeValue.trim())) {
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_062, new Object[0]);
        }
    }

    private static void checkDynamicInput(ProcessorMethod method, NotificationGatherer gatherer) {
        if (method.getPayloadParameter() == null) {
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_063, new Object[0]);
        }
        if (method.hasStaticKeyInputMetaData()) {
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_064, new Object[0]);
        }
    }

    private static void checkDynamicOutput(ProcessorMethod method, NotificationGatherer gatherer) {
        if (((Object)method.getReturnType()).toString().equals("void")) {
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_065, new Object[0]);
        }
        if (method.hasStaticKeyOutputMetaData()) {
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_066, new Object[0]);
        }
    }

    private static boolean isListOfMetaDataKeys(GenericType returnGenericType) {
        return returnGenericType != null && returnGenericType.isList() && ((GenericType)returnGenericType.getGenericTypeArguments().get(0)).is("MetaDataKey");
    }
}

