/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.TransformerMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasTransformers();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (TransformerMethod method : module.getTransformerMethods()) {
            List<? extends AnnotationValue> sourceTypes;
            if (!method.isStatic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_121, new Object[0]);
            }
            if (!method.isPublic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_122, new Object[0]);
            }
            if (((Object)method.getReturnType()).toString().equals("void")) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_123, new Object[0]);
            }
            if (((Object)method.getReturnType()).toString().equals("java.lang.Object")) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_124, new Object[0]);
            }
            if (method.getParameters().size() != 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_125, new Object[0]);
            }
            if ((sourceTypes = this.getSourceTypes((Method)method)) != null && !sourceTypes.isEmpty()) continue;
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_126, new Object[0]);
        }
    }

    private List<? extends AnnotationValue> getSourceTypes(Method method) {
        String transformerAnnotationName = Transformer.class.getName();
        List annotationMirrors = method.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!transformerAnnotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"sourceTypes".equals(entry.getKey().getSimpleName().toString())) continue;
                return (List)entry.getValue().getValue();
            }
        }
        return null;
    }
}

