/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.List;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.SourceMethod;

public class SourceAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasSources();
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        for (SourceMethod method : module.getSourceMethods()) {
            try {
                if (method.shouldRunOnPrimaryNodeOnly() && !module.getMinMuleVersion().atLeastBase("3.3")) {
                    gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_114, new Object[0]);
                }
            }
            catch (IllegalArgumentException iae) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_115, new Object[0]);
            }
            if (method.isStatic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_116, new Object[0]);
            }
            if (!method.getTypeParameters().isEmpty()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_117, new Object[0]);
            }
            if (!method.isPublic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_118, new Object[0]);
            }
            boolean containsSourceCallback = false;
            List parameters = method.getParameters();
            for (Parameter parameter : parameters) {
                if (((Object)parameter.asTypeMirror()).toString().startsWith(SourceCallback.class.getName())) {
                    containsSourceCallback = true;
                }
                if (!parameter.isReservedIdentifier()) continue;
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.DEVKIT_119, new Object[]{parameter.getName(), parameter.getName()});
            }
            if (containsSourceCallback) continue;
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_120, new Object[0]);
        }
    }
}

