/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.Query;
import org.mule.api.annotations.expressions.Expr;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.annotations.rest.RestCall;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.streaming.PagingConfiguration;
import org.mule.streaming.ProviderAwarePagingDelegate;

public class ProcessorAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        for (ProcessorMethod method : module.getProcessorMethods()) {
            if (method.isStatic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_094, new Object[0]);
                continue;
            }
            if (!method.getTypeParameters().isEmpty()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_095, new Object[0]);
                continue;
            }
            if (!method.isPublic()) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_096, new Object[0]);
                continue;
            }
            if (method.isAbstract() && !method.hasAnnotation(RestCall.class)) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_097, new Object[0]);
                continue;
            }
            this.validatePaging(module, method);
            this.validateIntercepting(method);
            int payloadCount = 0;
            int queryCount = 0;
            this.validatePagedArgs(method);
            for (Parameter parameter : method.getParameters()) {
                if (parameter.isReservedIdentifier()) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.DEVKIT_099, new Object[]{parameter.getName(), parameter.getName()});
                }
                int count = 0;
                if (parameter.hasAnnotation(InboundHeaders.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(OutboundHeaders.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(InvocationHeaders.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(SessionHeaders.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(Payload.class)) {
                    ++payloadCount;
                    ++count;
                }
                if (parameter.hasAnnotation(ExceptionPayload.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(CorrelationId.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(CorrelationSequence.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(CorrelationGroupSize.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(MessageUniqueId.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(MessageRootId.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(Expr.class)) {
                    ++count;
                }
                if (parameter.hasAnnotation(Query.class)) {
                    ++queryCount;
                }
                if (count > 1) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.DEVKIT_100, new Object[0]);
                }
                if (count > 0 && (parameter.hasDefaultValue() || parameter.isOptional())) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.DEVKIT_101, new Object[0]);
                }
                if (parameter.asTypeMirror().getKind().isPrimitive() && parameter.isOptional() && (!parameter.hasDefaultValue() || parameter.getDefaultValue().isEmpty())) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.DEVKIT_102, new Object[0]);
                }
                if (parameter.hasDefaultValue() && parameter.hasAnnotation(Optional.class)) {
                    gatherer.warn((Identifiable)parameter, (DevkitNotification)Message.DEVKIT_103, new Object[]{parameter.getName()});
                }
                if (!parameter.hasAnnotation(Payload.class) && parameter.asTypeMirror().getKind() == TypeKind.ARRAY) {
                    gatherer.error((Identifiable)parameter, (DevkitNotification)Message.DEVKIT_104, new Object[0]);
                }
                if (!parameter.hasDefaultValue() || !parameter.asType().isEnum() || this.isDefaultValueValidForEnum((Variable)parameter)) continue;
                gatherer.error((Identifiable)parameter, (DevkitNotification)Message.DEVKIT_105, new Object[0]);
            }
            if (payloadCount > 1) {
                gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_106, new Object[0]);
            }
            if (queryCount <= true) continue;
            gatherer.error((Identifiable)method, (DevkitNotification)Message.DEVKIT_107, new Object[0]);
        }
    }

    private void validatePaging(Module module, ProcessorMethod method) {
        if (method.isPaged()) {
            GenericType connectorType;
            String returnType = ((Object)method.getReturnType()).toString();
            if (!returnType.contains(ProviderAwarePagingDelegate.class.getCanonicalName())) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_098, new Object[]{method.getName(), returnType, ProviderAwarePagingDelegate.class.getCanonicalName()});
                return;
            }
            if (!(method.getReturnGenericType().getGenericTypeArguments().size() <= 0 || ((Object)(connectorType = (GenericType)method.getReturnGenericType().getGenericTypeArguments().get(1)).getType()).equals(module.asTypeMirror()) || module.getSuperClass() != null && ((Object)connectorType.getType()).equals(module.getSuperClass().asType()))) {
                this.getGatherer().warn((Identifiable)method, (DevkitNotification)Message.DEVKIT_227, new Object[]{method.getReturnGenericType().getGenericTypeArguments().get(1)});
            }
        } else if (((Object)method.getReturnType()).toString().startsWith(ProviderAwarePagingDelegate.class.getCanonicalName())) {
            this.getGatherer().warn((Identifiable)method, (DevkitNotification)Message.DEVKIT_228, new Object[0]);
        }
    }

    private void validatePagedArgs(ProcessorMethod method) throws AnnotationVerificationException {
        if (method.isPaged()) {
            boolean pagingConfigurationFound = false;
            for (Parameter param : method.getParameters()) {
                if (!param.asType().getQualifiedName().toString().equals(PagingConfiguration.class.getCanonicalName())) continue;
                if (pagingConfigurationFound) {
                    this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_108, new Object[]{method.getName(), PagingConfiguration.class.getCanonicalName()});
                    break;
                }
                pagingConfigurationFound = true;
            }
            if (!pagingConfigurationFound) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_109, new Object[]{method.getName(), PagingConfiguration.class.getCanonicalName()});
            }
        }
    }

    private void validateIntercepting(ProcessorMethod method) throws AnnotationVerificationException {
        if (method.isIntercepting()) {
            if (method.isPaged()) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_110, new Object[]{method.getName()});
                return;
            }
            boolean containsSourceCallback = false;
            for (Parameter parameter : method.getParameters()) {
                if (!((Object)parameter.asTypeMirror()).toString().startsWith(SourceCallback.class.getName())) continue;
                containsSourceCallback = true;
            }
            if (!containsSourceCallback) {
                this.getGatherer().error((Identifiable)method, (DevkitNotification)Message.DEVKIT_111, new Object[0]);
            }
        }
    }

    private boolean isDefaultValueValidForEnum(Variable variable) {
        for (Identifiable enumMember : ((EnumType)variable.asType()).getEnumConstants()) {
            String enumConstant = enumMember.getName();
            if (!variable.getDefaultValue().equals(enumConstant)) continue;
            return true;
        }
        return false;
    }
}

