/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mule.api.annotations.Connector;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.MultiModuleAnnotationVerifier;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class MultiModuleConsistencyAnnotationVerifier
implements MultiModuleAnnotationVerifier {
    private NotificationGatherer gatherer;

    public NotificationGatherer getGatherer() {
        return this.gatherer;
    }

    public void setGatherer(NotificationGatherer gatherer) {
        this.gatherer = gatherer;
    }

    public boolean shouldVerify(List<Module> modules) {
        return true;
    }

    public List<Module> processableModules(List<Module> modules) {
        ArrayList<Module> specificModules = new ArrayList<Module>();
        for (Module module : modules) {
            if (module.getKind().equals((Object)ModuleKind.METADATA_CATEGORY)) continue;
            specificModules.add(module);
        }
        return specificModules;
    }

    public void verifyUniqueProcessorPerNamespace(List<Module> modules) throws AnnotationVerificationException {
        HashMap processorMethods = new HashMap();
        for (Module module : modules) {
            for (ProcessorMethod method : module.getProcessorMethods()) {
                String moduleName;
                String methodName = method.getName();
                HashSet<String> modulesWithProcessor = (HashSet<String>)processorMethods.get(methodName);
                if (modulesWithProcessor == null) {
                    modulesWithProcessor = new HashSet<String>();
                    processorMethods.put(methodName, modulesWithProcessor);
                }
                if (modulesWithProcessor.contains(moduleName = module.getModuleName())) continue;
                if (!modulesWithProcessor.isEmpty()) {
                    this.gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_089, new Object[0]);
                }
                modulesWithProcessor.add(moduleName);
            }
        }
    }

    public void verifyUniqueFriendlyNamePerNamespace(List<Module> modules) throws AnnotationVerificationException {
        HashMap moduleNames = new HashMap();
        for (Module module : modules) {
            String moduleName = module.getModuleName();
            String moduleFriendlyName = module.getFriendlyName();
            HashSet<String> friendlyNames = (HashSet<String>)moduleNames.get(moduleName);
            if (friendlyNames == null) {
                friendlyNames = new HashSet<String>();
                moduleNames.put(moduleName, friendlyNames);
            }
            if (friendlyNames.contains(moduleFriendlyName)) {
                this.gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_090, new Object[0]);
            }
            friendlyNames.add(moduleFriendlyName);
        }
    }

    private void verifyOnlyOneConnectorPerNamespace(List<Module> modules, Class<? extends Module> moduleClass) throws AnnotationVerificationException {
        HashSet<String> hasModuleAnnotatedWithConnector = new HashSet<String>();
        for (Module module : modules) {
            if (!module.hasAnnotation(Connector.class) || !module.getClass().isInstance(moduleClass)) continue;
            if (hasModuleAnnotatedWithConnector.contains(module.getModuleName())) {
                this.gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_091, new Object[]{moduleClass});
            }
            hasModuleAnnotatedWithConnector.add(module.getModuleName());
        }
    }

    public void verifyUniqueNamePerExpressionLanguages(List<Module> modules) throws AnnotationVerificationException {
        HashSet<String> expressionLanguagesNames = new HashSet<String>();
        ArrayList<Module> expressionLanguageModules = new ArrayList<Module>();
        HashSet<String> nonExpressionLanguagesNames = new HashSet<String>();
        for (Module module : modules) {
            String moduleName = module.getModuleName();
            if (module.getKind() == ModuleKind.EXPRESSION_LANGUAGE) {
                if (expressionLanguagesNames.contains(moduleName)) {
                    this.gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_092, new Object[]{moduleName});
                    return;
                }
                expressionLanguagesNames.add(moduleName);
                expressionLanguageModules.add(module);
                continue;
            }
            nonExpressionLanguagesNames.add(moduleName);
        }
        for (Module exprLangModule : expressionLanguageModules) {
            if (!nonExpressionLanguagesNames.contains(exprLangModule.getModuleName())) continue;
            this.gatherer.error((Identifiable)exprLangModule, (DevkitNotification)Message.DEVKIT_093, new Object[]{exprLangModule.getModuleName()});
            break;
        }
    }

    public void verify(List<Module> modules, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.gatherer = gatherer;
        this.verifyUniqueProcessorPerNamespace(modules);
        this.verifyUniqueFriendlyNamePerNamespace(modules);
        this.verifyUniqueNamePerExpressionLanguages(modules);
        this.verifyOnlyOneConnectorPerNamespace(modules, OAuthModule.class);
        this.verifyOnlyOneConnectorPerNamespace(modules, ManagedConnectionModule.class);
    }
}

