/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.ArrayList;
import java.util.List;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.oauth.OAuth;
import org.mule.api.annotations.oauth.OAuth2;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.GENERIC || module.getKind() == ModuleKind.CONNECTOR;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        List connectMethods = module.getMethodsAnnotatedWith(Connect.class);
        List validateConnectionMethods = module.getMethodsAnnotatedWith(ValidateConnection.class);
        List disconnectMethods = module.getMethodsAnnotatedWith(Disconnect.class);
        List connectionIdentifierMethods = module.getMethodsAnnotatedWith(ConnectionIdentifier.class);
        if (module.getKind() == ModuleKind.GENERIC) {
            if (!connectMethods.isEmpty()) {
                gatherer.error((Identifiable)connectMethods.get(0), (DevkitNotification)Message.DEVKIT_014, new Object[0]);
            }
            if (!validateConnectionMethods.isEmpty()) {
                gatherer.error((Identifiable)validateConnectionMethods.get(0), (DevkitNotification)Message.DEVKIT_015, new Object[0]);
            }
            if (!disconnectMethods.isEmpty()) {
                gatherer.error((Identifiable)disconnectMethods.get(0), (DevkitNotification)Message.DEVKIT_016, new Object[0]);
            }
            if (!connectionIdentifierMethods.isEmpty()) {
                gatherer.error((Identifiable)connectionIdentifierMethods.get(0), (DevkitNotification)Message.DEVKIT_017, new Object[0]);
            }
            return;
        }
        this.checkConnectorMethodsConsistency(module, connectMethods, validateConnectionMethods, disconnectMethods, connectionIdentifierMethods);
        this.checkConnectMethod(connectMethods);
        this.checkDisconnectMethod(disconnectMethods);
        this.checkConnectionIdentifierMethod(connectionIdentifierMethods);
        this.checkValidateConnectionMethod(validateConnectionMethods);
    }

    private void checkConnectorMethodsConsistency(Module module, List<Method<Type>> connectMethods, List<Method<Type>> validateConnectionMethods, List<Method<Type>> disconnectMethods, List<Method<Type>> connectionIdentifierMethods) throws AnnotationVerificationException {
        ArrayList<String> implementedConnectorMethods = new ArrayList<String>();
        if (!connectMethods.isEmpty()) {
            implementedConnectorMethods.add("@Connect");
        }
        if (!disconnectMethods.isEmpty()) {
            implementedConnectorMethods.add("@Disconnect");
        }
        if (!connectionIdentifierMethods.isEmpty()) {
            implementedConnectorMethods.add("@ConnectionIdentifier");
        }
        if (!validateConnectionMethods.isEmpty()) {
            implementedConnectorMethods.add("@ValidateConnection");
        }
        if (!implementedConnectorMethods.isEmpty()) {
            if (implementedConnectorMethods.size() != 4) {
                String alreadyImplementedMethods = StringUtils.join(implementedConnectorMethods, (String)", ");
                this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.DEVKIT_018, new Object[]{alreadyImplementedMethods});
            }
            if (module.hasAnnotation(OAuth.class) || module.hasAnnotation(OAuth2.class)) {
                this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.DEVKIT_019, new Object[]{module.getClassName()});
            }
        }
    }

    private void checkConnectMethod(List<Method<Type>> connectMethods) throws AnnotationVerificationException {
        if (connectMethods.size() > 1) {
            this.getGatherer().errorAll(connectMethods, (DevkitNotification)Message.DEVKIT_020, new Object[0]);
            return;
        }
        if (connectMethods.size() > 0) {
            Method<Type> connectMethod = connectMethods.get(0);
            if (!connectMethod.isPublic()) {
                this.getGatherer().error(connectMethod, (DevkitNotification)Message.DEVKIT_021, new Object[0]);
            }
            if (connectMethod.getThrownTypes().size() != 1) {
                this.getGatherer().error(connectMethod, (DevkitNotification)Message.DEVKIT_022, new Object[0]);
            }
            if (!connectMethod.getThrownTypes().isEmpty() && !connectMethod.getThrownTypes().get(0).toString().equals("org.mule.api.ConnectionException")) {
                this.getGatherer().error(connectMethod, (DevkitNotification)Message.DEVKIT_023, new Object[0]);
            }
            if (!((Object)connectMethod.getReturnType()).toString().equals("void")) {
                this.getGatherer().error(connectMethod, (DevkitNotification)Message.DEVKIT_024, new Object[0]);
            }
            this.checkConnectMethodParameters(connectMethod);
        }
    }

    private void checkConnectMethodParameters(Method<Type> method) throws AnnotationVerificationException {
        int connectionKeys = 0;
        for (Parameter parameter : method.getParameters()) {
            if (parameter.isReservedIdentifier()) {
                this.getGatherer().error((Identifiable)parameter, (DevkitNotification)Message.DEVKIT_025, new Object[]{parameter.getName(), parameter.getName()});
            }
            if (!parameter.hasAnnotation(ConnectionKey.class)) continue;
            ++connectionKeys;
        }
        if (connectionKeys == 0) {
            this.getGatherer().error(method, (DevkitNotification)Message.DEVKIT_026, new Object[0]);
        }
    }

    private void checkDisconnectMethod(List<Method<Type>> disconnectMethods) throws AnnotationVerificationException {
        if (disconnectMethods.size() > 1) {
            this.getGatherer().errorAll(disconnectMethods, (DevkitNotification)Message.DEVKIT_027, new Object[0]);
            return;
        }
        if (disconnectMethods.size() > 0) {
            Method<Type> disconnectMethod = disconnectMethods.get(0);
            if (!disconnectMethod.isPublic()) {
                this.getGatherer().error(disconnectMethod, (DevkitNotification)Message.DEVKIT_028, new Object[0]);
            }
            if (!disconnectMethod.getParameters().isEmpty()) {
                this.getGatherer().error(disconnectMethod, (DevkitNotification)Message.DEVKIT_029, new Object[0]);
            }
            if (!((Object)disconnectMethod.getReturnType()).toString().equals("void")) {
                this.getGatherer().error(disconnectMethod, (DevkitNotification)Message.DEVKIT_030, new Object[0]);
            }
        }
    }

    private void checkValidateConnectionMethod(List<Method<Type>> validateConnectionMethods) throws AnnotationVerificationException {
        if (validateConnectionMethods.size() > 1) {
            this.getGatherer().errorAll(validateConnectionMethods, (DevkitNotification)Message.DEVKIT_031, new Object[0]);
            return;
        }
        if (validateConnectionMethods.size() > 0) {
            Method<Type> validateConnectionMethod = validateConnectionMethods.get(0);
            if (!validateConnectionMethod.isPublic()) {
                this.getGatherer().error(validateConnectionMethod, (DevkitNotification)Message.DEVKIT_032, new Object[0]);
            }
            if (!((Object)validateConnectionMethod.getReturnType()).toString().equals("boolean") && !((Object)validateConnectionMethod.getReturnType()).toString().equals("java.lang.Boolean")) {
                this.getGatherer().error(validateConnectionMethod, (DevkitNotification)Message.DEVKIT_033, new Object[0]);
            }
            if (!validateConnectionMethod.getParameters().isEmpty()) {
                this.getGatherer().error(validateConnectionMethod, (DevkitNotification)Message.DEVKIT_034, new Object[0]);
            }
        }
    }

    private void checkConnectionIdentifierMethod(List<Method<Type>> connectionIdentifierMethods) throws AnnotationVerificationException {
        if (connectionIdentifierMethods.size() > 1) {
            this.getGatherer().errorAll(connectionIdentifierMethods, (DevkitNotification)Message.DEVKIT_035, new Object[0]);
            return;
        }
        if (connectionIdentifierMethods.size() > 0) {
            Method<Type> connectionIdentifierMethod = connectionIdentifierMethods.get(0);
            if (!((Object)connectionIdentifierMethod.getReturnType()).toString().equals("java.lang.String")) {
                this.getGatherer().error(connectionIdentifierMethod, (DevkitNotification)Message.DEVKIT_036, new Object[0]);
            }
            if (!connectionIdentifierMethod.isPublic()) {
                this.getGatherer().error(connectionIdentifierMethod, (DevkitNotification)Message.DEVKIT_037, new Object[0]);
            }
            if (connectionIdentifierMethod.isStatic()) {
                this.getGatherer().error(connectionIdentifierMethod, (DevkitNotification)Message.DEVKIT_038, new Object[0]);
            }
            if (!connectionIdentifierMethod.getParameters().isEmpty()) {
                this.getGatherer().error(connectionIdentifierMethod, (DevkitNotification)Message.DEVKIT_039, new Object[0]);
            }
        }
    }
}

