/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import org.apache.commons.lang.StringUtils;
import org.mule.api.annotations.Filter;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ReconnectOn;
import org.mule.api.annotations.Source;
import org.mule.api.annotations.Transformer;
import org.mule.api.annotations.TransformerResolver;
import org.mule.api.annotations.param.Optional;
import org.mule.devkit.generation.api.AbstractBaseAnnotationVerifier;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.gatherer.DevkitNotification;
import org.mule.devkit.generation.api.gatherer.Message;
import org.mule.devkit.generation.api.gatherer.NotificationGatherer;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.devkit.model.visitor.VerifyAllClassesAvailableInClasspathVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAnnotationVerifier
extends AbstractBaseAnnotationVerifier {
    private static final Pattern VALID_MODULE_NAME = Pattern.compile("[A-Za-z]+[a-zA-Z0-9\\-_]*");
    static List<Class<? extends Annotation>> METHOD_ANNOTATIONS = Arrays.asList(Processor.class, Filter.class, Source.class, Transformer.class, TransformerResolver.class);

    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void verify(Module module, NotificationGatherer gatherer) throws AnnotationVerificationException {
        this.setGatherer(gatherer);
        this.verifyAnnotationModule(module);
        if (module.isInterface()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_001, new Object[0]);
        }
        if (module.isParametrized()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_002, new Object[0]);
        }
        if (!module.isPublic()) {
            gatherer.error((Identifiable)module, (DevkitNotification)Message.DEVKIT_003, new Object[0]);
        }
        for (Field variable : module.getConfigurableFields()) {
            if (variable.isFinal()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.DEVKIT_004, new Object[0]);
            }
            if (variable.isStatic()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.DEVKIT_005, new Object[0]);
            }
            if (variable.asTypeMirror().getKind() == TypeKind.ARRAY) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.DEVKIT_006, new Object[0]);
            }
            if (variable.isReservedIdentifier()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.DEVKIT_007, new Object[]{variable.getName(), variable.getName()});
            }
            if (!variable.hasGetter()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.DEVKIT_008, new Object[]{variable.getName()});
            }
            if (!variable.hasSetter()) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.DEVKIT_009, new Object[]{variable.getName()});
            }
            if (variable.asTypeMirror().getKind().isPrimitive() && variable.isOptional() && (!variable.hasDefaultValue() || variable.getDefaultValue().isEmpty())) {
                gatherer.error((Identifiable)variable, (DevkitNotification)Message.DEVKIT_010, new Object[0]);
            }
            if (variable.hasDefaultValue() && variable.hasAnnotation(Optional.class)) {
                gatherer.warn((Identifiable)variable, (DevkitNotification)Message.DEVKIT_011, new Object[]{variable.getName()});
            }
            if (!variable.hasDefaultValue() || !variable.asType().isEnum() || this.isDefaultValueValidForEnum((Variable)variable)) continue;
            gatherer.error((Identifiable)variable, (DevkitNotification)Message.DEVKIT_012, new Object[0]);
        }
        this.checkRecursiveAllClassesArePresent(module);
        this.checkProcessors(module, gatherer);
        this.checkRepeatedNamesInOperations(module, gatherer);
    }

    private void checkRepeatedNamesInOperations(Module module, NotificationGatherer gatherer) {
        HashMap gatheredMethods = new HashMap();
        for (Method method : module.getMethods()) {
            if (!this.needsToBeChecked((Method<Type>)method)) continue;
            String methodName = this.getMethodName(method);
            if (!gatheredMethods.containsKey(methodName)) {
                gatheredMethods.put(methodName, new ArrayList());
            }
            ((List)gatheredMethods.get(methodName)).add(method);
        }
        for (Map.Entry entry : gatheredMethods.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            gatherer.errorAll((List)entry.getValue(), (DevkitNotification)Message.DEVKIT_226, new Object[]{entry.getKey()});
        }
    }

    private String getMethodName(Method method) {
        String methodName = method.getName();
        String customName = "";
        if (method.hasAnnotation(Processor.class)) {
            customName = ((Processor)method.getAnnotation(Processor.class)).name();
        } else if (method.hasAnnotation(Filter.class)) {
            customName = ((Filter)method.getAnnotation(Filter.class)).name();
        } else if (method.hasAnnotation(Source.class)) {
            customName = ((Source)method.getAnnotation(Source.class)).name();
        }
        if (!customName.isEmpty()) {
            methodName = customName;
        }
        return methodName;
    }

    private boolean needsToBeChecked(Method<Type> method) {
        for (Class<? extends Annotation> allowedAnnotation : METHOD_ANNOTATIONS) {
            if (!method.hasAnnotation(allowedAnnotation)) continue;
            return true;
        }
        return false;
    }

    private void checkProcessors(Module module, NotificationGatherer gatherer) {
        List methodsAnnotatedWithReconnectOn;
        HashMap<String, Integer> exceptionsFullQualifiedNames = new HashMap<String, Integer>();
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            this.checkInvalidationAnnotation(module, processorMethod, gatherer, exceptionsFullQualifiedNames, processorMethod.invalidateConnectionOn(), Message.DEVKIT_222, Message.DEVKIT_220);
            this.checkInvalidationAnnotation(module, processorMethod, gatherer, exceptionsFullQualifiedNames, processorMethod.invalidateAccessTokenOn(), Message.DEVKIT_223, Message.DEVKIT_221);
        }
        if (!exceptionsFullQualifiedNames.isEmpty()) {
            ArrayList<String> gatheredList = new ArrayList<String>();
            for (Map.Entry exceptionCount : exceptionsFullQualifiedNames.entrySet()) {
                if ((Integer)exceptionCount.getValue() <= 1) continue;
                gatheredList.add("exception " + (String)exceptionCount.getKey() + " has been used " + exceptionCount.getValue() + " times");
            }
            if (!gatheredList.isEmpty()) {
                gatherer.warn((Identifiable)module, (DevkitNotification)Message.DEVKIT_224, new Object[]{StringUtils.join(gatheredList, (String)";")});
            }
        }
        if (!(methodsAnnotatedWithReconnectOn = module.getMethodsAnnotatedWith(ReconnectOn.class)).isEmpty()) {
            gatherer.note((Identifiable)module, (DevkitNotification)Message.DEVKIT_225, new Object[0]);
        }
    }

    private void checkInvalidationAnnotation(Module module, ProcessorMethod processorMethod, NotificationGatherer gatherer, Map<String, Integer> exceptionsFullQualifiedNames, DeclaredType declaredTypeInvalidateOn, Message messageWarn, Message messageError) {
        boolean hasReconnectExceptionInProcessor;
        boolean hasReconnectExceptionsInModule = !module.reconnectOn().isEmpty();
        boolean bl = hasReconnectExceptionInProcessor = !processorMethod.reconnectOn().isEmpty();
        if (declaredTypeInvalidateOn != null) {
            if (!exceptionsFullQualifiedNames.containsKey(declaredTypeInvalidateOn.toString())) {
                exceptionsFullQualifiedNames.put(declaredTypeInvalidateOn.toString(), 0);
            }
            exceptionsFullQualifiedNames.put(declaredTypeInvalidateOn.toString(), exceptionsFullQualifiedNames.get(declaredTypeInvalidateOn.toString()) + 1);
            gatherer.warn((Identifiable)processorMethod, (DevkitNotification)messageWarn, new Object[0]);
            if (hasReconnectExceptionInProcessor || hasReconnectExceptionsInModule) {
                gatherer.error((Identifiable)processorMethod, (DevkitNotification)messageError, new Object[0]);
            }
        }
    }

    private void verifyAnnotationModule(Module module) {
        String name = module.getModuleName();
        if (StringUtils.isEmpty((String)name)) {
            this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.DEVKIT_216, new Object[0]);
        } else {
            if (!VALID_MODULE_NAME.matcher(name).matches()) {
                this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.DEVKIT_217, new Object[]{name});
            }
            if (!name.equals(StringUtils.trim((String)name))) {
                this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.DEVKIT_218, new Object[]{name});
            }
            if (name.toLowerCase().equals("test")) {
                this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.DEVKIT_229, new Object[0]);
            }
        }
        if (StringUtils.isEmpty((String)module.getFriendlyName())) {
            this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.DEVKIT_219, new Object[0]);
        }
    }

    private void checkRecursiveAllClassesArePresent(Module module) throws AnnotationVerificationException {
        VerifyAllClassesAvailableInClasspathVisitor verifyAllClassesAvailableInClasspathVisitor = new VerifyAllClassesAvailableInClasspathVisitor();
        module.accept((ModelVisitor)verifyAllClassesAvailableInClasspathVisitor);
        if (!verifyAllClassesAvailableInClasspathVisitor.isAllClassesAvailable()) {
            this.getGatherer().error((Identifiable)module, (DevkitNotification)Message.DEVKIT_013, new Object[]{verifyAllClassesAvailableInClasspathVisitor.getClassesNotAvailable().toString()});
        }
    }

    private boolean isDefaultValueValidForEnum(Variable variable) {
        for (Identifiable enumMember : ((EnumType)variable.asType()).getEnumConstants()) {
            String enumConstant = enumMember.getName();
            if (!variable.getDefaultValue().equals(enumConstant)) continue;
            return true;
        }
        return false;
    }
}

