/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transformer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.transformer.types.DataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionHolderTransformerGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.EXPRESSION_HOLDER, Product.ABSTRACT_EXPRESSION_EVALUATOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.EXPRESSION_HOLDER_TRANSFORMER, Product.REGISTRY_BOOTSTRAP_ENTRY);
    private Set<String> registeredExpressionHolderTransformers = new HashSet<String>();

    public List<Product> consumes() {
        return Collections.unmodifiableList(CONSUMES);
    }

    public List<Product> produces() {
        return Collections.unmodifiableList(PRODUCES);
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void generate(Module module) throws GenerationException {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            for (Parameter parameter : processorMethod.getParameters()) {
                this.registerExpressionHolderTransformerFor((Identifiable<? extends Element>)parameter);
            }
        }
        for (SourceMethod sourceMethod : module.getSourceMethods()) {
            for (Parameter parameter : sourceMethod.getParameters()) {
                this.registerExpressionHolderTransformerFor((Identifiable<? extends Element>)parameter);
            }
        }
    }

    private void registerExpressionHolderTransformerFor(Identifiable<? extends Element> variable) {
        block3: {
            block2: {
                if (!variable.asType().isCollection()) break block2;
                for (org.mule.devkit.model.Type variableTypeParameter : variable.getTypeArguments()) {
                    this.registerExpressionHolderTransformerFor((Identifiable<? extends Element>)variableTypeParameter);
                }
                break block3;
            }
            if (!variable.asType().isComplexType() || this.isExpressionHolderTransformerRegistered(variable.asTypeMirror())) break block3;
            this.registerExpressionHolderTransformer(variable.asType());
            for (Field field : variable.asType().getFields()) {
                this.registerExpressionHolderTransformerFor((Identifiable<? extends Element>)field);
            }
        }
    }

    private void registerExpressionHolderTransformer(org.mule.devkit.model.Type type) {
        GeneratedClass expressionHolderTransformerClass = this.getExpressionHolderTransformerClass(type);
        this.ctx().note("Generating expression holder transformer for " + type.getName() + " as " + expressionHolderTransformerClass.binaryName());
        GeneratedField weighting = expressionHolderTransformerClass.field(4, (Type)this.ctx().getCodeModel().INT, "weighting", (GeneratedExpression)this.ref(DiscoverableTransformer.class).staticRef("DEFAULT_PRIORITY_WEIGHTING"));
        GeneratedField endpoint = expressionHolderTransformerClass.field(4, (Type)this.ref(ImmutableEndpoint.class), "endpoint");
        GeneratedField muleContext = expressionHolderTransformerClass.field(4, (Type)this.ref(MuleContext.class), "muleContext");
        GeneratedField name = expressionHolderTransformerClass.field(4, (Type)this.ref(String.class), "name");
        this.generateGetPriorityWeighting(expressionHolderTransformerClass, weighting);
        this.generateSetPriorityWeighting(expressionHolderTransformerClass, weighting);
        this.generateIsSourceTypeSupported(type, expressionHolderTransformerClass);
        this.generateIsSourceTypeSupportedDataType(type, expressionHolderTransformerClass);
        this.generateGetSourceTypes(type, expressionHolderTransformerClass);
        this.generateGetSourceDataTypes(type, expressionHolderTransformerClass);
        this.generateIsAcceptNull(expressionHolderTransformerClass);
        this.generateIsIgnoreBadInput(expressionHolderTransformerClass);
        this.generateTransform(expressionHolderTransformerClass);
        this.generateTransformWithEncoding(expressionHolderTransformerClass);
        this.generateSetReturnClass(expressionHolderTransformerClass);
        this.generateGetReturnClass(type, expressionHolderTransformerClass);
        this.generateSetReturnDataType(expressionHolderTransformerClass);
        this.generateGetReturnDataType(type, expressionHolderTransformerClass);
        this.generateSetEndpoint(expressionHolderTransformerClass, endpoint);
        this.generateGetEndpoint(expressionHolderTransformerClass, endpoint);
        this.generateDispose(expressionHolderTransformerClass);
        this.generateInitialise(expressionHolderTransformerClass);
        this.generateSetMuleContext(expressionHolderTransformerClass, muleContext);
        this.generateSetName(expressionHolderTransformerClass, name);
        this.generateGetName(expressionHolderTransformerClass, name);
        this.generateTransformWithEvent(expressionHolderTransformerClass);
        this.generateTransformWithEventAndEncoding(expressionHolderTransformerClass, type);
        this.generateProcess(expressionHolderTransformerClass);
        this.generateGetMimeType(expressionHolderTransformerClass);
        this.generateGetEncoding(expressionHolderTransformerClass);
        this.generateGetMuleContext(expressionHolderTransformerClass, muleContext);
        this.registeredExpressionHolderTransformers.add(((Object)type.asTypeMirror()).toString());
    }

    private void generateGetMuleContext(GeneratedClass expressionHolderTransformerClass, GeneratedField muleContext) {
        GeneratedMethod getMuleContext = expressionHolderTransformerClass.method(1, (Type)this.ref(MuleContext.class), "getMuleContext");
        getMuleContext.body()._return((GeneratedExpression)muleContext);
    }

    private void generateGetMimeType(GeneratedClass expressionHolderClass) {
        GeneratedMethod getMimeType = expressionHolderClass.method(1, (Type)this.ref(String.class), "getMimeType");
        getMimeType.body()._return(ExpressionFactory._null());
    }

    private void generateGetEncoding(GeneratedClass expressionHolderClass) {
        GeneratedMethod getEncoding = expressionHolderClass.method(1, (Type)this.ref(String.class), "getEncoding");
        getEncoding.body()._return(ExpressionFactory._null());
    }

    private void generateProcess(GeneratedClass expressionHolderClass) {
        GeneratedMethod process = expressionHolderClass.method(1, (Type)this.ref(MuleEvent.class), "process");
        GeneratedVariable event = process.param((Type)this.ref(MuleEvent.class), "event");
        process.body()._return(ExpressionFactory._null());
    }

    private void generateTransformWithEvent(GeneratedClass expressionHolderClass) {
        GeneratedMethod transform = expressionHolderClass.method(1, (Type)this.ref(Object.class), "transform");
        GeneratedVariable src = transform.param((Type)this.ref(Object.class), "src");
        GeneratedVariable muleEvent = transform.param((Type)this.ref(MuleEvent.class), "event");
        transform._throws(this.ref(TransformerMessagingException.class));
        transform.body()._return((GeneratedExpression)ExpressionFactory.invoke((String)"transform").arg((GeneratedExpression)src).arg(ExpressionFactory._null()).arg((GeneratedExpression)muleEvent));
    }

    private void generateTransformWithEventAndEncoding(GeneratedClass expressionHolderTransformerClass, org.mule.devkit.model.Type type) {
        GeneratedMethod transform = expressionHolderTransformerClass.method(1, (Type)this.ref(Object.class), "transform");
        GeneratedVariable src = transform.param((Type)this.ref(Object.class), "src");
        GeneratedVariable encoding = transform.param((Type)this.ref(String.class), "encoding");
        GeneratedVariable muleEvent = transform.param((Type)this.ref(MuleEvent.class), "event");
        transform._throws(this.ref(TransformerMessagingException.class));
        transform.body()._if(src.isNull())._then()._return(ExpressionFactory._null());
        GeneratedClass expressionHolderClass = (GeneratedClass)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type);
        GeneratedVariable expressionHolder = transform.body().decl((Type)expressionHolderClass, "holder", (GeneratedExpression)ExpressionFactory.cast((Type)expressionHolderClass, (GeneratedExpression)src));
        GeneratedVariable result = transform.body().decl(this.ref(type), "result", (GeneratedExpression)ExpressionFactory._new((Type)this.ref(type)));
        GeneratedTry attempt = transform.body()._try();
        this.generateTransformedFields(type, muleEvent, expressionHolder, expressionHolderClass, attempt, result);
        GeneratedCatchBlock noSuchFieldExceptionCatch = attempt._catch(this.ref(NoSuchFieldException.class));
        noSuchFieldExceptionCatch.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(TransformerMessagingException.class)).arg((GeneratedExpression)this.ref(CoreMessages.class).staticInvoke("createStaticMessage").arg("internal error")).arg((GeneratedExpression)muleEvent).arg(ExpressionFactory._this()).arg((GeneratedExpression)noSuchFieldExceptionCatch.param("e")));
        GeneratedCatchBlock transformerExceptionCatch = attempt._catch(this.ref(TransformerException.class));
        GeneratedVariable e = transformerExceptionCatch.param("e");
        transformerExceptionCatch.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(TransformerMessagingException.class)).arg((GeneratedExpression)e.invoke("getI18nMessage")).arg((GeneratedExpression)muleEvent).arg(ExpressionFactory._this()).arg((GeneratedExpression)e));
        transform.body()._return((GeneratedExpression)result);
    }

    private void generateTransformedFields(org.mule.devkit.model.Type type, GeneratedVariable muleEvent, GeneratedVariable expressionHolder, GeneratedClass expressionHolderClass, GeneratedTry attempt, GeneratedVariable result) {
        for (Field field : type.getFields()) {
            GeneratedVariable transformed;
            if (!field.hasGetter() || !field.hasSetter()) continue;
            if (field.asType().isNestedProcessor() || field.asType().isArrayOrList() && field.getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)field.getTypeArguments().get(0)).isNestedProcessor()) {
                transformed = this.declareNestedProcessorParameter((GeneratedExpression)expressionHolder.invoke("get" + StringUtils.capitalise((String)field.getName())), (GeneratedExpression)ExpressionFactory._this().ref("muleContext"), muleEvent, attempt.body(), field.asType().isArrayOrList(), field.getName());
                attempt.body().add((Statement)result.invoke("set" + StringUtils.capitalise((String)field.getName())).arg((GeneratedExpression)transformed));
                continue;
            }
            transformed = this.declareTransformedVariable((Variable)field, (GeneratedExpression)expressionHolder.invoke("get" + StringUtils.capitalise((String)field.getName())), (Type)expressionHolderClass, muleEvent, attempt.body(), (GeneratedExpression)ExpressionFactory._this().ref("muleContext"));
            attempt.body().add((Statement)result.invoke("set" + StringUtils.capitalise((String)field.getName())).arg((GeneratedExpression)transformed));
        }
        if (type.hasSuperClass()) {
            this.generateTransformedFields(type.getSuperClass(), muleEvent, expressionHolder, (GeneratedClass)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type.getSuperClass()), attempt, result);
        }
    }

    private void generateGetName(GeneratedClass expressionHolderClass, GeneratedField name) {
        GeneratedMethod getName = expressionHolderClass.method(1, (Type)this.ref(String.class), "getName");
        getName.body()._return((GeneratedExpression)name);
    }

    private void generateSetName(GeneratedClass expressionHolderClass, GeneratedField name) {
        GeneratedMethod setName = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setName");
        GeneratedVariable newName = setName.param((Type)this.ref(String.class), "newName");
        setName.body().assign((AssignmentTarget)name, (GeneratedExpression)newName);
    }

    private void generateSetMuleContext(GeneratedClass expressionHolderClass, GeneratedField muleContext) {
        GeneratedMethod setMuleContext = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setMuleContext");
        GeneratedVariable context = setMuleContext.param((Type)this.ref(MuleContext.class), "context");
        setMuleContext.body().assign((AssignmentTarget)muleContext, (GeneratedExpression)context);
    }

    private void generateInitialise(GeneratedClass expressionHolderClass) {
        GeneratedMethod initialise = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        initialise._throws(this.ref(InitialisationException.class));
    }

    private void generateDispose(GeneratedClass expressionHolderClass) {
        GeneratedMethod dispose = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
    }

    private void generateGetEndpoint(GeneratedClass expressionHolderClass, GeneratedField endpoint) {
        GeneratedMethod getEndpoint = expressionHolderClass.method(1, (Type)this.ref(ImmutableEndpoint.class), "getEndpoint");
        getEndpoint.body()._return((GeneratedExpression)endpoint);
    }

    private void generateSetEndpoint(GeneratedClass expressionHolderClass, GeneratedField endpoint) {
        GeneratedMethod setEndpoint = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setEndpoint");
        GeneratedVariable ep = setEndpoint.param((Type)this.ref(ImmutableEndpoint.class), "ep");
        setEndpoint.body().assign((AssignmentTarget)endpoint, (GeneratedExpression)ep);
    }

    private void generateGetReturnDataType(org.mule.devkit.model.Type type, GeneratedClass expressionHolderClass) {
        GeneratedMethod getReturnDataType = expressionHolderClass.method(1, (Type)this.ref(DataType.class).narrow(this.ref(Object.class).wildcard()), "getReturnDataType");
        getReturnDataType.body()._return((GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref(type).boxify().dotclass()));
    }

    private void generateSetReturnDataType(GeneratedClass expressionHolderClass) {
        GeneratedMethod setReturnDataType = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setReturnDataType");
        setReturnDataType.param((Type)this.ref(DataType.class).narrow(this.ref(Object.class).wildcard()), "type");
        setReturnDataType.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private void generateGetReturnClass(org.mule.devkit.model.Type type, GeneratedClass expressionHolderClass) {
        GeneratedMethod getReturnClass = expressionHolderClass.method(1, (Type)this.ref(Class.class).narrow(this.ref(Object.class).wildcard()), "getReturnClass");
        getReturnClass.body()._return(this.ref(type).boxify().dotclass());
    }

    private void generateSetReturnClass(GeneratedClass expressionHolderClass) {
        GeneratedMethod setReturnClass = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setReturnClass");
        setReturnClass.param((Type)this.ref(Class.class).narrow(this.ref(Object.class).wildcard()), "theClass");
        setReturnClass.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private void generateTransformWithEncoding(GeneratedClass expressionHolderClass) {
        GeneratedMethod transformWithEncoding = expressionHolderClass.method(1, (Type)this.ref(Object.class), "transform");
        transformWithEncoding.param((Type)this.ref(Object.class), "src");
        transformWithEncoding.param((Type)this.ref(String.class), "encoding");
        transformWithEncoding._throws(this.ref(TransformerException.class));
        transformWithEncoding.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private void generateTransform(GeneratedClass expressionHolderClass) {
        GeneratedMethod transform = expressionHolderClass.method(1, (Type)this.ref(Object.class), "transform");
        transform.param((Type)this.ref(Object.class), "src");
        transform._throws(this.ref(TransformerException.class));
        transform.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private void generateIsIgnoreBadInput(GeneratedClass expressionHolderClass) {
        GeneratedMethod isIgnoreBadInput = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isIgnoreBadInput");
        isIgnoreBadInput.body()._return(ExpressionFactory.FALSE);
    }

    private void generateIsAcceptNull(GeneratedClass expressionHolderClass) {
        GeneratedMethod isAcceptNull = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isAcceptNull");
        isAcceptNull.body()._return(ExpressionFactory.FALSE);
    }

    private void generateGetSourceTypes(org.mule.devkit.model.Type type, GeneratedClass expressionHolderClass) {
        GeneratedClass expressionHolder = (GeneratedClass)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type);
        GeneratedMethod getSourceTypes = expressionHolderClass.method(1, (Type)this.ref(List.class).narrow(this.ref(Class.class).narrow(this.ref(Object.class).wildcard())), "getSourceTypes");
        getSourceTypes.body()._return((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Class.class).narrow(this.ref(Object.class).wildcard()).array()).arg(expressionHolder.dotclass())));
    }

    private void generateGetSourceDataTypes(org.mule.devkit.model.Type type, GeneratedClass expressionHolderClass) {
        GeneratedClass expressionHolder = (GeneratedClass)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type);
        GeneratedMethod getSourceTypes = expressionHolderClass.method(1, (Type)this.ref(List.class).narrow(this.ref(DataType.class).narrow(this.ref(Object.class).wildcard())), "getSourceDataTypes");
        getSourceTypes.body()._return((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DataType.class).narrow(this.ref(Object.class).wildcard()).array()).arg((GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(expressionHolder.dotclass()))));
    }

    private void generateIsSourceTypeSupported(org.mule.devkit.model.Type type, GeneratedClass expressionHolderClass) {
        GeneratedClass expressionHolder = (GeneratedClass)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type);
        GeneratedMethod isSourceTypeSupported = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isSourceTypeSupported");
        GeneratedVariable aClass = isSourceTypeSupported.param((Type)this.ref(Class.class).narrow(this.ref(Object.class).wildcard()), "aClass");
        isSourceTypeSupported.body()._return(Op.eq((GeneratedExpression)aClass, (GeneratedExpression)expressionHolder.dotclass()));
    }

    private void generateIsSourceTypeSupportedDataType(org.mule.devkit.model.Type type, GeneratedClass expressionHolderClass) {
        GeneratedClass expressionHolder = (GeneratedClass)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type);
        GeneratedMethod isSourceTypeSupported = expressionHolderClass.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isSourceDataTypeSupported");
        GeneratedVariable dataType = isSourceTypeSupported.param((Type)this.ref(DataType.class).narrow(this.ref(Object.class).wildcard()), "dataType");
        isSourceTypeSupported.body()._return(Op.eq((GeneratedExpression)dataType.invoke("getType"), (GeneratedExpression)expressionHolder.dotclass()));
    }

    private GeneratedClass getExpressionHolderTransformerClass(org.mule.devkit.model.Type type) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".transformers");
        GeneratedClass expressionHolderClass = pkg._class(type.getClassName() + "ExpressionHolderTransformer");
        expressionHolderClass._extends(this.ref(ExpressionEvaluatorSupport.class));
        expressionHolderClass._implements(this.ref(MessageTransformer.class));
        expressionHolderClass._implements(this.ref(DiscoverableTransformer.class));
        this.ctx().registerProduct(Product.EXPRESSION_HOLDER_TRANSFORMER, (Identifiable)type, (Object)expressionHolderClass);
        this.ctx().registerProduct(Product.REGISTRY_BOOTSTRAP_ENTRY, null, expressionHolderClass.name(), (Object)expressionHolderClass);
        return expressionHolderClass;
    }

    private boolean isExpressionHolderTransformerRegistered(TypeMirror typeMirror) {
        return this.registeredExpressionHolderTransformers.contains(((Object)typeMirror).toString());
    }

    private void generateSetPriorityWeighting(GeneratedClass jaxbTransformerClass, GeneratedField weighting) {
        GeneratedMethod setPriorityWeighting = jaxbTransformerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "setPriorityWeighting");
        GeneratedVariable localWeighting = setPriorityWeighting.param((Type)this.ctx().getCodeModel().INT, "weighting");
        setPriorityWeighting.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)weighting), (GeneratedExpression)localWeighting);
    }

    private void generateGetPriorityWeighting(GeneratedClass jaxbTransformerClass, GeneratedField weighting) {
        GeneratedMethod getPriorityWeighting = jaxbTransformerClass.method(1, (Type)this.ctx().getCodeModel().INT, "getPriorityWeighting");
        getPriorityWeighting.body()._return((GeneratedExpression)weighting);
    }
}

