/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.callback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.callback.HttpCallback;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transport.Connector;
import org.mule.config.spring.factories.AsyncMessageProcessorsFactoryBean;
import org.mule.construct.Flow;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class DefaultHttpCallbackGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    public static final String LOCAL_PORT_FIELD_NAME = "localPort";
    public static final String REMOTE_PORT_FIELD_NAME = "remotePort";
    public static final String DOMAIN_FIELD_NAME = "domain";
    public static final String ASYNC_FIELD_NAME = "async";
    public static final String CONNECTOR_FIELD_NAME = "connector";
    public static final String EH_FIELD_NAME = "exceptionHandler";
    private static final String INBOUND_ENDPOINT_EXCHANGE_PATTERN = "REQUEST_RESPONSE";
    private GeneratedMethod buildUrlMethod;
    private GeneratedField muleContextField;
    private GeneratedField flowConstructVariable;
    private GeneratedMethod createHttpInboundEndpointMethod;
    private GeneratedField urlField;
    private GeneratedMethod createConnectorMethod;
    private GeneratedMethod wrapMessageProcessorInAsyncChain;
    private GeneratedField loggerField;
    private GeneratedField callbackFlowField;
    private GeneratedField localPortField;
    private GeneratedField callbackMessageProcessorField;
    private GeneratedField domainField;
    private GeneratedField localUrlField;
    private GeneratedField callbackPathField;
    private GeneratedField remotePortField;
    private GeneratedField async;
    private GeneratedField exceptionHandlerField;
    private GeneratedField connectorField;
    private static final List<Product> CONSUMES = Arrays.asList(new Product[0]);
    private static final List<Product> PRODUCES = Arrays.asList(Product.DEFAULT_HTTP_CALLBACK);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return false;
    }

    public void generate(Module module) {
        GeneratedClass callbackClass = this.getDefaultHttpCallbackClass(module);
        this.ctx().note("Generating HTTP callback implementation as " + callbackClass.fullName());
        this.generateFields(callbackClass);
        this.generateConstructorArgSimpleFlowConstruct(callbackClass);
        this.generateConstructorArgMessageProcessor(callbackClass);
        this.generateConstructorArgMessageProcessorAndCallbackPath(callbackClass);
        this.generateConstructorArgSimpleFlowConstructAndConnectorRef(callbackClass);
        this.generateConstructorArgMessageProcessorAndConnectorRef(callbackClass);
        this.generateConstructorArgMessageProcessorAndCallbackPathAndConnectorRef(callbackClass);
        this.generateConstructorArgChainAndConnectorRef(callbackClass);
        this.generateConstructorArgChainAndCallbackPathAndConnectorRef(callbackClass);
        this.generateConstructorArgChain(callbackClass);
        this.generateConstructorArgChainAndCallbackPath(callbackClass);
        this.generateConstructorArgChainAndCallbackPathAndExceptionHandler(callbackClass);
        this.generateConstructorArgChainAndCallbackPathAndExceptionHandlerAndConnector(callbackClass);
        this.generateBuildUrlMethod(callbackClass);
        this.createMessageProcessorInnerClass(callbackClass);
        this.generateWrapMessageProcessorInAsyncChain(callbackClass);
        this.generateCreateConnectorMethod(callbackClass);
        this.generateCreateHttpInboundEndpointMethod(callbackClass);
        this.generateStartMethod(callbackClass);
        this.generateStopMethod(callbackClass);
        this.generateBuildChainMethod(callbackClass);
    }

    private void generateFields(GeneratedClass callbackClass) {
        this.loggerField = FieldBuilder.newLoggerField((GeneratedClass)callbackClass);
        this.localPortField = new FieldBuilder(callbackClass).privateVisibility().type(Integer.class).name(LOCAL_PORT_FIELD_NAME).build();
        this.remotePortField = new FieldBuilder(callbackClass).privateVisibility().type(Integer.class).name(REMOTE_PORT_FIELD_NAME).javadoc("The port number to be used in the dynamic http inbound endpoint that will receive the callback").build();
        this.domainField = new FieldBuilder(callbackClass).type(String.class).name(DOMAIN_FIELD_NAME).javadoc("The domain to be used in the dynamic http inbound endpoint that will receive the callback").build();
        this.urlField = new FieldBuilder(callbackClass).privateVisibility().type(String.class).name("url").javadoc("The dynamically generated url to pass on to the cloud connector. When this url is called the callback flow will be executed").getter().build();
        this.localUrlField = new FieldBuilder(callbackClass).privateVisibility().type(String.class).name("localUrl").build();
        this.muleContextField = new FieldBuilder(callbackClass).privateVisibility().type(MuleContext.class).name("muleContext").javadoc("Mule Context").setter().build();
        this.callbackFlowField = new FieldBuilder(callbackClass).privateVisibility().type(Flow.class).name("callbackFlow").javadoc("The flow to be called upon the http callback").build();
        this.flowConstructVariable = new FieldBuilder(callbackClass).privateVisibility().type(Flow.class).name("flowConstruct").javadoc("The dynamically created flow").build();
        this.callbackMessageProcessorField = new FieldBuilder(callbackClass).type(MessageProcessor.class).name("callbackMessageProcessor").javadoc("The message processor to be called upon the http callback").build();
        this.callbackPathField = new FieldBuilder(callbackClass).type(String.class).name("callbackPath").javadoc("Optional path to set up the endpoint").build();
        this.async = new FieldBuilder(callbackClass).type(Boolean.class).name(ASYNC_FIELD_NAME).javadoc("Whether the the message processor that invokes the callback flow is asynchronous").build();
        this.connectorField = new FieldBuilder(callbackClass).type(Connector.class).name(CONNECTOR_FIELD_NAME).javadoc("HTTP connector").build();
        this.exceptionHandlerField = new FieldBuilder(callbackClass).type(MessagingExceptionHandler.class).name(EH_FIELD_NAME).javadoc("Exception Handler").build();
    }

    private void generateConstructorArgSimpleFlowConstructAndConnectorRef(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        GeneratedVariable callbackFlowArg = constructor.param((Type)this.ref(Flow.class), "callbackFlow");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        GeneratedVariable connectorArg = constructor.param((Type)this.ref(Connector.class), CONNECTOR_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackFlowField), (GeneratedExpression)callbackFlowArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), (GeneratedExpression)connectorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgMessageProcessorAndConnectorRef(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(MessageProcessor.class), "callbackMessageProcessor");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        GeneratedVariable connectorArg = constructor.param((Type)this.ref(Connector.class), CONNECTOR_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)messageProcessorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), (GeneratedExpression)connectorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgChainAndConnectorRef(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        constructor._throws(this.ref(MuleException.class));
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(List.class).narrow(this.ref(MessageProcessor.class)), "callbackMessageProcessors");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        GeneratedVariable connectorArg = constructor.param((Type)this.ref(Connector.class), CONNECTOR_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildChain").arg((GeneratedExpression)messageProcessorArg));
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), (GeneratedExpression)connectorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgMessageProcessorAndCallbackPathAndConnectorRef(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(MessageProcessor.class), "callbackMessageProcessor");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable callbackPathArg = constructor.param((Type)this.ref(String.class), "callbackPath");
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        GeneratedVariable connectorArg = constructor.param((Type)this.ref(Connector.class), CONNECTOR_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)messageProcessorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackPathField), (GeneratedExpression)callbackPathArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), (GeneratedExpression)connectorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgChainAndCallbackPathAndConnectorRef(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        constructor._throws(this.ref(MuleException.class));
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(List.class).narrow(this.ref(MessageProcessor.class)), "callbackMessageProcessors");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable callbackPathArg = constructor.param((Type)this.ref(String.class), "callbackPath");
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        GeneratedVariable connectorArg = constructor.param((Type)this.ref(Connector.class), CONNECTOR_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildChain").arg((GeneratedExpression)messageProcessorArg));
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackPathField), (GeneratedExpression)callbackPathArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), (GeneratedExpression)connectorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgSimpleFlowConstruct(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        GeneratedVariable callbackFlowArg = constructor.param((Type)this.ref(Flow.class), "callbackFlow");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackFlowField), (GeneratedExpression)callbackFlowArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), ExpressionFactory._null());
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgMessageProcessor(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(MessageProcessor.class), "callbackMessageProcessor");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)messageProcessorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), ExpressionFactory._null());
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgMessageProcessorAndCallbackPath(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(MessageProcessor.class), "callbackMessageProcessor");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable callbackPathArg = constructor.param((Type)this.ref(String.class), "callbackPath");
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)messageProcessorArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackPathField), (GeneratedExpression)callbackPathArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), ExpressionFactory._null());
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgChain(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        constructor._throws(this.ref(MuleException.class));
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(List.class).narrow(this.ref(MessageProcessor.class)), "callbackMessageProcessors");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildChain").arg((GeneratedExpression)messageProcessorArg));
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), ExpressionFactory._null());
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgChainAndCallbackPath(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        constructor._throws(this.ref(MuleException.class));
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(List.class).narrow(this.ref(MessageProcessor.class)), "callbackMessageProcessors");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable callbackPathArg = constructor.param((Type)this.ref(String.class), "callbackPath");
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildChain").arg((GeneratedExpression)messageProcessorArg));
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackPathField), (GeneratedExpression)callbackPathArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), ExpressionFactory._null());
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgChainAndCallbackPathAndExceptionHandler(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        constructor._throws(this.ref(MuleException.class));
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(List.class).narrow(this.ref(MessageProcessor.class)), "callbackMessageProcessors");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable callbackPathArg = constructor.param((Type)this.ref(String.class), "callbackPath");
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        GeneratedVariable ehArg = constructor.param((Type)this.ref(MessagingExceptionHandler.class), EH_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildChain").arg((GeneratedExpression)messageProcessorArg));
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackPathField), (GeneratedExpression)callbackPathArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), ExpressionFactory._null());
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.exceptionHandlerField), (GeneratedExpression)ehArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateConstructorArgChainAndCallbackPathAndExceptionHandlerAndConnector(GeneratedClass callbackClass) {
        GeneratedMethod constructor = callbackClass.constructor(1);
        constructor._throws(this.ref(MuleException.class));
        GeneratedVariable messageProcessorArg = constructor.param((Type)this.ref(List.class).narrow(this.ref(MessageProcessor.class)), "callbackMessageProcessors");
        GeneratedVariable muleContextArg = constructor.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable callbackDomainArg = constructor.param((Type)this.ref(String.class), "callbackDomain");
        GeneratedVariable localPortArg = constructor.param((Type)this.ref(Integer.class), LOCAL_PORT_FIELD_NAME);
        GeneratedVariable remotePortArg = constructor.param((Type)this.ref(Integer.class), REMOTE_PORT_FIELD_NAME);
        GeneratedVariable callbackPathArg = constructor.param((Type)this.ref(String.class), "callbackPath");
        GeneratedVariable asyncArg = constructor.param((Type)this.ref(Boolean.class), ASYNC_FIELD_NAME);
        GeneratedVariable ehArg = constructor.param((Type)this.ref(MessagingExceptionHandler.class), EH_FIELD_NAME);
        GeneratedVariable connector = constructor.param((Type)this.ref(Connector.class), CONNECTOR_FIELD_NAME);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackMessageProcessorField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildChain").arg((GeneratedExpression)messageProcessorArg));
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.muleContextField), (GeneratedExpression)muleContextArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localPortField), (GeneratedExpression)localPortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.domainField), (GeneratedExpression)callbackDomainArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.remotePortField), (GeneratedExpression)remotePortArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.callbackPathField), (GeneratedExpression)callbackPathArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.async), (GeneratedExpression)asyncArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), ExpressionFactory._null());
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.exceptionHandlerField), (GeneratedExpression)ehArg);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.connectorField), (GeneratedExpression)connector);
        constructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.urlField), (GeneratedExpression)ExpressionFactory.invoke((String)"buildUrl"));
    }

    private void generateBuildUrlMethod(GeneratedClass callbackClass) {
        this.buildUrlMethod = callbackClass.method(4, (Type)this.ref(String.class), "buildUrl");
        GeneratedBlock body = this.buildUrlMethod.body();
        GeneratedVariable urlBuilder = body.decl((Type)this.ref(StringBuilder.class), "urlBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        GeneratedBlock ifDomainNotPrefixed = body._if(Op.not((GeneratedExpression)this.domainField.invoke("contains").arg("://")))._then();
        GeneratedConditional ifConnectorNotNull = ifDomainNotPrefixed._if(this.connectorField.isNotNull());
        ifConnectorNotNull._then().invoke((GeneratedExpression)urlBuilder, "append").arg(Op.plus((GeneratedExpression)this.connectorField.invoke("getProtocol"), (GeneratedExpression)ExpressionFactory.lit((String)"://")));
        ifConnectorNotNull._else().invoke((GeneratedExpression)urlBuilder, "append").arg("http://");
        body.invoke((GeneratedExpression)urlBuilder, "append").arg((GeneratedExpression)this.domainField);
        GeneratedConditional ifNotNull = body._if(Op.cand((GeneratedExpression)this.remotePortField.isNotNull(), (GeneratedExpression)Op.ne((GeneratedExpression)this.remotePortField, (GeneratedExpression)ExpressionFactory.lit((int)80))));
        ifNotNull._then().invoke((GeneratedExpression)urlBuilder, "append").arg(":");
        ifNotNull._then().invoke((GeneratedExpression)urlBuilder, "append").arg((GeneratedExpression)this.remotePortField);
        body.invoke((GeneratedExpression)urlBuilder, "append").arg("/");
        GeneratedConditional ifCallbackPathNotNull = body._if(this.callbackPathField.isNotNull());
        ifCallbackPathNotNull._then().invoke((GeneratedExpression)urlBuilder, "append").arg((GeneratedExpression)this.callbackPathField);
        ifCallbackPathNotNull._else().invoke((GeneratedExpression)urlBuilder, "append").arg((GeneratedExpression)this.ref(UUID.class).staticInvoke("randomUUID"));
        body._return((GeneratedExpression)urlBuilder.invoke("toString"));
    }

    private void generateWrapMessageProcessorInAsyncChain(GeneratedClass callbackClass) {
        this.wrapMessageProcessorInAsyncChain = callbackClass.method(4, (Type)this.ref(MessageProcessor.class), "wrapMessageProcessorInAsyncChain")._throws(this.ref(MuleException.class));
        GeneratedVariable messageProcessorParam = this.wrapMessageProcessorInAsyncChain.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedBlock body = this.wrapMessageProcessorInAsyncChain.body();
        GeneratedVariable asyncMessageProcessorsFactoryBean = body.decl((Type)this.ref(AsyncMessageProcessorsFactoryBean.class), "asyncMessageProcessorsFactoryBean", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(AsyncMessageProcessorsFactoryBean.class)));
        body.invoke((GeneratedExpression)asyncMessageProcessorsFactoryBean, "setMuleContext").arg((GeneratedExpression)this.muleContextField);
        body.invoke((GeneratedExpression)asyncMessageProcessorsFactoryBean, "setMessageProcessors").arg((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)messageProcessorParam));
        body.invoke((GeneratedExpression)asyncMessageProcessorsFactoryBean, "setProcessingStrategy").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(AsynchronousProcessingStrategy.class)));
        GeneratedTry tryStatement = body._try();
        tryStatement.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MessageProcessor.class), (GeneratedExpression)asyncMessageProcessorsFactoryBean.invoke("getObject")));
        GeneratedCatchBlock catchBlock = tryStatement._catch(this.ref(Exception.class));
        catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(FlowConstructInvalidException.class)).arg((GeneratedExpression)catchBlock.param("e")));
    }

    private void generateCreateConnectorMethod(GeneratedClass callbackClass) {
        this.createConnectorMethod = callbackClass.method(4, (Type)this.ref(Connector.class), "createConnector")._throws(this.ref(MuleException.class));
        GeneratedBlock body = this.createConnectorMethod.body();
        GeneratedConditional ifConnectorNotNull = body._if(this.connectorField.isNotNull());
        ifConnectorNotNull._then()._return((GeneratedExpression)ExpressionFactory._this().ref(this.connectorField.name()));
        GeneratedVariable muleRegistryVariable = body.decl((Type)this.ref(MuleRegistry.class), "muleRegistry", (GeneratedExpression)ExpressionFactory.invoke((GeneratedExpression)this.muleContextField, (String)"getRegistry"));
        GeneratedVariable httpConnectorVariable = body.decl((Type)this.ref(Connector.class), "httpConnector", (GeneratedExpression)ExpressionFactory.invoke((GeneratedExpression)muleRegistryVariable, (String)"lookupConnector").arg("connector.http.mule.default"));
        GeneratedConditional conditional = body._if(httpConnectorVariable.isNotNull());
        conditional._then()._return((GeneratedExpression)httpConnectorVariable);
        conditional._else().block().invoke((GeneratedExpression)this.loggerField, "error").arg("Could not find connector with name 'connector.http.mule.default'");
        conditional._else().block()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMuleException.class)).arg("Could not find connector with name 'connector.http.mule.default'"));
    }

    private void generateCreateHttpInboundEndpointMethod(GeneratedClass callbackClass) {
        this.createHttpInboundEndpointMethod = callbackClass.method(4, (Type)this.ref(InboundEndpoint.class), "createHttpInboundEndpoint")._throws(this.ref(MuleException.class));
        GeneratedBlock body = this.createHttpInboundEndpointMethod.body();
        GeneratedVariable inBuilderVariable = body.decl((Type)this.ref(EndpointURIEndpointBuilder.class), "inBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(EndpointURIEndpointBuilder.class)).arg((GeneratedExpression)this.localUrlField).arg((GeneratedExpression)this.muleContextField));
        body.invoke((GeneratedExpression)inBuilderVariable, "setConnector").arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)this.createConnectorMethod));
        body.invoke((GeneratedExpression)inBuilderVariable, "setExchangePattern").arg((GeneratedExpression)this.ref(MessageExchangePattern.class).staticRef(INBOUND_ENDPOINT_EXCHANGE_PATTERN));
        GeneratedVariable endpointFactoryVariable = body.decl((Type)this.ref(EndpointFactory.class), "endpointFactory", (GeneratedExpression)ExpressionFactory.invoke((GeneratedExpression)this.muleContextField, (String)"getEndpointFactory"));
        body._return((GeneratedExpression)ExpressionFactory.invoke((GeneratedExpression)endpointFactoryVariable, (String)"getInboundEndpoint").arg((GeneratedExpression)inBuilderVariable));
    }

    private void generateStartMethod(GeneratedClass callbackClass) {
        GeneratedMethod startMethod = callbackClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start")._throws(this.ref(MuleException.class));
        GeneratedBlock body = startMethod.body();
        body.assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localUrlField), (GeneratedExpression)this.urlField.invoke("replaceFirst").arg((GeneratedExpression)this.domainField).arg("localhost"));
        GeneratedConditional ifNotFound = body._if(Op.eq((GeneratedExpression)this.localUrlField.invoke("indexOf").arg(Op.plus((GeneratedExpression)ExpressionFactory.lit((String)":"), (GeneratedExpression)this.ref(String.class).staticInvoke("valueOf").arg((GeneratedExpression)this.remotePortField))), (GeneratedExpression)ExpressionFactory.lit((int)-1)));
        ifNotFound._then().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localUrlField), (GeneratedExpression)this.localUrlField.invoke("replaceFirst").arg(ExpressionFactory.lit((String)"localhost")).arg(Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"localhost:"), (GeneratedExpression)this.ref(String.class).staticInvoke("valueOf").arg((GeneratedExpression)this.localPortField))));
        ifNotFound._else().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)this.localUrlField), (GeneratedExpression)this.localUrlField.invoke("replaceFirst").arg((GeneratedExpression)this.ref(String.class).staticInvoke("valueOf").arg((GeneratedExpression)this.remotePortField)).arg((GeneratedExpression)this.ref(String.class).staticInvoke("valueOf").arg((GeneratedExpression)this.localPortField)));
        GeneratedVariable dynamicFlowName = body.decl((Type)this.ref(String.class), "dynamicFlowName", (GeneratedExpression)this.ref(String.class).staticInvoke("format").arg("DynamicFlow-%s").arg((GeneratedExpression)this.localUrlField));
        body.assign((AssignmentTarget)this.flowConstructVariable, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(Flow.class)).arg((GeneratedExpression)dynamicFlowName).arg((GeneratedExpression)this.muleContextField));
        body.invoke((GeneratedExpression)this.flowConstructVariable, "setMessageSource").arg((GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)this.createHttpInboundEndpointMethod));
        GeneratedVariable messageProcessor = body.decl((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedConditional ifCallbackFlowNotNull = body._if(this.callbackFlowField.isNotNull());
        ifCallbackFlowNotNull._then().assign((AssignmentTarget)messageProcessor, (GeneratedExpression)ExpressionFactory._new((TypeReference)callbackClass.listClasses()[0]));
        ifCallbackFlowNotNull._else().assign((AssignmentTarget)messageProcessor, (GeneratedExpression)this.callbackMessageProcessorField);
        body._if((GeneratedExpression)this.async)._then().assign((AssignmentTarget)messageProcessor, (GeneratedExpression)ExpressionFactory.invoke((GeneratedMethod)this.wrapMessageProcessorInAsyncChain).arg((GeneratedExpression)messageProcessor));
        GeneratedVariable mps = body.decl((Type)this.ref(List.class).narrow(this.ref(MessageProcessor.class)), "messageProcessors", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(MessageProcessor.class)));
        body.invoke((GeneratedExpression)mps, "add").arg((GeneratedExpression)messageProcessor);
        body.invoke((GeneratedExpression)this.flowConstructVariable, "setMessageProcessors").arg((GeneratedExpression)mps);
        body._if(this.exceptionHandlerField.isNotNull())._then().invoke((GeneratedExpression)this.flowConstructVariable, "setExceptionListener").arg((GeneratedExpression)this.exceptionHandlerField);
        body.invoke((GeneratedExpression)this.flowConstructVariable, "initialise");
        body.invoke((GeneratedExpression)this.flowConstructVariable, "start");
        body.invoke((GeneratedExpression)this.loggerField, "debug").arg((GeneratedExpression)this.ref(String.class).staticInvoke("format").arg("Created flow with http inbound endpoint listening at: %s").arg((GeneratedExpression)this.urlField));
    }

    private void generateStopMethod(GeneratedClass callbackClass) {
        GeneratedMethod stopMethod = callbackClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop")._throws(this.ref(MuleException.class));
        GeneratedBlock body = stopMethod.body();
        GeneratedBlock block = body._if(this.flowConstructVariable.isNotNull())._then();
        block.invoke((GeneratedExpression)this.flowConstructVariable, "stop");
        block.invoke((GeneratedExpression)this.flowConstructVariable, "dispose");
        block.invoke((GeneratedExpression)this.loggerField, "debug").arg("Http callback flow stopped");
    }

    private void createMessageProcessorInnerClass(GeneratedClass callbackClass) {
        GeneratedClass messageProcessor = callbackClass._class("FlowRefMessageProcessor")._implements(this.ref(MessageProcessor.class));
        GeneratedMethod processMethod = messageProcessor.method(1, (Type)this.ref(MuleEvent.class), "process")._throws(this.ref(MuleException.class));
        processMethod.param((Type)this.ref(MuleEvent.class), "event");
        processMethod.body()._return((GeneratedExpression)ExpressionFactory.invoke((GeneratedExpression)this.callbackFlowField, (String)"process").arg((GeneratedExpression)processMethod.params().get(0)));
    }

    private GeneratedClass getDefaultHttpCallbackClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".process");
        GeneratedClass clazz = pkg._class("DefaultHttpCallback");
        clazz._implements(this.ref(HttpCallback.class));
        this.ctx().registerProduct(Product.DEFAULT_HTTP_CALLBACK, (Object)clazz);
        return clazz;
    }

    private void generateBuildChainMethod(GeneratedClass callbackClass) {
        GeneratedMethod buildChain = callbackClass.method(20, (Type)this.ref(MessageProcessor.class), "buildChain");
        buildChain._throws(this.ref(MuleException.class));
        GeneratedVariable messageProcessors = buildChain.param((Type)this.ref(List.class).narrow(this.ref(MessageProcessor.class)), "messageProcessors");
        GeneratedVariable builder = buildChain.body().decl((Type)this.ref(DefaultMessageProcessorChainBuilder.class), "builder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMessageProcessorChainBuilder.class)));
        GeneratedForEach forEach = buildChain.body().forEach((Type)this.ref(Object.class), "messageProcessor", (GeneratedExpression)messageProcessors);
        forEach.body()._if(Op._instanceof((GeneratedExpression)forEach.var(), (Type)this.ref(MessageProcessor.class)))._then().add((Statement)builder.invoke("chain").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MessageProcessor.class), (GeneratedExpression)forEach.var())))._continue();
        forEach.body()._if(Op._instanceof((GeneratedExpression)forEach.var(), (Type)this.ref(MessageProcessorBuilder.class)))._then().add((Statement)builder.invoke("chain").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MessageProcessorBuilder.class), (GeneratedExpression)forEach.var())))._continue();
        buildChain.body()._return((GeneratedExpression)builder.invoke("build"));
    }
}

