/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.List;
import org.mule.api.annotations.MetaDataKeyRetriever;
import org.mule.api.annotations.MetaDataRetriever;
import org.mule.api.annotations.param.MetaDataKeyParam;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;

public class MetaDataAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return true;
    }

    public void verify(Module module) throws AnnotationVerificationException {
        if (!module.isConnector()) {
            return;
        }
        List metaDataKeysRetrievers = module.getMethodsAnnotatedWith(MetaDataKeyRetriever.class);
        List metaDataRetriever = module.getMethodsAnnotatedWith(MetaDataRetriever.class);
        if (metaDataKeysRetrievers.size() == 1 && metaDataRetriever.size() == 1) {
            if (!module.getMinMuleVersion().atLeast("3.4")) {
                throw new AnnotationVerificationException((Identifiable)module, " MetaData is only available for @Connectors with a min mule version of 3.4");
            }
            Method metaDataKeyRetrieverMethod = (Method)metaDataKeysRetrievers.get(0);
            if (!metaDataKeyRetrieverMethod.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)metaDataKeyRetrieverMethod, " must be public");
            }
            if (!metaDataKeyRetrieverMethod.getParameters().isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)metaDataKeyRetrieverMethod, " must not have any arguments");
            }
            if (!this.isListOfMetaDataKeys(metaDataKeyRetrieverMethod.getReturnGenericType())) {
                throw new AnnotationVerificationException((Identifiable)metaDataKeyRetrieverMethod, " must return a List<MetaDataKey>");
            }
            Method metaDataRetrieveMethod = (Method)metaDataRetriever.get(0);
            if (!metaDataRetrieveMethod.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)metaDataKeyRetrieverMethod, " must be public");
            }
            if (metaDataRetrieveMethod.getParameters().isEmpty() || metaDataRetrieveMethod.getParameters().size() > 1 || !((Parameter)metaDataRetrieveMethod.getParameters().get(0)).getGenericType().is("MetaDataKey")) {
                throw new AnnotationVerificationException((Identifiable)metaDataRetrieveMethod, " must have one only argument of type MetaDataKey");
            }
            if (!metaDataRetrieveMethod.getReturnGenericType().is("MetaData")) {
                throw new AnnotationVerificationException((Identifiable)metaDataRetrieveMethod, " must return a MetaData object");
            }
        } else {
            if (metaDataKeysRetrievers.size() > 1 || metaDataRetriever.size() > 1) {
                throw new AnnotationVerificationException((Identifiable)module, " there must be only one @MetaDataKeyRetriever or @MetaDataRetriever methods");
            }
            if (metaDataRetriever.isEmpty()) {
                for (Method m : module.getMethods()) {
                    for (Parameter key : m.getParameters()) {
                        if (key.getAnnotation(MetaDataKeyParam.class) == null) continue;
                        throw new AnnotationVerificationException((Identifiable)m, " no @MetaDataRetriever defined in order to lookup for @MetaDataKeyParam in " + m.getName() + " method");
                    }
                }
            }
        }
    }

    private boolean isListOfMetaDataKeys(GenericType returnGenericType) {
        return returnGenericType != null && returnGenericType.isList() && ((GenericType)returnGenericType.getGenericTypeArguments().get(0)).is("MetaDataKey");
    }
}

