/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.model.visitor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.type.TypeKind;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyAllClassesAvailableInClasspathVisitor
extends AbstractVisitor {
    private Set<String> classesNotAvailable = new HashSet<String>();

    @Override
    public void visit(Parameter<?> parameter) {
        super.visit(parameter);
        this.checkClassIsAvailable((Variable<?>)parameter);
    }

    @Override
    public void visit(Field<?> field) {
        super.visit(field);
        this.checkClassIsAvailable((Variable<?>)field);
    }

    public Set<String> getClassesNotAvailable() {
        return Collections.unmodifiableSet(this.classesNotAvailable);
    }

    public boolean isAllClassesAvailable() {
        return this.classesNotAvailable.isEmpty();
    }

    private void checkClassIsAvailable(Variable<?> identifiable) {
        if (identifiable.asType() == null && identifiable.asTypeMirror().getKind() != TypeKind.TYPEVAR) {
            this.classesNotAvailable.add(identifiable.getJavaType());
        }
    }
}

