/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.api.callback.HttpCallback;
import org.mule.config.PoolingProfile;
import org.mule.config.spring.factories.MessageProcessorChainFactoryBean;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.FilterMethod;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;
import org.mule.devkit.model.schema.SchemaTypeConversion;
import org.mule.routing.MessageFilter;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDefinitionParserGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.DEFAULT_SAVE_ACCESS_TOKEN_CALLBACK_FACTORY, Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK_FACTORY, Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.INJECTION_ADAPTER, Product.OAUTH_ADAPTER, Product.MESSAGE_PROCESSOR, Product.MESSAGE_SOURCE, Product.EXPRESSION_HOLDER, Product.OAUTH_MANAGER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.BEAN_DEFINITION_PARSER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void generate(Module module) {
        this.generateConfigBeanDefinitionParserFor(module);
        for (FilterMethod executableElement : module.getFilterMethods()) {
            this.generateBeanDefinitionParserForFilter((Method)executableElement);
        }
        for (FilterMethod executableElement : module.getProcessorMethods()) {
            this.generateBeanDefinitionParserForProcessor((Method)executableElement);
        }
        for (FilterMethod executableElement : module.getSourceMethods()) {
            this.generateBeanDefinitionParserForSource((Method)executableElement);
        }
    }

    private void generateConfigBeanDefinitionParserFor(Module module) {
        GeneratedClass beanDefinitionparser = this.getConfigBeanDefinitionParserClass(module);
        GeneratedClass pojo = this.getModuleObject((org.mule.devkit.model.Type)module);
        this.ctx().note("Generating config element definition parser as " + beanDefinitionparser.fullName() + " for class " + module.getName());
        GeneratedMethod parse = beanDefinitionparser.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        GeneratedVariable element = parse.param((Type)this.ref(Element.class), "element");
        GeneratedVariable parserContext = parse.param((Type)this.ref(ParserContext.class), "parserContext");
        parse.body().invoke("parseConfigName").arg((GeneratedExpression)element);
        GeneratedInvocation rootBeanDefinition = this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition");
        OAuthModule oAuthModule = null;
        String restAdapterClass = null;
        if (module instanceof OAuthModule) {
            oAuthModule = (OAuthModule)module;
            if (oAuthModule.hasRestCalls()) {
                restAdapterClass = module.getPackage().getName() + ".adapters." + module.getClassName() + "RestClientAdapter.class";
                rootBeanDefinition.arg(ExpressionFactory.direct((String)(restAdapterClass + ".getName()")));
            } else {
                rootBeanDefinition.arg((GeneratedExpression)pojo.dotclass().invoke("getName"));
            }
        } else {
            rootBeanDefinition.arg((GeneratedExpression)pojo.dotclass().invoke("getName"));
        }
        GeneratedVariable builder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), "builder", (GeneratedExpression)rootBeanDefinition);
        if (oAuthModule != null && oAuthModule.getOAuthVersion().equals((Object)OAuthVersion.V10A)) {
            GeneratedClass manager = (GeneratedClass)this.ctx().getProduct(Product.OAUTH_MANAGER, (Identifiable)module);
            GeneratedVariable managerBuilder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), "managerBuilder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)manager.dotclass().invoke("getName")));
            parse.body().add((Statement)builder.invoke("addConstructorArgValue").arg((GeneratedExpression)managerBuilder.invoke("getBeanDefinition")));
        }
        parse.body().invoke((GeneratedExpression)builder, "setScope").arg((GeneratedExpression)this.ref(BeanDefinition.class).staticRef("SCOPE_SINGLETON"));
        if (restAdapterClass != null) {
            parse.body().invoke("setInitMethodIfNeeded").arg((GeneratedExpression)builder).arg(ExpressionFactory.direct((String)restAdapterClass));
            parse.body().invoke("setDestroyMethodIfNeeded").arg((GeneratedExpression)builder).arg(ExpressionFactory.direct((String)restAdapterClass));
        } else {
            parse.body().invoke("setInitMethodIfNeeded").arg((GeneratedExpression)builder).arg(pojo.dotclass());
            parse.body().invoke("setDestroyMethodIfNeeded").arg((GeneratedExpression)builder).arg(pojo.dotclass());
        }
        for (Field field : module.getConfigurableFields()) {
            this.generateParseVariable(parse.body(), (Variable)field, element, parserContext, builder, false, true, 0);
        }
        for (Field variable : module.getInjectFields()) {
            if (!((Object)variable.asTypeMirror()).toString().equals("org.mule.api.store.ObjectStore")) continue;
            GeneratedConditional ifNotNull = parse.body()._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)element).arg("objectStore-ref"));
            ifNotNull._then().add((Statement)builder.invoke("addPropertyValue").arg(variable.getName()).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((GeneratedExpression)element.invoke("getAttribute").arg("objectStore-ref"))));
        }
        if (module instanceof ManagedConnectionModule) {
            for (Field variable : ((ManagedConnectionModule)module).getConnectMethod().getParameters()) {
                String fieldName = variable.getName();
                if (SchemaTypeConversion.isSupported((String)((Object)variable.asTypeMirror()).toString())) {
                    this.generateParseProperty(parse.body(), element, builder, variable.getAlternativeName(), fieldName);
                    continue;
                }
                if (variable.asType().isArrayOrList()) {
                    this.generateParseList(parse.body(), element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), true, 0);
                    continue;
                }
                if (variable.asType().isMap()) {
                    this.generateParseMap(parse.body(), element, builder, (Identifiable)variable, fieldName, variable.getDefaultValue(), true);
                    continue;
                }
                if (variable.asType().isEnum()) {
                    this.generateParseProperty(parse.body(), element, builder, variable.getAlternativeName(), fieldName);
                    continue;
                }
                if (!variable.asType().isSet()) continue;
                this.generateParseSet(parse.body(), element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), true, 0);
            }
        }
        if (module instanceof OAuthModule) {
            this.generateParseHttpCallback("oauth-callback-config", parse, element, builder);
            GeneratedClass saveAccessTokenCallbackFactory = (GeneratedClass)this.ctx().getProduct(Product.DEFAULT_SAVE_ACCESS_TOKEN_CALLBACK_FACTORY);
            GeneratedClass restoreAccessTokenCallbackFactory = (GeneratedClass)this.ctx().getProduct(Product.DEFAULT_RESTORE_ACCESS_TOKEN_CALLBACK_FACTORY);
            this.generateParseNestedProcessor(parse.body(), element, parserContext, builder, "oauthSaveAccessToken", false, false, (TypeReference)saveAccessTokenCallbackFactory);
            this.generateParseNestedProcessor(parse.body(), element, parserContext, builder, "oauthRestoreAccessToken", false, false, (TypeReference)restoreAccessTokenCallbackFactory);
            this.generateParseOAuthStoreConfig("oauth-store-config", parse, element, builder);
            this.generateParseProperty(parse.body(), element, builder, "name", "name");
            this.generateParseProperty(parse.body(), element, builder, "authorizationUrl");
            this.generateParseProperty(parse.body(), element, builder, "accessTokenUrl");
            this.generateParseProperty(parse.body(), element, builder, "onNoToken");
            if (((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
                this.generateParseProperty(parse.body(), element, builder, "requestTokenUrl");
            }
        }
        if (module.hasProcessorMethodWithParameter(HttpCallback.class)) {
            this.generateParseHttpCallback("http-callback-config", parse, element, builder);
        }
        if (module instanceof ManagedConnectionModule) {
            this.generateParsePoolingProfile("connection-pooling-profile", "connectionPoolingProfile", parse, element, builder);
        }
        if (module.usesPooling()) {
            this.generateParsePoolingProfile("pooling-profile", "poolingProfile", parse, element, builder);
        }
        GeneratedVariable definition = parse.body().decl((Type)this.ref(BeanDefinition.class), "definition", (GeneratedExpression)builder.invoke("getBeanDefinition"));
        parse.body().invoke("setNoRecurseOnDefinition").arg((GeneratedExpression)definition);
        if (module instanceof ManagedConnectionModule) {
            parse.body().invoke("parseRetryPolicyTemplate").arg("reconnect").arg((GeneratedExpression)element).arg((GeneratedExpression)parserContext).arg((GeneratedExpression)builder).arg((GeneratedExpression)definition);
            parse.body().invoke("parseRetryPolicyTemplate").arg("reconnect-forever").arg((GeneratedExpression)element).arg((GeneratedExpression)parserContext).arg((GeneratedExpression)builder).arg((GeneratedExpression)definition);
            parse.body().invoke("parseRetryPolicyTemplate").arg("reconnect-custom-strategy").arg((GeneratedExpression)element).arg((GeneratedExpression)parserContext).arg((GeneratedExpression)builder).arg((GeneratedExpression)definition);
        }
        parse.body()._return((GeneratedExpression)definition);
    }

    private void generateParseHttpCallback(String elementName, GeneratedMethod parse, GeneratedVariable element, GeneratedVariable builder) {
        GeneratedVariable httpCallbackConfigElement = parse.body().decl((Type)this.ref(Element.class), "httpCallbackConfigElement", (GeneratedExpression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((GeneratedExpression)element).arg(elementName));
        GeneratedBlock ifHttpCallbackConfigPresent = parse.body()._if(httpCallbackConfigElement.isNotNull())._then();
        this.generateParseProperty(ifHttpCallbackConfigPresent, httpCallbackConfigElement, builder, "domain");
        this.generateParseProperty(ifHttpCallbackConfigPresent, httpCallbackConfigElement, builder, "localPort");
        this.generateParseProperty(ifHttpCallbackConfigPresent, httpCallbackConfigElement, builder, "remotePort");
        this.generateParseProperty(ifHttpCallbackConfigPresent, httpCallbackConfigElement, builder, "async");
        this.generateParseProperty(ifHttpCallbackConfigPresent, httpCallbackConfigElement, builder, "path");
        GeneratedConditional ifNotNull = ifHttpCallbackConfigPresent._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)httpCallbackConfigElement).arg("connector-ref"));
        ifNotNull._then().add((Statement)builder.invoke("addPropertyValue").arg("connector").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((GeneratedExpression)httpCallbackConfigElement.invoke("getAttribute").arg("connector-ref"))));
    }

    private void generateParseOAuthStoreConfig(String elementName, GeneratedMethod parse, GeneratedVariable element, GeneratedVariable builder) {
        GeneratedVariable oauthStoreConfigElement = parse.body().decl((Type)this.ref(Element.class), "oauthStoreConfigElement", (GeneratedExpression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((GeneratedExpression)element).arg(elementName));
        GeneratedBlock ifOAuthStoreConfigNotNull = parse.body()._if(oauthStoreConfigElement.isNotNull())._then();
        this.generateParsePropertyRef(ifOAuthStoreConfigNotNull, oauthStoreConfigElement, builder, "objectStore-ref", "accessTokenObjectStore");
    }

    private void generateParsePoolingProfile(String elementName, String propertyName, GeneratedMethod parse, GeneratedVariable element, GeneratedVariable builder) {
        GeneratedVariable poolingProfileBuilder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), propertyName + "Builder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)this.ref(PoolingProfile.class).dotclass().invoke("getName")));
        GeneratedVariable poolingProfileElement = parse.body().decl((Type)this.ref(Element.class), propertyName + "Element", (GeneratedExpression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((GeneratedExpression)element).arg(elementName));
        GeneratedConditional ifElementNotNull = parse.body()._if(poolingProfileElement.isNotNull());
        this.generateParseProperty(ifElementNotNull._then(), poolingProfileElement, poolingProfileBuilder, "maxActive");
        this.generateParseProperty(ifElementNotNull._then(), poolingProfileElement, poolingProfileBuilder, "maxIdle");
        this.generateParseProperty(ifElementNotNull._then(), poolingProfileElement, poolingProfileBuilder, "maxWait");
        GeneratedConditional ifNotNull = ifElementNotNull._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)poolingProfileElement).arg("exhaustedAction"));
        ifNotNull._then().add((Statement)poolingProfileBuilder.invoke("addPropertyValue").arg("exhaustedAction").arg((GeneratedExpression)this.ref(PoolingProfile.class).staticRef("POOL_EXHAUSTED_ACTIONS").invoke("get").arg((GeneratedExpression)poolingProfileElement.invoke("getAttribute").arg("exhaustedAction"))));
        ifNotNull = ifElementNotNull._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)poolingProfileElement).arg("initialisationPolicy"));
        ifNotNull._then().add((Statement)poolingProfileBuilder.invoke("addPropertyValue").arg("initialisationPolicy").arg((GeneratedExpression)this.ref(PoolingProfile.class).staticRef("POOL_INITIALISATION_POLICIES").invoke("get").arg((GeneratedExpression)poolingProfileElement.invoke("getAttribute").arg("initialisationPolicy"))));
        ifNotNull = ifElementNotNull._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)poolingProfileElement).arg("evictionCheckIntervalMillis"));
        this.generateParseProperty(ifNotNull._then(), poolingProfileElement, poolingProfileBuilder, "evictionCheckIntervalMillis");
        ifNotNull = ifElementNotNull._then()._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)poolingProfileElement).arg("minEvictionMillis"));
        this.generateParseProperty(ifNotNull._then(), poolingProfileElement, poolingProfileBuilder, "minEvictionMillis");
        ifElementNotNull._then().add((Statement)builder.invoke("addPropertyValue").arg(propertyName).arg((GeneratedExpression)poolingProfileBuilder.invoke("getBeanDefinition")));
    }

    private void generateBeanDefinitionParserForSource(Method sourceMethod) {
        if (this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, sourceMethod.parent(), sourceMethod.getName()) != null) {
            return;
        }
        GeneratedClass beanDefinitionparser = this.getBeanDefinitionParserClass((Method<org.mule.devkit.model.Type>)sourceMethod);
        GeneratedClass messageSourceClass = (GeneratedClass)this.ctx().getProduct(Product.MESSAGE_SOURCE, sourceMethod.parent(), sourceMethod.getName());
        this.ctx().note("Generating bean definition parser as " + beanDefinitionparser.fullName() + " for message source " + messageSourceClass.fullName());
        this.generateSourceParseMethod(beanDefinitionparser, messageSourceClass, sourceMethod);
    }

    private void generateBeanDefinitionParserForProcessor(Method processorMethod) {
        if (this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, processorMethod.parent(), processorMethod.getName()) != null) {
            return;
        }
        GeneratedClass beanDefinitionparser = this.getBeanDefinitionParserClass((Method<org.mule.devkit.model.Type>)processorMethod);
        GeneratedClass messageProcessorClass = (GeneratedClass)this.ctx().getProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName());
        this.ctx().note("Generating bean definition parser as " + beanDefinitionparser.fullName() + " for message processor " + messageProcessorClass.fullName());
        this.generateProcessorParseMethod(beanDefinitionparser, messageProcessorClass, processorMethod);
    }

    private void generateBeanDefinitionParserForFilter(Method filterMethod) {
        if (this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, filterMethod.parent(), filterMethod.getName()) != null) {
            return;
        }
        GeneratedClass beanDefinitionparser = this.getBeanDefinitionParserClass((Method<org.mule.devkit.model.Type>)filterMethod);
        GeneratedClass messageProcessorClass = (GeneratedClass)this.ctx().getProduct(Product.FILTER, filterMethod.parent(), filterMethod.getName());
        this.ctx().note("Generating bean definition parser as " + beanDefinitionparser.fullName() + " for filter " + messageProcessorClass.fullName());
        this.generateFilterParseMethod(beanDefinitionparser, messageProcessorClass, filterMethod);
    }

    private void generateProcessorParseMethod(GeneratedClass definitionParser, GeneratedClass messageProcessorClass, Method processorMethod) {
        GeneratedMethod parse = definitionParser.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        GeneratedVariable element = parse.param((Type)this.ref(Element.class), "element");
        GeneratedVariable parserContext = parse.param((Type)this.ref(ParserContext.class), "parserContext");
        GeneratedVariable definition = this.generateParseCommon(messageProcessorClass, (Method<? extends org.mule.devkit.model.Type>)processorMethod, parse, element, parserContext, true);
        parse.body().invoke("attachProcessorDefinition").arg((GeneratedExpression)parserContext).arg((GeneratedExpression)definition);
        parse.body()._return((GeneratedExpression)definition);
    }

    private void generateFilterParseMethod(GeneratedClass definitionParser, GeneratedClass filterClass, Method filterMethod) {
        GeneratedMethod parse = definitionParser.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        GeneratedVariable element = parse.param((Type)this.ref(Element.class), "element");
        GeneratedVariable parserContext = parse.param((Type)this.ref(ParserContext.class), "parserContext");
        GeneratedVariable definition = this.generateParseCommon(filterClass, (Method<? extends org.mule.devkit.model.Type>)filterMethod, parse, element, parserContext, false);
        GeneratedVariable messageFilterBuilder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), "messageFilterBuilder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)this.ref(MessageFilter.class).dotclass().invoke("getName")));
        parse.body().invoke((GeneratedExpression)messageFilterBuilder, "addPropertyValue").arg("filter").arg((GeneratedExpression)definition);
        parse.body().invoke("attachProcessorDefinition").arg((GeneratedExpression)parserContext).arg((GeneratedExpression)messageFilterBuilder.invoke("getBeanDefinition"));
        parse.body()._return((GeneratedExpression)definition);
    }

    private void generateSourceParseMethod(GeneratedClass definitionParser, GeneratedClass messageProcessorClass, Method sourceMethod) {
        GeneratedMethod parse = definitionParser.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        GeneratedVariable element = parse.param((Type)this.ref(Element.class), "element");
        GeneratedVariable parserContext = parse.param((Type)this.ref(ParserContext.class), "parserContext");
        GeneratedVariable definition = this.generateParseCommon(messageProcessorClass, (Method<? extends org.mule.devkit.model.Type>)sourceMethod, parse, element, parserContext, true);
        parse.body().invoke("attachSourceDefinition").arg((GeneratedExpression)parserContext).arg((GeneratedExpression)definition);
        parse.body()._return((GeneratedExpression)definition);
    }

    private GeneratedVariable generateParseCommon(GeneratedClass messageProcessorClass, Method<? extends org.mule.devkit.model.Type> method, GeneratedMethod parse, GeneratedVariable element, GeneratedVariable parserContext, boolean hasAtrribute) {
        GeneratedVariable builder = parse.body().decl((Type)this.ref(BeanDefinitionBuilder.class), "builder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)messageProcessorClass.dotclass().invoke("getName")));
        if (hasAtrribute) {
            parse.body().add((Statement)builder.invoke("addConstructorArgValue").arg(method.getName()));
        }
        parse.body().invoke((GeneratedExpression)builder, "setScope").arg((GeneratedExpression)this.ref(BeanDefinition.class).staticRef("SCOPE_PROTOTYPE"));
        parse.body().invoke("parseConfigRef").arg((GeneratedExpression)element).arg((GeneratedExpression)builder);
        for (Parameter variable : method.getParameters()) {
            GeneratedBlock body = parse.body();
            boolean oneChildElementOnly = method.hasOnlyOneChildElement();
            if (variable.shouldBeIgnored()) continue;
            this.generateParseVariable(body, (Variable)variable, element, parserContext, builder, oneChildElementOnly, false, 0);
        }
        if (method instanceof ProcessorMethod && ((ProcessorMethod)method).canBeUsedInConnectionManagement()) {
            for (Parameter variable : ((ProcessorMethod)method).getManagedConnectionModule().getConnectMethod().getParameters()) {
                if (variable.shouldBeIgnored()) continue;
                String fieldName = variable.getName();
                if (SchemaTypeConversion.isSupported((String)((Object)variable.asTypeMirror()).toString())) {
                    this.generateParseProperty(parse.body(), element, builder, variable.getAlternativeName(), fieldName);
                    continue;
                }
                if (variable.asType().isArrayOrList()) {
                    this.generateParseList(parse.body(), element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), false, 0);
                    continue;
                }
                if (variable.asType().isMap()) {
                    this.generateParseMap(parse.body(), element, builder, (Identifiable)variable, fieldName, variable.getDefaultValue(), false);
                    continue;
                }
                if (variable.asType().isEnum()) {
                    this.generateParseProperty(parse.body(), element, builder, variable.getAlternativeName(), fieldName);
                    continue;
                }
                if (!variable.asType().isSet()) continue;
                this.generateParseSet(parse.body(), element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), true, 0);
            }
        }
        if (method instanceof ProcessorMethod && ((ProcessorMethod)method).canBeUsedInOAuthManagement()) {
            this.generateParseProperty(parse.body(), element, builder, "accessTokenId");
        }
        GeneratedVariable definition = parse.body().decl((Type)this.ref(BeanDefinition.class), "definition", (GeneratedExpression)builder.invoke("getBeanDefinition"));
        parse.body().invoke("setNoRecurseOnDefinition").arg((GeneratedExpression)definition);
        return definition;
    }

    private void generateParseVariable(GeneratedBlock body, Variable variable, GeneratedVariable element, GeneratedVariable parserContext, GeneratedVariable builder, boolean oneChildElementOnly, boolean noExpressions, int depth) {
        String fieldName = variable.getName();
        if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
            this.generateParseNestedProcessor(body, element, parserContext, builder, fieldName, oneChildElementOnly, variable.asType().isArrayOrList(), this.ref(MessageProcessorChainFactoryBean.class));
        } else if (variable.isText()) {
            this.generateParseText(body, element, builder, NameUtils.uncamel((String)variable.getAlternativeName()), fieldName);
        } else if (SchemaTypeConversion.isSupported((String)((Object)variable.asTypeMirror()).toString())) {
            this.generateParseProperty(body, element, builder, variable.getAlternativeName(), fieldName);
        } else if (variable.asType().isArrayOrList()) {
            this.generateParseList(body, element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), noExpressions, depth);
        } else if (variable.asType().isMap()) {
            this.generateParseMap(body, element, builder, (Identifiable)variable, fieldName, variable.getDefaultValue(), noExpressions);
        } else if (variable.asType().isEnum()) {
            this.generateParseProperty(body, element, builder, variable.getAlternativeName(), fieldName);
        } else if (variable.asType().isSet()) {
            this.generateParseSet(body, element, builder, (Identifiable)variable, fieldName, parserContext, variable.getDefaultValue(), noExpressions, depth);
        } else if (((Object)variable.asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) {
            GeneratedVariable callbackFlowName = body.decl((Type)this.ref(String.class), fieldName + "CallbackFlowName", (GeneratedExpression)ExpressionFactory.invoke((String)"getAttributeValue").arg((GeneratedExpression)element).arg(NameUtils.uncamel((String)fieldName) + "-flow-ref"));
            GeneratedBlock block = body._if(callbackFlowName.isNotNull())._then();
            block.invoke((GeneratedExpression)builder, "addPropertyValue").arg(fieldName + "CallbackFlow").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((GeneratedExpression)callbackFlowName));
        } else if (variable.asType().isComplexType() && !variable.isRefOnly()) {
            TypeReference complexTypeRef = null;
            complexTypeRef = noExpressions ? this.ref(variable.asTypeMirror()).boxify() : (TypeReference)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)variable.asType());
            GeneratedConditional ifNoRef = null;
            ifNoRef = variable.hasDefaultValue() ? body._if(Op.not((GeneratedExpression)ExpressionFactory.invoke((String)(noExpressions ? "parseNoExprObjectRefWithDefault" : "parseObjectRefWithDefault")).arg((GeneratedExpression)element).arg((GeneratedExpression)builder).arg(NameUtils.uncamel((String)fieldName)).arg(fieldName).arg(variable.getDefaultValue()))) : body._if(Op.not((GeneratedExpression)ExpressionFactory.invoke((String)(noExpressions ? "parseNoExprObjectRef" : "parseObjectRef")).arg((GeneratedExpression)element).arg((GeneratedExpression)builder).arg(NameUtils.uncamel((String)fieldName)).arg(fieldName)));
            GeneratedVariable complexTypeBuilder = ifNoRef._then().decl((Type)this.ref(BeanDefinitionBuilder.class), this.getVariableName(variable.getName(), depth) + "Builder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg((GeneratedExpression)complexTypeRef.dotclass().invoke("getName")));
            GeneratedVariable childElement = ifNoRef._then().decl((Type)this.ref(Element.class), this.getVariableName(variable.getName(), depth) + "ChildElement", (GeneratedExpression)this.ref(DomUtils.class).staticInvoke("getChildElementByTagName").arg((GeneratedExpression)element).arg(NameUtils.uncamel((String)variable.getName())));
            GeneratedConditional ifChildElementNotNull = ifNoRef._then()._if(childElement.isNotNull());
            this.parseHierarchyVariables(ifChildElementNotNull._then(), variable.asType(), childElement, parserContext, complexTypeBuilder, noExpressions, depth + 1);
            for (Field field : variable.asType().getFields()) {
                if (!field.hasGetter() || !field.hasSetter() || field.shouldBeIgnored()) continue;
                if (field.asType().equals(variable.asType())) {
                    this.ctx().error("Parameter " + variable.getName() + " of type " + variable.asType().getClassName() + " cannot be used without @RefOnly annotation because it has an recursive structure");
                    continue;
                }
                this.generateParseVariable(ifChildElementNotNull._then(), (Variable)field, childElement, parserContext, complexTypeBuilder, false, noExpressions, depth + 1);
            }
            ifChildElementNotNull._then().invoke((GeneratedExpression)builder, "addPropertyValue").arg(fieldName).arg((GeneratedExpression)complexTypeBuilder.invoke("getBeanDefinition"));
        } else {
            GeneratedConditional ifNotNull = body._if((GeneratedExpression)ExpressionFactory.invoke((String)"hasAttribute").arg((GeneratedExpression)element).arg(fieldName + "-ref"));
            GeneratedConditional ifNotExpression = ifNotNull._then()._if((GeneratedExpression)element.invoke("getAttribute").arg(fieldName + "-ref").invoke("startsWith").arg("#"));
            if (noExpressions) {
                ifNotExpression._else().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeBeanReference.class)).arg((GeneratedExpression)element.invoke("getAttribute").arg(fieldName + "-ref"))));
            } else {
                ifNotExpression._else().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"#[registry:"), (GeneratedExpression)element.invoke("getAttribute").arg(fieldName + "-ref")), (GeneratedExpression)ExpressionFactory.lit((String)"]"))));
            }
            ifNotExpression._then().add((Statement)builder.invoke("addPropertyValue").arg(fieldName).arg((GeneratedExpression)element.invoke("getAttribute").arg(fieldName + "-ref")));
        }
    }

    private void parseHierarchyVariables(GeneratedBlock body, org.mule.devkit.model.Type variable, GeneratedVariable childElement, GeneratedVariable parserContext, GeneratedVariable complexTypeBuilder, boolean noExpressions, int depth) {
        if (variable.hasSuperClass()) {
            for (Field field : variable.getInheritedFields()) {
                this.generateParseVariable(body, (Variable)field, childElement, parserContext, complexTypeBuilder, false, noExpressions, depth + 1);
            }
            this.parseHierarchyVariables(body, variable.getSuperClass(), childElement, parserContext, complexTypeBuilder, noExpressions, depth + 1);
        }
    }

    private String getVariableName(String variableName, int depth) {
        StringBuilder name = new StringBuilder("");
        while (depth-- > 0) {
            name.append("_");
        }
        name.append(variableName);
        return name.toString();
    }

    private void generateParseList(GeneratedBlock body, GeneratedVariable element, GeneratedVariable builder, Identifiable variable, String fieldName, GeneratedVariable parserContext, String defaultValue, boolean noExpression, int depth) {
        GeneratedInvocation parseListAndSetProperty = null;
        parseListAndSetProperty = defaultValue != null ? body.invoke("parseListWithDefaultAndSetProperty").arg((GeneratedExpression)element).arg((GeneratedExpression)builder).arg(fieldName).arg(NameUtils.uncamel((String)fieldName)).arg(NameUtils.uncamel((String)NameUtils.singularize((String)fieldName))).arg(defaultValue) : body.invoke("parseListAndSetProperty").arg((GeneratedExpression)element).arg((GeneratedExpression)builder).arg(fieldName).arg(NameUtils.uncamel((String)fieldName)).arg(NameUtils.uncamel((String)NameUtils.singularize((String)fieldName)));
        if (variable.hasTypeArguments()) {
            Identifiable typeArgument = (Identifiable)variable.getTypeArguments().get(0);
            if (typeArgument.asType().isArrayOrList()) {
                String innerChildElementName = "inner-" + NameUtils.uncamel((String)NameUtils.singularize((String)fieldName));
                parseListAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForList(innerChildElementName)));
            } else if (typeArgument.asType().isMap()) {
                String innerChildElementName = "inner-" + NameUtils.uncamel((String)NameUtils.singularize((String)fieldName));
                parseListAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForMap(innerChildElementName)));
            } else if (typeArgument.asType().isComplexType()) {
                parseListAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForComplexType(typeArgument.asType(), parserContext, noExpression, depth + 1)));
            } else if (typeArgument.asType().isSet()) {
                String innerChildElementName = "inner-" + NameUtils.uncamel((String)NameUtils.singularize((String)fieldName));
                parseListAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForSet(innerChildElementName)));
            } else {
                parseListAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForTextContent()));
            }
        } else {
            parseListAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForTextContent()));
        }
    }

    private void generateParseSet(GeneratedBlock body, GeneratedVariable element, GeneratedVariable builder, Identifiable variable, String fieldName, GeneratedVariable parserContext, String defaultValue, boolean noExpression, int depth) {
        GeneratedInvocation parseSetAndSetProperty = null;
        parseSetAndSetProperty = defaultValue != null ? body.invoke("parseSetWithDefaultAndSetProperty").arg((GeneratedExpression)element).arg((GeneratedExpression)builder).arg(fieldName).arg(NameUtils.uncamel((String)fieldName)).arg(NameUtils.uncamel((String)NameUtils.singularize((String)fieldName))).arg(defaultValue) : body.invoke("parseSetAndSetProperty").arg((GeneratedExpression)element).arg((GeneratedExpression)builder).arg(fieldName).arg(NameUtils.uncamel((String)fieldName)).arg(NameUtils.uncamel((String)NameUtils.singularize((String)fieldName)));
        if (variable.hasTypeArguments()) {
            Identifiable typeArgument = (Identifiable)variable.getTypeArguments().get(0);
            if (typeArgument.asType().isArrayOrList()) {
                String innerChildElementName = "inner-" + NameUtils.uncamel((String)NameUtils.singularize((String)fieldName));
                parseSetAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForList(innerChildElementName)));
            } else if (typeArgument.asType().isMap()) {
                String innerChildElementName = "inner-" + NameUtils.uncamel((String)NameUtils.singularize((String)fieldName));
                parseSetAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForMap(innerChildElementName)));
            } else if (typeArgument.asType().isComplexType()) {
                parseSetAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForComplexType(typeArgument.asType(), parserContext, noExpression, depth + 1)));
            } else if (typeArgument.asType().isSet()) {
                String innerChildElementName = "inner-" + NameUtils.uncamel((String)NameUtils.singularize((String)fieldName));
                parseSetAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForSet(innerChildElementName)));
            } else {
                parseSetAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForTextContent()));
            }
        } else {
            parseSetAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForTextContent()));
        }
    }

    private void generateParseMap(GeneratedBlock body, GeneratedVariable element, GeneratedVariable builder, Identifiable variable, String fieldName, String defaultValue, boolean noExpression) {
        GeneratedInvocation parseMapAndSetProperty = null;
        parseMapAndSetProperty = defaultValue != null ? body.invoke("parseMapWithDefaultAndSetProperty").arg((GeneratedExpression)element).arg((GeneratedExpression)builder).arg(fieldName).arg(NameUtils.uncamel((String)fieldName)).arg(NameUtils.uncamel((String)NameUtils.singularize((String)fieldName))).arg(defaultValue) : body.invoke("parseMapAndSetProperty").arg((GeneratedExpression)element).arg((GeneratedExpression)builder).arg(fieldName).arg(NameUtils.uncamel((String)fieldName)).arg(NameUtils.uncamel((String)NameUtils.singularize((String)fieldName)));
        if (variable.hasTypeArguments()) {
            Identifiable typeArgument = (Identifiable)variable.getTypeArguments().get(0);
            if (typeArgument.asType().isArrayOrList()) {
                String innerChildElementName = "inner-" + NameUtils.uncamel((String)NameUtils.singularize((String)fieldName));
                parseMapAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForList(innerChildElementName)));
            } else if (typeArgument.asType().isMap()) {
                String innerChildElementName = "inner-" + NameUtils.uncamel((String)NameUtils.singularize((String)fieldName));
                parseMapAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForMap(innerChildElementName)));
            } else if (typeArgument.asType().isSet()) {
                String innerChildElementName = "inner-" + NameUtils.uncamel((String)NameUtils.singularize((String)fieldName));
                parseMapAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForSet(innerChildElementName)));
            } else {
                parseMapAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForTextContent()));
            }
        } else {
            parseMapAndSetProperty.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForTextContent()));
        }
    }

    private void generateParseNestedProcessor(GeneratedBlock block, GeneratedVariable element, GeneratedVariable parserContext, GeneratedVariable builder, String fieldName, boolean skipElement, boolean isList, TypeReference factoryBean) {
        if (skipElement) {
            block.invoke(isList ? "parseNestedProcessorAsListAndSetProperty" : "parseNestedProcessorAndSetProperty").arg((GeneratedExpression)element).arg((GeneratedExpression)parserContext).arg(factoryBean.dotclass()).arg((GeneratedExpression)builder).arg(fieldName);
        } else {
            block.invoke(isList ? "parseNestedProcessorAsListAndSetProperty" : "parseNestedProcessorAndSetProperty").arg((GeneratedExpression)element).arg(NameUtils.uncamel((String)fieldName)).arg((GeneratedExpression)parserContext).arg(factoryBean.dotclass()).arg((GeneratedExpression)builder).arg(fieldName);
        }
    }

    private void generateParsePropertyRef(GeneratedBlock block, GeneratedVariable element, GeneratedVariable builder, String attributeName, String fieldName) {
        block.invoke("parsePropertyRef").arg((GeneratedExpression)builder).arg((GeneratedExpression)element).arg(attributeName).arg(fieldName);
    }

    private void generateParsePropertyRef(GeneratedBlock block, GeneratedVariable element, GeneratedVariable builder, String fieldName) {
        block.invoke("parsePropertyRef").arg((GeneratedExpression)builder).arg((GeneratedExpression)element).arg(fieldName);
    }

    private void generateParseProperty(GeneratedBlock block, GeneratedVariable element, GeneratedVariable builder, String attributeName, String fieldName) {
        block.invoke("parseProperty").arg((GeneratedExpression)builder).arg((GeneratedExpression)element).arg(attributeName).arg(fieldName);
    }

    private void generateParseText(GeneratedBlock block, GeneratedVariable element, GeneratedVariable builder, String elementName, String fieldName) {
        block.invoke("parseTextProperty").arg((GeneratedExpression)builder).arg((GeneratedExpression)element).arg(elementName).arg(fieldName);
    }

    private void generateParseProperty(GeneratedBlock block, GeneratedVariable element, GeneratedVariable builder, String fieldName) {
        block.invoke("parseProperty").arg((GeneratedExpression)builder).arg((GeneratedExpression)element).arg(fieldName);
    }

    private GeneratedClass generateParserDelegateForTextContent() {
        GeneratedClass anonymousClass = this.ctx().getCodeModel().anonymousClass(this.ref(AbstractDevkitBasedDefinitionParser.ParseDelegate.class).narrow(this.ref(String.class)));
        GeneratedMethod parseMethod = anonymousClass.method(1, (Type)this.ref(String.class), "parse");
        GeneratedVariable element = parseMethod.param((Type)this.ref(Element.class), "element");
        parseMethod.body()._return((GeneratedExpression)element.invoke("getTextContent"));
        return anonymousClass;
    }

    private GeneratedClass generateParserDelegateForComplexType(org.mule.devkit.model.Type type, GeneratedVariable parserContext, boolean noExpressions, int depth) {
        GeneratedClass expressionHolder = (GeneratedClass)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type);
        GeneratedClass anonymousClass = this.ctx().getCodeModel().anonymousClass(this.ref(AbstractDevkitBasedDefinitionParser.ParseDelegate.class).narrow(this.ref(BeanDefinition.class)));
        GeneratedMethod parseMethod = anonymousClass.method(1, (Type)this.ref(BeanDefinition.class), "parse");
        GeneratedVariable element = parseMethod.param((Type)this.ref(Element.class), "element");
        if (depth < 20) {
            TypeReference complexTypeRef = null;
            complexTypeRef = noExpressions ? this.ref(type.asTypeMirror()).boxify() : (TypeReference)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type.asType());
            GeneratedVariable builder = parseMethod.body().decl((Type)this.ref(BeanDefinitionBuilder.class), "builder", (GeneratedExpression)this.ref(BeanDefinitionBuilder.class).staticInvoke("rootBeanDefinition").arg(complexTypeRef.dotclass()));
            this.parseHierarchyVariables(parseMethod.body(), type, element, parserContext, builder, noExpressions, depth);
            for (Field field : type.getFields()) {
                if (!field.hasGetter() || !field.hasSetter() || field.shouldBeIgnored()) continue;
                this.generateParseVariable(parseMethod.body(), (Variable)field, element, parserContext, builder, false, noExpressions, depth);
            }
            parseMethod.body()._return((GeneratedExpression)builder.invoke("getBeanDefinition"));
        } else {
            parseMethod.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Cannot parse this many nested elements"));
        }
        return anonymousClass;
    }

    private GeneratedClass generateParserDelegateForList(String childElementName) {
        GeneratedClass anonymousClass = this.ctx().getCodeModel().anonymousClass(this.ref(AbstractDevkitBasedDefinitionParser.ParseDelegate.class).narrow(this.ref(List.class)));
        GeneratedMethod parseMethod = anonymousClass.method(1, (Type)this.ref(List.class), "parse");
        GeneratedVariable element = parseMethod.param((Type)this.ref(Element.class), "element");
        parseMethod.body()._return((GeneratedExpression)ExpressionFactory.invoke((String)"parseList").arg((GeneratedExpression)element).arg(childElementName).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForTextContent())));
        return anonymousClass;
    }

    private GeneratedClass generateParserDelegateForSet(String childElementName) {
        GeneratedClass anonymousClass = this.ctx().getCodeModel().anonymousClass(this.ref(AbstractDevkitBasedDefinitionParser.ParseDelegate.class).narrow(this.ref(Set.class)));
        GeneratedMethod parseMethod = anonymousClass.method(1, (Type)this.ref(Set.class), "parse");
        GeneratedVariable element = parseMethod.param((Type)this.ref(Element.class), "element");
        parseMethod.body()._return((GeneratedExpression)ExpressionFactory.invoke((String)"parseSet").arg((GeneratedExpression)element).arg(childElementName).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForTextContent())));
        return anonymousClass;
    }

    private GeneratedClass generateParserDelegateForMap(String childElementName) {
        GeneratedClass anonymousClass = this.ctx().getCodeModel().anonymousClass(this.ref(AbstractDevkitBasedDefinitionParser.ParseDelegate.class).narrow(this.ref(Map.class)));
        GeneratedMethod parseMethod = anonymousClass.method(1, (Type)this.ref(Map.class), "parse");
        GeneratedVariable element = parseMethod.param((Type)this.ref(Element.class), "element");
        parseMethod.body()._return((GeneratedExpression)ExpressionFactory.invoke((String)"parseMap").arg((GeneratedExpression)element).arg(childElementName).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.generateParserDelegateForTextContent())));
        return anonymousClass;
    }

    private GeneratedClass getBeanDefinitionParserClass(Method<org.mule.devkit.model.Type> method) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)method.parent()).getPackage().getName() + ".config");
        GeneratedClass clazz = pkg._class(method.getCapitalizedName() + "DefinitionParser", this.ref(AbstractDevkitBasedDefinitionParser.class));
        this.ctx().registerProduct(Product.BEAN_DEFINITION_PARSER, method.parent(), method.getName(), (Object)clazz);
        return clazz;
    }

    private GeneratedClass getConfigBeanDefinitionParserClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".config");
        GeneratedClass clazz = pkg._class(module.getClassName() + "ConfigDefinitionParser", this.ref(AbstractDevkitBasedDefinitionParser.class));
        this.ctx().registerProduct(Product.BEAN_DEFINITION_PARSER, (Identifiable)module, "config", (Object)clazz);
        return clazz;
    }
}

