/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.config.ConfigurationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.security.oauth.processor.AbstractDevkitBasedMessageProcessor;
import org.mule.transformer.TransformerTemplate;
import org.mule.transport.NullPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class AbstractMessageProcessorGenerator
extends AbstractMuleGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.ABSTRACT_EXPRESSION_EVALUATOR, Product.ABSTRACT_CONNECTED_PROCESSOR);
    private static final List<Product> PRODUCES = Arrays.asList(Product.ABSTRACT_MESSAGE_PROCESSOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    private GeneratedClass getAbstractMessageProcessorClass(List<Module> modules) {
        Module module = modules.iterator().next();
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".processors");
        GeneratedClass clazz = this.hasToBeConnected(modules) ? pkg._class(33, "AbstractMessageProcessor", (TypeReference)this.ctx().getProduct(Product.ABSTRACT_CONNECTED_PROCESSOR)) : pkg._class("AbstractMessageProcessor", AbstractDevkitBasedMessageProcessor.class);
        this.ctx().registerProduct(Product.ABSTRACT_MESSAGE_PROCESSOR, (Object)clazz);
        return clazz;
    }

    private boolean hasToBeConnected(List<Module> modules) {
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule) && !(module instanceof OAuthModule)) continue;
            return true;
        }
        return false;
    }

    protected GeneratedMethod generateFindOrCreateMethod(GeneratedClass messageProcessorClass, TypeVariable typeVar, GeneratedField object, GeneratedField muleContext) {
        GeneratedMethod findOrCreateMethod = messageProcessorClass.method(2, (Type)typeVar, "findOrCreate");
        findOrCreateMethod.javadoc().add((Object)"Obtains the expression manager from the Mule context and initialises the connector. If a target object ");
        findOrCreateMethod.javadoc().add((Object)" has not been set already it will search the Mule registry for a default one.");
        findOrCreateMethod.javadoc().addThrows(this.ref(ConfigurationException.class));
        findOrCreateMethod.javadoc().addThrows(this.ref(RegistrationException.class));
        findOrCreateMethod.javadoc().addThrows(this.ref(InstantiationException.class));
        findOrCreateMethod.javadoc().addThrows(this.ref(IllegalAccessException.class));
        findOrCreateMethod._throws(ConfigurationException.class);
        findOrCreateMethod._throws(RegistrationException.class);
        findOrCreateMethod._throws(InstantiationException.class);
        findOrCreateMethod._throws(IllegalAccessException.class);
        GeneratedVariable moduleClass = findOrCreateMethod.param((Type)this.ref(Class.class), "moduleClass");
        GeneratedVariable shouldAutoCreate = findOrCreateMethod.param((Type)this.ctx().getCodeModel().BOOLEAN, "shouldAutoCreate");
        GeneratedVariable muleEvent = findOrCreateMethod.param((Type)this.ref(MuleEvent.class), "muleEvent");
        GeneratedVariable temporaryObject = findOrCreateMethod.body().decl((Type)this.ref(Object.class), "temporaryObject", (GeneratedExpression)object);
        GeneratedConditional ifNoObject = findOrCreateMethod.body()._if(temporaryObject.isNull());
        ifNoObject._then().assign((AssignmentTarget)temporaryObject, (GeneratedExpression)ExpressionFactory.cast((Type)typeVar, (GeneratedExpression)muleContext.invoke("getRegistry").invoke("lookupObject").arg((GeneratedExpression)moduleClass)));
        GeneratedConditional ifObjectNoFound = ifNoObject._then()._if(temporaryObject.isNull());
        GeneratedConditional ifShouldAutoCreate = ifObjectNoFound._then()._if((GeneratedExpression)shouldAutoCreate);
        ifShouldAutoCreate._then().assign((AssignmentTarget)temporaryObject, (GeneratedExpression)ExpressionFactory.cast((Type)typeVar, (GeneratedExpression)moduleClass.invoke("newInstance")));
        ifShouldAutoCreate._then().add((Statement)muleContext.invoke("getRegistry").invoke("registerObject").arg((GeneratedExpression)moduleClass.invoke("getName")).arg((GeneratedExpression)temporaryObject));
        ifShouldAutoCreate._else()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ConfigurationException.class)).arg((GeneratedExpression)this.ref(MessageFactory.class).staticInvoke("createStaticMessage").arg("Cannot find object")));
        GeneratedConditional ifObjectIsString = findOrCreateMethod.body()._if(Op._instanceof((GeneratedExpression)temporaryObject, (Type)this.ref(String.class)));
        ifObjectIsString._then().assign((AssignmentTarget)temporaryObject, (GeneratedExpression)ExpressionFactory.cast((Type)typeVar, (GeneratedExpression)muleContext.invoke("getExpressionManager").invoke("evaluate").arg((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(String.class), (GeneratedExpression)temporaryObject)).arg((GeneratedExpression)muleEvent).arg(ExpressionFactory.TRUE)));
        ifObjectIsString._then()._if(temporaryObject.isNull())._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ConfigurationException.class)).arg((GeneratedExpression)this.ref(MessageFactory.class).staticInvoke("createStaticMessage").arg("Cannot find object by config name")));
        findOrCreateMethod.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)typeVar, (GeneratedExpression)temporaryObject));
        return findOrCreateMethod;
    }

    private void generateOverwritePayloadMethod(GeneratedClass messageProcessorClass) {
        GeneratedMethod overwritePayload = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "overwritePayload");
        overwritePayload.javadoc().add((Object)"Overwrites the event payload with the specified one");
        overwritePayload._throws(this.ref(Exception.class));
        GeneratedVariable event = overwritePayload.param((Type)this.ref(MuleEvent.class), "event");
        GeneratedVariable resultPayload = overwritePayload.param((Type)this.ref(Object.class), "resultPayload");
        GeneratedInvocation applyTransformers = event.invoke("getMessage").invoke("applyTransformers");
        applyTransformers.arg((GeneratedExpression)event);
        GeneratedInvocation newTransformerTemplate = ExpressionFactory._new((TypeReference)this.ref(TransformerTemplate.class));
        GeneratedVariable overwritePayloadCallback = overwritePayload.body().decl((Type)this.ref(TransformerTemplate.OverwitePayloadCallback.class), "overwritePayloadCallback", ExpressionFactory._null());
        GeneratedConditional ifPayloadIsNull = overwritePayload.body()._if(resultPayload.isNull());
        GeneratedInvocation newOverwritePayloadCallback = ExpressionFactory._new((TypeReference)this.ref(TransformerTemplate.OverwitePayloadCallback.class));
        newOverwritePayloadCallback.arg((GeneratedExpression)resultPayload);
        GeneratedInvocation newOverwritePayloadCallbackWithNull = ExpressionFactory._new((TypeReference)this.ref(TransformerTemplate.OverwitePayloadCallback.class));
        newOverwritePayloadCallbackWithNull.arg((GeneratedExpression)this.ref(NullPayload.class).staticInvoke("getInstance"));
        ifPayloadIsNull._else().assign((AssignmentTarget)overwritePayloadCallback, (GeneratedExpression)newOverwritePayloadCallback);
        ifPayloadIsNull._then().assign((AssignmentTarget)overwritePayloadCallback, (GeneratedExpression)newOverwritePayloadCallbackWithNull);
        newTransformerTemplate.arg((GeneratedExpression)overwritePayloadCallback);
        GeneratedVariable transformerList = overwritePayload.body().decl((Type)this.ref(List.class).narrow(Transformer.class), "transformerList");
        overwritePayload.body().assign((AssignmentTarget)transformerList, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(ArrayList.class).narrow(Transformer.class)));
        overwritePayload.body().add((Statement)transformerList.invoke("add").arg((GeneratedExpression)newTransformerTemplate));
        applyTransformers.arg((GeneratedExpression)transformerList);
        overwritePayload.body().add((Statement)applyTransformers);
    }

    public boolean shouldGenerate(List<Module> module) {
        return false;
    }

    public void generate(List<Module> module) throws GenerationException {
        GeneratedClass abstractMessageProcessorClass = this.getAbstractMessageProcessorClass(module);
        TypeVariable moduleObject = abstractMessageProcessorClass.generify("O");
        GeneratedField object = this.generateFieldForModuleObject(abstractMessageProcessorClass, moduleObject);
        GeneratedField muleContext = abstractMessageProcessorClass.muleContextField();
        GeneratedField flowConstruct = abstractMessageProcessorClass.flowConstructField();
        abstractMessageProcessorClass.setter(object);
        this.generateFindOrCreateMethod(abstractMessageProcessorClass, moduleObject, object, muleContext);
        this.generateOverwritePayloadMethod(abstractMessageProcessorClass);
    }
}

