/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.security.oauth.processor.AbstractDevkitBasedMessageProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractConnectedProcessorGenerator
extends AbstractMuleGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(new Product[0]);
    private static final List<Product> PRODUCES = Arrays.asList(Product.ABSTRACT_CONNECTED_PROCESSOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        if (this.ctx().getProduct(Product.ABSTRACT_CONNECTED_PROCESSOR) != null) {
            return false;
        }
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule) && !(module instanceof OAuthModule)) continue;
            return true;
        }
        return false;
    }

    public void generate(List<Module> modules) throws GenerationException {
        GeneratedClass abstractConnectedProcessorClass = this.getAbstractConnectedProcessorClass(modules.get(0));
        GeneratedMethod constructor = abstractConnectedProcessorClass.constructor(1);
        constructor.param((Type)this.ref(String.class), "operationName");
        constructor.body().directStatement("super(operationName);");
        for (Module module : modules) {
            if (!(module instanceof ManagedConnectionModule)) continue;
            ManagedConnectionModule managedConnectionType = (ManagedConnectionModule)module;
            ConnectMethod connectMethod = managedConnectionType.getConnectMethod();
            Map<String, AbstractMuleGenerator.FieldVariableElement> connectFields = null;
            if (connectMethod != null) {
                connectFields = this.generateFieldForEachParameter(abstractConnectedProcessorClass, (Method)connectMethod);
            }
            if (connectFields == null) continue;
            for (String fieldName : connectFields.keySet()) {
                abstractConnectedProcessorClass.setter(connectFields.get(fieldName).getField());
                abstractConnectedProcessorClass.getter(connectFields.get(fieldName).getField());
            }
        }
    }

    private GeneratedClass getAbstractConnectedProcessorClass(Module type) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".processors");
        GeneratedClass clazz = pkg._class(33, "AbstractConnectedProcessor", this.ref(AbstractDevkitBasedMessageProcessor.class));
        this.ctx().registerProduct(Product.ABSTRACT_CONNECTED_PROCESSOR, (Object)clazz);
        return clazz;
    }
}

