/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import org.mule.api.MuleContext;
import org.mule.api.transformer.DataType;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.TransformerResolverMethod;

public class TransformerResolverAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasTransformerResolver();
    }

    public void verify(Module module) throws AnnotationVerificationException {
        for (TransformerResolverMethod method : module.getTransformerResolverMethods()) {
            if (!method.isStatic()) {
                throw new AnnotationVerificationException((Identifiable)method, "@TransformerResolver must be a static method");
            }
            if (!method.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)method, "@TransformerResolver cannot be applied to a non-public method");
            }
            if (!((Object)method.getReturnType()).toString().equals("org.mule.api.transformer.Transformer")) {
                throw new AnnotationVerificationException((Identifiable)method, "@TransformerResolver must return org.mule.api.transformer.Transformer");
            }
            if (method.getParameters().size() != 3) {
                throw new AnnotationVerificationException((Identifiable)method, "@TransformerResolver must receive exactly 3 arguments.");
            }
            if (((Parameter)method.getParameters().get(0)).asType().inheritsFrom(DataType.class) && ((Parameter)method.getParameters().get(1)).asType().inheritsFrom(DataType.class) && ((Parameter)method.getParameters().get(2)).asType().inheritsFrom(MuleContext.class)) continue;
            throw new AnnotationVerificationException((Identifiable)method, "@TransformerResolver must receive the following parameters: DataType, DataType and MuleContext");
        }
    }
}

