/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class ProcessInterfacesGenerator
implements ModuleGenerator {
    private static final String PROCESS_NAMESPACE = ".process";
    private static final String PROCESS_ADAPTER_INTERFACE_NAME = "ProcessAdapter";
    private static final String PROCESS_CALLBACK_INTERFACE_NAME = "ProcessCallback";
    private static final String PROCESS_INTERCEPTOR_INTERFACE_NAME = "ProcessInterceptor";
    private static final String PROCESS_TEMPLATE_INTERFACE_NAME = "ProcessTemplate";
    protected Context context;

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        try {
            this.generateProcessAdapterInterface(module);
            this.generateProcessCallbackInterface(module);
            this.generateProcessInterceptorInterface(module);
            this.generateProcessTemplateInterface(module);
        }
        catch (ClassAlreadyExistsException classAlreadyExistsException) {
            // empty catch block
        }
    }

    private void generateProcessTemplateInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + PROCESS_NAMESPACE);
        GeneratedClass clazz = pkg._interface(PROCESS_TEMPLATE_INTERFACE_NAME);
        this.ctx().registerProduct(Product.PROCESS_TEMPLATE_INTERFACE, (Object)clazz);
        clazz.javadoc().append((Object)"ProcessTemplate provides a processing context for message processing.\n<p/>\nExamples of processing context can be to provide error handling, transaction state verification,\ntransactional demarcation, connection management, security, etc.\n@param <T> type of the return value of the processing execution");
        clazz.generify("T,O");
        clazz.direct("   public T execute(ProcessCallback<T, O> callback, org.mule.api.processor.MessageProcessor messageProcessor, org.mule.api.MuleEvent event) throws Exception;\n    public T execute(ProcessCallback<T, O> callback, org.mule.api.routing.filter.Filter filter, org.mule.api.MuleMessage message) throws Exception;");
    }

    private void generateProcessInterceptorInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + PROCESS_NAMESPACE);
        GeneratedClass clazz = pkg._interface(PROCESS_INTERCEPTOR_INTERFACE_NAME);
        this.ctx().registerProduct(Product.PROCESS_INTERCEPTOR_INTERFACE, (Object)clazz);
        clazz.generify("T,O");
        clazz.direct("   T execute(ProcessCallback<T, O> callback, O under, org.mule.api.processor.MessageProcessor messageProcessor, org.mule.api.MuleEvent event) throws Exception;\n    T execute(ProcessCallback<T, O> callback, O under, org.mule.api.routing.filter.Filter filter, org.mule.api.MuleMessage message) throws Exception;");
    }

    private void generateProcessCallbackInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + PROCESS_NAMESPACE);
        GeneratedClass clazz = pkg._interface(PROCESS_CALLBACK_INTERFACE_NAME);
        this.ctx().registerProduct(Product.PROCESS_CALLBACK_INTERFACE, (Object)clazz);
        clazz.generify("T,O");
        clazz.javadoc().append((Object)"Callback with logic to execute within a controlled environment provided by {@link ProcessTemplate}\n @param <T> type of the return value of the processing execution");
        clazz.direct("T process(O object) throws Exception;\n\n    java.util.List<Class> getManagedExceptions();\n\n    boolean isProtected();\n");
    }

    private void generateProcessAdapterInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + PROCESS_NAMESPACE);
        GeneratedClass clazz = pkg._interface(PROCESS_ADAPTER_INTERFACE_NAME);
        this.ctx().registerProduct(Product.PROCESS_ADAPTER_INTERFACE, (Object)clazz);
        clazz.generify("O");
        clazz.direct("<T> ProcessTemplate<T, O> getProcessTemplate();");
    }

    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    public List<Product> produces() {
        return Arrays.asList(Product.PROCESS_INTERFACES);
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }
}

