/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transformer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.visitor.ModelVisitor;
import org.mule.devkit.model.visitor.TypeUsageVisitor;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransformerGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Collections.emptyList();
    private static final List<Product> PRODUCES = Arrays.asList(Product.TRANSFORMER, Product.REGISTRY_BOOTSTRAP_ENTRY);
    private static final Class<?>[] IMPLEMENTED_INTERFACES = new Class[]{DiscoverableTransformer.class};
    private static final String DO_TRANSFORM_METHOD_NAME = "doTransform";
    protected GeneratedField weightingField;

    protected abstract String getTransformerClassName();

    protected abstract Class<?> getSourceClass();

    protected abstract Class<?> getDestionationClass();

    protected abstract Map<String, GeneratedField> generateAdditionalFields(GeneratedClass var1);

    protected abstract void doTransformImplementation(GeneratedMethod var1, GeneratedVariable var2, GeneratedVariable var3, Map<String, GeneratedField> var4);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        TypeUsageVisitor visitor = new TypeUsageVisitor(this.getDestionationClass());
        module.accept((ModelVisitor)visitor);
        return visitor.uses();
    }

    public void generate(Module module) {
        GeneratedClass transformerClass = this.getTransformerClass(module);
        this.ctx().note("Generating " + this.getSourceClass().getName() + " to " + this.getDestionationClass().getName() + " transformer as " + transformerClass.fullName());
        Map<String, GeneratedField> additionalFields = this.generateAdditionalFields(transformerClass);
        this.generateConstructor(transformerClass);
        this.generateDoTransform(transformerClass, additionalFields);
        this.weightingField = new FieldBuilder(transformerClass).type((Type)this.ctx().getCodeModel().INT).name("priorityWeighting").initialValue(1).getterAndSetter().build();
    }

    private void generateDoTransform(GeneratedClass generatedClass, Map<String, GeneratedField> additionalFields) {
        GeneratedMethod doTransformMethod = generatedClass.method(2, (Type)this.ref(Object.class), DO_TRANSFORM_METHOD_NAME);
        doTransformMethod._throws(TransformerException.class);
        GeneratedVariable srcParam = doTransformMethod.param((Type)this.ref(Object.class), "src");
        GeneratedVariable encodingParam = doTransformMethod.param((Type)this.ref(this.getSourceClass()), "encoding");
        this.doTransformImplementation(doTransformMethod, srcParam, encodingParam, additionalFields);
    }

    private void generateConstructor(GeneratedClass transformerClass) {
        GeneratedMethod constructor = transformerClass.constructor(1);
        this.registerSourceTypes(constructor);
        this.registerDestinationType(constructor, this.ref(this.getDestionationClass()));
        constructor.body().invoke("setName").arg(transformerClass.name());
    }

    private void registerDestinationType(GeneratedMethod constructor, TypeReference clazz) {
        GeneratedInvocation setReturnClass = constructor.body().invoke("setReturnClass");
        setReturnClass.arg(ExpressionFactory.dotclass((Type)clazz));
    }

    private void registerSourceTypes(GeneratedMethod constructor) {
        GeneratedInvocation registerSourceType = constructor.body().invoke("registerSourceType");
        registerSourceType.arg((GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref(this.getSourceClass()).boxify().dotclass()));
    }

    private GeneratedClass getTransformerClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".transformers");
        GeneratedClass clazz = pkg._class(this.getTransformerClassName(), AbstractTransformer.class, (Class[])IMPLEMENTED_INTERFACES);
        this.ctx().registerProduct(Product.REGISTRY_BOOTSTRAP_ENTRY, (Identifiable)module, this.getTransformerClassName(), (Object)clazz);
        return clazz;
    }
}

