/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.agent.Agent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.registry.Registry;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.util.StringMessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class SplashScreenAgentGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.REGISTRY_BOOTSTRAP, Product.DEVKIT_INTERFACES, Product.BASICS_INTERFACE);
    private static final List<Product> PRODUCES = Arrays.asList(Product.SPLASH_SCREEN_AGENT, Product.REGISTRY_BOOTSTRAP_ENTRY);
    private static final String DESCRIPTION = "Agent implementation to add splash screen information for DevKit extensions at application startup";

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass splashScreenAgent = this.getSplashScreenAgentClass(module);
        this.generateSetNameMethod(splashScreenAgent);
        this.generateGetNameMethod(splashScreenAgent);
        this.generateGetDescriptionMethod(splashScreenAgent);
        GeneratedField extensionsCount = new FieldBuilder(splashScreenAgent).name("extensionsCount").type((Type)this.ctx().getCodeModel().INT).getter().build();
        GeneratedField muleContext = new FieldBuilder(splashScreenAgent).name("muleContext").type(MuleContext.class).getterAndSetter().build();
        GeneratedField loggerField = this.generateLoggerField(splashScreenAgent);
        splashScreenAgent.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        this.generateSplashMethod(splashScreenAgent, muleContext, loggerField, extensionsCount);
        this.generateStartMethod(splashScreenAgent);
        splashScreenAgent.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        splashScreenAgent.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
    }

    private void generateGetDescriptionMethod(GeneratedClass splashScreenAgent) {
        GeneratedMethod getDescription = splashScreenAgent.method(1, (Type)this.ref(String.class), "getDescription");
        getDescription.body()._return(ExpressionFactory.lit((String)"DevKit Extension Information"));
    }

    private void generateGetNameMethod(GeneratedClass splashScreenAgent) {
        GeneratedMethod getName = splashScreenAgent.method(1, (Type)this.ref(String.class), "getName");
        getName.body()._return(ExpressionFactory.lit((String)"DevKitSplashScreenAgent"));
    }

    private void generateSetNameMethod(GeneratedClass splashScreenAgent) {
        GeneratedMethod setName = splashScreenAgent.method(1, (Type)this.ctx().getCodeModel().VOID, "setName");
        setName.param((Type)this.ref(String.class), "name");
        setName.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private void generateStartMethod(GeneratedClass splashScreenAgent) {
        GeneratedMethod startMethod = splashScreenAgent.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        startMethod.body().invoke("splash");
    }

    private void generateSplashMethod(GeneratedClass splashScreenAgent, GeneratedField muleContext, GeneratedField loggerField, GeneratedField devKitExtensionsCount) {
        GeneratedMethod startMethod = splashScreenAgent.method(1, (Type)this.ctx().getCodeModel().VOID, "splash");
        GeneratedBlock startMethodBody = startMethod.body();
        GeneratedVariable registryVariable = startMethodBody.decl((Type)this.ref(Registry.class), "registry", (GeneratedExpression)muleContext.invoke("getRegistry"));
        GeneratedVariable metadataAwaresVariable = startMethodBody.decl((Type)this.ref(Collection.class).narrow((TypeReference)this.ctx().getProduct(Product.METADATA_AWARE_INTERFACE)), "metadataAwares", (GeneratedExpression)registryVariable.invoke("lookupObjects").arg(ExpressionFactory.dotclass((Type)((TypeReference)this.ctx().getProduct(Product.METADATA_AWARE_INTERFACE)))));
        GeneratedVariable metadataAwaresByClassVariable = startMethodBody.decl((Type)this.ref(Map.class).narrow(this.ref(Class.class)).narrow((TypeReference)this.ctx().getProduct(Product.METADATA_AWARE_INTERFACE)), "metadataAwaresByClass", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(HashMap.class).narrow(Class.class).narrow((TypeReference)this.ctx().getProduct(Product.METADATA_AWARE_INTERFACE))));
        GeneratedForEach forEachMetadataAware = startMethodBody.forEach((Type)((TypeReference)this.ctx().getProduct(Product.METADATA_AWARE_INTERFACE)), "connectorMetadata", (GeneratedExpression)metadataAwaresVariable);
        GeneratedBlock forEachLoop = forEachMetadataAware.body();
        forEachLoop.invoke((GeneratedExpression)metadataAwaresByClassVariable, "put").arg((GeneratedExpression)metadataAwaresVariable.invoke("getClass")).arg((GeneratedExpression)forEachMetadataAware.var());
        startMethodBody.assign((AssignmentTarget)devKitExtensionsCount, (GeneratedExpression)metadataAwaresByClassVariable.invoke("size"));
        GeneratedVariable stringBuilderVar = startMethodBody.decl((Type)this.ref(StringBuilder.class), "stringBuilder", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(StringBuilder.class)));
        startMethodBody.invoke((GeneratedExpression)stringBuilderVar, "append").arg(Op.plus((GeneratedExpression)Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"DevKit Extensions ("), (GeneratedExpression)this.ref(Integer.class).staticInvoke("toString").arg((GeneratedExpression)devKitExtensionsCount)), (GeneratedExpression)ExpressionFactory.lit((String)") used in this application \n")));
        GeneratedBlock ifAtLeastOneCloudConnector = startMethodBody._if(Op.gt((GeneratedExpression)devKitExtensionsCount, (GeneratedExpression)ExpressionFactory.lit((int)0)))._then();
        forEachMetadataAware = ifAtLeastOneCloudConnector.forEach((Type)((TypeReference)this.ctx().getProduct(Product.METADATA_AWARE_INTERFACE)), "connectorMetadata", (GeneratedExpression)metadataAwaresByClassVariable.invoke("values"));
        forEachLoop = forEachMetadataAware.body();
        forEachLoop.add((Statement)stringBuilderVar.invoke("append").arg((GeneratedExpression)this.ref(StringUtils.class).staticInvoke("capitalise").arg((GeneratedExpression)forEachMetadataAware.var().invoke("getModuleName"))));
        forEachLoop.add((Statement)stringBuilderVar.invoke("append").arg(" "));
        forEachLoop.add((Statement)stringBuilderVar.invoke("append").arg((GeneratedExpression)forEachMetadataAware.var().invoke("getModuleVersion")));
        forEachLoop.add((Statement)stringBuilderVar.invoke("append").arg(" (DevKit "));
        forEachLoop.add((Statement)stringBuilderVar.invoke("append").arg((GeneratedExpression)forEachMetadataAware.var().invoke("getDevkitVersion")));
        forEachLoop.add((Statement)stringBuilderVar.invoke("append").arg(" Build "));
        forEachLoop.add((Statement)stringBuilderVar.invoke("append").arg((GeneratedExpression)forEachMetadataAware.var().invoke("getDevkitBuild")));
        forEachLoop.add((Statement)stringBuilderVar.invoke("append").arg(")+\n"));
        startMethodBody.add((Statement)loggerField.invoke("info").arg((GeneratedExpression)this.ref(StringMessageUtils.class).staticInvoke("getBoilerPlate").arg((GeneratedExpression)stringBuilderVar.invoke("toString")).arg(ExpressionFactory.lit((char)'+')).arg(ExpressionFactory.lit((int)80))));
    }

    private GeneratedClass getSplashScreenAgentClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".agents");
        GeneratedClass clazz = pkg._class(1, "DefaultSplashScreenAgent", new Class[]{Agent.class, MuleContextAware.class});
        clazz._implements((TypeReference)this.ctx().getProduct(Product.SPLASH_SCREEN_AGENT_INTERFACE));
        clazz.javadoc().add((Object)DESCRIPTION);
        this.ctx().registerProduct(Product.REGISTRY_BOOTSTRAP_ENTRY, (Object)clazz);
        return clazz;
    }
}

