/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionKeyGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Collections.emptyList();
    private static final List<Product> PRODUCES = Arrays.asList(Product.CONNECTION_KEY);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void generate(Module module) throws GenerationException {
        ManagedConnectionModule managedConnectionType = (ManagedConnectionModule)module;
        GeneratedClass connectionKeyClass = this.getConnectionKeyClass(managedConnectionType);
        Map<String, AbstractMuleGenerator.FieldVariableElement> keyFields = this.generateStandardFieldForEachParameter(connectionKeyClass, (Method)managedConnectionType.getConnectMethod());
        this.generateKeyConstructor(managedConnectionType.getConnectMethod(), connectionKeyClass, keyFields);
        for (String fieldName : keyFields.keySet()) {
            connectionKeyClass.setter(keyFields.get(fieldName).getField());
            connectionKeyClass.getter(keyFields.get(fieldName).getField());
        }
        this.generateConnectionKeyHashCodeMethod(managedConnectionType.getConnectMethod(), connectionKeyClass);
        this.generateConnectionKeyEqualsMethod(managedConnectionType.getConnectMethod(), connectionKeyClass);
    }

    private GeneratedClass getConnectionKeyClass(ManagedConnectionModule module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass connectionKey = pkg._class(1, module.getClassName() + "ConnectionKey");
        connectionKey.javadoc().add((Object)"A tuple of connection parameters");
        this.ctx().registerProduct(Product.CONNECTION_KEY, (Identifiable)module, (Object)connectionKey);
        return connectionKey;
    }

    private void generateKeyConstructor(ConnectMethod connectMethod, GeneratedClass connectionKeyClass, Map<String, AbstractMuleGenerator.FieldVariableElement> keyFields) {
        GeneratedMethod keyConstructor = connectionKeyClass.constructor(1);
        for (Parameter variable : connectMethod.getParameters()) {
            String fieldName = variable.getName();
            GeneratedVariable parameter = keyConstructor.param(this.ref(variable.asTypeMirror()), fieldName);
            keyConstructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)keyFields.get(fieldName).getField()), (GeneratedExpression)parameter);
        }
    }

    private void generateConnectionKeyHashCodeMethod(ConnectMethod connectMethod, GeneratedClass connectionKeyClass) {
        GeneratedMethod hashCode = connectionKeyClass.method(1, (Type)this.ctx().getCodeModel().INT, "hashCode");
        GeneratedVariable hash = hashCode.body().decl((Type)this.ctx().getCodeModel().INT, "hash", ExpressionFactory.lit((int)1));
        for (Parameter variable : connectMethod.getParameters()) {
            if (variable.getAnnotation(ConnectionKey.class) == null) continue;
            String fieldName = variable.getName();
            hashCode.body().assign((AssignmentTarget)hash, Op.mul((GeneratedExpression)hash, (GeneratedExpression)ExpressionFactory.lit((int)31)));
            hashCode.body()._if(Op.ne((GeneratedExpression)ExpressionFactory._this().ref(fieldName), (GeneratedExpression)ExpressionFactory._null()))._then().assignPlus((AssignmentTarget)hash, (GeneratedExpression)ExpressionFactory._this().ref(fieldName).invoke("hashCode"));
        }
        hashCode.body()._return((GeneratedExpression)hash);
    }

    private void generateConnectionKeyEqualsMethod(ConnectMethod connectMethod, GeneratedClass connectionKey) {
        GeneratedMethod equals = connectionKey.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "equals");
        GeneratedVariable obj = equals.param((Type)this.ref(Object.class), "obj");
        GeneratedExpression areEqual = Op._instanceof((GeneratedExpression)obj, (Type)connectionKey);
        for (Parameter variable : connectMethod.getParameters()) {
            if (variable.getAnnotation(ConnectionKey.class) == null) continue;
            String fieldName = variable.getName();
            areEqual = Op.cand((GeneratedExpression)Op.cand((GeneratedExpression)areEqual, (GeneratedExpression)ExpressionFactory._this().ref(fieldName).isNotNull()), (GeneratedExpression)ExpressionFactory._this().ref(fieldName).invoke("equals").arg((GeneratedExpression)ExpressionFactory.cast((Type)connectionKey, (GeneratedExpression)obj).ref(fieldName)));
        }
        equals.body()._return(areEqual);
    }
}

