/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.List;
import org.mule.devkit.generation.AbstractCapabilityGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionIdentifierAdapterGenerator
extends AbstractCapabilityGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.PROCESS_ADAPTER, Product.CONNECTION_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(Product.CONNECTION_IDENTIFIER_ADAPTER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void generate(Module module) {
        ManagedConnectionModule managedConnectionType = (ManagedConnectionModule)module;
        GeneratedClass connectionIdentifierAdapterClass = this.getConnectionIdentifierAdapterClass(module);
        connectionIdentifierAdapterClass.javadoc().add((Object)("A <code>" + connectionIdentifierAdapterClass.name() + "</code> is a wrapper around "));
        connectionIdentifierAdapterClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        connectionIdentifierAdapterClass.javadoc().add((Object)" that implements {@link org.mule.devkit.dynamic.api.helper.Connection} interface.");
        this.generateGetConnectionIdentifierMethod(managedConnectionType, connectionIdentifierAdapterClass);
    }

    private void generateGetConnectionIdentifierMethod(ManagedConnectionModule managedConnectionType, GeneratedClass connectionIdentifierAdapterClass) {
        Method connectionIdentifierMethod = managedConnectionType.getConnectionIdentifierMethod();
        GeneratedMethod getConnectionIdentifier = connectionIdentifierAdapterClass.method(1, (Type)this.ref(String.class), "getConnectionIdentifier");
        getConnectionIdentifier.body()._return((GeneratedExpression)ExpressionFactory._super().invoke(connectionIdentifierMethod.getName()));
    }

    private GeneratedClass getConnectionIdentifierAdapterClass(Module module) {
        GeneratedClass processAdapterClass = (GeneratedClass)this.ctx().getProduct(Product.PROCESS_ADAPTER, (Identifiable)module);
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        int modifiers = 1;
        if (module.isAbstract()) {
            modifiers |= 0x20;
        }
        GeneratedClass clazz = pkg._class(modifiers, module.getClassName() + "ConnectionIdentifierAdapter", (TypeReference)processAdapterClass);
        clazz._implements((TypeReference)this.ctx().getProduct(Product.CONNECTION_INTERFACE));
        this.ctx().registerProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module, (Object)clazz);
        return clazz;
    }
}

