/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.lifecycle.Start;
import org.mule.api.annotations.lifecycle.Stop;
import org.mule.devkit.generation.NamingConstants;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleAnnotationVerifier
implements ModuleAnnotationVerifier {
    private static final boolean ALWAYS_VERIFY = true;

    public boolean shouldVerify(Module module) {
        return true;
    }

    public void verify(Module module) throws AnnotationVerificationException {
        this.checkForbiddedMethodNames(module);
        this.check(module, PostConstruct.class);
        this.check(module, Start.class);
        this.check(module, Stop.class);
        this.check(module, PreDestroy.class);
    }

    private void checkForbiddedMethodNames(Module module) throws AnnotationVerificationException {
        List methods = module.getMethods();
        for (Method method : methods) {
            if (method.isPrivate() || !method.getParameters().isEmpty()) continue;
            for (String forbiddenNoArgMethodName : NamingConstants.FORBIDDEN_NO_ARGS_METHOD_NAMES) {
                String methodName;
                if (!forbiddenNoArgMethodName.equals(methodName = method.getName())) continue;
                throw new AnnotationVerificationException((Identifiable)method, "The method name '" + methodName + "' is not valid for a no-arg non-private method");
            }
        }
    }

    private void check(Module module, Class<? extends Annotation> annotation) throws AnnotationVerificationException {
        List methods = module.getMethodsAnnotatedWith(annotation);
        if (methods.isEmpty()) {
            return;
        }
        if (methods.size() > 1) {
            throw new AnnotationVerificationException((Identifiable)module, "Cannot have more than method annotated with " + annotation.getSimpleName());
        }
        Method method = (Method)methods.get(0);
        if (!method.getParameters().isEmpty()) {
            throw new AnnotationVerificationException((Identifiable)module, "A method annotated with " + annotation.getSimpleName() + " cannot receive any paramters");
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            throw new AnnotationVerificationException((Identifiable)module, "A method annotated with " + annotation.getSimpleName() + " can only return void");
        }
        if (method.isStatic()) {
            throw new AnnotationVerificationException((Identifiable)method, "A method annotated with " + annotation.getSimpleName() + " cannot be static");
        }
        if (!method.isPublic()) {
            throw new AnnotationVerificationException((Identifiable)method, "A method annotated with " + annotation.getSimpleName() + " can only be public");
        }
    }
}

