/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.spring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.annotations.Filter;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.Source;
import org.mule.config.spring.parsers.specific.MessageProcessorDefinitionParser;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.FilterMethod;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.SourceMethod;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceHandlerGenerator
extends AbstractMuleGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.BEAN_DEFINITION_PARSER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.NAMESPACE_HANDLER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public void generate(List<Module> modules) {
        Map<String, Module> targetNamespaces = this.getTargetNamespaces(modules);
        for (String targetNamespace : targetNamespaces.keySet()) {
            GeneratedClass namespaceHandlerClass = this.getNamespaceHandlerClass(targetNamespaces.get(targetNamespace));
            GeneratedMethod init = namespaceHandlerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "init");
            init.javadoc().add((Object)"Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. \n@see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)");
            for (Module module : modules) {
                if (!module.getXmlNamespace().equals(targetNamespace)) continue;
                this.registerConfig(init, module);
                this.registerBeanDefinitionParserForEachFilter(module, init);
                this.registerBeanDefinitionParserForEachProcessor(module, init);
                this.registerBeanDefinitionParserForEachSource(module, init);
                this.registerBeanDefinitionParserForEachTransformer(module, init);
            }
        }
    }

    private Map<String, Module> getTargetNamespaces(List<Module> modules) {
        HashMap<String, Module> targetNamespaces = new HashMap<String, Module>();
        for (Module module : modules) {
            if (targetNamespaces.containsKey(module.getXmlNamespace())) continue;
            targetNamespaces.put(module.getXmlNamespace(), module);
        }
        return targetNamespaces;
    }

    private GeneratedClass getNamespaceHandlerClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".config");
        GeneratedClass clazz = pkg._class(NameUtils.camel((String)module.getModuleName()) + "NamespaceHandler", NamespaceHandlerSupport.class);
        clazz.javadoc().add((Object)("Registers bean definitions parsers for handling elements in <code>" + module.getXmlNamespace() + "</code>."));
        this.ctx().registerProduct(Product.NAMESPACE_HANDLER, null, module.getXmlNamespace(), (Object)clazz);
        return clazz;
    }

    private void registerConfig(GeneratedMethod init, Module module) {
        GeneratedClass configBeanDefinitionParser = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, (Identifiable)module, "config");
        init.body().invoke("registerBeanDefinitionParser").arg(module.getConfigElementName()).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)configBeanDefinitionParser));
    }

    private void registerBeanDefinitionParserForEachProcessor(Module module, GeneratedMethod init) {
        if (module instanceof OAuthModule) {
            GeneratedClass authorizeMessageProcessorClass = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, (Identifiable)module, "authorize");
            init.body().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)"authorize")).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)authorizeMessageProcessorClass));
            GeneratedClass unauthorizeMessageProcessorClass = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, (Identifiable)module, "unauthorize");
            init.body().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)"unauthorize")).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)unauthorizeMessageProcessorClass));
        }
        for (ProcessorMethod executableElement : module.getProcessorMethods()) {
            this.registerBeanDefinitionParserForProcessor(init, (Method)executableElement);
        }
    }

    private void registerBeanDefinitionParserForEachSource(Module module, GeneratedMethod init) {
        for (SourceMethod executableElement : module.getSourceMethods()) {
            this.registerBeanDefinitionParserForSource(init, (Method)executableElement);
        }
    }

    private void registerBeanDefinitionParserForEachFilter(Module module, GeneratedMethod init) {
        for (FilterMethod executableElement : module.getFilterMethods()) {
            this.registerBeanDefinitionParserForFilter(init, (Method)executableElement);
        }
    }

    private void registerBeanDefinitionParserForEachTransformer(Module module, GeneratedMethod init) {
        for (TransformerMethod executableElement : module.getTransformerMethods()) {
            GeneratedInvocation registerMuleBeanDefinitionParser = init.body().invoke("registerBeanDefinitionParser");
            registerMuleBeanDefinitionParser.arg(ExpressionFactory.lit((String)NameUtils.uncamel((String)executableElement.getName())));
            String transformerClassName = module.getPackage().getName() + ".transformers" + "." + executableElement.getCapitalizedName() + "Transformer";
            registerMuleBeanDefinitionParser.arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(MessageProcessorDefinitionParser.class)).arg(this.ref(transformerClassName).boxify().dotclass()));
        }
    }

    private void registerBeanDefinitionParserForProcessor(GeneratedMethod init, Method processorMethod) {
        GeneratedClass beanDefinitionParser = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, processorMethod.parent(), processorMethod.getName());
        Processor processor = (Processor)processorMethod.getAnnotation(Processor.class);
        String elementName = processorMethod.getName();
        if (processor.name().length() != 0) {
            elementName = processor.name();
        }
        init.body().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)NameUtils.uncamel((String)elementName))).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)beanDefinitionParser));
    }

    private void registerBeanDefinitionParserForSource(GeneratedMethod init, Method sourceMethod) {
        GeneratedClass beanDefinitionParser = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, sourceMethod.parent(), sourceMethod.getName());
        Source source = (Source)sourceMethod.getAnnotation(Source.class);
        String elementName = sourceMethod.getName();
        if (source.name().length() != 0) {
            elementName = source.name();
        }
        init.body().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)NameUtils.uncamel((String)elementName))).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)beanDefinitionParser));
    }

    private void registerBeanDefinitionParserForFilter(GeneratedMethod init, Method filterMethod) {
        GeneratedClass beanDefinitionParser = (GeneratedClass)this.ctx().getProduct(Product.BEAN_DEFINITION_PARSER, filterMethod.parent(), filterMethod.getName());
        Filter filter = (Filter)filterMethod.getAnnotation(Filter.class);
        String elementName = filterMethod.getName();
        if (filter.name().length() != 0) {
            elementName = filter.name();
        }
        init.body().invoke("registerBeanDefinitionParser").arg(ExpressionFactory.lit((String)NameUtils.uncamel((String)elementName))).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)beanDefinitionParser));
    }
}

