/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transformer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.mule.api.annotations.Transformer;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.TransformerMethod;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformerGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Collections.emptyList();
    private static final List<Product> PRODUCES = Arrays.asList(Product.TRANSFORMER, Product.REGISTRY_BOOTSTRAP_ENTRY);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void generate(Module module) throws GenerationException {
        for (TransformerMethod executableElement : module.getTransformerMethods()) {
            GeneratedClass transformerClass = this.getTransformerClass((Method<? extends Type>)executableElement);
            Transformer transformer = (Transformer)executableElement.getAnnotation(Transformer.class);
            GeneratedField weighting = transformerClass.field(4, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().INT, "weighting", Op.plus((GeneratedExpression)this.ref(DiscoverableTransformer.class).staticRef("DEFAULT_PRIORITY_WEIGHTING"), (GeneratedExpression)ExpressionFactory.lit((int)transformer.priorityWeighting())));
            this.generateConstructor(transformerClass, module, (Method)executableElement);
            this.generateDoTransform(transformerClass, (Method<Type>)executableElement);
            this.generateGetPriorityWeighting(transformerClass, weighting);
            this.generateSetPriorityWeighting(transformerClass, weighting);
        }
    }

    private void generateSetPriorityWeighting(GeneratedClass jaxbTransformerClass, GeneratedField weighting) {
        GeneratedMethod setPriorityWeighting = jaxbTransformerClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().VOID, "setPriorityWeighting");
        GeneratedVariable localWeighting = setPriorityWeighting.param((org.mule.devkit.model.code.Type)this.ctx().getCodeModel().INT, "weighting");
        setPriorityWeighting.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)weighting), (GeneratedExpression)localWeighting);
    }

    private void generateGetPriorityWeighting(GeneratedClass jaxbTransformerClass, GeneratedField weighting) {
        GeneratedMethod getPriorityWeighting = jaxbTransformerClass.method(1, (org.mule.devkit.model.code.Type)this.ctx().getCodeModel().INT, "getPriorityWeighting");
        getPriorityWeighting.body()._return((GeneratedExpression)weighting);
    }

    private void generateDoTransform(GeneratedClass transformerClass, Method<Type> executableElement) {
        GeneratedMethod doTransform = transformerClass.method(2, (org.mule.devkit.model.code.Type)this.ref(Object.class), "doTransform");
        doTransform._throws(TransformerException.class);
        GeneratedVariable src = doTransform.param((org.mule.devkit.model.code.Type)this.ref(Object.class), "src");
        doTransform.param((org.mule.devkit.model.code.Type)this.ref(String.class), "encoding");
        GeneratedVariable result = doTransform.body().decl((org.mule.devkit.model.code.Type)this.ref(executableElement.getReturnType()).boxify(), "result", ExpressionFactory._null());
        GeneratedTry tryBlock = doTransform.body()._try();
        GeneratedInvocation invoke = this.ref(((Type)executableElement.parent()).asTypeMirror()).boxify().staticInvoke(executableElement.getName());
        TypeMirror expectedType = ((Parameter)executableElement.getParameters().get(0)).asTypeMirror();
        invoke.arg((GeneratedExpression)ExpressionFactory.cast((org.mule.devkit.model.code.Type)this.ref(expectedType), (GeneratedExpression)src));
        tryBlock.body().assign((AssignmentTarget)result, (GeneratedExpression)invoke);
        GeneratedCatchBlock exceptionCatch = tryBlock._catch(this.ref(Exception.class));
        GeneratedVariable exception = exceptionCatch.param("exception");
        this.generateThrowTransformFailedException(exceptionCatch, exception, src, this.ref(executableElement.getReturnType()).boxify());
        doTransform.body()._return((GeneratedExpression)result);
    }

    private void generateThrowTransformFailedException(GeneratedCatchBlock catchBlock, GeneratedVariable exception, GeneratedVariable src, TypeReference target) {
        GeneratedInvocation transformFailedInvoke = this.ref(CoreMessages.class).staticInvoke("transformFailed");
        transformFailedInvoke.arg((GeneratedExpression)src.invoke("getClass").invoke("getName"));
        transformFailedInvoke.arg(ExpressionFactory.lit((String)target.fullName()));
        GeneratedInvocation transformerException = ExpressionFactory._new((TypeReference)this.ref(TransformerException.class));
        transformerException.arg((GeneratedExpression)transformFailedInvoke);
        transformerException.arg(ExpressionFactory._this());
        transformerException.arg((GeneratedExpression)exception);
        catchBlock.body()._throw((GeneratedExpression)transformerException);
    }

    private void generateConstructor(GeneratedClass transformerClass, Module moduleClass, Method executableElement) {
        GeneratedMethod constructor = transformerClass.constructor(1);
        this.registerSourceTypes(constructor, executableElement);
        this.registerDestinationType(constructor, moduleClass, (Method<Type>)executableElement);
        constructor.body().invoke("setName").arg(executableElement.getCapitalizedName() + "Transformer");
    }

    private void registerDestinationType(GeneratedMethod constructor, Module moduleClass, Method<Type> executableElement) {
        GeneratedTry tryToFindMethod = constructor.body()._try();
        GeneratedInvocation getMethod = this.ref(moduleClass.asTypeMirror()).boxify().dotclass().invoke("getMethod").arg(executableElement.getName());
        for (Parameter parameter : executableElement.getParameters()) {
            getMethod.arg(this.ref(parameter.asTypeMirror()).boxify().dotclass());
        }
        GeneratedVariable method = tryToFindMethod.body().decl((org.mule.devkit.model.code.Type)this.ref(java.lang.reflect.Method.class), "method", (GeneratedExpression)getMethod);
        GeneratedVariable dataType = tryToFindMethod.body().decl((org.mule.devkit.model.code.Type)this.ref(DataType.class), "dataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("createFromReturnType").arg((GeneratedExpression)method));
        tryToFindMethod.body().invoke("setReturnDataType").arg((GeneratedExpression)dataType);
        GeneratedCatchBlock catchNoSuchMethodException = tryToFindMethod._catch(this.ref(NoSuchMethodException.class));
        catchNoSuchMethodException.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Unable to find method " + executableElement.getName()));
    }

    private void registerSourceTypes(GeneratedMethod constructor, Method executableElement) {
        String transformerAnnotationName = Transformer.class.getName();
        List sourceTypes = null;
        List annotationMirrors = executableElement.getAnnotationMirrors();
        block0: for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!transformerAnnotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"sourceTypes".equals(entry.getKey().getSimpleName().toString())) continue;
                sourceTypes = (List)entry.getValue().getValue();
                continue block0;
            }
        }
        if (sourceTypes != null) {
            for (AnnotationValue sourceType : sourceTypes) {
                GeneratedInvocation registerSourceType = constructor.body().invoke("registerSourceType");
                registerSourceType.arg((GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("create").arg(this.ref((TypeMirror)sourceType.getValue()).boxify().dotclass()));
            }
        }
    }

    public GeneratedClass getTransformerClass(Method<? extends Type> executableElement) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((Type)executableElement.parent()).getPackage().getName() + ".transformers");
        GeneratedClass transformer = pkg._class(executableElement.getCapitalizedName() + "Transformer", AbstractTransformer.class, new Class[]{DiscoverableTransformer.class});
        this.ctx().registerProduct(Product.REGISTRY_BOOTSTRAP_ENTRY, executableElement.parent(), executableElement.getName(), (Object)transformer);
        return transformer;
    }
}

