/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.api.annotations.Mime;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.NoMetaData;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.callback.HttpCallback;
import org.mule.api.callback.SourceCallback;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transport.PropertyScope;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultListMetaDataModel;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultParameterizedMapMetaDataModel;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.MessageConstants;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.utils.NameUtils;
import org.mule.devkit.model.GenericType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedArray;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedForEach;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorGenerator
extends AbstractMuleGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.INJECTION_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.HTTP_CALLBACK_ADAPTER, Product.OAUTH_ADAPTER, Product.CONNECTION_KEY, Product.NESTED_PROCESSOR_CHAIN, Product.POOL_MANAGER, Product.CONNECTION_MANAGER, Product.ABSTRACT_LISTENING_MESSAGE_PROCESSOR, Product.ABSTRACT_CONNECTED_PROCESSOR, Product.PROCESS_INTERFACES, Product.HTTP_CALLBACK_ADAPTER_INTERFACE, Product.BASICS_INTERFACE);
    private static final List<Product> PRODUCES = Arrays.asList(Product.MESSAGE_PROCESSOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(org.mule.devkit.model.module.Module module) {
        return module.hasProcessors() && (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC);
    }

    public void generate(org.mule.devkit.model.module.Module module) {
        for (ProcessorMethod processorMethod : module.getProcessorMethods()) {
            this.generateMessageProcessor(module, processorMethod);
        }
    }

    private void generateMessageProcessor(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod) {
        if (this.ctx().getProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName()) != null) {
            return;
        }
        GeneratedClass messageProcessorClass = processorMethod.isIntercepting() ? this.getInterceptingMessageProcessorClass(module, processorMethod) : this.getMessageProcessorClass(module, processorMethod);
        this.ctx().note("Generating message processor as " + messageProcessorClass.fullName() + " for method " + processorMethod.getName() + " in " + module.getName());
        this.generateMessageProcessorClassDoc(processorMethod, messageProcessorClass);
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateFieldForEachParameter(messageProcessorClass, (Method)processorMethod);
        this.generateInitialiseMethod(messageProcessorClass, fields, module);
        this.generateStartMethod(messageProcessorClass, fields);
        this.generateStopMethod(messageProcessorClass, fields);
        this.generateDiposeMethod(messageProcessorClass, fields);
        this.generateSetMuleContextMethod(messageProcessorClass, fields);
        this.generateSetFlowConstructMethod(messageProcessorClass, fields);
        for (String fieldName : fields.keySet()) {
            messageProcessorClass.setter(fields.get(fieldName).getField());
        }
        if (module.usesPooling()) {
            GeneratedClass poolObjectClass = ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass();
            this.generateProcessMethod(processorMethod, messageProcessorClass, fields, poolObjectClass);
        } else {
            this.generateProcessMethod(processorMethod, messageProcessorClass, fields);
        }
        if (module.getMinMuleVersion().atLeastBase("3.4") && this.isMetaDataEnabled(processorMethod, module)) {
            this.generateInputMetadata(module, processorMethod, messageProcessorClass);
            this.generateOutputMetadata(module, processorMethod, messageProcessorClass);
            this.generateGetPojoOrSimpleModel(module, processorMethod, messageProcessorClass);
        }
    }

    private boolean isMetaDataEnabled(ProcessorMethod processorMethod, org.mule.devkit.model.module.Module module) {
        return processorMethod.getAnnotation(NoMetaData.class) == null && (module.isConnector() && !MetaDataSwitch.OFF.equals((Object)((Connector)module.getAnnotation(Connector.class)).metaData()) || module.isModule() && !MetaDataSwitch.OFF.equals((Object)((Module)module.getAnnotation(Module.class)).metaData()));
    }

    private void generateOutputMetadata(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getOutputMetadata = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "getOutputMetaData");
        getOutputMetadata.param((Type)this.ref(MetaData.class), "inputMetadata");
        getOutputMetadata.annotate(Override.class);
        GenericType outputGeneric = processorMethod.getReturnGenericType();
        Parameter key = processorMethod.getMetaDataKeyParameter();
        if (processorMethod.hasDynamicOutputMetaData()) {
            this.generateMetaDataByKeyMethod(key, outputGeneric, module, getOutputMetadata, processorMethod);
        } else if (outputGeneric != null) {
            this.generateMetaDataImplicitMethod(outputGeneric, module, getOutputMetadata, processorMethod);
        } else {
            this.generateNullMetaDataMethod(getOutputMetadata);
        }
    }

    private void generateInputMetadata(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getInputMetadata = messageProcessorClass.method(1, (Type)this.ref(Result.class).narrow(MetaData.class), "getInputMetaData");
        getInputMetadata.annotate(Override.class);
        if (processorMethod.hasDynamicInputMetadata()) {
            Parameter key = processorMethod.getMetaDataKeyParameter();
            Parameter input = processorMethod.getPayloadParameter();
            this.generateMetaDataByKeyMethod(key, input.getGenericType(), module, getInputMetadata, processorMethod);
        } else if (processorMethod.getPayloadParameter() != null) {
            this.generateMetaDataImplicitMethod(processorMethod.getPayloadParameter().getGenericType(), module, getInputMetadata, processorMethod);
        } else {
            this.generateNullMetaDataMethod(getInputMetadata);
        }
    }

    private void generateGetPojoOrSimpleModel(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod, GeneratedClass messageProcessorClass) {
        GeneratedMethod getPojoOrSimpleModel = messageProcessorClass.method(4, (Type)this.ref(MetaDataModel.class), "getPojoOrSimpleModel");
        GeneratedVariable clazz = getPojoOrSimpleModel.param((Type)this.ref(Class.class), "clazz");
        GeneratedVariable dataType = getPojoOrSimpleModel.body().decl((Type)this.ref(DataType.class), "dataType", (GeneratedExpression)this.ref(DataTypeFactory.class).staticInvoke("getInstance").invoke("getDataType").arg((GeneratedExpression)clazz));
        GeneratedConditional conditional = getPojoOrSimpleModel.body()._if((GeneratedExpression)this.ref(DataType.class).staticRef("POJO").invoke("equals").arg((GeneratedExpression)dataType));
        conditional._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultPojoMetaDataModel.class)).arg((GeneratedExpression)clazz));
        conditional._else()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultSimpleMetaDataModel.class)).arg((GeneratedExpression)dataType));
    }

    private void generateNullMetaDataMethod(GeneratedMethod method) {
        method.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(MetaData.class))).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.SUCCESS")));
    }

    private void generateMetaDataImplicitMethod(GenericType type, org.mule.devkit.model.module.Module module, GeneratedMethod method, ProcessorMethod processorMethod) {
        GeneratedInvocation defaultResultMetaData = ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaData.class)).arg(this.foldMetaData(type, processorMethod)));
        method.body()._return((GeneratedExpression)defaultResultMetaData);
    }

    private GeneratedExpression foldMetaData(GenericType type, ProcessorMethod processorMethod) {
        return this.foldMetaData(type, null, processorMethod);
    }

    private void generateMetaDataByKeyMethod(Parameter key, GenericType type, org.mule.devkit.model.module.Module module, GeneratedMethod method, ProcessorMethod processorMethod) {
        method.body()._if(Op.cor((GeneratedExpression)Op.eq((GeneratedExpression)ExpressionFactory.direct((String)key.getName()), (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)Op.eq((GeneratedExpression)ExpressionFactory.direct((String)key.getName()).invoke("toString"), (GeneratedExpression)ExpressionFactory._null())))._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.typeIsNull(module.getName(), processorMethod.getName(), key.getName())));
        GeneratedVariable metaDataKey = method.body().decl((Type)this.ref(MetaDataKey.class), "metaDataKey", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaDataKey.class)).arg((GeneratedExpression)ExpressionFactory.direct((String)key.getName()).invoke("toString")).arg(ExpressionFactory._null()));
        GeneratedVariable connector = method.body().decl((Type)this.ref(ConnectorMetaDataEnabled.class), "connector");
        GeneratedTry generatedTry = method.body()._try();
        if (module instanceof ManagedConnectionModule) {
            generatedTry.body().assign((AssignmentTarget)connector, (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectorMetaDataEnabled.class), (GeneratedExpression)ExpressionFactory.invoke((String)"findOrCreate").arg(this.getConnectionManager(processorMethod).dotclass()).arg(ExpressionFactory.TRUE).arg(ExpressionFactory._null())));
        } else if (module.isModule()) {
            generatedTry.body().assign((AssignmentTarget)connector, (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectorMetaDataEnabled.class), (GeneratedExpression)ExpressionFactory.invoke((String)"findOrCreate").arg(this.ref((org.mule.devkit.model.Type)module).dotclass()).arg(ExpressionFactory.TRUE).arg(ExpressionFactory._null())));
        }
        GeneratedTry metadataTry = generatedTry.body()._try();
        GeneratedVariable metadata = metadataTry.body().decl((Type)this.ref(Result.class).narrow(MetaData.class), "metadata", (GeneratedExpression)connector.invoke("getMetaData").arg((GeneratedExpression)metaDataKey));
        metadataTry.body()._if((GeneratedExpression)ExpressionFactory.direct((String)"Result.Status.FAILURE").invoke("equals").arg((GeneratedExpression)metadata.invoke("getStatus")))._then()._return((GeneratedExpression)metadata);
        metadataTry.body()._if(Op.eq((GeneratedExpression)metadata.invoke("get"), (GeneratedExpression)ExpressionFactory._null()))._then()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.metaDataGetNull(module.getName(), processorMethod.getName())));
        GeneratedCatchBlock metadataCatch = metadataTry._catch(this.ref(Exception.class));
        GeneratedVariable e1 = metadataCatch.param("e");
        metadataCatch.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e1.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e1));
        GeneratedInvocation defaultResultMetaData = ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultMetaData.class)).arg(this.foldMetaData(type, metadata, processorMethod)));
        metadataTry.body()._return((GeneratedExpression)defaultResultMetaData);
        GeneratedCatchBlock classCastExeption = generatedTry._catch(this.ref(ClassCastException.class));
        classCastExeption.param("cast");
        classCastExeption.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.noConnectionManagerAvaiableMaybeOauth()));
        GeneratedCatchBlock configException = generatedTry._catch(this.ref(ConfigurationException.class));
        GeneratedVariable e = configException.param("e");
        configException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock registrationException = generatedTry._catch(this.ref(RegistrationException.class));
        registrationException.param("e");
        registrationException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock illegalAccessException = generatedTry._catch(this.ref(IllegalAccessException.class));
        illegalAccessException.param("e");
        illegalAccessException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock instantiationException = generatedTry._catch(this.ref(InstantiationException.class));
        instantiationException.param("e");
        instantiationException.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
        GeneratedCatchBlock exception = generatedTry._catch(this.ref(Exception.class));
        exception.param("e");
        exception.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)e));
    }

    private GeneratedClass getConnectionManager(ProcessorMethod processorMethod) {
        if (processorMethod.canBeUsedInConnectionManagement()) {
            return (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_MANAGER, (Identifiable)processorMethod.getManagedConnectionModule());
        }
        throw new RuntimeException();
    }

    private GeneratedExpression foldMetaData(GenericType type, GeneratedVariable metadata, ProcessorMethod processorMethod) {
        if (type.isCollection()) {
            return ExpressionFactory._new((TypeReference)this.ref(DefaultListMetaDataModel.class)).arg(this.foldMetaData((GenericType)type.getGenericTypeArguments().get(0), metadata, processorMethod));
        }
        if (type.isMetaData() && metadata != null) {
            return metadata.invoke("get").invoke("getPayload");
        }
        if (type.isMap()) {
            return ExpressionFactory._new((TypeReference)this.ref(DefaultParameterizedMapMetaDataModel.class)).arg(this.foldMetaData((GenericType)type.getGenericTypeArguments().get(0), metadata, processorMethod)).arg(this.foldMetaData((GenericType)type.getGenericTypeArguments().get(1), metadata, processorMethod));
        }
        if (type.getType() != null) {
            if (!type.getGenericTypeArguments().isEmpty()) {
                this.ctx().warn(MessageConstants.typeDoesntSupportMetaData(type, processorMethod));
            }
            DataTypeFactory.getInstance().getDataType(type.getType().getKind().getDeclaringClass());
            return ExpressionFactory.invoke((String)"getPojoOrSimpleModel").arg(this.ref(type.getType()).dotclass());
        }
        this.ctx().error(MessageConstants.errorGeneratingMetaData(processorMethod));
        return ExpressionFactory._null();
    }

    private void generateMessageProcessorClassDoc(ProcessorMethod executableElement, GeneratedClass messageProcessorClass) {
        messageProcessorClass.javadoc().add((Object)(messageProcessorClass.name() + " invokes the "));
        messageProcessorClass.javadoc().add((Object)("{@link " + ((org.mule.devkit.model.Type)executableElement.parent()).getQualifiedName().toString() + "#"));
        messageProcessorClass.javadoc().add((Object)(executableElement.getName() + "("));
        boolean first = true;
        for (Parameter variable : executableElement.getParameters()) {
            if (!first) {
                messageProcessorClass.javadoc().add((Object)", ");
            }
            messageProcessorClass.javadoc().add((Object)((Object)variable.asTypeMirror()).toString().replaceAll("<[a-zA-Z\\-\\.\\<\\>\\s\\,]*>", ""));
            first = false;
        }
        messageProcessorClass.javadoc().add((Object)")} method in ");
        messageProcessorClass.javadoc().add((Object)this.ref(((org.mule.devkit.model.Type)executableElement.parent()).asTypeMirror()));
        messageProcessorClass.javadoc().add((Object)". For each argument there is a field in this processor to match it. ");
        messageProcessorClass.javadoc().add((Object)" Before invoking the actual method the processor will evaluate and transform");
        messageProcessorClass.javadoc().add((Object)" where possible to the expected argument type.");
    }

    private void generateProcessMethod(ProcessorMethod processorMethod, GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        this.generateProcessMethod(processorMethod, messageProcessorClass, fields, null);
    }

    private void generateProcessMethod(ProcessorMethod processorMethod, GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields, GeneratedClass poolObjectClass) {
        GeneratedInvocation findOrCreate;
        String methodName = processorMethod.getName();
        TypeReference muleEvent = this.ref(MuleEvent.class);
        boolean injectParameters = processorMethod.getAnnotation(Inject.class) != null;
        GeneratedMethod process = messageProcessorClass.method(1, (Type)muleEvent, "process");
        process.javadoc().add((Object)"Invokes the MessageProcessor.");
        process.javadoc().addParam("event MuleEvent to be processed");
        process.javadoc().addThrows(this.ref(MuleException.class));
        process._throws(MuleException.class);
        GeneratedVariable event = null;
        event = process.param(8, (Type)muleEvent, "event");
        GeneratedVariable sourceCallback = null;
        if (processorMethod.isIntercepting()) {
            sourceCallback = process.body().decl(8, (Type)this.ref(SourceCallback.class), "sourceCallback", ExpressionFactory._this());
        }
        GeneratedVariable poolObject = this.declarePoolObjectIfClassNotNull(poolObjectClass, process);
        GeneratedVariable moduleObject = process.body().decl((Type)this.ref(Object.class), "moduleObject", ExpressionFactory._null());
        GeneratedTry callProcessor = process.body()._try();
        if (this.getModuleObject((org.mule.devkit.model.Type)processorMethod.parent()) != null) {
            findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(this.getModuleObject((org.mule.devkit.model.Type)processorMethod.parent()).dotclass());
            if (processorMethod.parent() instanceof org.mule.devkit.model.module.Module && ((org.mule.devkit.model.module.Module)processorMethod.parent()).needsConfig()) {
                findOrCreate.arg(ExpressionFactory.FALSE);
            } else {
                findOrCreate.arg(ExpressionFactory.TRUE);
            }
            findOrCreate.arg((GeneratedExpression)event);
            callProcessor.body().assign((AssignmentTarget)moduleObject, (GeneratedExpression)findOrCreate);
        } else {
            findOrCreate = ExpressionFactory.invoke((String)"findOrCreate").arg(((TypeReference)this.ctx().getProduct(Product.PROCESS_ADAPTER_INTERFACE)).dotclass());
            findOrCreate.arg(ExpressionFactory.FALSE);
            findOrCreate.arg((GeneratedExpression)event);
            callProcessor.body().assign((AssignmentTarget)moduleObject, (GeneratedExpression)findOrCreate);
        }
        for (String fieldName : fields.keySet()) {
            AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
            if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
            GeneratedField callbackFlowName = fields.get(fieldName).getField();
            GeneratedBlock ifCallbackFlowNameIsNull = callProcessor.body()._if(Op.cand((GeneratedExpression)callbackFlowName.isNotNull(), (GeneratedExpression)variableElement.getFieldType().isNull()))._then();
            GeneratedVariable castedModuleObject = ifCallbackFlowNameIsNull.decl((Type)((TypeReference)this.ctx().getProduct(Product.HTTP_CALLBACK_ADAPTER_INTERFACE)), "castedModuleObject", (GeneratedExpression)ExpressionFactory.cast((Type)((TypeReference)this.ctx().getProduct(Product.HTTP_CALLBACK_ADAPTER_INTERFACE)), (GeneratedExpression)moduleObject));
            GeneratedInvocation domain = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"domain"));
            GeneratedInvocation localPort = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"localPort"));
            GeneratedInvocation remotePort = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"remotePort"));
            GeneratedInvocation async = castedModuleObject.invoke("get" + StringUtils.capitalize((String)"async"));
            ifCallbackFlowNameIsNull.assign((AssignmentTarget)variableElement.getFieldType(), (GeneratedExpression)ExpressionFactory._new((TypeReference)((TypeReference)this.ctx().getProduct(Product.DEFAULT_HTTP_CALLBACK))).arg((GeneratedExpression)callbackFlowName).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext")).arg((GeneratedExpression)domain).arg((GeneratedExpression)localPort).arg((GeneratedExpression)remotePort).arg((GeneratedExpression)async));
            ifCallbackFlowNameIsNull.add((Statement)variableElement.getFieldType().invoke("start"));
        }
        ArrayList<GeneratedExpression> parameters = new ArrayList<GeneratedExpression>();
        GeneratedVariable interceptCallback = null;
        GeneratedVariable outboundHeadersMap = null;
        for (Parameter variable : processorMethod.getParameters()) {
            String fieldName = variable.getName();
            if (((Object)variable.asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) {
                parameters.add((GeneratedExpression)fields.get(fieldName).getFieldType());
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(SourceCallback.class.getName())) {
                parameters.add((GeneratedExpression)sourceCallback);
                continue;
            }
            if (variable.asType().isNestedProcessor() || variable.asType().isArrayOrList() && variable.getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variable.getTypeArguments().get(0)).isNestedProcessor()) {
                parameters.add((GeneratedExpression)this.declareNestedProcessorParameter((GeneratedExpression)fields.get(fieldName).getField(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"), event, callProcessor.body(), variable.asType().isArrayOrList(), fieldName));
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(MuleMessage.class.getName()) && injectParameters) {
                parameters.add((GeneratedExpression)event.invoke("getMessage"));
                continue;
            }
            if (((Object)variable.asTypeMirror()).toString().startsWith(MuleEvent.class.getName()) && injectParameters) {
                parameters.add((GeneratedExpression)event);
                continue;
            }
            outboundHeadersMap = this.declareStandardParameter((Variable)variable, messageProcessorClass, event, callProcessor, parameters, outboundHeadersMap);
            GeneratedExpression lastTrasformedVariable = (GeneratedExpression)parameters.get(parameters.size() - 1);
            if (variable.asType().isString() && variable.hasSizeLimit()) {
                this.restrictSize(callProcessor, methodName, lastTrasformedVariable, event, "length", (Variable)variable);
            } else if (variable.hasSizeLimit()) {
                this.restrictSize(callProcessor, methodName, lastTrasformedVariable, event, "size", (Variable)variable);
            }
            if (!variable.asType().isString() || !variable.hasPattern() && !variable.hasEmailPattern()) continue;
            this.restrictPattern(callProcessor, methodName, lastTrasformedVariable, event, "matches", variable);
        }
        Type returnType = this.ref(processorMethod.getReturnType());
        GeneratedVariable resultPayload = this.generateMethodCall(processorMethod, callProcessor.body(), methodName, parameters, event, returnType, interceptCallback, (org.mule.devkit.model.Type)processorMethod.parent(), moduleObject);
        for (Parameter variable : processorMethod.getParameters()) {
            OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
            if (outboundHeaders == null) continue;
            GeneratedConditional ifNotEmpty = callProcessor.body()._if(Op.cand((GeneratedExpression)outboundHeadersMap.isNotNull(), (GeneratedExpression)Op.not((GeneratedExpression)outboundHeadersMap.invoke("isEmpty"))));
            if (this.isMuleEvent(returnType)) {
                ifNotEmpty._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)resultPayload).invoke("getMessage").invoke("addProperties").arg((GeneratedExpression)outboundHeadersMap).arg((GeneratedExpression)this.ref(PropertyScope.class).staticRef("OUTBOUND")));
                continue;
            }
            ifNotEmpty._then().add((Statement)event.invoke("getMessage").invoke("addProperties").arg((GeneratedExpression)outboundHeadersMap).arg((GeneratedExpression)this.ref(PropertyScope.class).staticRef("OUTBOUND")));
        }
        if (processorMethod.getAnnotation(Mime.class) != null) {
            GeneratedInvocation invocation = this.isMuleEvent(returnType) ? ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)resultPayload).invoke("getMessage") : event.invoke("getMessage");
            GeneratedCast defaultMuleMessage = ExpressionFactory.cast((Type)this.ref(DefaultMuleMessage.class), (GeneratedExpression)invocation);
            GeneratedInvocation setMimeType = defaultMuleMessage.invoke("setMimeType").arg(ExpressionFactory.lit((String)((Mime)processorMethod.getAnnotation(Mime.class)).value()));
            callProcessor.body().add((Statement)setMimeType);
        }
        if (this.isMuleEvent(returnType)) {
            callProcessor.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(MuleEvent.class), (GeneratedExpression)resultPayload));
        } else {
            callProcessor.body()._return((GeneratedExpression)event);
        }
        GeneratedCatchBlock catchMessagingException = callProcessor._catch(this.ref(MessagingException.class));
        GeneratedVariable messagingException = catchMessagingException.param("messagingException");
        catchMessagingException.body().invoke((GeneratedExpression)messagingException, "setProcessedEvent").arg((GeneratedExpression)event);
        catchMessagingException.body()._throw((GeneratedExpression)messagingException);
        this.generateThrow("failedToInvoke", MessagingException.class, callProcessor._catch(this.ref(Exception.class)), (GeneratedExpression)event, methodName);
        if (poolObjectClass != null) {
            GeneratedBlock fin = callProcessor._finally();
            GeneratedBlock poolObjectNotNull = fin._if(poolObject.isNotNull())._then();
            poolObjectNotNull.add((Statement)ExpressionFactory.cast((Type)((TypeReference)this.ctx().getProduct(Product.POOL_MANAGER_INTERFACE)), (GeneratedExpression)moduleObject).invoke("getLifecyleEnabledObjectPool").invoke("returnObject").arg((GeneratedExpression)poolObject));
        }
    }

    private void restrictPattern(GeneratedTry callProcessor, String methodName, GeneratedExpression trasformedVariable, GeneratedVariable event, String matches, Parameter variable) {
        GeneratedExpression optional = variable.isOptional() ? Op.ne((GeneratedExpression)trasformedVariable, (GeneratedExpression)ExpressionFactory._null()) : ExpressionFactory.TRUE;
        GeneratedConditional conditional = callProcessor.body()._if(Op.cand((GeneratedExpression)optional, (GeneratedExpression)Op.not((GeneratedExpression)trasformedVariable.invoke(matches).arg(variable.getPattern()))));
        this.generateThrow("createStaticMessage", MessagingException.class, conditional._then(), (GeneratedExpression)event, "Pattern doesn't match on attribute:" + variable.getName() + MessageConstants.AT_PROCESSOR + NameUtils.uncamel((String)methodName));
    }

    private void restrictSize(GeneratedTry callProcessor, String methodName, GeneratedExpression transformedParameter, GeneratedVariable event, String sizeMethod, Variable variable) {
        GeneratedExpression optional = variable.isOptional() ? Op.ne((GeneratedExpression)transformedParameter, (GeneratedExpression)ExpressionFactory._null()) : ExpressionFactory.TRUE;
        GeneratedConditional conditional = callProcessor.body()._if(Op.cand((GeneratedExpression)optional, (GeneratedExpression)Op.cor((GeneratedExpression)Op.lt((GeneratedExpression)transformedParameter.invoke(sizeMethod), (GeneratedExpression)ExpressionFactory.lit((int)variable.getMinSizeLimit())), (GeneratedExpression)Op.lt((GeneratedExpression)ExpressionFactory.lit((int)variable.getMaxSizeLimit()), (GeneratedExpression)transformedParameter.invoke(sizeMethod)))));
        this.generateThrow("createStaticMessage", MessagingException.class, conditional._then(), (GeneratedExpression)event, MessageConstants.LIMITED_SIZE_EXCEEDED + variable.getName() + MessageConstants.AT_PROCESSOR + NameUtils.uncamel((String)methodName));
    }

    private GeneratedVariable declareStandardParameter(Variable variable, GeneratedClass messageProcessorClass, GeneratedVariable muleEvent, GeneratedTry callProcessor, List<GeneratedExpression> parameters, GeneratedVariable outboundHeadersMap) {
        OutboundHeaders outboundHeaders = (OutboundHeaders)variable.getAnnotation(OutboundHeaders.class);
        if (outboundHeaders == null) {
            GeneratedVariable transformed = this.declareTransformedVariable(variable, (GeneratedExpression)ExpressionFactory.ref((String)variable.getName()), (Type)messageProcessorClass, muleEvent, callProcessor.body(), (GeneratedExpression)ExpressionFactory.invoke((String)"getMuleContext"));
            parameters.add((GeneratedExpression)transformed);
        } else {
            TypeReference type = this.ref(HashMap.class).narrow(new TypeReference[]{this.ref(String.class), this.ref(Object.class)});
            String name = "_transformed" + StringUtils.capitalize((String)variable.getName());
            outboundHeadersMap = callProcessor.body().decl(8, (Type)type, name, (GeneratedExpression)ExpressionFactory._new((Type)type));
            parameters.add((GeneratedExpression)outboundHeadersMap);
        }
        return outboundHeadersMap;
    }

    private GeneratedVariable declarePoolObjectIfClassNotNull(GeneratedClass poolObjectClass, GeneratedMethod process) {
        if (poolObjectClass != null) {
            return process.body().decl((Type)poolObjectClass, "_poolObject", ExpressionFactory._null());
        }
        return null;
    }

    private GeneratedVariable generateMethodCall(ProcessorMethod executableElement, GeneratedBlock body, String methodName, List<GeneratedExpression> parameters, GeneratedVariable event, Type returnType, GeneratedVariable interceptCallback, org.mule.devkit.model.Type module, GeneratedVariable moduleObject) {
        GeneratedVariable resultPayload = null;
        if (returnType != this.ctx().getCodeModel().VOID) {
            resultPayload = body.decl((Type)this.ref(Object.class), "resultPayload");
        }
        GeneratedVariable processTemplate = body.decl((Type)((TypeReference)this.ctx().getProduct(Product.PROCESS_TEMPLATE_INTERFACE)).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)), "processTemplate", (GeneratedExpression)ExpressionFactory.cast((Type)((TypeReference)this.ctx().getProduct(Product.PROCESS_ADAPTER_INTERFACE)).narrow(this.ref(Object.class)), (GeneratedExpression)moduleObject).invoke("getProcessTemplate"));
        GeneratedClass executionCallback = this.ctx().getCodeModel().anonymousClass(((TypeReference)this.ctx().getProduct(Product.PROCESS_CALLBACK_INTERFACE)).narrow(this.ref(Object.class)).narrow(this.ref(Object.class)));
        GeneratedMethod getManagedExceptions = executionCallback.method(1, (Type)this.ref(List.class).narrow(Class.class), "getManagedExceptions");
        if (executableElement.invalidateConnectionOn() != null || executableElement.invalidateAccessTokenOn() != null) {
            GeneratedArray newExceptionArray = ExpressionFactory.newArray((Type)this.ref(Class.class));
            if (executableElement.invalidateConnectionOn() != null) {
                newExceptionArray.add(this.ref(executableElement.invalidateConnectionOn()).boxify().dotclass());
            } else if (executableElement.invalidateAccessTokenOn() != null) {
                newExceptionArray.add(this.ref(executableElement.invalidateAccessTokenOn()).boxify().dotclass());
            }
            getManagedExceptions.body()._return((GeneratedExpression)this.ref(Arrays.class).staticInvoke("asList").arg((GeneratedExpression)newExceptionArray));
        } else {
            getManagedExceptions.body()._return(ExpressionFactory._null());
        }
        GeneratedMethod isProtected = executionCallback.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isProtected");
        if (executableElement.isOAuthProtected()) {
            isProtected.body()._return(ExpressionFactory.TRUE);
        } else {
            isProtected.body()._return(ExpressionFactory.FALSE);
        }
        GeneratedMethod process = executionCallback.method(1, (Type)this.ref(Object.class), "process");
        GeneratedVariable object2 = process.param((Type)this.ref(Object.class), "object");
        process._throws(this.ref(Exception.class));
        GeneratedInvocation methodCall = ExpressionFactory.cast((Type)this.ref(module), (GeneratedExpression)object2).invoke(methodName);
        for (GeneratedExpression parameter : parameters) {
            methodCall.arg(parameter);
        }
        if (returnType != this.ctx().getCodeModel().VOID) {
            process.body()._return((GeneratedExpression)methodCall);
            body.assign((AssignmentTarget)resultPayload, (GeneratedExpression)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        } else {
            process.body().add((Statement)methodCall);
            process.body()._return(ExpressionFactory._null());
            body.add((Statement)processTemplate.invoke("execute").arg((GeneratedExpression)ExpressionFactory._new((TypeReference)executionCallback)).arg(ExpressionFactory._this()).arg((GeneratedExpression)event));
        }
        GeneratedBlock scope = body;
        if (interceptCallback != null) {
            GeneratedConditional shallContinue = body._if(Op.cand((GeneratedExpression)interceptCallback.invoke("getShallContinue"), (GeneratedExpression)ExpressionFactory.invoke((String)"getListener").isNotNull()));
            shallContinue._then().assign((AssignmentTarget)event, (GeneratedExpression)ExpressionFactory.invoke((String)"getListener").invoke("process").arg((GeneratedExpression)event));
            scope = shallContinue._else();
        }
        if (returnType != this.ctx().getCodeModel().VOID && !this.isMuleEvent(returnType)) {
            scope.invoke("overwritePayload").arg((GeneratedExpression)event).arg((GeneratedExpression)resultPayload);
        }
        return resultPayload;
    }

    private GeneratedClass getMessageProcessorClass(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)processorMethod.parent()).getPackage().getName() + ".processors");
        GeneratedClass abstractMessageProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_MESSAGE_PROCESSOR);
        GeneratedClass clazz = pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", abstractMessageProcessor.narrow(this.ref(Object.class)), new Class[]{MessageProcessor.class, Initialisable.class, Startable.class, Disposable.class, Stoppable.class});
        if (module.getMinMuleVersion().atLeastBase("3.4") && this.isMetaDataEnabled(processorMethod, module)) {
            clazz._implements(OperationMetaDataEnabled.class);
        }
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName(), (Object)clazz);
        return clazz;
    }

    private GeneratedClass getInterceptingMessageProcessorClass(org.mule.devkit.model.module.Module module, ProcessorMethod processorMethod) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(((org.mule.devkit.model.Type)processorMethod.parent()).getPackage().getName() + ".processors");
        GeneratedClass abstractListeningMessageProcessor = (GeneratedClass)this.ctx().getProduct(Product.ABSTRACT_LISTENING_MESSAGE_PROCESSOR);
        GeneratedClass clazz = pkg._class(processorMethod.getCapitalizedName() + "MessageProcessor", abstractListeningMessageProcessor.narrow(this.ref(Object.class)), new Class[]{InterceptingMessageProcessor.class, Initialisable.class, Startable.class, Disposable.class, Stoppable.class});
        if (module.getMinMuleVersion().atLeastBase("3.4") && this.isMetaDataEnabled(processorMethod, module)) {
            clazz._implements(OperationMetaDataEnabled.class);
        }
        this.ctx().registerProduct(Product.MESSAGE_PROCESSOR, processorMethod.parent(), processorMethod.getName(), (Object)clazz);
        return clazz;
    }

    private void generateStartMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod startMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "start");
        startMethod._throws(this.ref(MuleException.class));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStartable = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Startable.class)));
                        ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)variableElement.getField()).invoke("start"));
                        continue;
                    }
                    GeneratedConditional ifIsList = startMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStartable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Startable.class)));
                    ifStartable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)forEachProcessor.var()).invoke("start"));
                    continue;
                }
                if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
                startMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "start");
            }
        }
    }

    private void generateStopMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod stopMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "stop");
        stopMethod._throws(this.ref(MuleException.class));
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (variableElement.getVariable().asType().isNestedProcessor() || variableElement.getVariable().asType().isArrayOrList() && variableElement.getVariable().getTypeArguments().size() > 0 && ((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor()) {
                    boolean isList = variableElement.getVariable().asType().isArrayOrList();
                    if (!isList) {
                        GeneratedConditional ifStoppable = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Stoppable.class)));
                        ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)variableElement.getField()).invoke("stop"));
                        continue;
                    }
                    GeneratedConditional ifIsList = stopMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                    GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                    GeneratedConditional ifStoppable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Stoppable.class)));
                    ifStoppable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)forEachProcessor.var()).invoke("stop"));
                    continue;
                }
                if (!((Object)variableElement.getVariable().asTypeMirror()).toString().startsWith(HttpCallback.class.getName())) continue;
                stopMethod.body()._if(variableElement.getFieldType().isNotNull())._then().invoke((GeneratedExpression)variableElement.getFieldType(), "stop");
            }
        }
    }

    private void generateDiposeMethod(GeneratedClass messageProcessorClass, Map<String, AbstractMuleGenerator.FieldVariableElement> fields) {
        GeneratedMethod diposeMethod = messageProcessorClass.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
        if (fields != null) {
            for (String fieldName : fields.keySet()) {
                AbstractMuleGenerator.FieldVariableElement variableElement = fields.get(fieldName);
                if (!variableElement.getVariable().asType().isNestedProcessor() && (!variableElement.getVariable().asType().isArrayOrList() || variableElement.getVariable().getTypeArguments().size() <= 0 || !((org.mule.devkit.model.Type)variableElement.getVariable().getTypeArguments().get(0)).isNestedProcessor())) continue;
                boolean isList = variableElement.getVariable().asType().isArrayOrList();
                if (!isList) {
                    GeneratedConditional ifDisposable = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(Disposable.class)));
                    ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)variableElement.getField()).invoke("dispose"));
                    continue;
                }
                GeneratedConditional ifIsList = diposeMethod.body()._if(Op._instanceof((GeneratedExpression)variableElement.getField(), (Type)this.ref(List.class)));
                GeneratedForEach forEachProcessor = ifIsList._then().forEach((Type)this.ref(MessageProcessor.class), "messageProcessor", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(List.class).narrow(MessageProcessor.class), (GeneratedExpression)fields.get(fieldName).getField()));
                GeneratedConditional ifDisposable = forEachProcessor.body()._if(Op._instanceof((GeneratedExpression)forEachProcessor.var(), (Type)this.ref(Disposable.class)));
                ifDisposable._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)forEachProcessor.var()).invoke("dispose"));
            }
        }
    }

    private boolean isMuleEvent(Type type) {
        return type.fullName().startsWith(MuleEvent.class.getName());
    }
}

