/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.MultiModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Type;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.visitor.ComplexTypeVisitor;
import org.mule.devkit.model.visitor.ModelVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionHolderGenerator
extends AbstractMuleGenerator
implements MultiModuleGenerator {
    private static final List<Product> CONSUMES = Collections.emptyList();
    private static final List<Product> PRODUCES = Arrays.asList(Product.EXPRESSION_HOLDER);
    private Set<Type> registeredComplexTypes = new HashSet<Type>();

    public List<Product> consumes() {
        return Collections.unmodifiableList(CONSUMES);
    }

    public List<Product> produces() {
        return Collections.unmodifiableList(PRODUCES);
    }

    public boolean shouldGenerate(List<Module> modules) {
        for (Module module : modules) {
            if (module.getKind() != ModuleKind.CONNECTOR && module.getKind() != ModuleKind.GENERIC) continue;
            return true;
        }
        return false;
    }

    public void generate(List<Module> modules) throws GenerationException {
        ComplexTypeVisitor visitor = new ComplexTypeVisitor();
        for (Module module : modules) {
            module.accept((ModelVisitor)visitor);
        }
        this.registeredComplexTypes = visitor.getRegisteredComplexTypes();
        for (Type complexType : this.registeredComplexTypes) {
            this.registerExpressionHolder(complexType);
        }
    }

    private void registerExpressionHolder(Type type) {
        if (this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type) != null) {
            return;
        }
        GeneratedClass expressionHolderClass = this.getExpressionHolderClass(type);
        this.ctx().note("Generating expression holder for " + type.getName() + " as " + expressionHolderClass.binaryName());
        for (Field field : type.getFields()) {
            if (!field.hasGetter() || !field.hasSetter()) continue;
            String fieldName = field.getName();
            GeneratedField expressionField = new FieldBuilder(expressionHolderClass).protectedVisibility().type(Object.class).name(fieldName).build();
            GeneratedField expressionFieldType = new FieldBuilder(expressionHolderClass).protectedVisibility().type(this.ref(field.asTypeMirror())).name("_" + fieldName + "Type").build();
            expressionHolderClass.setter(expressionField);
            expressionHolderClass.getter(expressionField);
        }
    }

    private GeneratedClass getExpressionHolderClass(Type type) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(type.getPackage().getName() + ".holders");
        GeneratedClass expressionHolderClass = pkg._class(type.getClassName() + "ExpressionHolder");
        this.ctx().registerProduct(Product.EXPRESSION_HOLDER, (Identifiable)type, (Object)expressionHolderClass);
        if (type.hasSuperClass()) {
            if (this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type.getSuperClass()) != null) {
                expressionHolderClass._extends((TypeReference)this.ctx().getProduct(Product.EXPRESSION_HOLDER, (Identifiable)type.getSuperClass()));
            } else {
                this.registerExpressionHolder(type.getSuperClass());
                GeneratedClass superclass = this.getExpressionHolderClass(type.getSuperClass());
                this.ctx().registerProduct(Product.EXPRESSION_HOLDER, (Identifiable)type.getSuperClass(), (Object)superclass);
                expressionHolderClass._extends((TypeReference)superclass);
            }
        }
        return expressionHolderClass;
    }
}

