/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.adapter;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.InitialisationCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterFactoryGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.INJECTION_ADAPTER, Product.HTTP_CALLBACK_ADAPTER, Product.OAUTH_ADAPTER);
    private static final List<Product> PRODUCES = Arrays.asList(Product.ADAPTER_FACTORY);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.usesPooling();
    }

    public void generate(Module module) {
        GeneratedClass lifecycleAdapterFactory = this.getAdapterFactoryClass(module);
        lifecycleAdapterFactory.javadoc().add((Object)("A <code>" + lifecycleAdapterFactory.name() + "</code> is an implementation  "));
        lifecycleAdapterFactory.javadoc().add((Object)" of {@link ObjectFactory} interface for ");
        lifecycleAdapterFactory.javadoc().add((Object)this.ref(module.asTypeMirror()));
        GeneratedClass poolObjectClass = ((GeneratedClass)this.ctx().getProduct(Product.CAPABILITIES_ADAPTER, (Identifiable)module)).topLevelClass();
        this.generateFields(module, lifecycleAdapterFactory);
        this.generateInitialiseMethod(lifecycleAdapterFactory);
        this.generateDisposeMethod(lifecycleAdapterFactory);
        this.generateGetInstanceMethod(module, lifecycleAdapterFactory, poolObjectClass);
        this.generateGetObjectClassMethod(lifecycleAdapterFactory, poolObjectClass);
        this.generateAddObjectInitialisationCallback(lifecycleAdapterFactory);
        this.generateIsSingleton(lifecycleAdapterFactory);
        this.generateIsAutoWireObject(lifecycleAdapterFactory);
        this.generateIsExternallyManagedLifecycle(lifecycleAdapterFactory);
    }

    private void generateIsExternallyManagedLifecycle(GeneratedClass lifecycleAdapterFactory) {
        GeneratedMethod isExternallyManagedLifecycle = lifecycleAdapterFactory.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isExternallyManagedLifecycle");
        isExternallyManagedLifecycle.body()._return(ExpressionFactory.FALSE);
    }

    private void generateIsAutoWireObject(GeneratedClass lifecycleAdapterFactory) {
        GeneratedMethod isAutoWireObject = lifecycleAdapterFactory.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isAutoWireObject");
        isAutoWireObject.body()._return(ExpressionFactory.FALSE);
    }

    private void generateIsSingleton(GeneratedClass lifecycleAdapterFactory) {
        GeneratedMethod isSingleton = lifecycleAdapterFactory.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isSingleton");
        isSingleton.body()._return(ExpressionFactory.FALSE);
    }

    private void generateAddObjectInitialisationCallback(GeneratedClass lifecycleAdapterFactory) {
        GeneratedMethod addObjectInitialisationCallback = lifecycleAdapterFactory.method(1, (Type)this.ctx().getCodeModel().VOID, "addObjectInitialisationCallback");
        addObjectInitialisationCallback.param((Type)this.ref(InitialisationCallback.class), "callback");
        addObjectInitialisationCallback.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(UnsupportedOperationException.class)));
    }

    private void generateGetObjectClassMethod(GeneratedClass lifecycleAdapterFactory, GeneratedClass poolObjectClass) {
        GeneratedMethod getObjectClass = lifecycleAdapterFactory.method(1, (Type)this.ref(Class.class), "getObjectClass");
        getObjectClass.body()._return(poolObjectClass.dotclass());
    }

    private void generateGetInstanceMethod(Module module, GeneratedClass lifecycleAdapterFactory, GeneratedClass poolObjectClass) {
        GeneratedMethod getInstance = lifecycleAdapterFactory.method(1, (Type)this.ref(Object.class), "getInstance");
        getInstance.param((Type)this.ref(MuleContext.class), "muleContext");
        GeneratedVariable object = getInstance.body().decl((Type)poolObjectClass, "object", (GeneratedExpression)ExpressionFactory._new((TypeReference)poolObjectClass));
        for (Field variable : module.getConfigurableFields()) {
            getInstance.body().add((Statement)object.invoke("set" + StringUtils.capitalize((String)variable.getName())).arg((GeneratedExpression)ExpressionFactory._this().ref(variable.getName())));
        }
        getInstance.body()._return((GeneratedExpression)object);
    }

    private void generateDisposeMethod(GeneratedClass lifecycleAdapterFactory) {
        lifecycleAdapterFactory.method(1, (Type)this.ctx().getCodeModel().VOID, "dispose");
    }

    private void generateInitialiseMethod(GeneratedClass lifecycleAdapterFactory) {
        GeneratedMethod initialise = lifecycleAdapterFactory.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        initialise._throws(this.ref(InitialisationException.class));
    }

    private void generateFields(Module module, GeneratedClass lifecycleAdapterFactory) {
        for (Field variable : module.getConfigurableFields()) {
            GeneratedField configField = lifecycleAdapterFactory.field(4, this.ref(variable.asTypeMirror()), variable.getName());
            lifecycleAdapterFactory.setter(configField);
        }
    }

    private GeneratedClass getAdapterFactoryClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".adapters");
        GeneratedClass clazz = pkg._class(module.getClassName() + "LifecycleAdapterFactory");
        clazz._implements(this.ref(ObjectFactory.class));
        this.ctx().registerProduct(Product.ADAPTER_FACTORY, (Identifiable)module, (Object)clazz);
        return clazz;
    }
}

