/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mule.devkit.generation.api.Context;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class BasicInterfaceGenerator
implements ModuleGenerator {
    private static final String BASIC_NAMESPACE = ".basic";
    private static final String CAPABILITIES_INTERFACE = "Capabilities";
    private static final String CAPABILITY_ENUM = "Capability";
    private static final String METADATA_AWARE = "MetadataAware";
    private static final String NESTED_PROCESSOR = "NestedProcessor";
    protected Context context;

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        try {
            this.generateCapabilitiesInterface(module);
            this.generateCapabilityEnum(module);
            this.generateMetaDataAwareInterface(module);
        }
        catch (ClassAlreadyExistsException classAlreadyExistsException) {
            // empty catch block
        }
    }

    private void generateNestedProcessorInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + BASIC_NAMESPACE);
        GeneratedClass clazz = pkg._interface(NESTED_PROCESSOR);
        this.ctx().registerProduct(Product.NESTED_PROCESSOR_INTERFACE, (Object)clazz);
        clazz.javadoc().append((Object)"Callback interface used by {@link org.mule.api.annotations.Processor} annotated methods. <p/>\nThe method parameters of type {@link NestedProcessor} will be able to receive other\nmessage processors. The {@link org.mule.api.annotations.Processor} annotated method\ncan use the process method to execute them.");
        clazz.direct("/**\n     * Dispatch original message to the processor chain\n     *\n     * @param invocationProperties Additional invocation properties\n     * @return The return payload for the processor chain\n     */\n    Object processWithExtraProperties(java.util.Map<String, Object> invocationProperties) throws Exception;\n\n    /**\n     * Dispatch message to the processor chain\n     *\n     * @param payload    The payload of the message\n     * @param invocationProperties Additional invocation properties\n     * @return The return payload for the processor chain\n     */\n    Object process(Object payload, java.util.Map<String, Object> invocationProperties) throws Exception;\n\n    /**\n     * Dispatch message to the processor chain\n     *\n     * @param payload The payload of the message\n     * @return The return payload for the processor chain\n     */\n    Object process(Object payload) throws Exception;\n\n    /**\n     * Dispatch original message to the processor chain\n     *\n     * @return The return payload for the processor chain\n     */\n    Object process() throws Exception;");
    }

    private void generateMetaDataAwareInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + BASIC_NAMESPACE);
        GeneratedClass clazz = pkg._interface(METADATA_AWARE);
        this.ctx().registerProduct(Product.METADATA_AWARE_INTERFACE, (Object)clazz);
        clazz.javadoc().append((Object)" This interface is implemented for every {@link org.mule.api.annotations.Module} and {@link org.mule.api.annotations.Connector} annotated class and its purpose is to define a contract to query the annotated class about its metadata.");
        clazz.direct(" /**\n     * Returns the user-friendly name of this module\n     */\n    String getModuleName();\n\n    /**\n     * Returns the version of this module\n     */\n    String getModuleVersion();\n\n    /**\n     * Returns the version of the DevKit used to create this module\n     */\n    String getDevkitVersion();\n\n    /**\n     * Returns the build of the DevKit used to create this module\n     */\n    String getDevkitBuild();");
    }

    private void generateCapabilityEnum(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + BASIC_NAMESPACE);
        GeneratedClass clazz = pkg._enum(CAPABILITY_ENUM);
        this.ctx().registerProduct(Product.CAPABILITY_ENUM, (Object)clazz);
        clazz.javadoc().append((Object)" Enumeration of possible capabilities of Mule modules. Each capability represents a bit in a bit array. The capabilities of a particular module can be queried using {@link Capabilities}");
        clazz.direct(" /**\n     * This capability indicates that the module implements {@link org.mule.api.lifecycle.Lifecycle}\n     */\n    LIFECYCLE_CAPABLE(0),\n\n    /**\n     * This capability indicates that the module implements {@link ConnectionManager}\n     */\n    CONNECTION_MANAGEMENT_CAPABLE(1),\n\n    /**\n     * This capability indicates that the module implements {@link org.mule.api.oauth.OAuth1Adapter}\n     */\n    OAUTH1_CAPABLE(2),\n\n    /**\n     * This capability indicates that the module implements {@link org.mule.api.oauth.OAuth2Adapter}\n     */\n    OAUTH2_CAPABLE(3),\n\n    /**\n     * This capability indicates that the module implements {@link org.mule.api.adapter.PoolManager}\n     */\n    POOLING_CAPABLE(4),\n\n    /**\n     * This capability indicates that the module implements {@link org.mule.api.oauth.OAuthManager}\n     */\n    OAUTH_ACCESS_TOKEN_MANAGEMENT_CAPABLE(5);\n\n    private int bit;\n\n    Capability(int bit) {\n        this.bit = bit;\n    }\n\n    public int getBit() {\n        return this.bit;\n    }");
    }

    private void generateCapabilitiesInterface(Module module) throws ClassAlreadyExistsException {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + BASIC_NAMESPACE);
        GeneratedClass clazz = pkg._interface(CAPABILITIES_INTERFACE);
        this.ctx().registerProduct(Product.CAPABILITIES_INTERFACE, (Object)clazz);
        clazz.javadoc().append((Object)"This interface is implemented for every {@link org.mule.api.annotations.Module} annotated class, to dynamically query what its capabilities are.");
        clazz.direct("    /**\n     * Returns true if this module implements such\n     * capability\n     *\n     * @param capability The capability to test for\n     * @return True if it does, false otherwise\n     */\n    boolean isCapableOf(Capability capability);");
    }

    public List<Product> consumes() {
        return new ArrayList<Product>();
    }

    public List<Product> produces() {
        return Arrays.asList(Product.BASICS_INTERFACE);
    }

    public Context ctx() {
        return this.context;
    }

    public void setCtx(Context generationContext) {
        this.context = generationContext;
    }

    protected TypeReference ref(Class<?> clazz) {
        return this.ctx().getCodeModel().ref(clazz);
    }

    protected Type ref(TypeMirror typeMirror) {
        return this.ctx().getCodeModel().ref(typeMirror);
    }

    protected Type ref(Module module) {
        return this.ctx().getCodeModel().ref(module.asTypeMirror());
    }
}

