/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation;

import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedFieldReference;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;
import org.mule.devkit.model.module.oauth.OAuthVersion;

public abstract class AbstractCapabilityGenerator
extends AbstractCodeGenerator {
    protected void generateIsCapableOfMethod(Module module, GeneratedClass capabilitiesAdapter) {
        GeneratedMethod isCapableOf = capabilitiesAdapter.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "isCapableOf");
        GeneratedVariable capability = isCapableOf.param((Type)((TypeReference)this.ctx().getProduct(Product.CAPABILITY_ENUM)), "capability");
        isCapableOf.javadoc().add((Object)"Returns true if this module implements such capability");
        this.addCapability(isCapableOf, capability, ((TypeReference)this.ctx().getProduct(Product.CAPABILITY_ENUM)).staticRef("LIFECYCLE_CAPABLE"));
        if (module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V2) {
            this.addCapability(isCapableOf, capability, ((TypeReference)this.ctx().getProduct(Product.CAPABILITY_ENUM)).staticRef("OAUTH2_CAPABLE"));
        }
        if (module instanceof OAuthModule && ((OAuthModule)module).getOAuthVersion() == OAuthVersion.V10A) {
            this.addCapability(isCapableOf, capability, ((TypeReference)this.ctx().getProduct(Product.CAPABILITY_ENUM)).staticRef("OAUTH1_CAPABLE"));
        }
        if (module.usesPooling()) {
            this.addCapability(isCapableOf, capability, ((TypeReference)this.ctx().getProduct(Product.CAPABILITY_ENUM)).staticRef("POOLING_CAPABLE"));
        }
        if (module instanceof ManagedConnectionModule) {
            this.addCapability(isCapableOf, capability, ((TypeReference)this.ctx().getProduct(Product.CAPABILITY_ENUM)).staticRef("CONNECTION_MANAGEMENT_CAPABLE"));
        }
        isCapableOf.body()._return(ExpressionFactory.FALSE);
    }

    private void addCapability(GeneratedMethod capableOf, GeneratedVariable capability, GeneratedFieldReference capabilityToCheckFor) {
        GeneratedConditional isCapable = capableOf.body()._if(Op.eq((GeneratedExpression)capability, (GeneratedExpression)capabilityToCheckFor));
        isCapable._then()._return(ExpressionFactory.TRUE);
    }
}

