/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.List;
import org.mule.api.annotations.Source;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.SourceMethod;

public class SourceAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasSources();
    }

    public void verify(Module module) throws AnnotationVerificationException {
        for (SourceMethod method : module.getSourceMethods()) {
            try {
                if (((Source)method.getAnnotation(Source.class)).primaryNodeOnly() && !module.getMinMuleVersion().atLeastBase("3.3")) {
                    throw new AnnotationVerificationException((Identifiable)method, "The attribute primaryNodeOnly works with Mule 3.3 only therefore you must set the minMuleVersion of your @Connector or @Module to \"3.3\". Example: @Module(minMuleVersion=\"3.3\")");
                }
            }
            catch (IllegalArgumentException iae) {
                throw new AnnotationVerificationException((Identifiable)method, "Error parsing Mule version, verify that the minMuleVersion is in the correct format: X.X.X");
            }
            if (method.isStatic()) {
                throw new AnnotationVerificationException((Identifiable)method, "@Source cannot be applied to a static method");
            }
            if (!method.getTypeParameters().isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)method, "@Source cannot be applied to a generic method");
            }
            if (!method.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)method, "@Source cannot be applied to a non-public method");
            }
            boolean containsSourceCallback = false;
            List parameters = method.getParameters();
            for (Parameter parameter : parameters) {
                if (((Object)parameter.asTypeMirror()).toString().startsWith(SourceCallback.class.getName())) {
                    containsSourceCallback = true;
                }
                if (!parameter.isReservedIdentifier()) continue;
                throw new AnnotationVerificationException((Identifiable)parameter, "@Source method cannot contain a parameter identified by '" + parameter.getName() + "'. '" + parameter.getName() + "' is a reserved identifier.");
            }
            if (containsSourceCallback) continue;
            throw new AnnotationVerificationException((Identifiable)method, "@Source method must contain a SourceCallback as one of its parameters");
        }
    }
}

