/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import javax.lang.model.type.TypeKind;
import org.mule.api.annotations.expressions.Expr;
import org.mule.api.annotations.param.CorrelationGroupSize;
import org.mule.api.annotations.param.CorrelationId;
import org.mule.api.annotations.param.CorrelationSequence;
import org.mule.api.annotations.param.ExceptionPayload;
import org.mule.api.annotations.param.InboundHeaders;
import org.mule.api.annotations.param.InvocationHeaders;
import org.mule.api.annotations.param.MessageRootId;
import org.mule.api.annotations.param.MessageUniqueId;
import org.mule.api.annotations.param.OutboundHeaders;
import org.mule.api.annotations.param.Payload;
import org.mule.api.annotations.param.SessionHeaders;
import org.mule.api.annotations.rest.RestCall;
import org.mule.api.callback.SourceCallback;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.EnumType;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.Variable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.ProcessorMethod;

public class ProcessorAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC;
    }

    public void verify(Module module) throws AnnotationVerificationException {
        for (ProcessorMethod method : module.getProcessorMethods()) {
            if (method.isStatic()) {
                throw new AnnotationVerificationException((Identifiable)method, "@Processor cannot be applied to a static method");
            }
            if (!method.getTypeParameters().isEmpty()) {
                throw new AnnotationVerificationException((Identifiable)method, "@Processor cannot be applied to a generic method");
            }
            if (!method.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)method, "@Processor cannot be applied to a non-public method");
            }
            if (method.isAbstract() && method.getAnnotation(RestCall.class) == null) {
                throw new AnnotationVerificationException((Identifiable)method, "@Processor cannot be applied to an abstract method that is not annotated with @RestCall");
            }
            this.validateIntercepting(method);
            for (Parameter parameter : method.getParameters()) {
                if (parameter.isReservedIdentifier()) {
                    throw new AnnotationVerificationException((Identifiable)parameter, "@Processor method cannot contain a parameter identified by '" + parameter.getName() + "'. '" + parameter.getName() + "' is a reserved identifier.");
                }
                int count = 0;
                if (parameter.getAnnotation(InboundHeaders.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(OutboundHeaders.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(InvocationHeaders.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(SessionHeaders.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(Payload.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(ExceptionPayload.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(CorrelationId.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(CorrelationSequence.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(CorrelationGroupSize.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(MessageUniqueId.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(MessageRootId.class) != null) {
                    ++count;
                }
                if (parameter.getAnnotation(Expr.class) != null) {
                    ++count;
                }
                if (count > 1) {
                    throw new AnnotationVerificationException((Identifiable)parameter, "You cannot have more than one of InboundHeader, OutboundHeaders, InvocationHeaders, SessionHeaders, ExceptionPayload, CorrelationId, CorrelationSequence, CorrelationGroupSize, MessageUniqueId, MessageRootId, Expr or Payload annotation");
                }
                if (count > 0 && (parameter.hasDefaultValue() || parameter.isOptional())) {
                    throw new AnnotationVerificationException((Identifiable)parameter, "You cannot use Default or Optional annotations with this annotation.");
                }
                if (count == 0 && parameter.hasDefaultValue() && !parameter.isOptional()) {
                    throw new AnnotationVerificationException((Identifiable)parameter, "You cannot use Default without Optional annotation. The default value will never kick in if the value is always required.");
                }
                if (parameter.getAnnotation(Payload.class) == null && parameter.asTypeMirror().getKind() == TypeKind.ARRAY) {
                    throw new AnnotationVerificationException((Identifiable)parameter, "@Processor parameter cannot be arrays, use List instead");
                }
                if (!parameter.hasDefaultValue() || !parameter.asType().isEnum() || this.isDefaultValueValidForEnum((Variable)parameter)) continue;
                throw new AnnotationVerificationException((Identifiable)parameter, "@Default value is not valid for this enum, check teh enum declaration");
            }
        }
    }

    private void validateIntercepting(ProcessorMethod method) throws AnnotationVerificationException {
        if (method.isIntercepting()) {
            boolean containsSourceCallback = false;
            for (Parameter parameter : method.getParameters()) {
                if (!((Object)parameter.asTypeMirror()).toString().startsWith(SourceCallback.class.getName())) continue;
                containsSourceCallback = true;
            }
            if (!containsSourceCallback) {
                throw new AnnotationVerificationException((Identifiable)method, "An intercepting method method must contain a SourceCallback as one of its parameters");
            }
        }
    }

    private boolean isDefaultValueValidForEnum(Variable variable) {
        for (Identifiable enumMember : ((EnumType)variable.asType()).getEnumConstants()) {
            String enumConstant = enumMember.getName();
            if (!variable.getDefaultValue().equals(enumConstant)) continue;
            return true;
        }
        return false;
    }
}

