/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.process;

import java.util.Arrays;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.devkit.generation.AbstractCodeGenerator;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class ProcessCallbackProcessInterceptorGenerator
extends AbstractCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.PROCESS_INTERFACES);
    private static final List<Product> PRODUCES = Arrays.asList(Product.PROCESS_CALLBACK_PROCESS_INTERCEPTOR);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return true;
    }

    public void generate(Module module) throws GenerationException {
        GeneratedClass processCallbackProcessInterceptorClass = this.getProcessCallbackProcessInterceptor(module);
        TypeVariable t = processCallbackProcessInterceptorClass.generify("T");
        TypeVariable o = processCallbackProcessInterceptorClass.generify("O");
        processCallbackProcessInterceptorClass._implements(((TypeReference)this.ctx().getProduct(Product.PROCESS_INTERCEPTOR_INTERFACE)).narrow((TypeReference)t).narrow((TypeReference)o));
        this.generateExecuteMethod(processCallbackProcessInterceptorClass, t, o);
        this.generateExecuteMethodForMessage(processCallbackProcessInterceptorClass, t, o);
    }

    private void generateExecuteMethod(GeneratedClass processCallbackProcessInterceptorClass, TypeVariable t, TypeVariable o) {
        GeneratedMethod execute = processCallbackProcessInterceptorClass.method(1, (Type)t, "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)((TypeReference)this.ctx().getProduct(Product.PROCESS_CALLBACK_INTERFACE)).narrow((TypeReference)t).narrow((TypeReference)o), "processCallback");
        GeneratedVariable object = execute.param((Type)o, "object");
        GeneratedVariable messageProcessor = execute.param((Type)this.ref(MessageProcessor.class), "messageProcessor");
        GeneratedVariable event = execute.param((Type)this.ref(MuleEvent.class), "event");
        execute.body()._return((GeneratedExpression)processCallback.invoke("process").arg((GeneratedExpression)object));
    }

    private void generateExecuteMethodForMessage(GeneratedClass processCallbackProcessInterceptorClass, TypeVariable t, TypeVariable o) {
        GeneratedMethod execute = processCallbackProcessInterceptorClass.method(1, (Type)t, "execute");
        execute._throws(this.ref(Exception.class));
        GeneratedVariable processCallback = execute.param((Type)((TypeReference)this.ctx().getProduct(Product.PROCESS_CALLBACK_INTERFACE)).narrow((TypeReference)t).narrow((TypeReference)o), "processCallback");
        GeneratedVariable object = execute.param((Type)o, "object");
        GeneratedVariable filter = execute.param((Type)this.ref(Filter.class), "filter");
        GeneratedVariable message = execute.param((Type)this.ref(MuleMessage.class), "message");
        execute.body()._return((GeneratedExpression)processCallback.invoke("process").arg((GeneratedExpression)object));
    }

    private GeneratedClass getProcessCallbackProcessInterceptor(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".process");
        GeneratedClass clazz = pkg._class(1, "ProcessCallbackProcessInterceptor");
        this.ctx().registerProduct(Product.PROCESS_CALLBACK_PROCESS_INTERCEPTOR, (Object)clazz);
        return clazz;
    }
}

