/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.mule.transformer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.devkit.generation.api.annotations.JustOnce;
import org.mule.devkit.generation.mule.transformer.AbstractTransformerGenerator;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.builders.FieldBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JustOnce
public class StringToDateTransformerGenerator
extends AbstractTransformerGenerator {
    private static final String PATTERN = "yyyy-MM-dd'T'hh:mm:ss";
    private static final String SIMPLE_DATE_FORMAT_FIELD_NAME = "SIMPLE_DATE_FORMAT";

    @Override
    protected String getTransformerClassName() {
        return "StringToDateTransformer";
    }

    @Override
    protected Class<?> getSourceClass() {
        return String.class;
    }

    @Override
    protected Class<?> getDestionationClass() {
        return Date.class;
    }

    @Override
    protected Map<String, GeneratedField> generateAdditionalFields(GeneratedClass transformerClass) {
        GeneratedField simpleDateFormatConstant = this.generateSimpleDataFormatField(transformerClass);
        HashMap<String, GeneratedField> fields = new HashMap<String, GeneratedField>(1);
        fields.put(SIMPLE_DATE_FORMAT_FIELD_NAME, simpleDateFormatConstant);
        return fields;
    }

    @Override
    protected void doTransformImplementation(GeneratedMethod doTransformMethod, GeneratedVariable srcParam, GeneratedVariable encodingParam, Map<String, GeneratedField> additionalFields) {
        GeneratedTry tryStatement = doTransformMethod.body()._try();
        GeneratedField simpleDateFormat = additionalFields.get(SIMPLE_DATE_FORMAT_FIELD_NAME);
        tryStatement.body()._return((GeneratedExpression)simpleDateFormat.invoke("parse").arg((GeneratedExpression)srcParam.invoke("toString")));
        GeneratedCatchBlock catchBlock = tryStatement._catch(this.ref(ParseException.class));
        GeneratedVariable exceptionCaught = catchBlock.param("e");
        GeneratedInvocation errorMessage = this.ref(MessageFactory.class).staticInvoke("createStaticMessage").arg((GeneratedExpression)this.ref(String.class).staticInvoke("format").arg("Could not parse %s using the format %s").arg((GeneratedExpression)srcParam).arg((GeneratedExpression)simpleDateFormat.invoke("toPattern")));
        catchBlock.body()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(TransformerException.class)).arg((GeneratedExpression)errorMessage).arg(ExpressionFactory._this()).arg((GeneratedExpression)exceptionCaught));
    }

    private GeneratedField generateSimpleDataFormatField(GeneratedClass transformerClass) {
        return FieldBuilder.newConstantFieldBuilder((GeneratedClass)transformerClass).type(SimpleDateFormat.class).name(SIMPLE_DATE_FORMAT_FIELD_NAME).initialValue((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(SimpleDateFormat.class)).arg(PATTERN)).build();
    }
}

