/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.connectivity;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.MetaDataKeyRetriever;
import org.mule.api.annotations.MetaDataRetriever;
import org.mule.api.annotations.MetaDataSwitch;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.config.PoolingProfile;
import org.mule.devkit.generation.AbstractMetadataCodeGenerator;
import org.mule.devkit.generation.AbstractMuleGenerator;
import org.mule.devkit.generation.MessageConstants;
import org.mule.devkit.generation.api.GenerationException;
import org.mule.devkit.generation.api.ModuleGenerator;
import org.mule.devkit.generation.api.Product;
import org.mule.devkit.model.Field;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.Parameter;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.GeneratedBlock;
import org.mule.devkit.model.code.GeneratedCast;
import org.mule.devkit.model.code.GeneratedCatchBlock;
import org.mule.devkit.model.code.GeneratedClass;
import org.mule.devkit.model.code.GeneratedConditional;
import org.mule.devkit.model.code.GeneratedExpression;
import org.mule.devkit.model.code.GeneratedField;
import org.mule.devkit.model.code.GeneratedInvocation;
import org.mule.devkit.model.code.GeneratedMethod;
import org.mule.devkit.model.code.GeneratedPackage;
import org.mule.devkit.model.code.GeneratedTry;
import org.mule.devkit.model.code.GeneratedVariable;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.TypeVariable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.connectivity.ConnectMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManagerGenerator
extends AbstractMetadataCodeGenerator
implements ModuleGenerator {
    private static final List<Product> CONSUMES = Arrays.asList(Product.CAPABILITIES_ADAPTER, Product.LIFECYCLE_ADAPTER, Product.CONNECTION_IDENTIFIER_ADAPTER, Product.INJECTION_ADAPTER, Product.HTTP_CALLBACK_ADAPTER, Product.OAUTH_ADAPTER, Product.MANAGED_CONNECTION_PROCESS_TEMPLATE, Product.METADATA_ADAPTER, Product.PROCESS_INTERFACES, Product.CONNECTION_INTERFACES, Product.BASICS_INTERFACE);
    private static final List<Product> PRODUCES = Arrays.asList(Product.CONNECTION_MANAGER);

    public List<Product> consumes() {
        return CONSUMES;
    }

    public List<Product> produces() {
        return PRODUCES;
    }

    public boolean shouldGenerate(Module module) {
        return module instanceof ManagedConnectionModule;
    }

    public void generate(Module module) throws GenerationException {
        ManagedConnectionModule managedConnectionType = (ManagedConnectionModule)module;
        ConnectMethod connectMethod = managedConnectionType.getConnectMethod();
        Method disconnectMethod = managedConnectionType.getDisconnectMethod();
        Method validateConnectionMethod = managedConnectionType.getValidateConnectionMethod();
        GeneratedClass connectionManagerClass = this.getConnectionManagerAdapterClass(managedConnectionType);
        Map<String, AbstractMuleGenerator.FieldVariableElement> fields = this.generateStandardFieldForEachParameter(connectionManagerClass, (Method)connectMethod);
        for (Field field : module.getConfigurableFields()) {
            GeneratedField configField = connectionManagerClass.field(4, this.ref(field.asTypeMirror()), field.getName());
            connectionManagerClass.setter(configField);
            connectionManagerClass.getter(configField);
        }
        GeneratedField muleContext = connectionManagerClass.muleContextField();
        GeneratedField flowConstruct = connectionManagerClass.flowConstructField();
        GeneratedField connectionPool = this.generateFieldForConnectionPool(connectionManagerClass);
        GeneratedField poolingProfile = connectionManagerClass.field(2, (Type)this.ref(PoolingProfile.class), "connectionPoolingProfile");
        GeneratedField retryPolicyTemplate = connectionManagerClass.field(2, (Type)this.ref(RetryPolicyTemplate.class), "retryPolicyTemplate");
        connectionManagerClass.setter(poolingProfile);
        connectionManagerClass.getter(poolingProfile);
        connectionManagerClass.setter(retryPolicyTemplate);
        connectionManagerClass.getter(retryPolicyTemplate);
        for (String fieldName : fields.keySet()) {
            connectionManagerClass.setter(fields.get(fieldName).getField());
            connectionManagerClass.getter(fields.get(fieldName).getField());
        }
        GeneratedClass connectionKeyClass = (GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module);
        GeneratedClass connectionFactoryClass = this.getConnectorFactoryClass(module);
        GeneratedField loggerFactory = this.generateLoggerField(connectionFactoryClass);
        GeneratedField connectionManagerInFactory = connectionFactoryClass.field(4, (Type)connectionManagerClass, "connectionManager");
        GeneratedMethod connectionFactoryConstructor = connectionFactoryClass.constructor(1);
        GeneratedVariable constructorConnectionManager = connectionFactoryConstructor.param((Type)connectionManagerClass, "connectionManager");
        connectionFactoryConstructor.body().assign((AssignmentTarget)ExpressionFactory._this().ref((GeneratedVariable)connectionManagerInFactory), (GeneratedExpression)constructorConnectionManager);
        this.generateMakeObjectMethod(module, connectMethod, validateConnectionMethod, connectionFactoryClass, connectionKeyClass, connectionManagerInFactory, loggerFactory);
        this.generateDestroyObjectMethod((Method)connectMethod, disconnectMethod, connectionKeyClass, connectionFactoryClass, loggerFactory);
        this.generateValidateObjectMethod(connectionFactoryClass, loggerFactory, validateConnectionMethod);
        this.generateActivateObjectMethod(connectionFactoryClass, validateConnectionMethod, connectMethod, connectionKeyClass, loggerFactory);
        this.generatePassivateObjectMethod(connectionFactoryClass);
        this.generateInitialiseMethod(module, connectionManagerClass, connectionPool, poolingProfile, retryPolicyTemplate, connectionFactoryClass);
        this.generateBorrowConnectionMethod((Method)connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateReturnConnectionMethod((Method)connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateDestroyConnectionMethod((Method)connectMethod, connectionManagerClass, connectionPool, connectionKeyClass);
        this.generateIsCapableOfMethod(module, connectionManagerClass);
        this.generateGetProcessTemplateMethod(managedConnectionType, connectionManagerClass);
        this.generateGetDefaultConnectionKey(managedConnectionType, connectionManagerClass, connectionKeyClass);
        this.generateMetadataConstantsAndGetters(module, connectionManagerClass);
        if (module.getMinMuleVersion().atLeastBase("3.4")) {
            this.generateTestMethod((Method)connectMethod, connectionManagerClass, connectionKeyClass);
            this.generateBuildFailureTestResultMethod((Method)connectMethod, connectionManagerClass);
        }
        if (this.isMetaDataCapable(module)) {
            this.generateMetadataMethods(module, connectionManagerClass, connectionKeyClass, (Method)connectMethod);
        }
    }

    private boolean isMetaDataCapable(Module module) {
        if (MetaDataSwitch.OFF.equals((Object)((Connector)module.getAnnotation(Connector.class)).metaData())) {
            return false;
        }
        List metaDataKeysRetrievers = module.getMethodsAnnotatedWith(MetaDataKeyRetriever.class);
        List metaDataRetriever = module.getMethodsAnnotatedWith(MetaDataRetriever.class);
        return module.getMinMuleVersion().atLeastBase("3.4") && metaDataKeysRetrievers.size() == 1 && metaDataRetriever.size() == 1;
    }

    protected void generateMetadataMethods(Module module, GeneratedClass generatedClass, GeneratedClass connectionKeyClass, Method connect) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod getMetadataKeys = generatedClass.method(1, (Type)this.ref(String.class), "getMetaDataKeys");
        getMetadataKeys.annotate(Override.class);
        getMetadataKeys.type((Type)this.ref(Result.class).narrow(this.ref(List.class).narrow(this.ref(MetaDataKey.class))));
        if (module.getMethodsAnnotatedWith(MetaDataKeyRetriever.class).size() == 1) {
            GeneratedVariable connection = getMetadataKeys.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
            GeneratedVariable defaultConnectionKey = getMetadataKeys.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
            GeneratedTry tryTestConnection = getMetadataKeys.body()._try();
            tryTestConnection.body().assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
            GeneratedTry tryGetMetaDataKeys = tryTestConnection.body()._try();
            tryGetMetaDataKeys.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(List.class).narrow(MetaDataKey.class))).arg((GeneratedExpression)connection.invoke(module.getMetaDataKeyRetrieverMethod().getName())).arg(ExpressionFactory.direct((String)"Result.Status.SUCCESS")));
            GeneratedCatchBlock catchGetMetaDataKeys = tryGetMetaDataKeys._catch(this.ref(Exception.class));
            GeneratedVariable e1 = catchGetMetaDataKeys.param("e");
            catchGetMetaDataKeys.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(List.class).narrow(MetaDataKey.class))).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg(MessageConstants.getMetaDataKeysException()).arg((GeneratedExpression)this.ref(MetaDataFailureType.class).staticRef("ERROR_METADATA_KEYS_RETRIEVER")).arg((GeneratedExpression)e1));
            GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
            GeneratedVariable e = catchTestConnection.param("e");
            GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
            tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
            tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
            catchTestConnection.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultResult.class).narrow(this.ref(List.class).narrow(MetaDataKey.class)), (GeneratedExpression)ExpressionFactory.invoke((String)"buildFailureTestResult").arg((GeneratedExpression)e)));
            GeneratedBlock finallyTestConnection = tryTestConnection._finally();
            GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
            GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
            tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
            tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
        } else {
            getMetadataKeys.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(List.class).narrow(MetaDataKey.class))).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.SUCCESS")));
        }
        GeneratedMethod getMetadata = generatedClass.method(1, (Type)this.ref(Result.class).narrow(this.ref(MetaData.class)), "getMetaData");
        getMetadata.annotate(Override.class);
        GeneratedVariable key = getMetadata.param((Type)this.ref(MetaDataKey.class), "metaDataKey");
        if (module.getMethodsAnnotatedWith(MetaDataRetriever.class).size() == 1) {
            GeneratedVariable connection = getMetadata.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
            GeneratedVariable defaultConnectionKey = getMetadata.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
            GeneratedTry tryTestConnection = getMetadata.body()._try();
            tryTestConnection.body().assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
            GeneratedTry tryGetMetaData = tryTestConnection.body()._try();
            tryGetMetaData.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(this.ref(MetaData.class))).arg((GeneratedExpression)connection.invoke(module.getMetaDataRetrieverMethod().getName()).arg((GeneratedExpression)key)));
            GeneratedCatchBlock catchGetMetaData = tryGetMetaData._catch(this.ref(Exception.class));
            GeneratedVariable e1 = catchGetMetaData.param("e");
            catchGetMetaData.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.FAILURE")).arg((GeneratedExpression)ExpressionFactory.invoke((String)"getMetaDataException").arg((GeneratedExpression)key)).arg((GeneratedExpression)this.ref(MetaDataFailureType.class).staticRef("ERROR_METADATA_RETRIEVER")).arg((GeneratedExpression)e1));
            GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
            GeneratedVariable e = catchTestConnection.param("e");
            GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
            tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
            tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
            catchTestConnection.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultResult.class).narrow(this.ref(MetaData.class)), (GeneratedExpression)ExpressionFactory.invoke((String)"buildFailureTestResult").arg((GeneratedExpression)e)));
            GeneratedBlock finallyTestConnection = tryTestConnection._finally();
            GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
            GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
            tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
            tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
            GeneratedMethod getMetaDataException = generatedClass.method(4, (Type)this.ref(String.class), "getMetaDataException");
            GeneratedVariable metaDataKey = getMetaDataException.param((Type)this.ref(MetaDataKey.class), "key");
            GeneratedConditional metadataif = getMetaDataException.body()._if(Op.cand((GeneratedExpression)Op.ne((GeneratedExpression)metaDataKey, (GeneratedExpression)ExpressionFactory._null()), (GeneratedExpression)Op.ne((GeneratedExpression)metaDataKey.invoke("getId"), (GeneratedExpression)ExpressionFactory._null())));
            metadataif._then()._return(Op.plus((GeneratedExpression)ExpressionFactory.lit((String)"There was an error retrieving metadata from key: "), (GeneratedExpression)Op.plus((GeneratedExpression)metaDataKey.invoke("getId"), (GeneratedExpression)ExpressionFactory.lit((String)" after acquiring the connection, for more detailed information please read the provided stacktrace"))));
            metadataif._else()._return(ExpressionFactory.lit((String)"There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace"));
        } else {
            getMetadata.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultResult.class).narrow(MetaData.class)).arg(ExpressionFactory._null()).arg(ExpressionFactory.direct((String)"Result.Status.SUCCESS")));
        }
    }

    private void generateTestMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod testMethod = connectionManagerClass.method(1, (Type)this.ref(TestResult.class), "test");
        GeneratedVariable connection = testMethod.body().decl((Type)connectorClass, "connection", ExpressionFactory._null());
        GeneratedVariable result = testMethod.body().decl((Type)this.ref(DefaultTestResult.class), "result");
        GeneratedVariable defaultConnectionKey = testMethod.body().decl((Type)connectionKeyClass, "key", (GeneratedExpression)ExpressionFactory.invoke((String)"getDefaultConnectionKey"));
        GeneratedTry tryTestConnection = testMethod.body()._try();
        tryTestConnection.body().assign((AssignmentTarget)connection, (GeneratedExpression)ExpressionFactory.invoke((String)"acquireConnection").arg((GeneratedExpression)defaultConnectionKey));
        tryTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("SUCCESS")));
        GeneratedCatchBlock catchTestConnection = tryTestConnection._catch(this.ref(Exception.class));
        GeneratedVariable e = catchTestConnection.param("e");
        GeneratedTry tryDestroyConnection = catchTestConnection.body()._try();
        tryDestroyConnection.body().invoke("destroyConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryDestroyConnection._catch(this.ref(Exception.class)).param("ie");
        catchTestConnection.body().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(DefaultTestResult.class), (GeneratedExpression)ExpressionFactory.invoke((String)"buildFailureTestResult").arg((GeneratedExpression)e)));
        GeneratedBlock finallyTestConnection = tryTestConnection._finally();
        GeneratedConditional ifNotNull = finallyTestConnection._if(connection.isNotNull());
        GeneratedTry tryReleaseConnection = ifNotNull._then()._try();
        tryReleaseConnection.body().invoke("releaseConnection").arg((GeneratedExpression)defaultConnectionKey).arg((GeneratedExpression)connection);
        tryReleaseConnection._catch(this.ref(Exception.class)).param("ie");
        testMethod.body()._return((GeneratedExpression)result);
    }

    private void generateBuildFailureTestResultMethod(Method connect, GeneratedClass connectionManagerClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod buildFailureTestResult = connectionManagerClass.method(1, (Type)this.ref(DefaultResult.class), "buildFailureTestResult");
        GeneratedVariable exception = buildFailureTestResult.param((Type)this.ref(Exception.class), "exception");
        GeneratedVariable result = buildFailureTestResult.body().decl((Type)this.ref(DefaultTestResult.class), "result");
        GeneratedConditional ifConnectionException = buildFailureTestResult.body()._if(exception._instanceof((Type)this.ref(ConnectionException.class)));
        GeneratedVariable code = ifConnectionException._then().decl((Type)this.ref(ConnectionExceptionCode.class), "code", (GeneratedExpression)ExpressionFactory.cast((Type)this.ref(ConnectionException.class), (GeneratedExpression)exception).invoke("getCode"));
        GeneratedConditional ifCode = ifConnectionException._then()._if(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("UNKNOWN_HOST")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNKNOWN_HOST")).arg((GeneratedExpression)exception));
        ifCode = ifCode._elseif(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("CANNOT_REACH")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("RESOURCE_UNAVAILABLE")).arg((GeneratedExpression)exception));
        ifCode = ifCode._elseif(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("INCORRECT_CREDENTIALS")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("INVALID_CREDENTIALS")).arg((GeneratedExpression)exception));
        ifCode = ifCode._elseif(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("CREDENTIALS_EXPIRED")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("INVALID_CREDENTIALS")).arg((GeneratedExpression)exception));
        ifCode = ifCode._elseif(Op.eq((GeneratedExpression)code, (GeneratedExpression)this.ref(ConnectionExceptionCode.class).staticRef("UNKNOWN")));
        ifCode._then().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)exception));
        ifCode._else().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)exception));
        ifConnectionException._else().assign((AssignmentTarget)result, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(DefaultTestResult.class)).arg((GeneratedExpression)this.ref(Result.Status.class).staticRef("FAILURE")).arg((GeneratedExpression)exception.invoke("getMessage")).arg((GeneratedExpression)this.ref(FailureType.class).staticRef("UNSPECIFIED")).arg((GeneratedExpression)exception));
        buildFailureTestResult.body()._return((GeneratedExpression)result);
    }

    private void generateGetDefaultConnectionKey(ManagedConnectionModule module, GeneratedClass connectionManagerClass, GeneratedClass connectionKeyClass) {
        GeneratedMethod getDefaultConnectionKey = connectionManagerClass.method(1, (Type)connectionKeyClass, "getDefaultConnectionKey");
        GeneratedInvocation newConnectionKey = ExpressionFactory._new((TypeReference)connectionKeyClass);
        for (Parameter parameter : module.getConnectMethod().getParameters()) {
            newConnectionKey.arg((GeneratedExpression)ExpressionFactory.invoke((String)("get" + StringUtils.capitalize((String)parameter.getName()))));
        }
        getDefaultConnectionKey.body()._return((GeneratedExpression)newConnectionKey);
    }

    private void generateGetProcessTemplateMethod(ManagedConnectionModule module, GeneratedClass connectionManagerClass) {
        GeneratedClass connectionIdentifierAdapterClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass managedConnectionProcessTemplateClass = (GeneratedClass)this.ctx().getProduct(Product.MANAGED_CONNECTION_PROCESS_TEMPLATE);
        GeneratedMethod getProcessTemplate = connectionManagerClass.method(1, (Type)((TypeReference)this.ctx().getProduct(Product.PROCESS_TEMPLATE_INTERFACE)), "getProcessTemplate");
        getProcessTemplate.annotate(this.ref(Override.class));
        TypeVariable p = getProcessTemplate.generify("P");
        getProcessTemplate.type((Type)((TypeReference)this.ctx().getProduct(Product.PROCESS_TEMPLATE_INTERFACE)).narrow((TypeReference)p).narrow((TypeReference)connectionIdentifierAdapterClass));
        getProcessTemplate.body()._return((GeneratedExpression)ExpressionFactory._new((TypeReference)managedConnectionProcessTemplateClass).arg(ExpressionFactory._this()).arg((GeneratedExpression)ExpressionFactory.ref((String)"muleContext")));
    }

    private void generateBorrowConnectionMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod borrowConnector = connectionManagerClass.method(1, (Type)connectorClass, "acquireConnection");
        GeneratedVariable key = borrowConnector.param((Type)connectionKeyClass, "key");
        borrowConnector._throws(this.ref(Exception.class));
        borrowConnector.body()._return((GeneratedExpression)ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)connectionPool.invoke("borrowObject").arg((GeneratedExpression)key)));
    }

    private void generateReturnConnectionMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod returnConnector = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "releaseConnection");
        GeneratedVariable key = returnConnector.param((Type)connectionKeyClass, "key");
        returnConnector._throws(this.ref(Exception.class));
        GeneratedVariable connection = returnConnector.param((Type)connectorClass, "connection");
        returnConnector.body().add((Statement)connectionPool.invoke("returnObject").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
    }

    private void generateDestroyConnectionMethod(Method connect, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedClass connectionKeyClass) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod destroyConnector = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "destroyConnection");
        GeneratedVariable key = destroyConnector.param((Type)connectionKeyClass, "key");
        destroyConnector._throws(this.ref(Exception.class));
        GeneratedVariable connection = destroyConnector.param((Type)connectorClass, "connection");
        destroyConnector.body().add((Statement)connectionPool.invoke("invalidateObject").arg((GeneratedExpression)key).arg((GeneratedExpression)connection));
    }

    private void generateInitialiseMethod(Module module, GeneratedClass connectionManagerClass, GeneratedField connectionPool, GeneratedField connectionPoolingProfile, GeneratedField retryPolicyTemplate, GeneratedClass connectionFactoryClass) {
        GeneratedMethod initialisableMethod = connectionManagerClass.method(1, (Type)this.ctx().getCodeModel().VOID, "initialise");
        GeneratedVariable config = initialisableMethod.body().decl((Type)this.ref(GenericKeyedObjectPool.Config.class), "config", (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(GenericKeyedObjectPool.Config.class)));
        GeneratedConditional ifNotNull = initialisableMethod.body()._if(connectionPoolingProfile.isNotNull());
        ifNotNull._then().assign((AssignmentTarget)config.ref("maxIdle"), (GeneratedExpression)connectionPoolingProfile.invoke("getMaxIdle"));
        ifNotNull._then().assign((AssignmentTarget)config.ref("maxActive"), (GeneratedExpression)connectionPoolingProfile.invoke("getMaxActive"));
        ifNotNull._then().assign((AssignmentTarget)config.ref("maxWait"), (GeneratedExpression)connectionPoolingProfile.invoke("getMaxWait"));
        ifNotNull._then().assign((AssignmentTarget)config.ref("whenExhaustedAction"), (GeneratedExpression)ExpressionFactory.cast((Type)this.ctx().getCodeModel().BYTE, (GeneratedExpression)connectionPoolingProfile.invoke("getExhaustedAction")));
        if (module.getMinMuleVersion().atLeast("3.3.2")) {
            ifNotNull._then().assign((AssignmentTarget)config.ref("timeBetweenEvictionRunsMillis"), (GeneratedExpression)connectionPoolingProfile.invoke("getEvictionCheckIntervalMillis"));
            ifNotNull._then().assign((AssignmentTarget)config.ref("minEvictableIdleTimeMillis"), (GeneratedExpression)connectionPoolingProfile.invoke("getMinEvictionMillis"));
        }
        GeneratedInvocation newObjectFactory = ExpressionFactory._new((TypeReference)connectionFactoryClass);
        newObjectFactory.arg(ExpressionFactory._this());
        initialisableMethod.body().assign((AssignmentTarget)connectionPool, (GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(GenericKeyedObjectPool.class)).arg((GeneratedExpression)newObjectFactory).arg((GeneratedExpression)config));
        GeneratedConditional ifRetryPolicyTemplateIsNull = initialisableMethod.body()._if(retryPolicyTemplate.isNull());
        ifRetryPolicyTemplateIsNull._then().assign((AssignmentTarget)retryPolicyTemplate, (GeneratedExpression)ExpressionFactory.ref((String)"muleContext").invoke("getRegistry").invoke("lookupObject").arg((GeneratedExpression)this.ref(MuleProperties.class).staticRef("OBJECT_DEFAULT_RETRY_POLICY_TEMPLATE")));
    }

    private void generateActivateObjectMethod(GeneratedClass connectionFactoryClass, Method validateConnectionMethod, ConnectMethod connect, GeneratedClass connectionKeyClass, GeneratedField logger) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, validateConnectionMethod.parent())).topLevelClass();
        GeneratedMethod activateObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "activateObject");
        activateObject._throws(this.ref(Exception.class));
        GeneratedVariable key = activateObject.param(Object.class, "key");
        GeneratedVariable obj = activateObject.param(Object.class, "obj");
        GeneratedConditional ifNotKey = activateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)connectionKeyClass)));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid key type"));
        GeneratedConditional ifNotObj = activateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg("Invalid connector type"));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = activateObject.body()._try();
        GeneratedConditional ifNotConnected = tryDisconnect.body()._if(Op.not((GeneratedExpression)casterConnector.invoke(validateConnectionMethod.getName())));
        GeneratedCast castedConnectionKey = ExpressionFactory.cast((Type)connectionKeyClass, (GeneratedExpression)key);
        GeneratedInvocation connectInvoke = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj).invoke(connect.getName());
        for (Parameter variable : connect.getParameters()) {
            String fieldName = variable.getName();
            connectInvoke.arg((GeneratedExpression)castedConnectionKey.invoke("get" + StringUtils.capitalize((String)fieldName)));
        }
        ifNotConnected._then().add((Statement)connectInvoke);
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body()._throw((GeneratedExpression)e);
    }

    private void generatePassivateObjectMethod(GeneratedClass connectionFactoryClass) {
        GeneratedMethod passivateObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "passivateObject");
        passivateObject._throws(this.ref(Exception.class));
        passivateObject.param(Object.class, "key");
        passivateObject.param(Object.class, "obj");
    }

    private void generateValidateObjectMethod(GeneratedClass connectionFactoryClass, GeneratedField logger, Method validateConnectionMethod) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, validateConnectionMethod.parent())).topLevelClass();
        GeneratedMethod validateObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().BOOLEAN, "validateObject");
        validateObject.param(Object.class, "key");
        GeneratedVariable obj = validateObject.param(Object.class, "obj");
        GeneratedConditional ifNotObj = validateObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        GeneratedConditional ifNullObj = ifNotObj._then()._if(obj.isNull());
        ifNullObj._then().add((Statement)logger.invoke("warn").arg("Connector is null"));
        ifNullObj._else().add((Statement)logger.invoke("warn").arg((GeneratedExpression)ExpressionFactory.lit((String)"Cannot cast connector of type ").invoke("concat").arg((GeneratedExpression)obj.invoke("getClass").invoke("getName").invoke("concat").arg(" to ").invoke("concat").arg(connectorClass.fullName()))));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)ExpressionFactory.lit((String)"Invalid connector type ").invoke("concat").arg((GeneratedExpression)obj.invoke("getClass").invoke("getName"))));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = validateObject.body()._try();
        tryDisconnect.body()._return((GeneratedExpression)casterConnector.invoke(validateConnectionMethod.getName()));
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body().add((Statement)logger.invoke("error").arg((GeneratedExpression)e.invoke("getMessage")).arg((GeneratedExpression)e));
        catchAndRethrow.body()._return(ExpressionFactory.FALSE);
    }

    private void generateDestroyObjectMethod(Method connect, Method disconnect, GeneratedClass connectionKeyClass, GeneratedClass connectionFactoryClass, GeneratedField logger) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod destroyObject = connectionFactoryClass.method(1, (Type)this.ctx().getCodeModel().VOID, "destroyObject");
        destroyObject._throws(this.ref(Exception.class));
        GeneratedVariable key = destroyObject.param(Object.class, "key");
        GeneratedVariable obj = destroyObject.param(Object.class, "obj");
        GeneratedConditional ifNotKey = destroyObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)connectionKeyClass)));
        GeneratedConditional ifNullKey = ifNotKey._then()._if(key.isNull());
        ifNullKey._then().add((Statement)logger.invoke("warn").arg("Connection key is null"));
        ifNullKey._else().add((Statement)logger.invoke("warn").arg((GeneratedExpression)ExpressionFactory.lit((String)"Cannot cast key of type ").invoke("concat").arg((GeneratedExpression)key.invoke("getClass").invoke("getName").invoke("concat").arg(" to ").invoke("concat").arg(connectionKeyClass.fullName()))));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)ExpressionFactory.lit((String)"Invalid key type ").invoke("concat").arg((GeneratedExpression)key.invoke("getClass").invoke("getName"))));
        GeneratedConditional ifNotObj = destroyObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)obj, (Type)connectorClass)));
        GeneratedConditional ifNullObj = ifNotObj._then()._if(obj.isNull());
        ifNullObj._then().add((Statement)logger.invoke("warn").arg("Connector is null"));
        ifNullObj._else().add((Statement)logger.invoke("warn").arg((GeneratedExpression)ExpressionFactory.lit((String)"Cannot cast connector of type ").invoke("concat").arg((GeneratedExpression)obj.invoke("getClass").invoke("getName").invoke("concat").arg(" to ").invoke("concat").arg(connectorClass.fullName()))));
        ifNotObj._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)ExpressionFactory.lit((String)"Invalid connector type ").invoke("concat").arg((GeneratedExpression)obj.invoke("getClass").invoke("getName"))));
        GeneratedCast casterConnector = ExpressionFactory.cast((Type)connectorClass, (GeneratedExpression)obj);
        GeneratedTry tryDisconnect = destroyObject.body()._try();
        tryDisconnect.body().add((Statement)casterConnector.invoke(disconnect.getName()));
        GeneratedCatchBlock catchAndRethrow = tryDisconnect._catch(this.ref(Exception.class));
        GeneratedVariable e = catchAndRethrow.param("e");
        catchAndRethrow.body()._throw((GeneratedExpression)e);
        tryDisconnect._finally()._if(Op._instanceof((GeneratedExpression)casterConnector, (Type)this.ref(Stoppable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Stoppable.class), (GeneratedExpression)obj).invoke("stop"));
        tryDisconnect._finally()._if(Op._instanceof((GeneratedExpression)casterConnector, (Type)this.ref(Disposable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Disposable.class), (GeneratedExpression)obj).invoke("dispose"));
    }

    private void generateMakeObjectMethod(Module module, ConnectMethod connect, Method validateConnectionMethod, GeneratedClass connectionFactoryClass, GeneratedClass connectionKey, GeneratedField connectionManagerInFactory, GeneratedField logger) {
        GeneratedClass connectorClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, connect.parent())).topLevelClass();
        GeneratedMethod makeObject = connectionFactoryClass.method(1, Object.class, "makeObject");
        makeObject._throws(this.ref(Exception.class));
        GeneratedVariable key = makeObject.param(Object.class, "key");
        GeneratedConditional ifNotKey = makeObject.body()._if(Op.not((GeneratedExpression)Op._instanceof((GeneratedExpression)key, (Type)connectionKey)));
        GeneratedConditional ifNullKey = ifNotKey._then()._if(key.isNull());
        ifNullKey._then().add((Statement)logger.invoke("warn").arg("Connection key is null"));
        ifNullKey._else().add((Statement)logger.invoke("warn").arg((GeneratedExpression)ExpressionFactory.lit((String)"Cannot cast key of type ").invoke("concat").arg((GeneratedExpression)key.invoke("getClass").invoke("getName").invoke("concat").arg(" to ").invoke("concat").arg(connectionKey.fullName()))));
        ifNotKey._then()._throw((GeneratedExpression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)).arg((GeneratedExpression)ExpressionFactory.lit((String)"Invalid key type ").invoke("concat").arg((GeneratedExpression)key.invoke("getClass").invoke("getName"))));
        GeneratedVariable connector = makeObject.body().decl((Type)connectorClass, "connector", (GeneratedExpression)ExpressionFactory._new((TypeReference)connectorClass));
        for (Field field : module.getConfigurableFields()) {
            makeObject.body().add((Statement)connector.invoke("set" + StringUtils.capitalize((String)field.getName())).arg((GeneratedExpression)connectionManagerInFactory.invoke("get" + StringUtils.capitalize((String)field.getName()))));
        }
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Initialisable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Initialisable.class), (GeneratedExpression)connector).invoke("initialise"));
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(MuleContextAware.class), (GeneratedExpression)connector).invoke("setMuleContext").arg((GeneratedExpression)connectionManagerInFactory.invoke("getMuleContext")));
        makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(Startable.class)))._then().add((Statement)ExpressionFactory.cast((Type)this.ref(Startable.class), (GeneratedExpression)connector).invoke("start"));
        this.setMuleContextToConnectorIfNecessary(connectionManagerInFactory, connectorClass, makeObject, connector);
        GeneratedConditional ifNotConnected = makeObject.body()._if(Op.not((GeneratedExpression)connector.invoke(validateConnectionMethod.getName())));
        GeneratedCast castedConnectionKey = ExpressionFactory.cast((Type)connectionKey, (GeneratedExpression)key);
        GeneratedInvocation connectInvoke = connector.invoke(connect.getName());
        for (Parameter variable : connect.getParameters()) {
            String fieldName = variable.getName();
            connectInvoke.arg((GeneratedExpression)castedConnectionKey.invoke("get" + StringUtils.capitalize((String)fieldName)));
        }
        ifNotConnected._then().add((Statement)connectInvoke);
        makeObject.body()._return((GeneratedExpression)connector);
    }

    private void setMuleContextToConnectorIfNecessary(GeneratedField connectionManagerInFactory, GeneratedClass connectorClass, GeneratedMethod makeObject, GeneratedVariable connector) {
        Iterator implementsIterator = connectorClass._implements();
        while (implementsIterator.hasNext()) {
            TypeReference implementedInterface = (TypeReference)implementsIterator.next();
            if (!implementedInterface.equals((Object)this.ref(MuleContextAware.class))) continue;
            makeObject.body()._if(Op._instanceof((GeneratedExpression)connector, (Type)this.ref(MuleContextAware.class)))._then().add((Statement)connector.invoke("setMuleContext").arg(ExpressionFactory.direct((String)(connectionManagerInFactory.name() + "." + "muleContext"))));
        }
    }

    private GeneratedField generateFieldForConnectionPool(GeneratedClass connectionManagerClass) {
        GeneratedField connectionPool = connectionManagerClass.field(4, (Type)this.ref(GenericKeyedObjectPool.class), "connectionPool");
        connectionPool.javadoc().add((Object)"Connector Pool");
        return connectionPool;
    }

    private GeneratedClass getConnectionManagerAdapterClass(ManagedConnectionModule module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass connectionKeyClass = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_KEY, (Identifiable)module)).topLevelClass();
        GeneratedClass classToExtend = ((GeneratedClass)this.ctx().getProduct(Product.CONNECTION_IDENTIFIER_ADAPTER, (Identifiable)module)).topLevelClass();
        GeneratedClass connectionManagerClass = pkg._class(module.getClassName() + "ConnectionManager");
        connectionManagerClass._implements(this.ref(Initialisable.class));
        connectionManagerClass._implements((TypeReference)this.ctx().getProduct(Product.CAPABILITIES_INTERFACE));
        connectionManagerClass._implements(this.ref(MuleContextAware.class));
        connectionManagerClass._implements(((TypeReference)this.ctx().getProduct(Product.CONNECTION_MANAGER_INTERFACE)).narrow((TypeReference)connectionKeyClass).narrow((TypeReference)classToExtend));
        connectionManagerClass._implements(((TypeReference)this.ctx().getProduct(Product.PROCESS_ADAPTER_INTERFACE)).narrow((TypeReference)classToExtend));
        connectionManagerClass._implements((TypeReference)this.ctx().getProduct(Product.METADATA_AWARE_INTERFACE));
        if (module.getMinMuleVersion().atLeastBase("3.4")) {
            connectionManagerClass._implements(this.ref(Testable.class));
        }
        if (this.isMetaDataCapable((Module)module)) {
            connectionManagerClass._implements(this.ref(ConnectorMetaDataEnabled.class));
        }
        this.ctx().registerProduct(Product.CONNECTION_MANAGER, (Identifiable)module, (Object)connectionManagerClass);
        connectionManagerClass.javadoc().add((Object)("A {@code " + connectionManagerClass.name() + "} is a wrapper around "));
        connectionManagerClass.javadoc().add((Object)this.ref(module.asTypeMirror()));
        connectionManagerClass.javadoc().add((Object)" that adds connection management capabilities to the pojo.");
        return connectionManagerClass;
    }

    private GeneratedClass getConnectorFactoryClass(Module module) {
        GeneratedPackage pkg = this.ctx().getCodeModel()._package(module.getPackage().getName() + ".connectivity");
        GeneratedClass objectFactory = pkg._class(1, module.getClassName() + "ConnectionFactory");
        objectFactory._implements(KeyedPoolableObjectFactory.class);
        return objectFactory;
    }
}

