/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import org.mule.api.annotations.Transformer;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.ModuleAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.Method;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ModuleKind;
import org.mule.devkit.model.module.TransformerMethod;

public class TransformerAnnotationVerifier
implements ModuleAnnotationVerifier {
    public boolean shouldVerify(Module module) {
        return (module.getKind() == ModuleKind.CONNECTOR || module.getKind() == ModuleKind.GENERIC) && module.hasTransformers();
    }

    public void verify(Module module) throws AnnotationVerificationException {
        for (TransformerMethod method : module.getTransformerMethods()) {
            if (!method.isStatic()) {
                throw new AnnotationVerificationException((Identifiable)method, "@Transformer must be a static method");
            }
            if (!method.isPublic()) {
                throw new AnnotationVerificationException((Identifiable)method, "@Transformer cannot be applied to a non-public method");
            }
            if (((Object)method.getReturnType()).toString().equals("void")) {
                throw new AnnotationVerificationException((Identifiable)method, "@Transformer cannot be void");
            }
            if (((Object)method.getReturnType()).toString().equals("java.lang.Object")) {
                throw new AnnotationVerificationException((Identifiable)method, "@Transformer cannot return java.lang.Object");
            }
            if (method.getParameters().size() != 1) {
                throw new AnnotationVerificationException((Identifiable)method, "@Transformer must receive exactly one argument.");
            }
            List<? extends AnnotationValue> sourceTypes = this.getSourceTypes((Method)method);
            if (sourceTypes != null && !sourceTypes.isEmpty()) continue;
            throw new AnnotationVerificationException((Identifiable)method, "@Transformer must have at declare at least one element in the sourceTypes attribute");
        }
    }

    private List<? extends AnnotationValue> getSourceTypes(Method method) {
        String transformerAnnotationName = Transformer.class.getName();
        List annotationMirrors = method.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!transformerAnnotationName.equals(annotationMirror.getAnnotationType().toString())) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"sourceTypes".equals(entry.getKey().getSimpleName().toString())) continue;
                return (List)entry.getValue().getValue();
            }
        }
        return null;
    }
}

