/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.verifiers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.mule.api.annotations.Connector;
import org.mule.devkit.generation.api.AnnotationVerificationException;
import org.mule.devkit.generation.api.MultiModuleAnnotationVerifier;
import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.module.Module;
import org.mule.devkit.model.module.ProcessorMethod;
import org.mule.devkit.model.module.connectivity.ManagedConnectionModule;
import org.mule.devkit.model.module.oauth.OAuthModule;

public class MultiModuleConsistencyAnnotationVerifier
implements MultiModuleAnnotationVerifier {
    public boolean shouldVerify(List<Module> modules) {
        return true;
    }

    public void verifyUniqueProcessorPerNamespace(List<Module> modules) throws AnnotationVerificationException {
        HashMap processorMethods = new HashMap();
        for (Module module : modules) {
            for (ProcessorMethod method : module.getProcessorMethods()) {
                String moduleName;
                String methodName = method.getName();
                HashSet<String> modulesWithProcessor = (HashSet<String>)processorMethods.get(methodName);
                if (modulesWithProcessor == null) {
                    modulesWithProcessor = new HashSet<String>();
                    processorMethods.put(methodName, modulesWithProcessor);
                }
                if (modulesWithProcessor.contains(moduleName = module.getModuleName())) continue;
                if (!modulesWithProcessor.isEmpty()) {
                    throw new AnnotationVerificationException((Identifiable)module, "Two or more classes annotated with @Module or @Connector not sharing the same module namespaces have a @Processor with the exact name. ");
                }
                modulesWithProcessor.add(moduleName);
            }
        }
    }

    public void verifyUniqueFriendlyNamePerNamespace(List<Module> modules) throws AnnotationVerificationException {
        HashMap moduleNames = new HashMap();
        for (Module module : modules) {
            String moduleName = module.getModuleName();
            String moduleFriendlyName = module.getFriendlyName();
            HashSet<String> friendlyNames = (HashSet<String>)moduleNames.get(moduleName);
            if (friendlyNames == null) {
                friendlyNames = new HashSet<String>();
                moduleNames.put(moduleName, friendlyNames);
            }
            if (friendlyNames.contains(moduleFriendlyName)) {
                throw new AnnotationVerificationException((Identifiable)module, "If they belong to the same module, two or more @Module or @Connector classes cannot share the same friendly name.");
            }
            friendlyNames.add(moduleFriendlyName);
        }
    }

    private void verifyOnlyOneConnectorPerNamespace(List<Module> modules, Class<? extends Module> moduleClass) throws AnnotationVerificationException {
        HashSet<String> hasModuleAnnotatedWithConnector = new HashSet<String>();
        for (Module module : modules) {
            if (module.getAnnotation(Connector.class) == null || !module.getClass().isInstance(moduleClass)) continue;
            if (hasModuleAnnotatedWithConnector.contains(module.getModuleName())) {
                throw new AnnotationVerificationException((Identifiable)module, "Only one class per Namespace (module name) can be annotated with a @Connector of type " + moduleClass + ".");
            }
            hasModuleAnnotatedWithConnector.add(module.getModuleName());
        }
    }

    public void verify(List<Module> modules) throws AnnotationVerificationException {
        this.verifyUniqueProcessorPerNamespace(modules);
        this.verifyUniqueFriendlyNamePerNamespace(modules);
        this.verifyOnlyOneConnectorPerNamespace(modules, OAuthModule.class);
        this.verifyOnlyOneConnectorPerNamespace(modules, ManagedConnectionModule.class);
    }
}

